/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import ghidra.app.util.viewer.util.OpenCloseManager;
import ghidra.program.model.address.Address;
import java.util.HashSet;
import java.util.Set;

public class InMemoryOpenCloseManager
implements OpenCloseManager {
    private boolean openByDefault = true;
    private Set<Address> addresses = new HashSet<Address>();

    @Override
    public boolean isOpen(Address address) {
        boolean contains = this.addresses.contains(address);
        return this.openByDefault ? !contains : contains;
    }

    @Override
    public void open(Address address) {
        if (this.openByDefault) {
            this.addresses.remove(address);
        } else {
            this.addresses.add(address);
        }
    }

    @Override
    public void close(Address address) {
        if (this.openByDefault) {
            this.addresses.add(address);
        } else {
            this.addresses.remove(address);
        }
    }

    @Override
    public boolean isOpenByDefault() {
        return this.openByDefault;
    }

    @Override
    public void openAll() {
        this.openByDefault = true;
        this.addresses.clear();
    }

    @Override
    public void closeAll() {
        this.openByDefault = false;
        this.addresses.clear();
    }
}

