/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.listing;

import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.ViewerPosition;
import generic.theme.GIcon;
import ghidra.GhidraOptions;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.codebrowser.hover.DataTypeListingHover;
import ghidra.app.plugin.core.codebrowser.hover.LabelListingHover;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.codebrowser.hover.ReferenceListingHover;
import ghidra.app.plugin.core.codebrowser.hover.TruncatedTextListingHover;
import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.plugin.core.marker.MarkerMarginProvider;
import ghidra.app.plugin.core.marker.MarkerOverviewProvider;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingOverviewProvider;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.ProgramLocationListener;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.app.util.viewer.util.FieldNavigator;
import ghidra.features.base.codecompare.listing.ListingCodeComparisonOptions;
import ghidra.features.base.codecompare.listing.ListingDiffChangeListener;
import ghidra.features.base.codecompare.listing.ListingDiffHighlightProvider;
import ghidra.features.base.codecompare.listing.ListingDisplayGoToService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ListingDiff;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Duo;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;

public class ListingDisplay
implements ListingDiffChangeListener {
    private static final Icon CURSOR_LOC_ICON = new GIcon("icon.base.util.listingcompare.cursor");
    private ListingPanel listingPanel;
    private PluginTool tool;
    private ListingDisplayServiceProvider serviceProvider;
    private MarkerManager markerManager;
    private ListingCodeComparisonOptions comparisonOptions;
    private Color cursorHighlightColor;
    private MarkerSet unmatchedMarkers;
    private MarkerSet diffMarkers;
    private MarkerSet currentCursorMarkers;
    private ListingDiffHighlightProvider diffHighlights;
    private FieldNavigator fieldNavigator;
    private ListingDiff listingDiff;
    private Duo.Side side;

    public ListingDisplay(PluginTool tool, String owner, ListingDiff listingDiff, ListingCodeComparisonOptions comparsionOptions, Duo.Side side) {
        this.tool = tool;
        this.listingDiff = listingDiff;
        this.comparisonOptions = comparsionOptions;
        this.side = side;
        FormatManager formatManager = this.createFormatManager();
        this.loadOptions();
        this.listingPanel = new ListingPanel(formatManager);
        this.listingPanel.getFieldPanel().enableSelection(false);
        this.serviceProvider = new ListingDisplayServiceProvider(this);
        formatManager.setServiceProvider((ServiceProvider)this.serviceProvider);
        this.fieldNavigator = new FieldNavigator((ServiceProvider)this.serviceProvider, null);
        this.setMouseNavigationEnabled(true);
        this.createMarkerManager(owner);
        this.listingPanel.addHoverService(new ReferenceListingHover(tool, () -> formatManager));
        this.listingPanel.addHoverService(new DataTypeListingHover(tool));
        this.listingPanel.addHoverService(new TruncatedTextListingHover(tool));
        this.listingPanel.addHoverService(new LabelListingHover(tool));
        listingDiff.addListingDiffChangeListener(this);
        this.setHoverMode(true);
    }

    private void createMarkerManager(String owner) {
        this.markerManager = new ListingDisplayMarkerManager(this.tool, owner);
        this.markerManager.addChangeListener(e -> this.listingPanel.repaint());
        MarkerMarginProvider marginProvider = this.markerManager.createMarginProvider();
        this.listingPanel.addMarginProvider(marginProvider);
        MarkerOverviewProvider overviewProvider = this.markerManager.createOverviewProvider();
        this.listingPanel.addOverviewProvider(overviewProvider);
    }

    void setProgramLocationListener(ProgramLocationListener listener) {
        this.listingPanel.setProgramLocationListener(listener);
    }

    private FormatManager createFormatManager() {
        ToolOptions displayOptions = this.tool.getOptions("Listing Display");
        ToolOptions fieldOptions = this.tool.getOptions("Listing Fields");
        FormatManager formatManager = new FormatManager(displayOptions, fieldOptions);
        return formatManager;
    }

    public void repaint() {
        this.listingPanel.getFieldPanel().repaint();
    }

    public void setDiffHighlightProvider(ListingDiffHighlightProvider newDiffHighlights) {
        if (this.diffHighlights != null) {
            this.removeHighlightProvider(this.diffHighlights);
        }
        this.diffHighlights = newDiffHighlights;
        if (this.diffHighlights != null) {
            this.addHighlightProvider(this.diffHighlights);
        }
    }

    public void addHighlightProvider(ListingHighlightProvider highlightProvider) {
        this.listingPanel.getFormatManager().addHighlightProvider(highlightProvider);
    }

    public void removeHighlightProvider(ListingHighlightProvider highlightProvider) {
        if (highlightProvider == null) {
            return;
        }
        this.listingPanel.getFormatManager().removeHighlightProvider(highlightProvider);
    }

    public void addHoverService(ListingHoverService service) {
        this.listingPanel.addHoverService(service);
    }

    public void showHeader(boolean show) {
        this.listingPanel.showHeader(show);
        this.listingPanel.validate();
        this.listingPanel.invalidate();
    }

    public void setHoverMode(boolean enabled) {
        this.listingPanel.setHoverMode(enabled);
    }

    public void setView(AddressSetView view) {
        ProgramLocation saved = this.listingPanel.getProgramLocation();
        this.listingPanel.setView(view);
        if (saved != null) {
            this.listingPanel.goTo(saved);
        }
    }

    public boolean isHeaderShowing() {
        return this.listingPanel.isHeaderShowing();
    }

    public void setProgramView(Program program, AddressSetView view, String name) {
        this.listingPanel.setProgram(program);
        this.markerManager.clearAll();
        this.listingPanel.setView(view);
        AddressIndexMap indexMap = this.listingPanel.getAddressIndexMap();
        List<ListingOverviewProvider> providers = this.listingPanel.getOverviewProviders();
        for (ListingOverviewProvider provider : providers) {
            provider.screenDataChanged(program, indexMap);
        }
        this.listingPanel.setBackgroundColorModel(new MarkerServiceBackgroundColorModel(this.markerManager, program, indexMap));
        this.setUpAreaMarkerSets(program, name);
        this.repaint();
    }

    private void setUpAreaMarkerSets(Program program, String name) {
        if (program == null) {
            return;
        }
        Color diffColor = this.comparisonOptions.getDiffCodeUnitsBackgroundColor();
        Color unmatchedColor = this.comparisonOptions.getUnmatchedCodeUnitsBackgroundColor();
        AddressIndexMap indexMap = this.listingPanel.getAddressIndexMap();
        this.listingPanel.getFieldPanel().setBackgroundColorModel((BackgroundColorModel)new MarkerServiceBackgroundColorModel(this.markerManager, program, indexMap));
        this.unmatchedMarkers = this.markerManager.createAreaMarker(name + " Unmatched Code", "Instructions that are not matched to an instruction in the other function.", program, 80, true, true, true, unmatchedColor);
        this.diffMarkers = this.markerManager.createAreaMarker(name + " Diffs", "Instructions that have a difference.", program, 80, true, true, true, diffColor);
        this.currentCursorMarkers = this.markerManager.createPointMarker("Cursor", "Cursor Location", program, 49, true, true, true, this.cursorHighlightColor, CURSOR_LOC_ICON, false);
    }

    public ProgramLocation getProgramLocation() {
        return this.listingPanel.getProgramLocation();
    }

    private void loadOptions() {
        ToolOptions fieldOptions = this.tool.getOptions("Listing Fields");
        this.cursorHighlightColor = fieldOptions.isRegistered("Cursor.Highlight Cursor Line Color") ? fieldOptions.getColor("Cursor.Highlight Cursor Line Color", (Color)GhidraOptions.DEFAULT_CURSOR_LINE_COLOR) : GhidraOptions.DEFAULT_CURSOR_LINE_COLOR;
    }

    public void updateCursorMarkers(ProgramLocation location) {
        if (this.currentCursorMarkers != null) {
            this.currentCursorMarkers.clearAll();
            if (location != null) {
                this.currentCursorMarkers.add(location.getAddress());
            }
        }
        this.repaint();
    }

    private void setAreaMarkers(MarkerSet markers, AddressSetView diffAddresses, Color color) {
        if (markers == null) {
            return;
        }
        markers.setMarkerColor(color);
        markers.clearAll();
        markers.add(diffAddresses);
        this.repaint();
    }

    public void goTo(ProgramLocation location) {
        if (location != null) {
            this.listingPanel.goTo(location);
        }
        this.updateCursorMarkers(location);
    }

    public ListingPanel getListingPanel() {
        return this.listingPanel;
    }

    void dispose() {
        this.listingDiff.removeListingDiffChangeListener(this);
        this.setDiffHighlightProvider(null);
        this.markerManager.dispose();
        this.listingPanel.removeButtonPressedListener(this.fieldNavigator);
        this.listingPanel.dispose();
    }

    public FormatManager getFormatManager() {
        return this.listingPanel.getFormatManager();
    }

    public ViewerPosition getViewerPosition() {
        return this.listingPanel.getFieldPanel().getViewerPosition();
    }

    public void setViewerPosition(ViewerPosition position) {
        this.listingPanel.getFieldPanel().setViewerPosition(position.getIndex(), position.getXOffset(), position.getYOffset());
    }

    public void setMouseNavigationEnabled(boolean enabled) {
        this.listingPanel.removeButtonPressedListener(this.fieldNavigator);
        if (enabled) {
            this.listingPanel.addButtonPressedListener(new FieldNavigator((ServiceProvider)this.serviceProvider, null));
        }
    }

    @Override
    public void listingDiffChanged() {
        this.updateFunctionComparisonDiffHighlights();
        this.setUnmatchedCodeUnitAreaMarkers();
        this.setDiffAreaMarkers();
    }

    private void updateFunctionComparisonDiffHighlights() {
        this.setDiffHighlightProvider(new ListingDiffHighlightProvider(this.listingDiff, this.side, this.comparisonOptions));
    }

    private void setDiffAreaMarkers() {
        Color color = this.comparisonOptions.getDiffCodeUnitsBackgroundColor();
        AddressSetView addresses = this.listingDiff.getDiffs(this.side);
        this.setAreaMarkers(this.diffMarkers, addresses, color);
    }

    private void setUnmatchedCodeUnitAreaMarkers() {
        Color color = this.comparisonOptions.getUnmatchedCodeUnitsBackgroundColor();
        AddressSetView addresses = this.listingDiff.getUnmatchedCode(this.side);
        this.setAreaMarkers(this.unmatchedMarkers, addresses, color);
    }

    private class ListingDisplayServiceProvider
    extends ServiceProviderStub {
        private GoToService goToService;

        ListingDisplayServiceProvider(ListingDisplay listingDisplay) {
            this.goToService = new ListingDisplayGoToService(listingDisplay.listingPanel);
        }

        public <T> T getService(Class<T> serviceClass) {
            if (serviceClass == GoToService.class) {
                return (T)this.goToService;
            }
            return null;
        }
    }

    private class ListingDisplayMarkerManager
    extends MarkerManager {
        private ListingDisplayMarkerManager(PluginTool tool, String owner) {
            super(owner, tool);
        }

        @Override
        public GoToService getGoToService() {
            return ListingDisplay.this.serviceProvider.getService(GoToService.class);
        }
    }
}

