/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.format;

import ghidra.features.base.memsearch.format.NumberParseResult;
import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.InvalidByteMatcher;
import ghidra.features.base.memsearch.matcher.MaskedByteSequenceByteMatcher;
import ghidra.features.base.memsearch.matcher.UserInputByteMatcher;
import ghidra.util.HTMLUtilities;
import java.math.BigInteger;
import java.util.StringTokenizer;
import org.bouncycastle.util.Arrays;

class DecimalSearchFormat
extends SearchFormat {
    DecimalSearchFormat() {
        super("Decimal");
    }

    @Override
    public UserInputByteMatcher parse(String input, SearchSettings settings) {
        if ((input = input.trim()).isBlank()) {
            return new InvalidByteMatcher("");
        }
        int byteSize = settings.getDecimalByteSize();
        StringTokenizer tokenizer = new StringTokenizer(input);
        int tokenCount = tokenizer.countTokens();
        byte[] bytes = new byte[tokenCount * byteSize];
        int bytesPosition = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            NumberParseResult result = this.parseNumber(token, settings);
            if (result.errorMessage() != null) {
                return new InvalidByteMatcher(result.errorMessage(), result.validInput());
            }
            System.arraycopy(result.bytes(), 0, bytes, bytesPosition, byteSize);
            bytesPosition += byteSize;
        }
        return new MaskedByteSequenceByteMatcher(input, bytes, settings);
    }

    private NumberParseResult parseNumber(String tok, SearchSettings settings) {
        BigInteger min = this.getMin(settings);
        BigInteger max = this.getMax(settings);
        try {
            if (tok.equals("-")) {
                if (settings.isDecimalUnsigned()) {
                    return new NumberParseResult(null, "Negative numbers not allowed for unsigned values", false);
                }
                return new NumberParseResult(null, "Incomplete negative number", true);
            }
            BigInteger value = new BigInteger(tok);
            if (value.compareTo(min) < 0 || value.compareTo(max) > 0) {
                return new NumberParseResult(null, "Number must be in the range [" + String.valueOf(min) + ", " + String.valueOf(max) + "]", false);
            }
            long longValue = value.longValue();
            return this.createBytesResult(longValue, settings);
        }
        catch (NumberFormatException e) {
            return new NumberParseResult(null, "Number parse error: " + e.getMessage(), false);
        }
    }

    private BigInteger getMax(SearchSettings settings) {
        boolean unsigned = settings.isDecimalUnsigned();
        int size = settings.getDecimalByteSize();
        int shift = unsigned ? 8 * size : 8 * size - 1;
        return BigInteger.ONE.shiftLeft(shift).subtract(BigInteger.ONE);
    }

    private BigInteger getMin(SearchSettings settings) {
        boolean unsigned = settings.isDecimalUnsigned();
        int size = settings.getDecimalByteSize();
        if (unsigned) {
            return BigInteger.ZERO;
        }
        return BigInteger.ONE.shiftLeft(8 * size - 1).negate();
    }

    private NumberParseResult createBytesResult(long value, SearchSettings settings) {
        int byteSize = settings.getDecimalByteSize();
        byte[] bytes = new byte[byteSize];
        for (int i = 0; i < byteSize; ++i) {
            byte b;
            bytes[i] = b = (byte)value;
            value >>= 8;
        }
        if (settings.isBigEndian()) {
            this.reverse(bytes);
        }
        return new NumberParseResult(bytes, null, true);
    }

    @Override
    public String getToolTip() {
        return HTMLUtilities.toHTML((String)"Interpret values as a sequence of decimal numbers, separated by spaces");
    }

    @Override
    public int compareValues(byte[] bytes1, byte[] bytes2, SearchSettings settings) {
        int byteSize = settings.getDecimalByteSize();
        for (int i = 0; i < bytes1.length / byteSize; ++i) {
            long value2;
            long value1 = this.getValue(bytes1, i * byteSize, settings);
            if (value1 == (value2 = this.getValue(bytes2, i * byteSize, settings))) continue;
            if (byteSize == 8 && settings.isDecimalUnsigned()) {
                return Long.compareUnsigned(value1, value2);
            }
            return Long.compare(value1, value2);
        }
        return 0;
    }

    public long getValue(byte[] bytes, int index, SearchSettings settings) {
        boolean isBigEndian = settings.isBigEndian();
        int byteSize = settings.getDecimalByteSize();
        boolean isUnsigned = settings.isDecimalUnsigned();
        byte[] bigEndianBytes = this.getBigEndianBytes(bytes, index, isBigEndian, byteSize);
        long value = isUnsigned ? (long)(bigEndianBytes[0] & 0xFF) : (long)bigEndianBytes[0];
        for (int i = 1; i < byteSize; ++i) {
            value = value << 8 | (long)(bigEndianBytes[i] & 0xFF);
        }
        return value;
    }

    private byte[] getBigEndianBytes(byte[] bytes, int index, boolean isBigEndian, int byteSize) {
        byte[] bigEndianBytes = new byte[byteSize];
        System.arraycopy(bytes, index * byteSize, bigEndianBytes, 0, byteSize);
        if (!isBigEndian) {
            this.reverse(bigEndianBytes);
        }
        return bigEndianBytes;
    }

    @Override
    public String getValueString(byte[] bytes, SearchSettings settings) {
        return this.getValueString(bytes, settings, false);
    }

    protected String getValueString(byte[] bytes, SearchSettings settings, boolean padNegative) {
        int byteSize = settings.getDecimalByteSize();
        boolean isBigEndian = settings.isBigEndian();
        boolean isUnsigned = settings.isDecimalUnsigned();
        StringBuilder buffer = new StringBuilder();
        int numValues = bytes.length / byteSize;
        for (int i = 0; i < numValues; ++i) {
            long value = this.getValue(bytes, i, settings);
            String text = isUnsigned ? Long.toUnsignedString(value) : Long.toString(value);
            buffer.append(text);
            if (i == numValues - 1) continue;
            buffer.append(", ");
        }
        int remainder = bytes.length - numValues * byteSize;
        if (remainder > 0) {
            String text;
            byte[] remainderBytes = new byte[remainder];
            System.arraycopy(bytes, numValues * byteSize, remainderBytes, 0, remainder);
            byte[] padded = this.padToByteSize(remainderBytes, byteSize, isBigEndian, padNegative);
            long value = this.getValue(padded, 0, settings);
            String string = text = isUnsigned ? Long.toUnsignedString(value) : Long.toString(value);
            if (!buffer.isEmpty()) {
                buffer.append(", ");
            }
            buffer.append(text);
        }
        return buffer.toString();
    }

    @Override
    public String convertText(String text, SearchSettings oldSettings, SearchSettings newSettings) {
        SearchFormat oldFormat = oldSettings.getSearchFormat();
        switch (oldFormat.getFormatType()) {
            case BYTE: {
                return this.getTextFromBytes(text, oldSettings, newSettings);
            }
            case INTEGER: {
                return this.convertFromDifferentNumberFormat(text, oldSettings, newSettings);
            }
        }
        return this.isValidText(text, newSettings) ? text : "";
    }

    private String convertFromDifferentNumberFormat(String text, SearchSettings oldSettings, SearchSettings newSettings) {
        int oldSize = oldSettings.getDecimalByteSize();
        int newSize = newSettings.getDecimalByteSize();
        boolean oldUnsigned = oldSettings.isDecimalUnsigned();
        boolean newUnsigned = newSettings.isDecimalUnsigned();
        if (oldSize == newSize && oldUnsigned == newUnsigned) {
            return text;
        }
        if (oldSize > newSize && this.isValidText(text, newSettings)) {
            return text;
        }
        return this.getTextFromBytes(text, oldSettings, newSettings);
    }

    private String getTextFromBytes(String text, SearchSettings oldSettings, SearchSettings newSettings) {
        byte[] bytes = this.getBytes(oldSettings.getSearchFormat(), text, oldSettings);
        if (bytes == null) {
            return "";
        }
        boolean padNegative = this.shouldPadNegative(text);
        String valueString = this.getValueString(bytes, newSettings, padNegative);
        return valueString.replaceAll(",", "");
    }

    private boolean shouldPadNegative(String text) {
        if (text.isBlank()) {
            return false;
        }
        int lastIndexOf = text.trim().lastIndexOf(" ");
        if (lastIndexOf < 0) {
            return text.charAt(0) == '-';
        }
        return false;
    }

    private byte[] getBytes(SearchFormat oldFormat, String text, SearchSettings settings) {
        UserInputByteMatcher byteMatcher = oldFormat.parse(text, settings);
        if (byteMatcher instanceof MaskedByteSequenceByteMatcher) {
            MaskedByteSequenceByteMatcher matcher = (MaskedByteSequenceByteMatcher)byteMatcher;
            return matcher.getBytes();
        }
        return null;
    }

    private byte[] padToByteSize(byte[] bytes, int byteSize, boolean isBigEndian, boolean padNegative) {
        if (bytes.length >= byteSize) {
            return bytes;
        }
        byte[] newBytes = new byte[byteSize];
        if (padNegative) {
            Arrays.fill((byte[])newBytes, (byte)-1);
        }
        int startIndex = isBigEndian ? byteSize - bytes.length : 0;
        System.arraycopy(bytes, 0, newBytes, startIndex, bytes.length);
        return newBytes;
    }

    @Override
    public SearchFormat.SearchFormatType getFormatType() {
        return SearchFormat.SearchFormatType.INTEGER;
    }
}

