/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.format;

import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.InvalidByteMatcher;
import ghidra.features.base.memsearch.matcher.RegExByteMatcher;
import ghidra.features.base.memsearch.matcher.UserInputByteMatcher;
import java.util.regex.PatternSyntaxException;

class RegExSearchFormat
extends SearchFormat {
    RegExSearchFormat() {
        super("Reg Ex");
    }

    @Override
    public UserInputByteMatcher parse(String input, SearchSettings settings) {
        if ((input = input.trim()).isBlank()) {
            return new InvalidByteMatcher("");
        }
        try {
            return new RegExByteMatcher(input, settings);
        }
        catch (PatternSyntaxException e) {
            return new InvalidByteMatcher("RegEx Pattern Error: " + e.getDescription(), true);
        }
    }

    @Override
    public String getToolTip() {
        return "Interpret value as a regular expression.";
    }

    @Override
    public String getValueString(byte[] bytes, SearchSettings settings) {
        return new String(bytes);
    }

    @Override
    public String convertText(String text, SearchSettings oldSettings, SearchSettings newSettings) {
        return this.isValidText(text, newSettings) ? text : "";
    }

    @Override
    public SearchFormat.SearchFormatType getFormatType() {
        return SearchFormat.SearchFormatType.STRING_TYPE;
    }
}

