/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import ghidra.features.base.memsearch.gui.MemoryMatchTableLoader;
import ghidra.features.base.memsearch.gui.MemorySearchResultsPanel;
import ghidra.features.base.memsearch.matcher.SearchData;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.features.base.memsearch.searcher.MemorySearcher;
import ghidra.program.model.address.Address;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class FindOnceTableLoader
implements MemoryMatchTableLoader {
    private MemorySearcher<SearchData> searcher;
    private Address address;
    private List<MemoryMatch<SearchData>> previousResults;
    private MemorySearchResultsPanel panel;
    private MemoryMatch<SearchData> match;
    private boolean forward;

    public FindOnceTableLoader(MemorySearcher<SearchData> searcher, Address address, List<MemoryMatch<SearchData>> previousResults, MemorySearchResultsPanel panel, boolean forward) {
        this.searcher = searcher;
        this.address = address;
        this.previousResults = previousResults;
        this.panel = panel;
        this.forward = forward;
    }

    @Override
    public void loadResults(Accumulator<MemoryMatch<SearchData>> accumulator, TaskMonitor monitor) {
        accumulator.addAll(this.previousResults);
        this.match = this.searcher.findOnce(this.address, this.forward, monitor);
        if (this.match != null) {
            MemoryMatch<SearchData> existing = this.findExisingMatch(this.match.getAddress());
            if (existing != null) {
                existing.updateBytes(this.match.getBytes());
            } else {
                accumulator.add(this.match);
            }
        }
    }

    private MemoryMatch<SearchData> findExisingMatch(Address newMatchAddress) {
        for (MemoryMatch<SearchData> memoryMatch : this.previousResults) {
            if (!newMatchAddress.equals((Object)memoryMatch.getAddress())) continue;
            return memoryMatch;
        }
        return null;
    }

    @Override
    public boolean didTerminateEarly() {
        return false;
    }

    @Override
    public MemoryMatch getFirstMatch() {
        return this.match;
    }

    @Override
    public void dispose() {
        this.previousResults = null;
    }

    @Override
    public boolean hasResults() {
        return this.match != null;
    }
}

