/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import docking.widgets.button.GRadioButton;
import ghidra.features.base.memsearch.gui.MemorySearchProvider;
import ghidra.features.base.memsearch.scan.Scanner;
import ghidra.util.HelpLocation;
import help.Help;
import help.HelpService;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MemoryScanControlPanel
extends JPanel {
    private Scanner selectedScanner = Scanner.NOT_EQUALS;
    private boolean hasResults;
    private boolean isBusy;
    private JButton scanButton;
    private JButton compareButton;

    MemoryScanControlPanel(MemorySearchProvider provider) {
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.scanButton = new JButton("Scan Values");
        this.scanButton.setMnemonic('V');
        this.scanButton.setEnabled(false);
        this.scanButton.setToolTipText("Refreshes byte values of current results and eliminates those that don't meet the selected change criteria");
        this.add(this.scanButton);
        this.add(Box.createHorizontalStrut(20));
        this.compareButton = new JButton("Compare to...");
        this.compareButton.setEnabled(false);
        this.compareButton.setToolTipText("Create a new search using a new program, remapping the current results");
        this.add(this.compareButton);
        this.add(Box.createHorizontalStrut(20));
        this.add(this.buildButtonPanel());
        HelpService helpService = Help.getHelpService();
        helpService.registerHelp((Object)this, new HelpLocation("Search", "Scan_Controls"));
        this.scanButton.addActionListener(e -> provider.scan(this.selectedScanner));
        this.compareButton.addActionListener(e -> provider.generateNewProvider(this.selectedScanner));
    }

    private JComponent buildButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Scanner scanner : Scanner.values()) {
            GRadioButton button = new GRadioButton(scanner.getName());
            buttonGroup.add((AbstractButton)button);
            panel.add((Component)button);
            button.setSelected(scanner == this.selectedScanner);
            button.addActionListener(e -> {
                this.selectedScanner = scanner;
            });
            button.setToolTipText(scanner.getDescription());
        }
        return panel;
    }

    public void setSearchStatus(boolean hasResults, boolean isBusy) {
        this.hasResults = hasResults;
        this.isBusy = isBusy;
        this.updateScanButton();
        this.updateCompareButton();
    }

    private void updateScanButton() {
        this.scanButton.setEnabled(this.canScan());
    }

    private boolean canScan() {
        return this.hasResults && !this.isBusy;
    }

    private void updateCompareButton() {
        this.compareButton.setEnabled(this.canScan());
    }
}

