/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.mnemonic;

import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.services.MemorySearchService;
import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.mnemonic.MaskGenerator;
import ghidra.features.base.memsearch.mnemonic.MaskValue;
import ghidra.features.base.memsearch.mnemonic.SLMaskControl;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Search for Matching Instructions", description="This plugin will use the selected instructions and build a combined mask/value buffer. Memory is then searched looking for this combined value buffer that represents the selected instructions. This automates the process of searching through memory for a particular ordering of instructions by hand.", servicesRequired={MemorySearchService.class}, eventsConsumed={ProgramSelectionPluginEvent.class})
public class MnemonicSearchPlugin
extends Plugin {
    static final String MENU_PULLRIGHT = "\u5339\u914d\u6307\u4ee4\u641c\u7d22";
    static final String POPUP_MENU_GROUP = "Search";
    private NavigatableContextAction setSearchMnemonicOpsNoConstAction;
    private NavigatableContextAction setSearchMnemonicOpsConstAction;
    private NavigatableContextAction setSearchMnemonicNoOpsNoConstAction;
    public String maskedBitString;

    public MnemonicSearchPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void processAction(NavigatableActionContext context, boolean useOps, boolean useConsts) {
        NavigatableActionContext newContext = (NavigatableActionContext)context.getContextObject();
        Program program = newContext.getProgram();
        ProgramSelection selection = newContext.getSelection();
        if (selection.getNumAddressRanges() > 1) {
            Msg.showInfo((Object)((Object)this), (Component)context.getComponentProvider().getComponent(), (String)"\u52a9\u8bb0\u7b26\u641c\u7d22\u9519\u8bef", (Object)"\u4e0d\u5141\u8bb8\u591a\u4e2a\u9009\u5b9a\u533a\u57df\uff1b\u8bf7\u9650\u5236\u4e3a\u4e00\u4e2a\u3002");
            return;
        }
        SLMaskControl maskControl = new SLMaskControl(useOps, useConsts);
        MaskGenerator generator = new MaskGenerator(maskControl);
        MaskValue mask = generator.getMask(program, selection);
        if (mask != null) {
            this.maskedBitString = this.createMaskedBitString(mask.getValue(), mask.getMask());
            MemorySearchService memorySearchService = (MemorySearchService)this.tool.getService(MemorySearchService.class);
            SearchSettings settings = new SearchSettings().withSearchFormat(SearchFormat.BINARY);
            memorySearchService.createMemorySearchProvider(context.getNavigatable(), this.maskedBitString, settings, false);
        }
    }

    private void createActions() {
        String group = "search for";
        String pullRightGroup = "0";
        this.tool.setMenuGroup(new String[]{"\u641c\u7d22", MENU_PULLRIGHT}, group, pullRightGroup);
        HelpLocation helpLocation = new HelpLocation(POPUP_MENU_GROUP, "Mnemonic_Search");
        this.setSearchMnemonicOpsNoConstAction = new NavigatableContextAction("\u5305\u542b\u64cd\u4f5c\u6570\uff08\u9664\u5e38\u91cf\uff09", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                MnemonicSearchPlugin.this.processAction(context, true, false);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasSelection();
            }
        };
        this.setSearchMnemonicOpsNoConstAction.setMenuBarData(new MenuData(new String[]{"\u641c\u7d22", MENU_PULLRIGHT, "\u5305\u542b\u64cd\u4f5c\u6570\uff08\u9664\u5e38\u91cf\uff09"}, null, group, -1, "3"));
        this.setSearchMnemonicOpsNoConstAction.setHelpLocation(helpLocation);
        this.setSearchMnemonicOpsNoConstAction.addToWindowWhen(NavigatableActionContext.class);
        this.setSearchMnemonicOpsConstAction = new NavigatableContextAction("\u5305\u542b\u64cd\u4f5c\u6570", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                MnemonicSearchPlugin.this.processAction(context, true, true);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasSelection();
            }
        };
        this.setSearchMnemonicOpsConstAction.setMenuBarData(new MenuData(new String[]{"\u641c\u7d22", MENU_PULLRIGHT, "\u5305\u542b\u64cd\u4f5c\u6570"}, null, group, -1, "2"));
        this.setSearchMnemonicOpsConstAction.setHelpLocation(helpLocation);
        this.setSearchMnemonicOpsConstAction.addToWindowWhen(NavigatableActionContext.class);
        this.setSearchMnemonicNoOpsNoConstAction = new NavigatableContextAction("\u6392\u9664\u64cd\u4f5c\u6570", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                MnemonicSearchPlugin.this.processAction(context, false, false);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasSelection();
            }
        };
        this.setSearchMnemonicNoOpsNoConstAction.setMenuBarData(new MenuData(new String[]{"\u641c\u7d22", MENU_PULLRIGHT, "\u6392\u9664\u64cd\u4f5c\u6570"}, null, group, -1, "1"));
        this.setSearchMnemonicNoOpsNoConstAction.setHelpLocation(helpLocation);
        this.setSearchMnemonicNoOpsNoConstAction.addToWindowWhen(NavigatableActionContext.class);
        this.tool.addAction((DockingActionIf)this.setSearchMnemonicOpsNoConstAction);
        this.tool.addAction((DockingActionIf)this.setSearchMnemonicOpsConstAction);
        this.tool.addAction((DockingActionIf)this.setSearchMnemonicNoOpsNoConstAction);
        this.tool.setMenuGroup(new String[]{MENU_PULLRIGHT}, POPUP_MENU_GROUP);
    }

    private String createMaskedBitString(byte[] values, byte[] masks) {
        String bitString = new String();
        if (values.length != masks.length) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                bitString = (masks[i] >> 7 - j & 1) == 0 ? bitString.concat(".") : ((values[i] >> 7 - j & 1) == 0 ? bitString.concat("0") : bitString.concat("1"));
            }
            bitString = bitString.concat(" ");
        }
        return bitString;
    }
}

