/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.searcher;

import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeSplitter;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.bytesearch.AddressableByteSequence;
import ghidra.util.bytesearch.ExtendedByteSequence;
import ghidra.util.bytesearch.Match;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.task.TaskMonitor;
import java.util.function.Predicate;

public class MemorySearcher<T> {
    private static final int DEFAULT_CHUNK_SIZE = 16384;
    private static final int OVERLAP_SIZE = 100;
    private AddressableByteSequence preBytes;
    private AddressableByteSequence mainBytes;
    private AddressableByteSequence postBytes;
    private final ByteMatcher<T> matcher;
    private final int chunkSize;
    private Predicate<MemoryMatch<T>> filter = r -> true;
    private final int searchLimit;
    private final AddressSetView searchSet;

    public MemorySearcher(AddressableByteSource byteSource, ByteMatcher<T> matcher, AddressSetView addresses, int searchLimit) {
        this(byteSource, matcher, addresses, searchLimit, 16384);
    }

    public MemorySearcher(AddressableByteSource byteSource, ByteMatcher<T> matcher, AddressSetView addresses, int searchLimit, int chunkSize) {
        this.matcher = matcher;
        this.searchSet = addresses;
        this.searchLimit = searchLimit;
        this.chunkSize = chunkSize;
        this.preBytes = new AddressableByteSequence(byteSource, chunkSize);
        this.mainBytes = new AddressableByteSequence(byteSource, chunkSize);
        this.postBytes = new AddressableByteSequence(byteSource, chunkSize);
    }

    public void setMatchFilter(Predicate<MemoryMatch<T>> filter) {
        this.filter = filter;
    }

    public boolean findAll(Accumulator<MemoryMatch<T>> accumulator, TaskMonitor monitor) {
        monitor.initialize(this.searchSet.getNumAddresses(), "Searching...");
        for (AddressRange range : this.searchSet.getAddressRanges()) {
            if (this.findAll(accumulator, range, monitor)) continue;
            return false;
        }
        return true;
    }

    public MemoryMatch<T> findOnce(Address start, boolean forward, TaskMonitor monitor) {
        if (forward) {
            return this.findNext(start, monitor);
        }
        return this.findPrevious(start, monitor);
    }

    public MemoryMatch<T> findNext(Address start, TaskMonitor monitor) {
        long numAddresses = this.searchSet.getNumAddresses() - this.searchSet.getAddressCountBefore(start);
        monitor.initialize(numAddresses, "Searching....");
        for (AddressRange range : this.searchSet.getAddressRanges(start, true)) {
            MemoryMatch<T> match = this.findFirst(range = range.intersectRange(start, range.getMaxAddress()), monitor);
            if (match != null) {
                return match;
            }
            if (!monitor.isCancelled()) continue;
            break;
        }
        return null;
    }

    public MemoryMatch<T> findPrevious(Address start, TaskMonitor monitor) {
        monitor.initialize(this.searchSet.getAddressCountBefore(start) + 1L, "Searching....");
        for (AddressRange range : this.searchSet.getAddressRanges(start, false)) {
            MemoryMatch<T> match = this.findLast(range, start, monitor);
            if (match != null) {
                return match;
            }
            if (!monitor.isCancelled()) continue;
            break;
        }
        return null;
    }

    private MemoryMatch<T> findFirst(AddressRange range, TaskMonitor monitor) {
        this.preBytes.clear();
        this.mainBytes.clear();
        this.postBytes.clear();
        AddressRangeSplitter it = new AddressRangeSplitter(range, this.chunkSize, true);
        AddressRange first = (AddressRange)it.next();
        this.mainBytes.setRange(first);
        while (it.hasNext()) {
            AddressRange next = (AddressRange)it.next();
            this.postBytes.setRange(next);
            MemoryMatch<T> match = this.findFirst(monitor);
            if (match != null) {
                return match;
            }
            if (monitor.isCancelled()) break;
            this.rotateBuffers();
        }
        this.postBytes.clear();
        return this.findFirst(monitor);
    }

    private MemoryMatch<T> findLast(AddressRange range, Address start, TaskMonitor monitor) {
        this.preBytes.clear();
        this.mainBytes.clear();
        this.postBytes.clear();
        if (range.contains(start)) {
            Address min = range.getMinAddress();
            Address max = range.getMaxAddress();
            range = new AddressRangeImpl(min, start);
            AddressRangeImpl remaining = new AddressRangeImpl(start.next(), max);
            AddressRange extraRange = new AddressRangeSplitter((AddressRange)remaining, this.chunkSize, true).next();
            this.postBytes.setRange(extraRange);
        }
        AddressRangeSplitter it = new AddressRangeSplitter(range, this.chunkSize, false);
        this.mainBytes.setRange((AddressRange)it.next());
        while (it.hasNext()) {
            AddressRange next = (AddressRange)it.next();
            this.preBytes.setRange(next);
            MemoryMatch<T> match = this.findLast(monitor);
            if (match != null) {
                return match;
            }
            if (monitor.isCancelled()) break;
            this.rotateBuffersBackwards();
        }
        this.preBytes.clear();
        return this.findLast(monitor);
    }

    private MemoryMatch<T> findFirst(TaskMonitor monitor) {
        ExtendedByteSequence sequence = new ExtendedByteSequence(this.mainBytes, this.preBytes, this.postBytes, 100);
        for (Match<T> byteMatch : this.matcher.match(sequence)) {
            byte[] bytes;
            Address address = this.mainBytes.getAddress((int)byteMatch.getStart());
            MemoryMatch<T> match = new MemoryMatch<T>(address, bytes = sequence.getBytes((int)byteMatch.getStart(), byteMatch.getLength()), byteMatch.getPattern());
            if (this.filter.test(match)) {
                return match;
            }
            if (!monitor.isCancelled()) continue;
            break;
        }
        monitor.incrementProgress((long)this.mainBytes.getLength());
        return null;
    }

    private MemoryMatch<T> findLast(TaskMonitor monitor) {
        MemoryMatch<T> last = null;
        ExtendedByteSequence searchSequence = new ExtendedByteSequence(this.mainBytes, this.preBytes, this.postBytes, 100);
        for (Match<T> byteMatch : this.matcher.match(searchSequence)) {
            byte[] bytes;
            Address address = this.mainBytes.getAddress((int)byteMatch.getStart());
            MemoryMatch<T> match = new MemoryMatch<T>(address, bytes = searchSequence.getBytes((int)byteMatch.getStart(), byteMatch.getLength()), byteMatch.getPattern());
            if (this.filter.test(match)) {
                last = match;
            }
            if (!monitor.isCancelled()) continue;
            return null;
        }
        monitor.incrementProgress((long)this.mainBytes.getLength());
        return last;
    }

    private boolean findAll(Accumulator<MemoryMatch<T>> accumulator, AddressRange range, TaskMonitor monitor) {
        this.preBytes.clear();
        this.mainBytes.clear();
        this.postBytes.clear();
        AddressRangeSplitter it = new AddressRangeSplitter(range, this.chunkSize, true);
        AddressRange first = (AddressRange)it.next();
        this.mainBytes.setRange(first);
        while (it.hasNext()) {
            AddressRange next = (AddressRange)it.next();
            this.postBytes.setRange(next);
            if (!this.findAllInBuffers(accumulator, monitor)) {
                return false;
            }
            this.rotateBuffers();
        }
        this.postBytes.clear();
        return this.findAllInBuffers(accumulator, monitor);
    }

    private void rotateBuffers() {
        AddressableByteSequence tmp = this.preBytes;
        this.preBytes = this.mainBytes;
        this.mainBytes = this.postBytes;
        this.postBytes = tmp;
    }

    private void rotateBuffersBackwards() {
        AddressableByteSequence tmp = this.postBytes;
        this.postBytes = this.mainBytes;
        this.mainBytes = this.preBytes;
        this.preBytes = tmp;
    }

    private boolean findAllInBuffers(Accumulator<MemoryMatch<T>> accumulator, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return false;
        }
        ExtendedByteSequence searchSequence = new ExtendedByteSequence(this.mainBytes, this.preBytes, this.postBytes, 100);
        for (Match<T> match : this.matcher.match(searchSequence)) {
            byte[] bytes;
            Address address = this.mainBytes.getAddress((int)match.getStart());
            MemoryMatch<T> memMatch = new MemoryMatch<T>(address, bytes = searchSequence.getBytes((int)match.getStart(), match.getLength()), match.getPattern());
            if (this.filter.test(memMatch)) {
                if (accumulator.size() >= this.searchLimit) {
                    return false;
                }
                accumulator.add(memMatch);
            }
            if (!monitor.isCancelled()) continue;
            return false;
        }
        monitor.setMessage("Searching...");
        monitor.incrementProgress((long)this.mainBytes.getLength());
        return true;
    }
}

