/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.features.base.replace.SearchAndReplaceDialog;
import ghidra.features.base.replace.SearchAndReplaceProvider;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.bean.opteditor.OptionsVetoException;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Search", shortDescription="Search and replace text on program element names or comments.", description="This plugin provides a search and replace capability for a variety ofprogram elements including functions, classes, namespaces, datatypes, field names, andother.", servicesRequired={ProgramManager.class, GoToService.class})
public class SearchAndReplacePlugin
extends ProgramPlugin {
    private SearchAndReplaceDialog cachedDialog;
    private int searchLimit = 500;
    private OptionsChangeListener searchOptionsListener;
    private List<SearchAndReplaceProvider> providers = new ArrayList<SearchAndReplaceProvider>();

    public SearchAndReplacePlugin(PluginTool plugintool) {
        super(plugintool);
        this.createActions();
        this.initializeOptions();
    }

    @Override
    protected void programClosed(Program program) {
        ArrayList<SearchAndReplaceProvider> copy = new ArrayList<SearchAndReplaceProvider>(this.providers);
        for (SearchAndReplaceProvider provider : copy) {
            provider.programClosed(program);
        }
    }

    private void initializeOptions() {
        ToolOptions options = this.tool.getOptions("Search");
        this.searchLimit = options.getInt("Search Limit", 500);
        this.searchOptionsListener = this::searchOptionsChanged;
        options.addOptionsChangeListener(this.searchOptionsListener);
    }

    private void searchOptionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals("Search Limit")) {
            int limit = (Integer)newValue;
            if (limit <= 0) {
                throw new OptionsVetoException("Search limit must be greater than 0");
            }
            this.searchLimit = limit;
            if (this.cachedDialog != null) {
                this.cachedDialog.setSearchLimit(limit);
            }
        }
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("\u641c\u7d22\u548c\u66ff\u6362", this.getName()).menuPath(new String[]{"\u641c\u7d22", "\u641c\u7d22\u548c\u66ff\u6362..."})).menuGroup("search", "d")).description("\u641c\u7d22\u548c\u66ff\u6362\u5404\u79cd\u7a0b\u5e8f\u5143\u7d20\u7684\u540d\u79f0")).helpLocation(new HelpLocation("Search", "Search And Replace"))).withContext(NavigatableActionContext.class, true).onAction(this::searchAndReplace).buildAndInstall((Tool)this.tool);
    }

    private void searchAndReplace(NavigatableActionContext c) {
        SearchAndReplaceDialog dialog = this.getDialog();
        SearchAndReplaceQuery query = dialog.show(this.tool);
        if (query == null) {
            return;
        }
        Program program = c.getProgram();
        this.providers.add(new SearchAndReplaceProvider(this, program, query));
    }

    private SearchAndReplaceDialog getDialog() {
        if (this.cachedDialog == null) {
            this.cachedDialog = new SearchAndReplaceDialog(this.searchLimit);
        }
        return this.cachedDialog;
    }

    void providerClosed(SearchAndReplaceProvider provider) {
        this.providers.remove((Object)provider);
    }
}

