/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.SingleFileSystemIndexHelper;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractSinglePayloadFileSystem
implements GFileSystem {
    protected final FSRLRoot fsFSRL;
    protected final FileSystemRefManager refManager = new FileSystemRefManager(this);
    protected final SingleFileSystemIndexHelper fsIndex;
    protected ByteProvider payloadProvider;

    public AbstractSinglePayloadFileSystem(FSRLRoot fsFSRL, ByteProvider payloadProvider, String payloadFilename) {
        this(fsFSRL, payloadProvider, payloadFilename, FileAttributes.EMPTY);
    }

    public AbstractSinglePayloadFileSystem(FSRLRoot fsFSRL, ByteProvider payloadProvider, String payloadFilename, FileAttributes payloadAttrs) {
        this.fsFSRL = fsFSRL;
        this.payloadProvider = payloadProvider;
        String md5 = payloadProvider.getFSRL() != null ? payloadProvider.getFSRL().getMD5() : null;
        this.fsIndex = new SingleFileSystemIndexHelper(this, fsFSRL, payloadFilename, payloadProvider.length(), md5);
        this.fsIndex.setPayloadFileAttributes(payloadAttrs);
    }

    public GFile getPayloadFile() {
        return this.fsIndex.getPayloadFile();
    }

    @Override
    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndex.clear();
        FSUtilities.uncheckedClose(this.payloadProvider, null);
        this.payloadProvider = null;
    }

    @Override
    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    @Override
    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    @Override
    public boolean isClosed() {
        return this.fsIndex.isClosed();
    }

    @Override
    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    @Override
    public int getFileCount() {
        return 1;
    }

    @Override
    public GFile lookup(String path) throws IOException {
        return this.fsIndex.lookup(path);
    }

    @Override
    public GFile lookup(String path, Comparator<String> nameComp) throws IOException {
        return this.fsIndex.lookup(null, path, nameComp);
    }

    @Override
    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fsIndex.isPayloadFile(file)) {
            return new ByteProviderWrapper(this.payloadProvider, file.getFSRL());
        }
        return null;
    }

    @Override
    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndex.getListing(directory);
    }

    @Override
    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        return this.fsIndex.getFileAttributes(file);
    }
}

