/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.batch;

import docking.DialogComponentProvider;
import docking.widgets.ListSelectionTableDialog;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GDLabel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GThemeDefaults;
import ghidra.app.services.ProgramManager;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugins.importer.batch.BatchGroup;
import ghidra.plugins.importer.batch.BatchGroupLoadSpec;
import ghidra.plugins.importer.batch.BatchImportTableModel;
import ghidra.plugins.importer.batch.BatchInfo;
import ghidra.plugins.importer.batch.BatchProjectDestinationPanel;
import ghidra.plugins.importer.batch.UserAddedSourceInfo;
import ghidra.plugins.importer.tasks.ImportBatchTask;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BatchImportDialog
extends DialogComponentProvider {
    private static final String PREF_STRIPCONTAINER = "BATCHIMPORT.STRIPCONTAINER";
    private static final String PREF_STRIPLEADING = "BATCHIMPORT.STRIPLEADING";
    private static final String PREF_MIRRORFS = "BATCHIMPORT.MIRRORFS";
    private static final String LAST_IMPORT_DIR = "LastBatchImportDir";
    private BatchInfo batchInfo;
    private DomainFolder destinationFolder;
    private ProgramManager programManager;
    private boolean stripLeading = BatchImportDialog.getBooleanPref("BATCHIMPORT.STRIPLEADING", true);
    private boolean stripContainer = BatchImportDialog.getBooleanPref("BATCHIMPORT.STRIPCONTAINER", false);
    private boolean mirrorFs = BatchImportDialog.getBooleanPref("BATCHIMPORT.MIRRORFS", false);
    private boolean openAfterImporting = false;
    private GCheckBox stripLeadingCb;
    private GCheckBox stripContainerCb;
    private GCheckBox mirrorFsCb;
    private BatchImportTableModel tableModel;
    private GTable table;
    private JButton removeSourceButton;
    private JButton rescanButton;
    private JSpinner maxDepthSpinner;
    private SourcesListModel sourceListModel;

    public static void showAndImport(PluginTool tool, BatchInfo batchInfo, List<FSRL> initialFiles, DomainFolder defaultFolder, ProgramManager programManager) {
        BatchImportDialog dialog = new BatchImportDialog(batchInfo, defaultFolder, programManager);
        Swing.runLater(() -> {
            if (initialFiles != null && !initialFiles.isEmpty()) {
                dialog.addSources(initialFiles);
            }
            if (!dialog.setupInitialDefaults()) {
                return;
            }
            tool.showDialog((DialogComponentProvider)dialog);
        });
    }

    private BatchImportDialog(BatchInfo batchInfo, DomainFolder defaultFolder, ProgramManager programManager) {
        super("Batch Import", true);
        this.batchInfo = batchInfo != null ? batchInfo : new BatchInfo();
        this.destinationFolder = defaultFolder != null ? defaultFolder : AppInfo.getActiveProject().getProjectData().getRootFolder();
        this.programManager = programManager;
        this.setHelpLocation(new HelpLocation("ImporterPlugin", "Batch_Import_Dialog"));
        this.setPreferredSize(900, 600);
        this.build();
    }

    private void build() {
        this.tableModel = new BatchImportTableModel(this.batchInfo){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                super.setValueAt(aValue, rowIndex, columnIndex);
                BatchImportDialog.this.refreshButtons();
            }
        };
        this.table = new GTable((TableModel)((Object)this.tableModel));
        this.table.getAccessibleContext().setAccessibleName("\u591a\u9879\u5185\u5bb9");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                int row = BatchImportDialog.this.table.rowAtPoint(p);
                int col = BatchImportDialog.this.table.columnAtPoint(p);
                TableColumnModel columnModel = BatchImportDialog.this.table.getColumnModel();
                TableColumn column = columnModel.getColumn(col);
                int modelIndex = column.getModelIndex();
                if (modelIndex == BatchImportTableModel.COLS.FILES.ordinal()) {
                    BatchImportDialog.this.showFiles(row);
                }
            }
        });
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        TableColumn selectedColumn = this.table.getColumnModel().getColumn(BatchImportTableModel.COLS.SELECTED.ordinal());
        selectedColumn.setResizable(false);
        selectedColumn.setMaxWidth(50);
        TableColumn filesColumn = this.table.getColumnModel().getColumn(BatchImportTableModel.COLS.FILES.ordinal());
        filesColumn.setCellEditor(this.createFilesColumnCellEditor());
        filesColumn.setCellRenderer(this.createFilesColumnCellRenderer());
        TableColumn langColumn = this.table.getColumnModel().getColumn(BatchImportTableModel.COLS.LANG.ordinal());
        langColumn.setCellEditor(this.createLangColumnCellEditor());
        langColumn.setCellRenderer(this.createLangColumnCellRenderer());
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        JPanel filesPanel = new JPanel();
        filesPanel.setLayout(new BorderLayout());
        filesPanel.add((Component)scrollPane, "Center");
        filesPanel.setBorder(this.createTitledBorder("\u5bfc\u5165\u6587\u4ef6", true));
        JPanel sourceListPanel = new JPanel();
        sourceListPanel.setLayout(new BorderLayout());
        sourceListPanel.setBorder(this.createTitledBorder("\u5bfc\u5165\u6e90", false));
        sourceListPanel.getAccessibleContext().setAccessibleName("\u6e90\u5217\u8868");
        this.sourceListModel = new SourcesListModel();
        final JList<String> sourceList = new JList<String>(this.sourceListModel);
        sourceList.setName("batch.import.source.list");
        sourceList.getAccessibleContext().setAccessibleName("\u591a\u9879\u5bfc\u5165\u6e90\u5217\u8868");
        sourceList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                boolean hasSelection = sourceList.getSelectedIndices().length > 0;
                this.removeSourceButton.setEnabled(hasSelection);
            }
        });
        JScrollPane sourceListScrollPane = new JScrollPane(sourceList);
        sourceListPanel.add((Component)sourceListScrollPane, "Center");
        sourceListScrollPane.getAccessibleContext().setAccessibleName("\u6e90\u5217\u8868\u6eda\u52a8");
        JPanel sourceOptionsPanel = new JPanel();
        sourceOptionsPanel.getAccessibleContext().setAccessibleName("\u6e90\u9009\u9879");
        sourceOptionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        sourceListPanel.add((Component)sourceOptionsPanel, "South");
        JPanel maxDepthPanel = new JPanel();
        GDLabel maxDepthLabel = new GDLabel("\u6df1\u5ea6\u9650\u5236\uff1a");
        String maxDepthTip = "\u6e90\u6587\u4ef6\u4e2d\u9012\u5f52\u89e3\u6790\u7684\u6700\u5927\u5bb9\u5668\u6df1\u5ea6\uff08\u4f8b\u5982\u5d4c\u5957\u7684 zip\u3001tar \u7b49\uff09\u3002";
        maxDepthLabel.setToolTipText(maxDepthTip);
        maxDepthPanel.add((Component)maxDepthLabel);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.batchInfo.getMaxDepth(), 0, 99, 1);
        this.maxDepthSpinner = new JSpinner(spinnerNumberModel);
        this.maxDepthSpinner.setToolTipText(maxDepthTip);
        this.rescanButton = new JButton("\u91cd\u65b0");
        this.rescanButton.setToolTipText("\u6e05\u7a7a\u6587\u4ef6\u5bfc\u5165\u5217\u8868\u5e76\u91cd\u65b0\u626b\u63cf\u5bfc\u5165\u6e90\u4ee5\u5bfc\u5165\u5e94\u7528\u7a0b\u5e8f\u3002");
        spinnerNumberModel.addChangeListener(e -> this.rescanButton.setEnabled(spinnerNumberModel.getNumber().intValue() != this.batchInfo.getMaxDepth()));
        this.rescanButton.addActionListener(e -> Swing.runLater(() -> this.setMaxDepth(spinnerNumberModel.getNumber().intValue())));
        maxDepthPanel.add(this.maxDepthSpinner);
        maxDepthPanel.add(this.rescanButton);
        sourceOptionsPanel.add(maxDepthPanel);
        JPanel sourceListButtonsPanel = new JPanel();
        sourceListButtonsPanel.setLayout(new BorderLayout());
        sourceListButtonsPanel.getAccessibleContext().setAccessibleName("\u6e90\u5217\u8868\u6309\u94ae");
        JButton addSourceButton = new JButton("\u6dfb\u52a0");
        addSourceButton.getAccessibleContext().setAccessibleName("\u6dfb\u52a0\u6e90");
        this.removeSourceButton = new JButton("\u79fb\u9664");
        this.removeSourceButton.setEnabled(false);
        this.removeSourceButton.getAccessibleContext().setAccessibleName("\u79fb\u9664");
        addSourceButton.addActionListener(e -> this.addSources());
        this.removeSourceButton.addActionListener(e -> {
            ArrayList<FSRL> sourcesToRemove = new ArrayList<FSRL>();
            for (int index : sourceList.getSelectedIndices()) {
                if (index < 0 || index >= this.batchInfo.getUserAddedSources().size()) continue;
                UserAddedSourceInfo uasi = this.batchInfo.getUserAddedSources().get(index);
                sourcesToRemove.add(uasi.getFSRL());
            }
            Object object = sourcesToRemove.iterator();
            while (object.hasNext()) {
                FSRL fsrl = (FSRL)object.next();
                this.batchInfo.remove(fsrl);
            }
            this.refreshData();
        });
        sourceListButtonsPanel.add((Component)addSourceButton, "North");
        sourceListButtonsPanel.add((Component)this.removeSourceButton, "South");
        JPanel buttonWrapperPanel = new JPanel();
        buttonWrapperPanel.add(sourceListButtonsPanel);
        sourceListPanel.add((Component)buttonWrapperPanel, "East");
        this.sourceListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                boolean hasSelection = sourceList.getSelectedIndices().length > 0;
                BatchImportDialog.this.removeSourceButton.setEnabled(hasSelection);
            }
        });
        JPanel outputOptionsPanel = this.buildOutputOptionsPanel();
        outputOptionsPanel.getAccessibleContext().setAccessibleName("\u8f93\u51fa\u9009\u9879");
        Box box = Box.createVerticalBox();
        box.add(sourceListPanel);
        box.add(filesPanel);
        box.add(outputOptionsPanel);
        box.getAccessibleContext().setAccessibleName("\u591a\u9879\u5bfc\u5165");
        this.addOKButton();
        this.addCancelButton();
        this.addWorkPanel(box);
    }

    private Border createTitledBorder(String title, boolean drawLine) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(" " + title + " "));
    }

    private JPanel buildOutputOptionsPanel() {
        JPanel outputChoicesPanel = new JPanel();
        outputChoicesPanel.setLayout(new BoxLayout(outputChoicesPanel, 2));
        outputChoicesPanel.getAccessibleContext().setAccessibleName("\u8f93\u51fa\u9009\u9879");
        this.stripLeadingCb = new GCheckBox("\u53bb\u9664\u524d\u5bfc\u8def\u5f84", this.stripLeading);
        this.stripLeadingCb.addChangeListener(e -> this.setStripLeading(this.stripLeadingCb.isSelected()));
        this.stripLeadingCb.setToolTipText("\u5bfc\u5165\u6587\u4ef6\u7684\u76ee\u6807\u6587\u4ef6\u5939\u5c06\u4e0d\u5305\u542b\u6e90\u6587\u4ef6\u7684\u524d\u5bfc\u8def\u5f84\u3002");
        this.stripLeadingCb.getAccessibleContext().setAccessibleName("\u53bb\u9664\u524d\u5bfc\u8def\u5f84");
        this.stripContainerCb = new GCheckBox("\u53bb\u9664\u5bb9\u5668\u8def\u5f84", this.stripContainer);
        this.stripContainerCb.addChangeListener(e -> this.setStripContainer(this.stripContainerCb.isSelected()));
        this.stripContainerCb.setToolTipText("\u5bfc\u5165\u6587\u4ef6\u7684\u76ee\u6807\u6587\u4ef6\u5939\u5c06\u4e0d\u4f1a\u5305\u542b\u4efb\u4f55\u6e90\u8def\u5f84\u540d\u79f0\u3002");
        this.stripContainerCb.getAccessibleContext().setAccessibleName("\u53bb\u9664\u5bb9\u5668\u8def\u5f84");
        this.mirrorFsCb = new GCheckBox("Mirror Filesystem", this.mirrorFs);
        this.mirrorFsCb.addChangeListener(e -> this.setMirrorFs(this.mirrorFsCb.isSelected()));
        this.mirrorFsCb.setToolTipText("The imported files' project paths will mirror the filesystem rooted at the desination folder");
        this.mirrorFsCb.getAccessibleContext().setAccessibleName("Mirror Filesystem");
        this.setMirrorFs(this.mirrorFs);
        GCheckBox openAfterImportCb = new GCheckBox("\u5bfc\u5165\u540e\u6253\u5f00", this.openAfterImporting);
        openAfterImportCb.addChangeListener(e -> this.setOpenAfterImporting(openAfterImportCb.isSelected()));
        openAfterImportCb.setToolTipText("\u5728\u4ee3\u7801\u6d4f\u89c8\u5668\u4e2d\u6253\u5f00\u5bfc\u5165\u7684\u4e8c\u8fdb\u5236\u6587\u4ef6");
        openAfterImportCb.getAccessibleContext().setAccessibleName("\u5bfc\u5165\u540e\u6253\u5f00");
        outputChoicesPanel.add((Component)this.stripLeadingCb);
        outputChoicesPanel.add((Component)this.stripContainerCb);
        outputChoicesPanel.add((Component)this.mirrorFsCb);
        if (this.programManager != null) {
            outputChoicesPanel.add((Component)openAfterImportCb);
        }
        outputChoicesPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        BatchProjectDestinationPanel destPanel = new BatchProjectDestinationPanel(this.getComponent(), this.destinationFolder){

            @Override
            public void onProjectDestinationChange(DomainFolder newFolder) {
                BatchImportDialog.this.destinationFolder = newFolder;
            }
        };
        JPanel outputOptionsPanel = new JPanel(new BorderLayout());
        outputOptionsPanel.setBorder(this.createTitledBorder("\u5bfc\u5165\u9009\u9879", true));
        outputOptionsPanel.add((Component)outputChoicesPanel, "North");
        outputOptionsPanel.add((Component)destPanel, "South");
        outputOptionsPanel.getAccessibleContext().setAccessibleName("\u8f93\u51fa\u9009\u9879");
        return outputOptionsPanel;
    }

    private void showFiles(int row) {
        BatchGroup group = (BatchGroup)this.tableModel.getRowObject(row);
        List<BatchGroup.BatchLoadConfig> batchLoadConfigs = group.getBatchLoadConfig();
        List names = batchLoadConfigs.stream().map(batchLoadConfig -> batchLoadConfig.getPreferredFileName()).sorted().collect(Collectors.toList());
        ListSelectionTableDialog dialog = new ListSelectionTableDialog("Application Files", names);
        dialog.hideOkButton();
        dialog.showSelectMultiple((Component)this.table);
    }

    private void setOpenAfterImporting(boolean b) {
        this.openAfterImporting = b;
    }

    private void refreshData() {
        this.sourceListModel.refresh();
        this.tableModel.refreshData();
        this.maxDepthSpinner.setValue(this.batchInfo.getMaxDepth());
        this.refreshButtons();
    }

    private void refreshButtons() {
        this.setOkEnabled(this.batchInfo.getEnabledCount() > 0);
        this.rescanButton.setEnabled(((Number)this.maxDepthSpinner.getValue()).intValue() != this.batchInfo.getMaxDepth());
    }

    public boolean setupInitialDefaults() {
        if (this.batchInfo.getUserAddedSources().isEmpty() && !this.addSources()) {
            return false;
        }
        if (this.batchInfo.getMaxDepth() < 2) {
            this.setMaxDepth(2);
        }
        return true;
    }

    private boolean addSources() {
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.getComponent());
        chooser.setMultiSelectionEnabled(true);
        chooser.setTitle("\u9009\u62e9\u6587\u4ef6\u6279\u91cf\u5bfc\u5165");
        chooser.setApproveButtonText("\u9009\u62e9\u6587\u4ef6");
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_AND_DIRECTORIES);
        chooser.addFileFilter(ImporterUtilities.LOADABLE_FILES_FILTER);
        chooser.addFileFilter(ImporterUtilities.CONTAINER_FILES_FILTER);
        chooser.setSelectedFileFilter(GhidraFileFilter.ALL);
        chooser.setLastDirectoryPreference(LAST_IMPORT_DIR);
        List selectedFiles = chooser.getSelectedFiles();
        if (selectedFiles.isEmpty()) {
            return !chooser.wasCancelled();
        }
        ArrayList<FSRL> filesToAdd = new ArrayList<FSRL>();
        for (File selectedFile : selectedFiles) {
            filesToAdd.add(FileSystemService.getInstance().getLocalFSRL(selectedFile));
        }
        chooser.dispose();
        return this.addSources(filesToAdd);
    }

    private boolean addSources(List<FSRL> filesToAdd) {
        List<FSRL> updatedFiles = filesToAdd.stream().map(FSRL::convertRootToContainer).toList();
        List<FSRL> badFiles = this.batchInfo.addFiles(updatedFiles);
        if (!badFiles.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (FSRL fsrl : badFiles) {
                if (sb.length() > 0) {
                    sb.append(",\n");
                }
                sb.append(fsrl.getPath());
            }
            Msg.showWarn((Object)((Object)this), (Component)this.getComponent(), (String)("\u8df3\u8fc7 " + badFiles.size() + " \u6587\u4ef6"), (Object)("\u5c06\u6587\u4ef6\u6dfb\u52a0\u5230\u6279\u5904\u7406\u4e2d\u65f6\u9047\u5230\u7a0b\u5e8f\uff1a" + sb.toString()));
        }
        this.refreshData();
        return true;
    }

    protected void okCallback() {
        new TaskLauncher((Task)new ImportBatchTask(this.batchInfo, this.destinationFolder, this.openAfterImporting ? this.programManager : null, this.stripLeading, this.stripContainer, this.mirrorFs), (Component)this.getComponent());
        this.close();
    }

    private TableCellEditor createFilesColumnCellEditor() {
        GComboBox comboBox = new GComboBox();
        DefaultCellEditor cellEditor = new DefaultCellEditor((JComboBox)comboBox, (JComboBox)comboBox){
            final /* synthetic */ JComboBox val$comboBox;
            {
                this.val$comboBox = jComboBox;
                super(arg0);
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return true;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jtable, Object value, boolean isSelected, int row, int column) {
                this.val$comboBox.setSelectedItem("");
                this.val$comboBox.removeAllItems();
                BatchGroup rowVal = (BatchGroup)BatchImportDialog.this.tableModel.getRowObject(row);
                this.val$comboBox.addItem(rowVal.size() + " \u6587\u4ef6...");
                for (BatchGroup.BatchLoadConfig batchLoadConfig : rowVal.getBatchLoadConfig()) {
                    this.val$comboBox.addItem(batchLoadConfig.getPreferredFileName());
                }
                return super.getTableCellEditorComponent((JTable)BatchImportDialog.this.table, value, isSelected, row, column);
            }
        };
        cellEditor.setClickCountToStart(2);
        return cellEditor;
    }

    private TableCellRenderer createFilesColumnCellRenderer() {
        GTableCellRenderer cellRenderer = new GTableCellRenderer(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
                renderer.setToolTipText("\u70b9\u51fb\u67e5\u770b\u6587\u4ef6");
                return renderer;
            }

            protected String getText(Object value) {
                BatchGroup batchGroup = (BatchGroup)value;
                if (batchGroup != null) {
                    return batchGroup.size() + " \u6587\u4ef6...";
                }
                return "";
            }
        };
        return cellRenderer;
    }

    private TableCellEditor createLangColumnCellEditor() {
        GComboBox comboBox = new GComboBox();
        DefaultCellEditor cellEditor = new DefaultCellEditor((JComboBox)comboBox, (JComboBox)comboBox){
            final /* synthetic */ JComboBox val$comboBox;
            {
                this.val$comboBox = jComboBox;
                super(arg0);
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jtable, Object value, boolean isSelected, int row, int column) {
                this.val$comboBox.removeAllItems();
                BatchGroup batchGroup = (BatchGroup)BatchImportDialog.this.tableModel.getRowObject(row);
                for (BatchGroupLoadSpec bo : batchGroup.getCriteria().getBatchGroupLoadSpecs()) {
                    this.val$comboBox.addItem(bo);
                }
                return super.getTableCellEditorComponent(jtable, value, isSelected, row, column);
            }
        };
        return cellEditor;
    }

    private TableCellRenderer createLangColumnCellRenderer() {
        GTableCellRenderer cellRenderer = new GTableCellRenderer(){
            {
                this.setHTMLRenderingEnabled(true);
            }

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
                renderer.setToolTipText("\u70b9\u51fb\u8bbe\u7f6e\u8bed\u8a00");
                return renderer;
            }

            protected String getText(Object value) {
                BatchGroupLoadSpec bgls = (BatchGroupLoadSpec)value;
                return bgls != null ? bgls.toString() : "<html><font size=\"-2\" color=\"" + String.valueOf(GThemeDefaults.Colors.Messages.HINT) + "\">Click to set language</font>";
            }
        };
        return cellRenderer;
    }

    private void setStripLeading(boolean stripLeading) {
        this.stripLeading = stripLeading;
        BatchImportDialog.setBooleanPref(PREF_STRIPLEADING, stripLeading);
    }

    private void setStripContainer(boolean stripContainer) {
        this.stripContainer = stripContainer;
        BatchImportDialog.setBooleanPref(PREF_STRIPCONTAINER, stripContainer);
    }

    private void setMirrorFs(boolean mirrorFs) {
        this.mirrorFs = mirrorFs;
        BatchImportDialog.setBooleanPref(PREF_MIRRORFS, mirrorFs);
        this.stripContainerCb.setEnabled(!mirrorFs);
        this.stripContainerCb.setSelected(mirrorFs ? false : this.stripContainer);
    }

    private void setMaxDepth(int newMaxDepth) {
        if (newMaxDepth == this.batchInfo.getMaxDepth()) {
            return;
        }
        this.batchInfo.setMaxDepth(newMaxDepth);
        this.refreshData();
    }

    private static boolean getBooleanPref(String name, boolean defaultValue) {
        return Boolean.parseBoolean(Preferences.getProperty((String)name, (String)Boolean.toString(defaultValue), (boolean)true));
    }

    private static void setBooleanPref(String name, boolean value) {
        Preferences.setProperty((String)name, (String)Boolean.toString(value));
    }

    private class SourcesListModel
    extends AbstractListModel<String> {
        int prevSize;

        private SourcesListModel() {
            this.prevSize = BatchImportDialog.this.batchInfo.getUserAddedSources().size();
        }

        @Override
        public int getSize() {
            return this.prevSize;
        }

        @Override
        public String getElementAt(int index) {
            List<UserAddedSourceInfo> list = BatchImportDialog.this.batchInfo.getUserAddedSources();
            if (index >= list.size()) {
                return "Missing";
            }
            UserAddedSourceInfo uasi = list.get(index);
            String info = String.format("%s [%d files/%d apps/%d containers/%d%s levels]", uasi.getFSRL().getPath(), uasi.getRawFileCount(), uasi.getFileCount(), uasi.getContainerCount(), uasi.getMaxNestLevel() - uasi.getFSRL().getNestingDepth() + 1, uasi.wasRecurseTerminatedEarly() ? "+" : "");
            return info;
        }

        public void refresh() {
            if (this.prevSize > 0) {
                this.fireIntervalRemoved(this, 0, this.prevSize - 1);
            }
            this.prevSize = BatchImportDialog.this.batchInfo.getUserAddedSources().size();
            if (this.prevSize > 0) {
                this.fireIntervalAdded(this, 0, this.prevSize - 1);
            }
        }
    }
}

