/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.batch;

import docking.widgets.button.BrowseButton;
import docking.widgets.label.GDLabel;
import docking.widgets.textfield.ElidingFilePathTextField;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

class BatchProjectDestinationPanel
extends JPanel {
    private JComponent parent;
    private JTextField folderNameTextField;
    private DomainFolder selectedDomainFolder;

    public BatchProjectDestinationPanel(JComponent parent, DomainFolder defaultFolder) {
        this.parent = parent;
        this.build();
        this.setFolder(defaultFolder != null ? defaultFolder : BatchProjectDestinationPanel.getProjectRootFolder());
    }

    public void onProjectDestinationChange(DomainFolder newDomainFolder) {
    }

    private void build() {
        this.setLayout(new BorderLayout());
        this.folderNameTextField = new ElidingFilePathTextField();
        this.folderNameTextField.setEditable(false);
        this.folderNameTextField.setFocusable(false);
        this.folderNameTextField.setText(BatchProjectDestinationPanel.getProjectRootFolder().toString());
        GDLabel folderLabel = new GDLabel("Destination Folder");
        folderLabel.setLabelFor(this.folderNameTextField);
        BrowseButton browseButton = new BrowseButton();
        browseButton.addActionListener(e -> this.browseFolders());
        JPanel savePanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        savePanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        gbc.insets.right = 0;
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints((Component)folderLabel, gbc);
        savePanel.add((Component)folderLabel);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbl.setConstraints(this.folderNameTextField, gbc);
        savePanel.add(this.folderNameTextField);
        gbc.insets.right = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbl.setConstraints((Component)browseButton, gbc);
        savePanel.add((Component)browseButton);
        Box box = Box.createVerticalBox();
        box.add(savePanel);
        this.add((Component)box, "Center");
    }

    private void browseFolders() {
        DataTreeDialog dataTreeDialog = new DataTreeDialog(this.parent, "Choose a project folder", DataTreeDialogType.CHOOSE_FOLDER);
        dataTreeDialog.addOkActionListener(e -> {
            dataTreeDialog.close();
            this.setFolder(dataTreeDialog.getDomainFolder());
        });
        dataTreeDialog.setSelectedFolder(this.selectedDomainFolder);
        dataTreeDialog.showComponent();
    }

    public void setFolder(DomainFolder folder) {
        this.folderNameTextField.setText(folder != null ? folder.toString() : "< Choose a folder >");
        this.selectedDomainFolder = folder;
        this.onProjectDestinationChange(this.selectedDomainFolder);
    }

    public DomainFolder getFolder() {
        return this.selectedDomainFolder;
    }

    private static DomainFolder getProjectRootFolder() {
        Project project = AppInfo.getActiveProject();
        ProjectData projectData = project.getProjectData();
        return projectData.getRootFolder();
    }
}

