/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.theme.GColor;
import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.properties.UnsupportedMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkComparator;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.AddressIteratorConverter;
import ghidra.program.util.AddressRangeIteratorConverter;
import ghidra.program.util.CombinedAddressRangeIterator;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.MultiAddressIterator;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMemoryComparator;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.Msg;
import ghidra.util.MultiComparableArrayIterator;
import ghidra.util.NumericUtilities;
import ghidra.util.Saveable;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.NoValueException;
import ghidra.util.map.TypeMismatchException;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ProgramDiffDetails {
    private static final int INDENT_SIZE = 4;
    private static final String STANDARD_NEW_LINE = "\n";
    private static Color FG_COLOR_ADDRESS = new GColor("color.fg.plugin.programdiff.details.address");
    private static Color FG_COLOR_COMMENT = new GColor("color.fg.plugin.programdiff.details.comment");
    private static Color FG_COLOR_DANGER = new GColor("color.fg.plugin.programdiff.details.danger");
    private static Color FG_COLOR_EMPHASIZE = new GColor("color.fg.plugin.programdiff.details.emphasize");
    private static Color FG_COLOR_PROGRAM = new GColor("color.fg.plugin.programdiff.details.program");
    private static final Color EMPHASIZE_COLOR = FG_COLOR_EMPHASIZE;
    private static final Color ADDRESS_COLOR = FG_COLOR_ADDRESS;
    private static final Color COMMENT_COLOR = FG_COLOR_COMMENT;
    private static final BookmarkComparator BOOKMARK_COMPARATOR = new BookmarkComparator();
    private Program p1;
    private Program p2;
    private Address currentP1Address;
    private Address currentP2Address;
    private Listing l1;
    private Listing l2;
    private CodeUnit cu1;
    private CodeUnit cu2;
    private CodeUnit cu1At;
    private CodeUnit cu2At;
    private Address minP1Address;
    private Address maxP1Address;
    private AddressSet checkP1AddressSet;
    private boolean noDifferences;
    private boolean noMem;
    private String newLine = "\n";
    protected String indent1 = ProgramDiffDetails.getIndentString(1);
    protected String indent2 = ProgramDiffDetails.getIndentString(2);
    protected String indent3 = ProgramDiffDetails.getIndentString(3);
    protected String indent4 = ProgramDiffDetails.getIndentString(4);
    private StyledDocument detailsDoc;
    private SimpleAttributeSet textAttrSet;
    private int maxRegisterName;
    private boolean hasProgramContextDiffs = false;
    private boolean hasByteDiffs = false;
    private boolean hasCodeUnitDiffs = false;
    private boolean hasFunctionDiffs = false;
    private boolean hasSymbolDiffs = false;
    private boolean hasEquateDiffs = false;
    private boolean hasRefDiffs = false;
    private boolean hasPlateCommentDiffs = false;
    private boolean hasPreCommentDiffs = false;
    private boolean hasEolCommentDiffs = false;
    private boolean hasRepeatableCommentDiffs = false;
    private boolean hasPostCommentDiffs = false;
    private boolean hasBookmarkDiffs = false;
    private boolean hasTagDiffs = false;
    private boolean hasUserDefinedDiffs = false;

    public ProgramDiffDetails(Program p1, Program p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.initDetails();
        this.textAttrSet = new SimpleAttributeSet();
    }

    private static String getIndentString(int indentCount) {
        int indentChars = indentCount * 4;
        StringBuffer buf = new StringBuffer(indentChars);
        for (int i = 0; i < indentChars; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String getDiffDetails(Program p1, Program p2, Address p1DiffAddress) {
        ProgramDiffDetails diffDetails = new ProgramDiffDetails(p1, p2);
        return diffDetails.getDiffDetails(p1DiffAddress);
    }

    public static String getDiffDetails(Program p1, Program p2, Address p1DiffAddress, ProgramDiffFilter filter) {
        ProgramDiffDetails diffDetails = new ProgramDiffDetails(p1, p2);
        return diffDetails.getDiffDetails(p1DiffAddress, filter);
    }

    public String getDiffDetails(Address p1DiffAddress) {
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.getAllDetails(p1DiffAddress, doc, null);
        String text = null;
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)("Error getting Diff details for address " + p1DiffAddress.toString() + "."), (Throwable)e);
        }
        return text;
    }

    public String getDiffDetails(Address p1DiffAddress, ProgramDiffFilter filter) {
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.getDetails(p1DiffAddress, filter, doc, null);
        String text = null;
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)("Error getting Diff details for address " + p1DiffAddress.toString() + "."), (Throwable)e);
        }
        return text;
    }

    public void getAllDetails(Address p1DiffAddress, StyledDocument doc, String prefixString) {
        this.resetDetails(p1DiffAddress, doc);
        if (prefixString != null) {
            this.addText(prefixString + STANDARD_NEW_LINE);
        }
        if (this.noMem) {
            this.addText(doc, "Program" + (this.cu1 == null ? "1" : "2") + " ");
            Program p = this.cu1 == null ? this.p1 : this.p2;
            this.addColorProgram(doc, p.getDomainFile().toString());
            this.addText(" has ");
            this.addDangerColorText("no memory");
            this.addText(" at address ");
            this.addColorAddress(this.currentP1Address);
            this.addText(".\n\n");
            return;
        }
        this.noDifferences = true;
        this.addHeader();
        this.addProgramContextDetails();
        this.addByteDetails();
        this.addCodeUnitDetails();
        this.addFunctionDetails();
        this.addSymbolDetails();
        this.addEquateDetails();
        this.addRefDetails();
        this.addPlateCommentDetails();
        this.addPreCommentDetails();
        this.addEOLCommentDetails();
        this.addRepeatableCommentDetails();
        this.addPostCommentDetails();
        this.addBookmarkDetails();
        this.addUserDefinedDetails();
        this.noDifferences = !this.hasProgramContextDiffs && !this.hasByteDiffs && !this.hasCodeUnitDiffs && !this.hasFunctionDiffs && !this.hasSymbolDiffs && !this.hasEquateDiffs && !this.hasRefDiffs && !this.hasPlateCommentDiffs && !this.hasPreCommentDiffs && !this.hasEolCommentDiffs && !this.hasRepeatableCommentDiffs && !this.hasPostCommentDiffs && !this.hasBookmarkDiffs && !this.hasTagDiffs && !this.hasUserDefinedDiffs;
        this.addFooter();
    }

    public void getDetails(Address p1DiffAddress, ProgramDiffFilter filter, StyledDocument doc, String prefixString) {
        this.resetDetails(p1DiffAddress, doc);
        if (prefixString != null) {
            this.addText(prefixString + STANDARD_NEW_LINE);
        }
        if (this.noMem) {
            this.addText(doc, "Program" + (this.cu1 == null ? "1" : "2") + " ");
            Program p = this.cu1 == null ? this.p1 : this.p2;
            this.addColorProgram(doc, p.getDomainFile().toString());
            this.addText(" has ");
            this.addDangerColorText("no memory");
            this.addText(" at address ");
            this.addColorAddress(this.currentP1Address);
            this.addText(".\n\n");
            return;
        }
        this.noDifferences = true;
        this.addHeader();
        if (filter.getFilter(1)) {
            this.addProgramContextDetails();
        }
        if (filter.getFilter(2)) {
            this.addByteDetails();
        }
        if (filter.getFilter(4)) {
            this.addCodeUnitDetails();
        }
        if (filter.getFilter(2048)) {
            this.addFunctionDetails();
        }
        if (filter.getFilter(1024)) {
            this.addSymbolDetails();
        }
        if (filter.getFilter(512)) {
            this.addEquateDetails();
        }
        if (filter.getFilter(256)) {
            this.addRefDetails();
        }
        if (filter.getFilter(64)) {
            this.addPlateCommentDetails();
        }
        if (filter.getFilter(16)) {
            this.addPreCommentDetails();
        }
        if (filter.getFilter(8)) {
            this.addEOLCommentDetails();
        }
        if (filter.getFilter(128)) {
            this.addRepeatableCommentDetails();
        }
        if (filter.getFilter(32)) {
            this.addPostCommentDetails();
        }
        if (filter.getFilter(4096)) {
            this.addBookmarkDetails();
        }
        if (filter.getFilter(8192)) {
            this.addUserDefinedDetails();
        }
        this.noDifferences = !this.hasProgramContextDiffs && !this.hasByteDiffs && !this.hasCodeUnitDiffs && !this.hasFunctionDiffs && !this.hasSymbolDiffs && !this.hasEquateDiffs && !this.hasRefDiffs && !this.hasPlateCommentDiffs && !this.hasPreCommentDiffs && !this.hasEolCommentDiffs && !this.hasRepeatableCommentDiffs && !this.hasPostCommentDiffs && !this.hasBookmarkDiffs && !this.hasTagDiffs && !this.hasUserDefinedDiffs;
        this.addFooter();
    }

    private void addHeader() {
        if (this.minP1Address.equals((Object)this.maxP1Address)) {
            this.bold(true);
            this.underline(true);
            this.addText("Difference details for address");
            this.underline(false);
            this.addText(": ");
            this.addColorAddress(this.minP1Address);
            this.bold(false);
            this.addText(this.newLine);
        } else {
            this.bold(true);
            this.underline(true);
            this.addText("Difference details for address range");
            this.underline(false);
            this.addText(": ");
            this.addText("[ ");
            this.addColorAddress(this.minP1Address);
            this.addText(" - ");
            this.addColorAddress(this.maxP1Address);
            this.addText(" ]");
            this.bold(false);
            this.addText(this.newLine);
        }
    }

    private void addFooter() {
        if (this.noDifferences) {
            this.addText(this.indent1 + "No " + (this.noMem ? "other " : "") + "differences." + this.newLine);
        }
    }

    private void initDetails() {
        this.l1 = this.p1.getListing();
        this.l2 = this.p2.getListing();
        this.maxRegisterName = "Register".length();
        for (Register element : this.p1.getProgramContext().getRegisters()) {
            this.maxRegisterName = Math.max(this.maxRegisterName, element.getName().length());
        }
    }

    private void resetDetails(Address p1DiffAddress, StyledDocument doc) {
        this.currentP1Address = p1DiffAddress;
        this.currentP2Address = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)p1DiffAddress, (Program)this.p2);
        this.detailsDoc = doc;
        this.noMem = false;
        try {
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)("Error resetting Diff details for address " + p1DiffAddress.toString() + "."), (Throwable)e);
        }
        this.hasProgramContextDiffs = false;
        this.hasByteDiffs = false;
        this.hasCodeUnitDiffs = false;
        this.hasFunctionDiffs = false;
        this.hasSymbolDiffs = false;
        this.hasEquateDiffs = false;
        this.hasRefDiffs = false;
        this.hasPlateCommentDiffs = false;
        this.hasPreCommentDiffs = false;
        this.hasEolCommentDiffs = false;
        this.hasRepeatableCommentDiffs = false;
        this.hasPostCommentDiffs = false;
        this.hasBookmarkDiffs = false;
        this.hasTagDiffs = false;
        this.hasUserDefinedDiffs = false;
        this.cu1At = this.l1.getCodeUnitAt(this.currentP1Address);
        this.cu2At = this.currentP2Address != null ? this.l2.getCodeUnitAt(this.currentP2Address) : null;
        this.cu1 = this.l1.getCodeUnitContaining(this.currentP1Address);
        CodeUnit codeUnit = this.cu2 = this.currentP2Address != null ? this.l2.getCodeUnitContaining(this.currentP2Address) : null;
        if (this.cu1 == null || this.cu2 == null) {
            this.noMem = true;
        }
        Address cu1Min = this.cu1 != null ? this.cu1.getMinAddress() : null;
        Address cu1Max = this.cu1 != null ? this.cu1.getMaxAddress() : null;
        Address cu2Min = this.cu2 != null ? this.cu2.getMinAddress() : null;
        Address cu2Max = this.cu2 != null ? this.cu2.getMaxAddress() : null;
        Address cu2MinAsP1Addr = SimpleDiffUtility.getCompatibleAddress((Program)this.p2, (Address)cu2Min, (Program)this.p1);
        Address cu2MaxAsP1Addr = SimpleDiffUtility.getCompatibleAddress((Program)this.p2, (Address)cu2Max, (Program)this.p1);
        this.minP1Address = cu2MinAsP1Addr == null || cu1Min != null && cu1Min.compareTo((Object)cu2MinAsP1Addr) <= 0 ? cu1Min : cu2MinAsP1Addr;
        this.maxP1Address = cu2MaxAsP1Addr == null || cu1Max != null && cu1Max.compareTo((Object)cu2MaxAsP1Addr) >= 0 ? cu1Max : cu2MaxAsP1Addr;
        this.checkP1AddressSet = new AddressSet(this.minP1Address, this.maxP1Address);
    }

    public AddressSetView getDetailsAddressSet(Address p1Address) {
        CodeUnit codeunit2;
        Address p2Address = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)p1Address, (Program)this.p2);
        CodeUnit codeunit1 = p1Address != null ? this.l1.getCodeUnitContaining(p1Address) : null;
        CodeUnit codeUnit = codeunit2 = p2Address != null ? this.l2.getCodeUnitContaining(p2Address) : null;
        if (codeunit1 == null || codeunit2 == null) {
            this.noMem = true;
            return new AddressSet();
        }
        Address cu1Min = codeunit1.getMinAddress();
        Address cu1Max = codeunit1.getMaxAddress();
        Address cu2Min = codeunit2.getMinAddress();
        Address cu2Max = codeunit2.getMaxAddress();
        Address cu2MinAsP1Addr = SimpleDiffUtility.getCompatibleAddress((Program)this.p2, (Address)cu2Min, (Program)this.p1);
        Address cu2MaxAsP1Addr = SimpleDiffUtility.getCompatibleAddress((Program)this.p2, (Address)cu2Max, (Program)this.p1);
        Address minimum = cu2MinAsP1Addr == null || cu1Min.compareTo((Object)cu2MinAsP1Addr) <= 0 ? cu1Min : cu2MinAsP1Addr;
        Address maximum = cu2MaxAsP1Addr == null || cu1Max.compareTo((Object)cu2MaxAsP1Addr) >= 0 ? cu1Max : cu2MaxAsP1Addr;
        return new AddressSet(minimum, maximum);
    }

    private void addByteDetails() {
        int addrLen = Math.max(7, this.minP1Address.toString().length());
        Memory mem1 = this.p1.getMemory();
        Memory mem2 = this.p2.getMemory();
        try {
            Address tmpAddr = this.minP1Address;
            while (tmpAddr.compareTo((Object)this.maxP1Address) <= 0) {
                this.addByteInfo(tmpAddr, addrLen, mem1, mem2);
                tmpAddr = tmpAddr.add(1L);
            }
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
    }

    private void addByteHeader(int addrLength, Memory mem1, Memory mem2) {
        this.addDiffHeader("Byte");
        this.addByteInfo(null, addrLength, mem1, mem2);
    }

    private void addByteInfo(Address p1Address, int addrLength, Memory mem1, Memory mem2) {
        String separatorSpaces = this.getSpaces(2);
        if (p1Address == null) {
            String spacesAfterAddr = this.getSpaces(addrLength - "Address".length());
            this.addText(this.indent1);
            this.underline("Address");
            this.addText(spacesAfterAddr);
            this.addText(separatorSpaces);
            this.underline("Program1");
            this.addText(separatorSpaces);
            this.underline("Program2");
            this.addText(this.newLine);
        } else {
            Object b2Str;
            Object b1Str;
            Address p2Address = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)p1Address, (Program)this.p2);
            String addr = p1Address.toString();
            boolean hasB1 = true;
            boolean hasB2 = true;
            try {
                byte b1 = mem1.getByte(p1Address);
                b1Str = "0x" + this.getHexByte(b1);
            }
            catch (MemoryAccessException e) {
                b1Str = "Undefined";
                hasB1 = false;
            }
            if (p2Address != null) {
                try {
                    byte b2 = mem2.getByte(p2Address);
                    b2Str = "0x" + this.getHexByte(b2);
                }
                catch (MemoryAccessException e) {
                    b2Str = "Undefined";
                    hasB2 = false;
                }
            } else {
                b2Str = "Undefined";
                hasB2 = false;
            }
            if (((String)b1Str).equals(b2Str)) {
                return;
            }
            if (!this.hasByteDiffs) {
                this.addByteHeader(addrLength, mem1, mem2);
                this.hasByteDiffs = true;
            }
            String spacesAfterAddr = this.getSpaces(addrLength - addr.length());
            this.addText(this.indent1);
            this.addColorAddress(p1Address);
            this.addText(spacesAfterAddr);
            this.addText(separatorSpaces);
            if (hasB1) {
                this.addText("  ");
            }
            this.addColorText((String)b1Str);
            if (hasB1) {
                this.addText("   ");
            }
            this.addText(separatorSpaces);
            if (hasB2) {
                this.addText("  ");
            }
            this.addColorText((String)b2Str);
            this.addText(this.newLine);
        }
    }

    private String getHexByte(byte b) {
        String bStr = Integer.toHexString(b);
        if (b >= 0 && b <= 15) {
            return "0" + bStr;
        }
        if (bStr.length() > 2) {
            bStr = bStr.substring(bStr.length() - 2);
        }
        return bStr;
    }

    private void addSymbolDetails() {
        try {
            Address tmpAddr = this.minP1Address;
            while (tmpAddr.compareTo((Object)this.maxP1Address) <= 0) {
                this.addLabelInfo(tmpAddr);
                tmpAddr = tmpAddr.add(1L);
            }
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
    }

    private void addLabelInfo(Address p1Address) {
        boolean entryPtsDiffer;
        Address p2Address = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)p1Address, (Program)this.p2);
        Symbol[] s1 = this.p1.getSymbolTable().getSymbols(p1Address);
        Symbol[] s2 = p2Address != null ? this.p2.getSymbolTable().getSymbols(p2Address) : new Symbol[]{};
        s1 = this.stripDefaultLabels(s1);
        s2 = this.stripDefaultLabels(s2);
        if (s1.length == 0 && s2.length == 0) {
            return;
        }
        Comparator c = SymbolUtilities.getSymbolNameComparator();
        Arrays.sort(s1, c);
        Arrays.sort(s2, c);
        boolean s1IsEntry = s1.length > 0 && s1[0].isExternalEntryPoint();
        boolean s2IsEntry = s2.length > 0 && s2[0].isExternalEntryPoint();
        boolean bl = entryPtsDiffer = s1IsEntry != s2IsEntry;
        if (entryPtsDiffer && !this.hasSymbolDiffs) {
            this.addDiffHeader("Label");
            this.hasSymbolDiffs = true;
        }
        boolean sameSyms = this.sameSymbols(s1, s2);
        int maxLen = "Name".length();
        int maxTypeLen = "Type".length();
        int maxSourceLen = "Source".length();
        if (!sameSyms) {
            int sourceLen;
            int typelen;
            int len;
            if (!this.hasSymbolDiffs) {
                this.addDiffHeader("Label");
                this.hasSymbolDiffs = true;
            }
            for (Symbol element : s1) {
                len = element.getName().length();
                if (len > maxLen) {
                    maxLen = len;
                }
                if ((typelen = element.getSymbolType().toString().length()) > maxTypeLen) {
                    maxTypeLen = typelen;
                }
                if ((sourceLen = element.getSource().toString().length()) <= maxSourceLen) continue;
                maxSourceLen = sourceLen;
            }
            for (Symbol element : s2) {
                len = element.getName().length();
                if (len > maxLen) {
                    maxLen = len;
                }
                if ((typelen = element.getSymbolType().toString().length()) > maxTypeLen) {
                    maxTypeLen = typelen;
                }
                if ((sourceLen = element.getSource().toString().length()) <= maxSourceLen) continue;
                maxSourceLen = sourceLen;
            }
            this.addSymbolInfo(1, p1Address, s1IsEntry, s1, maxLen, maxTypeLen, maxSourceLen);
            this.addSymbolInfo(2, p2Address, s2IsEntry, s2, maxLen, maxTypeLen, maxSourceLen);
        } else if (entryPtsDiffer) {
            this.addSymbolInfo(1, p1Address, s1IsEntry, null, 0, 0, 0);
            this.addSymbolInfo(2, p2Address, s2IsEntry, null, 0, 0, 0);
        }
    }

    private Symbol[] stripDefaultLabels(Symbol[] originalSymbols) {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (Symbol symbol : originalSymbols) {
            SymbolType symbolType = symbol.getSymbolType();
            if (!symbolType.equals((Object)SymbolType.FUNCTION) && (!symbolType.equals((Object)SymbolType.LABEL) || symbol.getSource().equals((Object)SourceType.DEFAULT))) continue;
            list.add(symbol);
        }
        return list.toArray(new Symbol[list.size()]);
    }

    private void addEntryPtLine(Address addr) {
        this.addText(this.indent2);
        this.addColorAddress(addr);
        this.addText(" is an ");
        this.addColorText("External Entry Point");
        this.addText("." + this.newLine);
    }

    private void addSymbolInfo(int pgmNum, Address pgmAddress, boolean isEntryPt, Symbol[] symbols, int maxLen, int maxTypeLen, int maxSourceLen) {
        this.addProgramText(pgmNum, pgmAddress);
        if (isEntryPt) {
            this.addEntryPtLine(pgmAddress);
        }
        if (symbols == null) {
            return;
        }
        if (symbols.length == 0) {
            this.addText(this.indent2 + "No symbols." + this.newLine);
            return;
        }
        this.addDisplayLabel(null, maxLen, maxTypeLen, maxSourceLen);
        for (Symbol symbol : symbols) {
            this.addDisplayLabel(symbol, maxLen, maxTypeLen, maxSourceLen);
        }
    }

    private boolean sameSymbols(Symbol[] s1, Symbol[] s2) {
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (ProgramDiff.equivalentSymbols(this.p1, this.p2, s1[i], s2[i])) continue;
            return false;
        }
        return true;
    }

    private void addDisplayLabel(Symbol symbol, int nameLength, int typeLength, int sourceLength) {
        String name = "";
        String type = "";
        Object primary = this.getSpaces(7);
        String source = "";
        String namespace = "";
        String yes = this.getSpaces(2) + "yes" + this.getSpaces(2);
        String separatorSpaces = this.getSpaces(2);
        this.addText(this.indent2);
        if (symbol == null) {
            this.underline("Name");
            this.addText(this.getSpaces(nameLength - "Name".length()));
            this.addText(separatorSpaces);
            this.underline("Type");
            this.addText(this.getSpaces(typeLength - "Type".length()));
            this.addText(separatorSpaces);
            this.underline("Primary");
            this.addText(separatorSpaces);
            this.underline("Source");
            this.addText(this.getSpaces(sourceLength - "Source".length()));
            this.addText(separatorSpaces);
            this.underline("Namespace");
        } else {
            Namespace parentNS;
            name = symbol.getName();
            SymbolType symType = symbol.getSymbolType();
            type = symType.toString();
            source = symbol.getSource().toString();
            if (symbol.isPrimary()) {
                primary = yes;
            }
            namespace = (parentNS = symbol.getParentNamespace()) instanceof GlobalNamespace ? parentNS.getName() : parentNS.getName(true);
            this.addColorText(name);
            this.addText(this.getSpaces(nameLength - name.length()));
            this.addText(separatorSpaces);
            this.addColorText(type);
            this.addText(this.getSpaces(typeLength - type.length()));
            this.addText(separatorSpaces);
            this.addColorText((String)primary);
            this.addText(separatorSpaces);
            this.addColorText(source);
            this.addText(this.getSpaces(sourceLength - source.length()));
            this.addText(separatorSpaces);
            this.addColorText(namespace);
            if (symbol.isPinned()) {
                this.addText(separatorSpaces);
                this.addColorText("(pinned)");
            }
        }
        this.addText(this.newLine);
    }

    private void addCodeUnitDetails() {
        if (this.cu1 instanceof Data && this.cu2 instanceof Data) {
            if (!this.isSameData((Data)this.cu1, (Data)this.cu2)) {
                this.addSubDataInfo((Data)this.cu1, (Data)this.cu2);
            }
        } else if (this.cu1 instanceof Instruction && this.cu2 instanceof Instruction) {
            if (!this.isSameInstruction((Instruction)this.cu1, (Instruction)this.cu2)) {
                this.addSimpleCodeUnitInfo();
            }
        } else {
            this.addSimpleCodeUnitInfo();
        }
    }

    private void addSubDataInfo(Data d1, Data d2) {
        Address addr;
        CodeUnit cu;
        String indent = this.indent2;
        StringBuffer buf1 = new StringBuffer();
        StringBuffer buf2 = new StringBuffer();
        this.compareDataCUs(d1, d2, buf1, buf2, indent);
        this.addDiffHeader("Code Unit");
        this.addProgramText(1);
        this.addText(buf1.toString());
        if (this.cu1At != null && (cu = this.l1.getCodeUnitAfter(this.cu1At.getMaxAddress())) != null) {
            addr = cu.getMinAddress();
            this.addText(this.getCodeUnitInfo(this.l1, addr, indent));
        }
        this.addProgramText(2);
        this.addText(buf2.toString());
        if (this.cu2At != null && (cu = this.l2.getCodeUnitAfter(this.cu2At.getMaxAddress())) != null) {
            addr = cu.getMinAddress();
            this.addText(this.getCodeUnitInfo(this.l2, addr, indent));
        }
        this.hasCodeUnitDiffs = true;
    }

    private void compareDataTypeComponents(DataTypeComponent dtc1, DataTypeComponent dtc2, StringBuffer buf1, StringBuffer buf2, String indent) {
        this.getComponentInfo(dtc1, buf1, indent);
        this.getComponentInfo(dtc2, buf2, indent);
        this.compareSubDataTypes(dtc1.getDataType(), dtc2.getDataType(), buf1, buf2, indent);
    }

    private void compareSubDataTypes(DataType dt1, DataType dt2, StringBuffer buf1, StringBuffer buf2, String indent) {
        String newIndent = indent + this.indent1;
        DataType actualDt1 = dt1;
        DataType actualDt2 = dt2;
        if (actualDt1 != actualDt2 && (actualDt1 instanceof Structure && actualDt2 instanceof Structure || actualDt1 instanceof Union && actualDt2 instanceof Union)) {
            this.compareCompositeComponents((Composite)actualDt1, (Composite)actualDt2, buf1, buf2, newIndent);
        }
    }

    private void compareCompositeComponents(Composite dt1, Composite dt2, StringBuffer buf1, StringBuffer buf2, String newIndent) {
        DataTypeComponent[] compDt2;
        DataTypeComponent[] compDt1 = dt1.getComponents();
        int min = compDt1.length <= (compDt2 = dt2.getComponents()).length ? compDt1.length : compDt2.length;
        for (int i = 0; i < min; ++i) {
            this.compareDataTypeComponents(compDt1[i], compDt2[i], buf1, buf2, newIndent);
        }
        for (int index1 = i; index1 < compDt1.length; ++index1) {
            this.getComponentInfo(compDt1[index1], buf1, newIndent);
        }
        for (int index2 = i; index2 < compDt2.length; ++index2) {
            this.getComponentInfo(compDt2[index2], buf2, newIndent);
        }
    }

    private void compareDataCUs(Data d1, Data d2, StringBuffer buf1, StringBuffer buf2, String indent) {
        String newIndent = indent + this.indent1;
        DataType actualDt1 = d1.getDataType();
        DataType actualDt2 = d2.getDataType();
        String name1 = this.getCategoryName(actualDt1);
        String name2 = this.getCategoryName(actualDt2);
        this.getCUString(indent, buf1, this.cu1);
        this.getCUString(indent, buf2, this.cu2);
        if (actualDt1 != actualDt2 && name1.equals(name2) && (actualDt1 instanceof Structure && actualDt2 instanceof Structure || actualDt1 instanceof Union && actualDt2 instanceof Union)) {
            this.compareCompositeComponents((Composite)actualDt1, (Composite)actualDt2, buf1, buf2, newIndent);
        }
    }

    private DataType getComponentInfo(DataTypeComponent dtc, StringBuffer buf, String indent) {
        int offset = dtc.getOffset();
        int ordinal = dtc.getOrdinal();
        String comment = dtc.getComment();
        String fieldName = dtc.getFieldName();
        DataType actualDt = dtc.getDataType();
        if (fieldName == null) {
            fieldName = dtc.getDefaultFieldName();
        }
        buf.append(indent + "Offset=" + NumericUtilities.toSignedHexString((long)offset) + " Ordinal=" + ordinal + " " + fieldName + " " + actualDt.getMnemonic(actualDt.getDefaultSettings()) + "  " + this.getCategoryName(actualDt) + " DataTypeSize=" + (actualDt.isZeroLength() ? 0 : actualDt.getLength()) + " ComponentSize=" + dtc.getLength() + " " + (comment != null ? comment : "") + " " + this.newLine);
        return actualDt;
    }

    private String getCategoryName(DataType dt) {
        return dt.getPathName();
    }

    private void addSimpleCodeUnitInfo() {
        String cui2;
        String newIndent = this.indent2 + this.indent1;
        String cui1 = this.getCodeUnitInfo(this.l1, this.currentP1Address, newIndent);
        if (!cui1.equals(cui2 = this.getCodeUnitInfo(this.l2, this.currentP2Address, newIndent))) {
            this.addDiffHeader("Code Unit");
            this.addProgramText(1);
            this.addText(cui1);
            this.addProgramText(2);
            this.addText(cui2);
            this.hasCodeUnitDiffs = true;
        }
    }

    private String getCodeUnitInfo(Listing listing, Address addr, String indent) {
        int linesSoFar;
        CodeUnit cu;
        String newIndent = indent + this.indent1;
        CodeUnit codeUnit = cu = addr != null ? listing.getCodeUnitContaining(addr) : null;
        if (cu == null) {
            return indent + "No instruction or data." + this.newLine;
        }
        StringBuffer buf = new StringBuffer();
        Address maxAddress = this.maxP1Address;
        if (listing == this.l2) {
            maxAddress = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)this.maxP1Address, (Program)this.p2);
        }
        int maxVisibleLines = 100;
        for (linesSoFar = 0; cu != null && maxAddress != null && cu.getMinAddress().compareTo((Object)maxAddress) <= 0 && linesSoFar < maxVisibleLines; ++linesSoFar) {
            Data data;
            DataType dt;
            Address min = this.getCUString(indent, buf, cu);
            if (cu instanceof Data && (dt = (data = (Data)cu).getDataType()) instanceof Composite) {
                DataTypeComponent[] components;
                for (DataTypeComponent dtc : components = ((Composite)dt).getComponents()) {
                    int offset = dtc.getOffset();
                    String comment = dtc.getComment();
                    Object fieldName = dtc.getFieldName();
                    if (fieldName == null) {
                        fieldName = "field" + offset;
                    }
                    buf.append(newIndent + String.valueOf(min.add((long)offset)) + " " + dtc.getFieldName() + " " + dtc.getDataType().getName() + " length=" + dtc.getLength() + " " + (comment != null ? comment : "") + " " + this.newLine);
                }
            }
            cu = listing.getCodeUnitAfter(cu.getMaxAddress());
        }
        if (linesSoFar >= maxVisibleLines) {
            buf.append(newIndent + "... Too many code unit lines for display, so truncating at " + maxVisibleLines + " lines." + this.newLine);
        }
        return buf.toString();
    }

    private Address getCUString(String indent, StringBuffer buf, CodeUnit cu) {
        Object[] settingNames;
        Object cuRep;
        Data data;
        Address min = cu.getMinAddress();
        Address max = cu.getMaxAddress();
        String addrRangeStr = String.valueOf(min) + (String)(min.equals((Object)max) ? "" : " - " + String.valueOf(max));
        if (cu instanceof Data) {
            data = (Data)cu;
            cuRep = data.getDataType().getPathName();
        } else if (cu instanceof Instruction) {
            Instruction inst = (Instruction)cu;
            boolean removedFallThrough = inst.isFallThroughOverridden() && inst.getFallThrough() == null;
            boolean hasFlowOverride = inst.getFlowOverride() != FlowOverride.NONE;
            boolean hasLengthOverride = inst.isLengthOverridden();
            cuRep = cu.toString();
            if (removedFallThrough) {
                cuRep = (String)cuRep + this.newLine + indent + this.getSpaces(addrRangeStr.length()) + "    Removed FallThrough";
            } else if (inst.isFallThroughOverridden()) {
                Reference[] refs;
                Address fallThroughAddress = inst.getFallThrough();
                for (Reference ref : refs = inst.getReferencesFrom()) {
                    if (!ref.getReferenceType().isFallthrough()) continue;
                    Address toAddress = ref.getToAddress();
                    boolean isOverride = SystemUtilities.isEqual((Object)fallThroughAddress, (Object)toAddress);
                    String prefix = isOverride ? "FallThrough Override: " : "FallThrough Reference: ";
                    cuRep = (String)cuRep + this.newLine + indent + this.getSpaces(addrRangeStr.length()) + "    " + prefix + DiffUtility.getUserToAddressString(inst.getProgram(), ref);
                }
            }
            if (hasFlowOverride) {
                cuRep = (String)cuRep + this.newLine + indent + this.getSpaces(addrRangeStr.length()) + "    Flow Override: " + String.valueOf(inst.getFlowOverride());
            }
            if (hasLengthOverride) {
                cuRep = (String)cuRep + this.newLine + indent + this.getSpaces(addrRangeStr.length()) + "    Length Override: " + inst.getLength() + " (actual length is " + inst.getParsedLength() + ")";
            }
            cuRep = (String)cuRep + this.newLine + indent + this.getSpaces(addrRangeStr.length()) + "    Instruction Prototype hash = " + Integer.toHexString(inst.getPrototype().hashCode());
        } else {
            cuRep = cu.toString();
        }
        buf.append(indent + addrRangeStr + "    " + (String)cuRep + this.newLine);
        if (cu instanceof Data && (settingNames = (data = (Data)cu).getNames()).length != 0) {
            HashMap<String, SettingsDefinition> defMap = new HashMap<String, SettingsDefinition>();
            for (SettingsDefinition settingsDef : data.getDataType().getSettingsDefinitions()) {
                defMap.put(settingsDef.getStorageKey(), settingsDef);
            }
            buf.append(indent + indent + "Data Settings: ");
            int count = 0;
            Arrays.sort(settingNames);
            for (Object settingName : settingNames) {
                Object value = data.getValue((String)settingName);
                SettingsDefinition def = (SettingsDefinition)defMap.get(settingName);
                if (def != null) {
                    settingName = def.getName();
                }
                if (value instanceof Long && def instanceof EnumSettingsDefinition) {
                    EnumSettingsDefinition eDef = (EnumSettingsDefinition)def;
                    value = eDef.getValueString((Settings)data);
                }
                if (count++ != 0) {
                    buf.append(", ");
                }
                buf.append((String)settingName + "=" + String.valueOf(value));
            }
            buf.append(this.newLine);
        }
        return min;
    }

    private void addRefDetails() {
        ReferenceManager rm1 = this.p1.getReferenceManager();
        ReferenceManager rm2 = this.p2.getReferenceManager();
        Address addr1 = this.minP1Address;
        Address addr2 = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)addr1, (Program)this.p2);
        while (addr1.compareTo((Object)this.maxP1Address) <= 0) {
            Reference[] refs1 = rm1.getReferencesFrom(addr1);
            Reference[] refs2 = addr2 != null ? rm2.getReferencesFrom(addr2) : new Reference[]{};
            Object[] diffRefs1 = ProgramDiff.getDiffRefs(refs1);
            Object[] diffRefs2 = ProgramDiff.getDiffRefs(refs2);
            Arrays.sort(diffRefs1);
            Arrays.sort(diffRefs2);
            if (!ProgramDiff.equivalentReferenceArrays(this.p1, this.p2, (Reference[])diffRefs1, (Reference[])diffRefs2)) {
                this.getRefsText(addr1, (Reference[])diffRefs1, (Reference[])diffRefs2);
            }
            try {
                addr1 = addr1.addNoWrap(1L);
            }
            catch (AddressOverflowException e) {
                break;
            }
            addr2 = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)addr1, (Program)this.p2);
        }
    }

    private void getRefsText(Address p1Address, Reference[] refs1, Reference[] refs2) {
        Address p2Address = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)p1Address, (Program)this.p2);
        if (!this.hasRefDiffs) {
            this.addDiffHeader("Reference");
        }
        this.addProgramText(1, p1Address);
        this.addText(this.getProgramRefDetails(this.p1, refs1, this.p2));
        this.addProgramText(2, p2Address);
        this.addText(this.getProgramRefDetails(this.p2, refs2, this.p1));
        this.hasRefDiffs = true;
    }

    private String getRefInfo(Program pgm, Reference ref) {
        Symbol sym;
        String typeStr = "Type: " + String.valueOf(ref.getReferenceType());
        String fromStr = "  From: " + String.valueOf(ref.getFromAddress());
        String operandStr = ref.isMnemonicReference() ? "  Mnemonic" : "  Operand: " + ref.getOperandIndex();
        String toStr = "  To: " + DiffUtility.getUserToAddressString(pgm, ref);
        String sourceStr = "  " + ref.getSource().toString();
        String primaryStr = ref.isPrimary() ? "  Primary" : "";
        Object symbolStr = "";
        long symbolID = ref.getSymbolID();
        if (symbolID != -1L && (sym = pgm.getSymbolTable().getSymbol(symbolID)) != null) {
            symbolStr = "  Symbol: " + sym.getName(true);
        }
        return typeStr + fromStr + operandStr + toStr + sourceStr + primaryStr + (String)symbolStr;
    }

    private String getProgramRefDetails(Program pgm, Reference[] refs, Program otherProgram) {
        StringBuffer buf = new StringBuffer();
        for (Reference ref : refs) {
            Reference otherRef = DiffUtility.getReference(pgm, ref, otherProgram);
            if (otherRef != null && ProgramDiff.equivalentReferences(pgm, otherProgram, ref, otherRef)) continue;
            if (ref.isExternalReference()) {
                buf.append(this.indent2 + "External Reference " + this.getRefInfo(pgm, ref) + this.newLine);
                continue;
            }
            if (ref.isStackReference()) {
                buf.append(this.indent2 + "Stack Reference " + this.getRefInfo(pgm, ref) + this.newLine);
                continue;
            }
            buf.append(this.indent2 + "Reference " + this.getRefInfo(pgm, ref) + this.newLine);
        }
        if (buf.length() == 0) {
            return this.indent2 + "No unmatched references." + this.newLine;
        }
        return buf.toString();
    }

    private void addEquateDetails() {
        EquateTable et1 = this.p1.getEquateTable();
        EquateTable et2 = this.p2.getEquateTable();
        AddressSet checkP2AddressSet = DiffUtility.getCompatibleAddressSet((AddressSetView)this.checkP1AddressSet, this.p2);
        AddressIterator iter1 = et1.getEquateAddresses((AddressSetView)this.checkP1AddressSet);
        AddressIterator iter2 = et2.getEquateAddresses((AddressSetView)checkP2AddressSet);
        AddressIteratorConverter convertedIter2 = new AddressIteratorConverter(this.p2, iter2, this.p1);
        MultiAddressIterator iter = new MultiAddressIterator(new AddressIterator[]{iter1, convertedIter2}, true);
        while (iter.hasNext()) {
            Address p1Address = iter.next();
            this.addEquateInfo(et1, et2, p1Address);
        }
    }

    private void addEquateInfo(EquateTable et1, EquateTable et2, Address p1Address) {
        boolean hasAddrDiffs = false;
        for (int opIndex = 0; opIndex < 16; ++opIndex) {
            hasAddrDiffs = this.addEquateInfo(et1, et2, p1Address, opIndex, hasAddrDiffs);
        }
    }

    private boolean addEquateInfo(EquateTable et1, EquateTable et2, Address p1Address, int opIndex, boolean hasAddrDiffs) {
        Equate[] eq2;
        Address p2Address = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)p1Address, (Program)this.p2);
        boolean hasAddr1 = hasAddrDiffs;
        boolean hasAddr2 = hasAddrDiffs;
        List list1 = et1.getEquates(p1Address, opIndex);
        List list2 = et2.getEquates(p2Address, opIndex);
        Equate[] eq1 = list1.toArray(new Equate[list1.size()]);
        if (!this.sameEquates(eq1, eq2 = list2.toArray(new Equate[list2.size()]))) {
            int vlen;
            int len;
            if (!this.hasEquateDiffs) {
                this.addDiffHeader("Equate");
                this.hasEquateDiffs = true;
            }
            if (!hasAddr1) {
                this.addProgramText(1, p1Address);
                hasAddrDiffs = true;
            }
            int nameLen = "Equate".length();
            int valueLen = "Value".length();
            for (Equate element : eq1) {
                len = element.getName().length();
                if (len > nameLen) {
                    nameLen = len;
                }
                if ((vlen = Long.toHexString(element.getValue()).length()) <= valueLen) continue;
                valueLen = vlen;
            }
            for (Equate element : eq2) {
                len = element.getName().length();
                if (len > nameLen) {
                    nameLen = len;
                }
                if ((vlen = Long.toHexString(element.getValue()).length()) <= valueLen) continue;
                valueLen = vlen;
            }
            this.addOperandText(opIndex);
            this.addEquates(eq1, nameLen, valueLen);
            if (!hasAddr2) {
                this.addProgramText(2, p2Address);
                hasAddrDiffs = true;
            }
            this.addEquates(eq2, nameLen, valueLen);
        }
        return hasAddrDiffs;
    }

    private void addOperandText(int opIndex) {
        this.addText(this.indent2);
        this.addText("Operand: ");
        this.addColorText(Integer.toString(opIndex));
        this.addText(this.newLine);
    }

    private void addEquates(Equate[] eq, int nameLen, int valueLen) {
        int num = eq.length;
        if (num == 0) {
            this.addText(this.indent3 + "No equates." + this.newLine);
        } else {
            this.addDisplayEquate(null, nameLen, valueLen);
            for (int i = 0; i < num; ++i) {
                this.addDisplayEquate(eq[i], nameLen, valueLen);
            }
        }
    }

    private void addDisplayEquate(Equate equate, int nameLength, int valueLength) {
        String separatorSpaces = this.getSpaces(2);
        this.addText(this.indent3);
        if (equate == null) {
            this.underline("Equate");
            this.addText(this.getSpaces(nameLength - "Equate".length()));
            this.addText(separatorSpaces);
            this.underline("Value");
            this.addText(this.getSpaces(valueLength - "Value".length()));
        } else {
            String name = equate.getName();
            long eqValue = equate.getValue();
            String value = Long.toString(eqValue) + " or 0x" + Long.toHexString(eqValue);
            this.addColorText(name);
            this.addText(this.getSpaces(nameLength - name.length()));
            this.addText(separatorSpaces);
            this.addText(this.getSpaces(valueLength - value.length()));
            this.addColorText(value);
        }
        this.addText(this.newLine);
    }

    private boolean sameEquates(Equate[] e1, Equate[] e2) {
        if (e1.length != e2.length) {
            return false;
        }
        for (int i = 0; i < e1.length; ++i) {
            if (e1[i].equals((Object)e2[i])) continue;
            return false;
        }
        return true;
    }

    private void addProgramContextDetails() throws ConcurrentModificationException {
        if (!ProgramMemoryComparator.sameProgramContextRegisterNames(this.p1, this.p2)) {
            this.addDiffHeader("Program Context");
            this.addText(this.indent1 + "Program Context Registers don't match between the programs." + this.newLine);
            return;
        }
        ProgramContext pc1 = this.p1.getProgramContext();
        ProgramContext pc2 = this.p2.getProgramContext();
        for (Register reg1 : pc1.getRegisters()) {
            this.addRegisterDiffDetails(pc1, pc2, reg1);
        }
    }

    private void addRegisterDiffDetails(ProgramContext pc1, ProgramContext pc2, Register reg1) throws ConcurrentModificationException {
        String name = reg1.getName();
        Register reg2 = pc2.getRegister(name);
        AddressRangeIterator p1AddressRangeIter = this.checkP1AddressSet.getAddressRanges();
        while (p1AddressRangeIter.hasNext()) {
            AddressRange p1Range = (AddressRange)p1AddressRangeIter.next();
            Address min1 = p1Range.getMinAddress();
            Address max1 = p1Range.getMaxAddress();
            Address min2 = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)min1, (Program)this.p2);
            Address max2 = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)max1, (Program)this.p2);
            AddressRangeIterator it1 = pc1.getRegisterValueAddressRanges(reg1, min1, max1);
            AddressRangeIterator it2 = pc2.getRegisterValueAddressRanges(reg2, min2, max2);
            AddressRangeIteratorConverter convertedIt2 = new AddressRangeIteratorConverter(it2, this.p1);
            CombinedAddressRangeIterator p1CombinedIterator = new CombinedAddressRangeIterator(it1, convertedIt2);
            while (p1CombinedIterator.hasNext()) {
                AddressRange addrRange1 = (AddressRange)p1CombinedIterator.next();
                Address rangeMin1 = addrRange1.getMinAddress();
                Address rangeMax1 = addrRange1.getMaxAddress();
                Address rangeMin2 = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)rangeMin1, (Program)this.p2);
                BigInteger value1 = pc1.getValue(reg1, rangeMin1, false);
                BigInteger value2 = pc2.getValue(reg2, rangeMin2, false);
                boolean sameValue = value1 == null ? value2 == null : value1.equals(value2);
                if (sameValue) continue;
                if (!this.hasProgramContextDiffs) {
                    this.addDiffHeader("Program Context");
                    this.addDisplayRegValues(null, rangeMin1, rangeMax1, value1, value2);
                    this.hasProgramContextDiffs = true;
                }
                this.addDisplayRegValues(reg1, rangeMin1, rangeMax1, value1, value2);
            }
        }
    }

    private void addDisplayRegValues(Register reg, Address p1MinRegAddr, Address p1MaxRegAddr, BigInteger value1, BigInteger value2) {
        int maxValueLength;
        String minStr = p1MinRegAddr.toString();
        String maxStr = p1MaxRegAddr.toString();
        String separatorSpaces = this.getSpaces(2);
        AddressSpace p1DefaultSpace = this.p1.getAddressFactory().getDefaultAddressSpace();
        int maxAddrLength = p1DefaultSpace.getMaxAddress().toString().length();
        if (maxAddrLength < 10) {
            maxAddrLength = 10;
        }
        if ((maxValueLength = Long.toHexString(-1L).length() + 2) < 14) {
            maxValueLength = 14;
        }
        this.addText(this.indent2);
        if (reg == null) {
            this.underline("Register");
            this.underline(this.getSpaces(this.maxRegisterName - "Register".length()));
            this.addText(separatorSpaces);
            this.underline("MinAddress");
            this.underline(this.getSpaces(maxAddrLength - "MinAddress".length()));
            this.addText(separatorSpaces);
            this.underline("MaxAddress");
            this.underline(this.getSpaces(maxAddrLength - "MaxAddress".length()));
            this.addText(separatorSpaces);
            this.underline("Program1 Value");
            this.underline(this.getSpaces(maxValueLength - "Program1 Value".length()));
            this.addText(separatorSpaces);
            this.underline("Program2 Value");
            this.underline(this.getSpaces(maxValueLength - "Program2 Value".length()));
        } else {
            String regName = reg.getName();
            this.addColorText(regName);
            this.addText(this.getSpaces(this.maxRegisterName - regName.length()));
            this.addText(separatorSpaces);
            this.addColorText(minStr);
            this.addText(this.getSpaces(maxAddrLength - minStr.length()));
            this.addText(separatorSpaces);
            this.addColorText(maxStr);
            this.addText(this.getSpaces(maxAddrLength - maxStr.length()));
            this.addText(separatorSpaces);
            String value1Str = value1 != null ? "0x" + value1.toString(16) : "Undefined";
            this.addText(this.getSpaces(maxValueLength - value1Str.length()));
            this.addColorText(value1Str);
            this.addText(separatorSpaces);
            String value2Str = value2 != null ? "0x" + value2.toString(16) : "Undefined";
            this.addText(this.getSpaces(maxValueLength - value2Str.length()));
            this.addColorText(value2Str);
        }
        this.addText(this.newLine);
    }

    private void addEOLCommentDetails() {
        this.hasEolCommentDiffs = this.addSpecificCommentDetails(CommentType.EOL, "EOL-Comment");
    }

    private void addPreCommentDetails() {
        this.hasPreCommentDiffs = this.addSpecificCommentDetails(CommentType.PRE, "Pre-Comment");
    }

    private void addPostCommentDetails() {
        this.hasPostCommentDiffs = this.addSpecificCommentDetails(CommentType.POST, "Post-Comment");
    }

    private void addPlateCommentDetails() {
        this.hasPlateCommentDiffs = this.addSpecificCommentDetails(CommentType.PLATE, "Plate-Comment");
    }

    private void addTagDetails(StyledDocument doc1, StyledDocument doc2) {
        Function func2;
        Function func1 = this.l1.getFunctionAt(this.currentP1Address);
        Function function = func2 = this.currentP2Address != null ? this.l2.getFunctionAt(this.currentP2Address) : null;
        if (func1 == null || func2 == null) {
            Msg.error((Object)this, (Object)("couldn't find functions for addresses: " + String.valueOf(this.currentP1Address) + "::" + String.valueOf(this.currentP2Address)));
        }
        TreeSet<FunctionTag> func1Tags = func1.getTags();
        TreeSet<FunctionTag> func2Tags = func2.getTags();
        if (!ProgramDiff.equivalentTagSets(func1Tags = new TreeSet<FunctionTag>((Collection<FunctionTag>)func1Tags), func2Tags = new TreeSet<FunctionTag>((Collection<FunctionTag>)func2Tags))) {
            this.addText(doc1, this.indent2 + "Tags: ");
            this.addColorText(doc1, this.getTagInfo(func1Tags));
            this.addText(doc1, this.newLine);
            this.addText(doc2, this.indent2 + "Tags: ");
            this.addColorText(doc2, this.getTagInfo(func2Tags));
            this.addText(doc2, this.newLine);
            this.hasTagDiffs = true;
        }
        this.hasTagDiffs = false;
    }

    private void addRepeatableCommentDetails() {
        this.hasRepeatableCommentDiffs = this.addSpecificCommentDetails(CommentType.REPEATABLE, "Repeatable-Comment");
    }

    private String getTagInfo(Collection<FunctionTag> tags) {
        if (tags == null || tags.size() == 0) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder();
        for (FunctionTag tag : tags) {
            strBuilder.append(", ");
            strBuilder.append(tag.getName());
            if (tag.getComment() == null || tag.getComment().isEmpty()) continue;
            strBuilder.append("(" + tag.getComment() + ")");
        }
        String retString = strBuilder.toString();
        if (retString.startsWith(",")) {
            retString = retString.replaceFirst(",", "");
        }
        return retString;
    }

    private boolean addSpecificCommentDetails(CommentType commentType, String commentName) {
        boolean hasCommentDiff = false;
        try {
            Address p1Address = this.minP1Address;
            while (p1Address.compareTo((Object)this.maxP1Address) <= 0) {
                String cmt2;
                Address p2Address = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)p1Address, (Program)this.p2);
                String noComment = "No " + commentName + ".";
                String cmt1 = this.l1.getComment(commentType, p1Address);
                String string = cmt2 = p2Address != null ? this.l2.getComment(commentType, p2Address) : null;
                if (!SystemUtilities.isEqual((Object)cmt1, (Object)cmt2)) {
                    if (!hasCommentDiff) {
                        this.addDiffHeader(commentName);
                        hasCommentDiff = true;
                    }
                    this.addProgramText(1, p1Address);
                    if (cmt1 != null) {
                        this.addColorComment(cmt1);
                    } else {
                        this.addText(noComment);
                    }
                    this.addText(this.newLine);
                    this.addProgramText(2, p2Address);
                    if (cmt2 != null) {
                        this.addColorComment(cmt2);
                    } else {
                        this.addText(noComment);
                    }
                    this.addText(this.newLine);
                }
                p1Address = p1Address.add(1L);
            }
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
        return hasCommentDiff;
    }

    private void addFunctionDetails() {
        Function func2;
        Function func1 = this.l1.getFunctionAt(this.currentP1Address);
        Function function = func2 = this.currentP2Address != null ? this.l2.getFunctionAt(this.currentP2Address) : null;
        if (func1 == null && func2 == null) {
            return;
        }
        if (ProgramDiff.equivalentFunctions(func1, func2)) {
            return;
        }
        this.addDiffHeader("Function");
        this.addFunctionInfo(func1, func2);
        this.hasFunctionDiffs = true;
    }

    private void addFunctionInfo(Function function1, Function function2) {
        DefaultStyledDocument doc1 = new DefaultStyledDocument();
        DefaultStyledDocument doc2 = new DefaultStyledDocument();
        if (function1 == null || function2 == null) {
            this.addAllFunctionInfo(doc1, doc2, function1, function2);
        } else {
            this.addSignature(doc1, doc2, function1, function2);
            this.addNamespace(doc1, doc2, function1, function2);
            this.addBody(doc1, doc2, function1, function2);
            this.addThunk(doc1, doc2, function1, function2);
            this.addInline(doc1, doc2, function1, function2);
            this.addCallingConvention(doc1, doc2, function1, function2);
            this.addNoReturn(doc1, doc2, function1, function2);
            this.addReturn(doc1, doc2, function1, function2);
            this.addStackPurge(doc1, doc2, function1, function2);
            this.addStackFrame(doc1, doc2, function1.getStackFrame(), function2.getStackFrame());
            this.addCustomVariableStorage(doc1, doc2, function1, function2);
            this.addParameters(doc1, doc2, function1, function2);
            this.addLocals(doc1, doc2, function1, function2);
            this.addTagDetails(doc1, doc2);
        }
        this.addProgramText(1);
        this.addStyledDocument(doc1);
        this.addProgramText(2);
        this.addStyledDocument(doc2);
    }

    private boolean sameDocs(StyledDocument doc1, StyledDocument doc2) {
        int len2;
        int len1 = doc1.getLength();
        if (len1 != (len2 = doc2.getLength())) {
            return false;
        }
        try {
            String text1 = doc1.getText(0, len1);
            String text2 = doc2.getText(0, len2);
            return text1.equals(text2);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private void addStyledDocument(StyledDocument doc1) {
        Element root = doc1.getDefaultRootElement();
        this.copyLeafs(root);
    }

    private void copyLeafs(Element parent) {
        int elementCount = parent.getElementCount();
        for (int elementIndex = 0; elementIndex < elementCount; ++elementIndex) {
            Element child = parent.getElement(elementIndex);
            if (child.isLeaf()) {
                this.copyLeaf(child);
                continue;
            }
            this.copyLeafs(child);
        }
    }

    private void copyLeaf(Element leaf) {
        AttributeSet attrSet = leaf.getAttributes();
        Document leafDoc = leaf.getDocument();
        int start = leaf.getStartOffset();
        int end = leaf.getEndOffset();
        try {
            String text = leafDoc.getText(start, end - start);
            this.detailsDoc.insertString(this.detailsDoc.getLength(), text, attrSet);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private void addAllFunctionInfo(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        this.addAllFunctionInfo(doc1, function1);
        this.addAllFunctionInfo(doc2, function2);
    }

    private void addAllFunctionInfo(StyledDocument doc, Function function) {
        if (function == null) {
            this.addText(doc, this.indent2 + "No function defined here." + this.newLine);
            return;
        }
        this.addSignature(doc, function);
        this.addNamespace(doc, function);
        this.addBody(doc, function);
        this.addThunk(doc, function);
        this.addInline(doc, function);
        this.addCallingConvention(doc, function);
        this.addNoReturn(doc, function);
        this.addReturn(doc, function);
        this.addStackPurge(doc, function);
        this.addStackFrame(doc, function);
        this.addCustomVariableStorage(doc, function);
        this.addParameters(doc, function);
        this.addLocals(doc, function);
    }

    private void addSignature(StyledDocument doc, Function function) {
        this.addFunctionInfo(doc, "Signature: ", function.getPrototypeString(false, false));
    }

    private void addSignature(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        String sigStr2;
        String sigStr1 = function1.getPrototypeString(false, false);
        if (!sigStr1.equals(sigStr2 = function2.getPrototypeString(false, false))) {
            this.addFunctionInfo(doc1, "Signature: ", sigStr1);
            this.addFunctionInfo(doc2, "Signature: ", sigStr2);
        }
    }

    private void addNamespace(StyledDocument doc, Function function) {
        Namespace parentNS = function.getParentNamespace();
        String namespace = parentNS instanceof GlobalNamespace ? parentNS.getName() : parentNS.getName(true);
        this.addFunctionInfo(doc, "Namespace: ", namespace);
    }

    private void addNamespace(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        String namespace2;
        Namespace parentNS1 = function1.getParentNamespace();
        Namespace parentNS2 = function2.getParentNamespace();
        String namespace1 = parentNS1 instanceof GlobalNamespace ? parentNS1.getName() : parentNS1.getName(true);
        String string = namespace2 = parentNS2 instanceof GlobalNamespace ? parentNS2.getName() : parentNS2.getName(true);
        if (!namespace1.equals(namespace2)) {
            this.addFunctionInfo(doc1, "Namespace: ", namespace1);
            this.addFunctionInfo(doc2, "Namespace: ", namespace2);
        }
    }

    private void addBody(StyledDocument doc, Function function) {
        this.addFunctionInfo(doc, "Body: ", function.getBody().toString());
    }

    private void addBody(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        AddressSetView body2;
        AddressSet body2AsP1;
        AddressSetView body1 = function1.getBody();
        if (!body1.equals((Object)(body2AsP1 = DiffUtility.getCompatibleAddressSet(body2 = function2.getBody(), this.p1)))) {
            this.addFunctionInfo(doc1, "Body: ", body1.toString());
            this.addFunctionInfo(doc2, "Body: ", body2.toString());
        }
    }

    private void addStackPurge(StyledDocument doc, Function function) {
        this.addFunctionInfo(doc, "Stack Purge Size: ", Integer.toString(function.getStackPurgeSize()));
    }

    private void addStackPurge(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        int purge2;
        int purge1 = function1.getStackPurgeSize();
        if (purge1 != (purge2 = function2.getStackPurgeSize())) {
            this.addFunctionInfo(doc1, "Stack Purge Size: ", Integer.toString(purge1));
            this.addFunctionInfo(doc2, "Stack Purge Size: ", Integer.toString(purge2));
        }
    }

    private void addCallingConvention(StyledDocument doc, Function function) {
        this.addFunctionInfo(doc, "Calling Convention: ", function.getCallingConventionName());
    }

    private void addCallingConvention(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        String name2;
        String name1 = function1.getCallingConventionName();
        if (!name1.equals(name2 = function2.getCallingConventionName())) {
            this.addFunctionInfo(doc1, "Calling Convention: ", name1);
            this.addFunctionInfo(doc2, "Calling Convention: ", name2);
        }
    }

    private void addThunk(StyledDocument doc, Function function) {
        Function thunkedFunction = function.getThunkedFunction(false);
        this.addFunctionInfo(doc, "Thunk? : ", (String)(thunkedFunction != null ? "yes   " + this.getThunkedFunctionString(thunkedFunction) : "no"));
        if (thunkedFunction != null) {
            this.addFunctionInfo(doc, "  Name : ", function.getName());
            this.addFunctionInfo(doc, "  Source : ", function.getSymbol().getSource().getDisplayString());
            this.addFunctionInfo(doc, "  External : ", (String)(thunkedFunction.isExternal() ? "yes   " + thunkedFunction.getExternalLocation().toString() : "no"));
        }
    }

    private void addThunk(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        if (!ProgramDiff.isEquivalentThunk(function1, function2)) {
            this.addThunk(doc1, function1);
            this.addThunk(doc2, function2);
        }
    }

    private String getThunkedFunctionString(Function thunkedFunction) {
        return "Thunked Function: " + thunkedFunction.getName() + " @ " + thunkedFunction.getEntryPoint().toString(true);
    }

    private void addInline(StyledDocument doc, Function function) {
        this.addFunctionInfo(doc, "Inline? : ", function.isInline() ? "yes" : "no");
    }

    private void addInline(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        boolean isInline2;
        boolean isInline1 = function1.isInline();
        if (isInline1 != (isInline2 = function2.isInline())) {
            this.addFunctionInfo(doc1, "Inline? : ", isInline1 ? "yes" : "no");
            this.addFunctionInfo(doc2, "Inline? : ", isInline2 ? "yes" : "no");
        }
    }

    private void addNoReturn(StyledDocument doc, Function function) {
        this.addFunctionInfo(doc, "No Return? : ", Boolean.toString(function.hasNoReturn()));
    }

    private void addNoReturn(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        boolean hasNoReturn2;
        boolean hasNoReturn1 = function1.hasNoReturn();
        if (hasNoReturn1 != (hasNoReturn2 = function2.hasNoReturn())) {
            this.addFunctionInfo(doc1, "No Return? : ", Boolean.toString(hasNoReturn1));
            this.addFunctionInfo(doc2, "No Return? : ", Boolean.toString(hasNoReturn2));
        }
    }

    private void addCustomVariableStorage(StyledDocument doc, Function function) {
        this.addFunctionInfo(doc, "Custom Variable Storage? : ", function.hasCustomVariableStorage() ? "yes" : "no");
    }

    private void addCustomVariableStorage(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        boolean hasCustomStorage2;
        boolean hasCustomStorage1 = function1.hasCustomVariableStorage();
        if (hasCustomStorage1 != (hasCustomStorage2 = function2.hasCustomVariableStorage())) {
            this.addFunctionInfo(doc1, "Custom Variable Storage? : ", hasCustomStorage1 ? "yes" : "no");
            this.addFunctionInfo(doc2, "Custom Variable Storage? : ", hasCustomStorage2 ? "yes" : "no");
        }
    }

    private void addStackFrame(StyledDocument doc, Function function) {
        StackFrame frame = function.getStackFrame();
        this.addFunctionInfo(doc, "Stack Frame: ", "");
        this.addFrameSize(doc, frame);
        this.addStackGrowth(doc, frame);
        this.addReturnOffset(doc, frame);
        this.addParameterOffset(doc, frame);
        this.addParameterSize(doc, frame);
    }

    private void addStackFrame(StyledDocument doc1, StyledDocument doc2, StackFrame frame1, StackFrame frame2) {
        if (!this.sameStackFrame(frame1, frame2)) {
            this.addFunctionInfo(doc1, "Stack Frame: ", "");
            this.addFunctionInfo(doc2, "Stack Frame: ", "");
            this.addFrameSize(doc1, doc2, frame1, frame2);
            this.addStackGrowth(doc1, doc2, frame1, frame2);
            this.addReturnOffset(doc1, doc2, frame1, frame2);
            this.addParameterOffset(doc1, doc2, frame1, frame2);
            this.addParameterSize(doc1, doc2, frame1, frame2);
        }
    }

    private boolean sameStackFrame(StackFrame frame1, StackFrame frame2) {
        return frame1.equals((Object)frame2);
    }

    private void addFrameSize(StyledDocument doc, StackFrame frame) {
        this.addFrameInfo(doc, "Frame Size: ", Integer.toString(frame.getFrameSize()));
    }

    private void addFrameSize(StyledDocument doc1, StyledDocument doc2, StackFrame frame1, StackFrame frame2) {
        int size2;
        int size1 = frame1.getFrameSize();
        if (size1 != (size2 = frame2.getFrameSize())) {
            this.addFrameInfo(doc1, "Frame Size: ", Integer.toString(size1));
            this.addFrameInfo(doc2, "Frame Size: ", Integer.toString(size2));
        }
    }

    private void addStackGrowth(StyledDocument doc, StackFrame frame) {
        this.addFrameInfo(doc, "Grows negative? ", Boolean.toString(frame.growsNegative()));
    }

    private void addStackGrowth(StyledDocument doc1, StyledDocument doc2, StackFrame frame1, StackFrame frame2) {
        boolean growth2;
        boolean growth1 = frame1.growsNegative();
        if (growth1 != (growth2 = frame2.growsNegative())) {
            this.addFrameInfo(doc1, "Grows negative? ", Boolean.toString(growth1));
            this.addFrameInfo(doc2, "Grows negative? ", Boolean.toString(growth2));
        }
    }

    private void addReturnOffset(StyledDocument doc, StackFrame frame) {
        this.addFrameInfo(doc, "Return Address Offset: ", NumericUtilities.toSignedHexString((long)frame.getReturnAddressOffset()));
    }

    private void addReturnOffset(StyledDocument doc1, StyledDocument doc2, StackFrame frame1, StackFrame frame2) {
        int offset2;
        int offset1 = frame1.getReturnAddressOffset();
        if (offset1 != (offset2 = frame2.getReturnAddressOffset())) {
            this.addFrameInfo(doc1, "Return Address Offset: ", NumericUtilities.toSignedHexString((long)offset1));
            this.addFrameInfo(doc2, "Return Address Offset: ", NumericUtilities.toSignedHexString((long)offset2));
        }
    }

    private void addParameterOffset(StyledDocument doc, StackFrame frame) {
        this.addFrameInfo(doc, "Parameter Offset: ", NumericUtilities.toSignedHexString((long)frame.getParameterOffset()));
    }

    private void addParameterOffset(StyledDocument doc1, StyledDocument doc2, StackFrame frame1, StackFrame frame2) {
        int offset2;
        int offset1 = frame1.getParameterOffset();
        if (offset1 != (offset2 = frame2.getParameterOffset())) {
            this.addFrameInfo(doc1, "Parameter Offset: ", NumericUtilities.toSignedHexString((long)offset1));
            this.addFrameInfo(doc2, "Parameter Offset: ", NumericUtilities.toSignedHexString((long)offset2));
        }
    }

    private void addParameterSize(StyledDocument doc, StackFrame frame) {
        this.addFrameInfo(doc, "Size of Parameter Portion: ", "" + frame.getParameterSize());
    }

    private void addParameterSize(StyledDocument doc1, StyledDocument doc2, StackFrame frame1, StackFrame frame2) {
        int size2;
        int size1 = frame1.getParameterSize();
        if (size1 != (size2 = frame2.getParameterSize())) {
            this.addFrameInfo(doc1, "Size of Parameter Portion: ", "" + size1);
            this.addFrameInfo(doc2, "Size of Parameter Portion: ", "" + size2);
        }
    }

    private VariableLayout getVariableLayout(Variable[] vars) {
        VariableLayout vl = new VariableLayout(this);
        vl.dtLen = "DataType".length();
        vl.offsetLen = "Storage".length();
        vl.firstUseLen = "FirstUse".length();
        vl.nameLen = "Name".length();
        vl.sizeLen = "Size".length();
        vl.sourceLen = "Source".length();
        for (Variable var : vars) {
            vl.dtLen = Math.max(vl.dtLen, var.getDataType().getPathName().length());
            vl.offsetLen = Math.max(vl.offsetLen, var.getVariableStorage().toString().length());
            vl.firstUseLen = Math.max(vl.firstUseLen, NumericUtilities.toSignedHexString((long)var.getFirstUseOffset()).length());
            vl.nameLen = Math.max(vl.nameLen, var.getName().length());
            vl.sizeLen = Math.max(vl.sizeLen, Integer.toString(var.getLength()).length());
            vl.sourceLen = Math.max(vl.sourceLen, var.getSource().toString().length());
        }
        return vl;
    }

    private void addParameters(StyledDocument doc, Function function) {
        Parameter[] vars = function.getParameters();
        this.addFrameInfo(doc, "Parameters: ", "");
        VariableLayout varLayout = this.getVariableLayout((Variable[])vars);
        this.printParameters(doc, (Variable[])vars, varLayout, vars.length);
    }

    private void addParameters(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        Parameter[] vars2;
        boolean checkParamStorage = function1.hasCustomVariableStorage() || function2.hasCustomVariableStorage();
        Parameter[] vars1 = function1.getParameters();
        if (ProgramDiff.equivalentVariableArrays((Variable[])vars1, (Variable[])(vars2 = function2.getParameters()), checkParamStorage)) {
            return;
        }
        this.addFrameInfo(doc1, "Parameters: ", "");
        this.addFrameInfo(doc2, "Parameters: ", "");
        MultiComparableArrayIterator iter = new MultiComparableArrayIterator((Comparable[][])new Variable[][]{vars1, vars2});
        ArrayList<Variable> varList1 = new ArrayList<Variable>();
        ArrayList<Variable> varList2 = new ArrayList<Variable>();
        while (iter.hasNext()) {
            Variable[] vars = (Variable[])iter.next();
            Variable var1 = vars[0];
            Variable var2 = vars[1];
            if (var1 != null && var2 != null && ProgramDiff.equivalentVariables(var1, var2, checkParamStorage)) continue;
            if (var1 != null) {
                varList1.add(var1);
            }
            if (var2 == null) continue;
            varList2.add(var2);
        }
        ArrayList<Variable> allVarsList = new ArrayList<Variable>(varList1);
        allVarsList.addAll(varList2);
        Variable[] printVars1 = varList1.toArray(new Variable[varList1.size()]);
        Variable[] printVars2 = varList2.toArray(new Variable[varList2.size()]);
        Variable[] combinedVars = allVarsList.toArray(new Variable[allVarsList.size()]);
        VariableLayout varLayout = this.getVariableLayout(combinedVars);
        this.printParameters(doc1, printVars1, varLayout, vars1.length);
        this.printParameters(doc2, printVars2, varLayout, vars2.length);
    }

    private void printParameters(StyledDocument doc, Variable[] printVars, VariableLayout varLayout, int actualVarCount) {
        if (printVars.length == 0) {
            this.addText(doc, this.indent4 + "No " + (actualVarCount == 0 ? "" : "unmatched ") + "parameters." + this.newLine);
        } else {
            this.addVariable(doc, null, varLayout, this.indent4);
            for (Variable printVar : printVars) {
                this.addVariable(doc, printVar, varLayout, this.indent4);
            }
        }
    }

    private void addReturn(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        boolean checkParamStorage;
        Parameter returnVar1 = function1.getReturn();
        Parameter returnVar2 = function2.getReturn();
        boolean bl = checkParamStorage = function1.hasCustomVariableStorage() || function2.hasCustomVariableStorage();
        if (ProgramDiff.equivalentVariables((Variable)returnVar1, (Variable)returnVar2, checkParamStorage)) {
            return;
        }
        VariableLayout varLayout1 = this.getVariableLayout(new Variable[]{returnVar1});
        this.addFunctionInfo(doc1, "Return Value : ", "");
        this.addVariable(doc1, null, varLayout1, this.indent3);
        this.addVariable(doc1, (Variable)returnVar1, varLayout1, this.indent3);
        VariableLayout varLayout2 = this.getVariableLayout(new Variable[]{returnVar2});
        this.addFunctionInfo(doc2, "Return Value : ", "");
        this.addVariable(doc2, null, varLayout2, this.indent3);
        this.addVariable(doc2, (Variable)returnVar2, varLayout2, this.indent3);
    }

    private void addReturn(StyledDocument doc, Function function) {
        Parameter returnVar = function.getReturn();
        VariableLayout varLayout = this.getVariableLayout(new Variable[]{returnVar});
        this.addFunctionInfo(doc, "Return Value : ", "");
        this.addVariable(doc, null, varLayout, this.indent3);
        this.addVariable(doc, (Variable)returnVar, varLayout, this.indent3);
    }

    private void addLocals(StyledDocument doc, Function function) {
        Variable[] vars = function.getLocalVariables();
        this.addFrameInfo(doc, "Local Variables: ", "");
        VariableLayout varLayout = this.getVariableLayout(vars);
        this.printLocals(doc, vars, varLayout, vars.length);
    }

    private void addLocals(StyledDocument doc1, StyledDocument doc2, Function function1, Function function2) {
        Variable[] vars2;
        Variable[] vars1 = function1.getLocalVariables();
        if (ProgramDiff.equivalentVariableArrays(vars1, vars2 = function2.getLocalVariables(), false)) {
            return;
        }
        this.addFrameInfo(doc1, "Local Variables: ", "");
        this.addFrameInfo(doc2, "Local Variables: ", "");
        MultiComparableArrayIterator iter = new MultiComparableArrayIterator((Comparable[][])new Variable[][]{vars1, vars2});
        ArrayList<Variable> varList1 = new ArrayList<Variable>();
        ArrayList<Variable> varList2 = new ArrayList<Variable>();
        while (iter.hasNext()) {
            Variable[] vars = (Variable[])iter.next();
            Variable var1 = vars[0];
            Variable var2 = vars[1];
            if (var1 != null && var2 != null && ProgramDiff.equivalentVariables(var1, var2, true)) continue;
            if (var1 != null) {
                varList1.add(var1);
            }
            if (var2 == null) continue;
            varList2.add(var2);
        }
        ArrayList<Variable> allVarsList = new ArrayList<Variable>(varList1);
        allVarsList.addAll(varList2);
        Variable[] printVars1 = varList1.toArray(new Variable[varList1.size()]);
        Variable[] printVars2 = varList2.toArray(new Variable[varList2.size()]);
        Variable[] combinedVars = allVarsList.toArray(new Variable[allVarsList.size()]);
        VariableLayout varLayout = this.getVariableLayout(combinedVars);
        this.printLocals(doc1, printVars1, varLayout, vars1.length);
        this.printLocals(doc2, printVars2, varLayout, vars2.length);
    }

    private void printLocals(StyledDocument doc, Variable[] printVars, VariableLayout varLayout, int actualVarCount) {
        if (printVars.length == 0) {
            this.addText(doc, this.indent4 + "No " + (actualVarCount == 0 ? "" : "unmatched ") + "local variables." + this.newLine);
        } else {
            this.addVariable(doc, null, varLayout, this.indent4);
            for (Variable printVar : printVars) {
                this.addVariable(doc, printVar, varLayout, this.indent4);
            }
        }
    }

    private void addVariable(StyledDocument doc, Variable var, VariableLayout layout, String indent) {
        int offsetLen = layout.offsetLen;
        int firstUseLen = layout.firstUseLen;
        int dtLen = layout.dtLen;
        int nameLen = layout.nameLen;
        int sizeLen = layout.sizeLen;
        int sourceLen = layout.sourceLen;
        String separatorSpaces = this.getSpaces(2);
        this.addText(doc, indent);
        if (var == null) {
            this.underline(doc, "DataType");
            this.addText(doc, this.getSpaces(dtLen - "DataType".length()));
            this.addText(doc, separatorSpaces);
            this.underline(doc, "Storage");
            this.addText(doc, this.getSpaces(offsetLen - "Storage".length()));
            this.addText(doc, separatorSpaces);
            this.underline(doc, "FirstUse");
            this.addText(doc, this.getSpaces(firstUseLen - "FirstUse".length()));
            this.addText(doc, separatorSpaces);
            this.underline(doc, "Name");
            this.addText(doc, this.getSpaces(nameLen - "Name".length()));
            this.addText(doc, separatorSpaces);
            this.underline(doc, "Size");
            this.addText(doc, this.getSpaces(sizeLen - "Size".length()));
            this.addText(doc, separatorSpaces);
            this.underline(doc, "Source");
            this.addText(doc, this.getSpaces(sourceLen - "Source".length()));
            this.addText(doc, separatorSpaces);
            this.underline(doc, "Comment");
        } else {
            String dt = var.getDataType().getPathName();
            String offset = var.getVariableStorage().toString();
            String firstUse = NumericUtilities.toSignedHexString((long)var.getFirstUseOffset());
            String name = var.getName();
            String size = "" + var.getLength();
            String source = var.getSource().toString();
            String comment = var.getComment();
            this.addColorText(doc, dt);
            this.addText(doc, this.getSpaces(dtLen - dt.length()));
            this.addText(doc, separatorSpaces);
            this.addText(doc, this.getSpaces(offsetLen - offset.length()));
            this.addColorText(doc, offset);
            this.addText(doc, separatorSpaces);
            this.addText(doc, this.getSpaces(firstUseLen - firstUse.length()));
            this.addColorText(doc, firstUse);
            this.addText(doc, separatorSpaces);
            this.addColorText(doc, name);
            this.addText(doc, this.getSpaces(nameLen - name.length()));
            this.addText(doc, separatorSpaces);
            this.addText(doc, this.getSpaces(sizeLen - size.length()));
            this.addColorText(doc, size);
            this.addText(doc, separatorSpaces);
            this.addColorText(doc, source);
            this.addText(doc, this.getSpaces(sourceLen - source.length()));
            this.addText(doc, separatorSpaces);
            this.addColorText(doc, comment);
        }
        this.addText(doc, this.newLine);
    }

    private void addFunctionInfo(StyledDocument doc, String name, String value) {
        this.addText(doc, this.indent2 + name);
        this.addColorText(doc, value);
        this.addText(doc, this.newLine);
    }

    private void addFrameInfo(StyledDocument doc, String name, String value) {
        this.addText(doc, this.indent3 + name);
        this.addColorText(doc, value);
        this.addText(doc, this.newLine);
    }

    private void addUserDefinedDetails() {
        String upi2;
        String upi1 = this.getUserPropertyInfo(this.cu1At);
        if (!SystemUtilities.isEqual((Object)upi1, (Object)(upi2 = this.getUserPropertyInfo(this.cu2At)))) {
            this.addDiffHeader("User Defined Property");
            this.addProgramText(1, this.currentP1Address);
            this.addText(upi1);
            this.addProgramText(2, this.currentP2Address);
            this.addText(upi2);
            this.hasUserDefinedDiffs = true;
        }
    }

    private String getUserPropertyInfo(CodeUnit cu) {
        StringBuffer buf = new StringBuffer();
        if (cu != null) {
            Iterator propNames = cu.propertyNames();
            ArrayList<String> names = new ArrayList<String>();
            while (propNames.hasNext()) {
                names.add((String)propNames.next());
            }
            Object[] names1 = names.toArray(new String[names.size()]);
            Arrays.sort(names1);
            String stringProp = null;
            int intProp = -1;
            Saveable objProp = null;
            boolean voidProp = false;
            for (Object propertyName : names1) {
                if (!cu.hasProperty((String)propertyName)) continue;
                if (cu.getProgram().getListing().getPropertyMap((String)propertyName) instanceof UnsupportedMapDB) {
                    buf.append(this.indent2 + (String)propertyName + " is an unsupported property." + this.newLine);
                    continue;
                }
                try {
                    intProp = cu.getIntProperty((String)propertyName);
                    buf.append(this.indent2 + (String)propertyName + " = " + intProp + this.newLine);
                    continue;
                }
                catch (NoValueException noValueException) {
                }
                catch (TypeMismatchException typeMismatchException) {
                    // empty catch block
                }
                try {
                    stringProp = cu.getStringProperty((String)propertyName);
                }
                catch (TypeMismatchException typeMismatchException) {
                    // empty catch block
                }
                if (stringProp != null) {
                    buf.append(this.indent2 + (String)propertyName + " = " + stringProp + this.newLine);
                    continue;
                }
                try {
                    objProp = cu.getObjectProperty((String)propertyName);
                }
                catch (TypeMismatchException typeMismatchException) {
                    // empty catch block
                }
                if (objProp != null) {
                    buf.append(this.indent2 + (String)propertyName + ": " + objProp.toString() + this.newLine);
                    continue;
                }
                try {
                    voidProp = cu.getVoidProperty((String)propertyName);
                }
                catch (TypeMismatchException typeMismatchException) {
                    // empty catch block
                }
                if (voidProp) {
                    buf.append(this.indent2 + (String)propertyName + " is a VoidProperty." + this.newLine);
                    continue;
                }
                buf.append(this.indent2 + "Unknown property type for " + (String)propertyName + "." + this.newLine);
            }
        }
        if (buf.length() == 0) {
            return this.indent2 + "No user properties." + this.newLine;
        }
        return buf.toString();
    }

    private void addBookmarkDetails() {
        BookmarkManager bmm1 = this.p1.getBookmarkManager();
        BookmarkManager bmm2 = this.p2.getBookmarkManager();
        try {
            Address p1Address = this.minP1Address;
            while (p1Address.compareTo((Object)this.maxP1Address) <= 0) {
                Address p2Address = SimpleDiffUtility.getCompatibleAddress((Program)this.p1, (Address)p1Address, (Program)this.p2);
                Bookmark[] marks1 = bmm1.getBookmarks(p1Address);
                Arrays.sort(marks1, BOOKMARK_COMPARATOR);
                Bookmark[] marks2 = p2Address != null ? bmm2.getBookmarks(p2Address) : new Bookmark[]{};
                Arrays.sort(marks2, BOOKMARK_COMPARATOR);
                if (!this.sameBookmarks(marks1, marks2)) {
                    if (!this.hasBookmarkDiffs) {
                        this.addDiffHeader("Bookmark");
                        this.hasBookmarkDiffs = true;
                    }
                    this.addProgramText(1, p1Address);
                    this.addBookmarks(marks1);
                    this.addProgramText(2, p2Address);
                    this.addBookmarks(marks2);
                }
                p1Address = p1Address.add(1L);
            }
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
    }

    private boolean sameBookmarks(Bookmark[] marks1, Bookmark[] marks2) {
        if (marks1.length != marks2.length) {
            return false;
        }
        for (int i = 0; i < marks1.length; ++i) {
            Address marks2Addr;
            Address marks2AddressAsP1;
            Address marks1Addr = marks1[i].getAddress();
            if (marks1Addr.equals((Object)(marks2AddressAsP1 = SimpleDiffUtility.getCompatibleAddress((Program)this.p2, (Address)(marks2Addr = marks2[i].getAddress()), (Program)this.p1))) && marks1[i].getTypeString().equals(marks2[i].getTypeString()) && marks1[i].getCategory().equals(marks2[i].getCategory()) && marks1[i].getComment().equals(marks2[i].getComment())) continue;
            return false;
        }
        return true;
    }

    private void addBookmarks(Bookmark[] marks) {
        if (marks.length > 0) {
            int typeLen = "Type".length();
            int catLen = "Category".length();
            for (Bookmark mark : marks) {
                typeLen = Math.max(typeLen, mark.getType().getTypeString().length());
                catLen = Math.max(catLen, mark.getCategory().length());
            }
            this.addDisplayBookmark(null, typeLen, catLen);
            for (Bookmark mark : marks) {
                this.addDisplayBookmark(mark, typeLen, catLen);
            }
        } else {
            this.addText(this.indent2 + "No bookmarks." + this.newLine);
        }
    }

    private void addDisplayBookmark(Bookmark mark, int typeLength, int catLength) {
        String separatorSpaces = this.getSpaces(2);
        this.addText(this.indent2);
        if (mark == null) {
            this.underline("Type");
            this.addText(this.getSpaces(typeLength - "Type".length()));
            this.addText(separatorSpaces);
            this.underline("Category");
            this.addText(this.getSpaces(catLength - "Category".length()));
            this.addText(separatorSpaces);
            this.underline("Comment");
        } else {
            String type = mark.getType().getTypeString();
            String category = mark.getCategory();
            String comment = mark.getComment();
            this.addColorText(type);
            this.addText(this.getSpaces(typeLength - type.length()));
            this.addText(separatorSpaces);
            this.addColorText(category);
            this.addText(this.getSpaces(catLength - category.length()));
            this.addText(separatorSpaces);
            this.addColorText(comment);
        }
        this.addText(this.newLine);
    }

    private boolean isSameInstruction(Instruction i1, Instruction i2) {
        boolean samePrototypes = i1.getPrototype().equals((Object)i2.getPrototype());
        boolean sameInstructionLength = i1.getLength() == i2.getLength();
        boolean sameFallthrough = ProgramDiff.isSameFallthrough(this.p1, i1, this.p2, i2);
        boolean sameFlowOverride = i1.getFlowOverride() == i2.getFlowOverride();
        return samePrototypes && sameInstructionLength && sameFallthrough && sameFlowOverride;
    }

    private boolean isSameData(Data d1, Data d2) {
        DataType dt2;
        if (d1.getLength() != d2.getLength()) {
            return false;
        }
        DataType dt1 = d1.getDataType();
        if (!dt1.isEquivalent(dt2 = d2.getDataType())) {
            return false;
        }
        if (!dt1.getPathName().equals(dt2.getPathName())) {
            return false;
        }
        if (d1.getParent() != null || d2.getParent() != null) {
            throw new UnsupportedOperationException("Expecting top-level Data only");
        }
        Object[] settingNames1 = d1.getNames();
        Arrays.sort(settingNames1);
        Object[] settingNames2 = d2.getNames();
        Arrays.sort(settingNames2);
        if (!Arrays.equals(settingNames1, settingNames2)) {
            return false;
        }
        for (int i = 0; i < settingNames1.length; ++i) {
            Object v2;
            Object v1 = d1.getValue((String)settingNames1[i]);
            if (Objects.equals(v1, v2 = d2.getValue((String)settingNames2[i]))) continue;
            return false;
        }
        return true;
    }

    private void addDiffString(String name, int nameOffset, String p1Diff, int p1Offset, String p2Diff, int p2Offset, boolean underline) {
        int nameLen = name.length();
        int p1Len = p1Diff.length();
        int nameEnd = nameOffset + nameLen;
        int p1End = p1Offset + p1Len;
        int spacesBeforeName = nameOffset;
        int spacesBeforeP1 = p1Offset - nameEnd;
        int spacesBeforeP2 = p2Offset - p1End;
        this.addText(this.getSpaces(spacesBeforeName));
        if (underline) {
            this.underline(name);
        } else {
            this.addColorText(name);
        }
        this.addText(this.getSpaces(spacesBeforeP1));
        if (underline) {
            this.underline(p1Diff);
        } else {
            this.addColorText(p1Diff);
        }
        this.addText(this.getSpaces(spacesBeforeP2));
        if (underline) {
            this.underline(p2Diff);
        } else {
            this.addColorText(p2Diff);
        }
        this.addText(this.newLine);
    }

    private String getSpaces(int numSpaces) {
        if (numSpaces <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(numSpaces);
        for (int i = 0; i < numSpaces; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    private void addDiffHeader(String text) {
        this.addText(this.newLine);
        this.underline(text + " Diffs");
        this.addText(" : " + this.newLine);
    }

    private void addProgramText(int programNumber) {
        this.addProgramText(this.detailsDoc, programNumber);
    }

    private void addProgramText(StyledDocument doc, int programNumber) {
        Program p = programNumber == 2 ? this.p2 : this.p1;
        this.addText(doc, this.newLine + this.indent1);
        this.addText(doc, "Program" + programNumber + " ");
        this.addColorProgram(doc, p.getDomainFile().toString());
        this.addText(doc, " :" + this.newLine);
    }

    private void addProgramText(int programNumber, Address addr) {
        this.addProgramText(this.detailsDoc, programNumber, addr);
    }

    private void addProgramText(StyledDocument doc, int programNumber, Address addr) {
        Program p = programNumber == 2 ? this.p2 : this.p1;
        this.addText(doc, this.newLine + this.indent1);
        this.addText(doc, "Program" + programNumber + " ");
        this.addColorProgram(doc, p.getDomainFile().toString());
        this.addText(doc, " at ");
        this.addColorAddress(doc, addr);
        this.addText(doc, " :" + this.newLine);
    }

    private void underline(boolean show) {
        if (show) {
            this.textAttrSet.addAttribute(StyleConstants.Underline, Boolean.TRUE);
        } else {
            this.textAttrSet.removeAttribute(StyleConstants.Underline);
        }
    }

    private void bold(boolean show) {
        if (show) {
            this.textAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        } else {
            this.textAttrSet.removeAttribute(StyleConstants.Bold);
        }
    }

    private void color(Color color) {
        if (color != null) {
            this.textAttrSet.addAttribute(StyleConstants.Foreground, color);
        } else {
            this.textAttrSet.removeAttribute(StyleConstants.Foreground);
        }
    }

    private void underline(String text) {
        this.underline(this.detailsDoc, text);
    }

    private void underline(StyledDocument doc, String text) {
        this.underline(true);
        try {
            doc.insertString(doc.getLength(), text, this.textAttrSet);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"Error underlining text in the Diff details.", (Throwable)e);
        }
        this.underline(false);
    }

    private void addColorComment(String text) {
        this.addColorComment(this.detailsDoc, text);
    }

    private void addColorComment(StyledDocument doc, String text) {
        this.color(COMMENT_COLOR);
        try {
            doc.insertString(doc.getLength(), text, this.textAttrSet);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"Error coloring text in Diff details.", (Throwable)e);
        }
        this.color(null);
    }

    private void addColorAddress(Address addr) {
        this.addColorAddress(this.detailsDoc, addr);
    }

    private void addColorAddress(StyledDocument doc, Address addr) {
        String text = addr != null ? addr.toString() : "no matching address";
        this.color(ADDRESS_COLOR);
        try {
            doc.insertString(doc.getLength(), text, this.textAttrSet);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"Error coloring address text in Diff details.", (Throwable)e);
        }
        this.color(null);
    }

    private void addColorText(String text) {
        this.addColorText(this.detailsDoc, text);
    }

    private void addColorText(StyledDocument doc, String text) {
        this.color(EMPHASIZE_COLOR);
        try {
            doc.insertString(doc.getLength(), text, this.textAttrSet);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"Error coloring text in Diff details.", (Throwable)e);
        }
        this.color(null);
    }

    private void addColorProgram(StyledDocument doc, String text) {
        this.color(FG_COLOR_PROGRAM);
        try {
            doc.insertString(doc.getLength(), text, this.textAttrSet);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"Error coloring text in Diff details.", (Throwable)e);
        }
        this.color(null);
    }

    private void addText(String text) {
        this.addText(this.detailsDoc, text);
    }

    private void addText(StyledDocument doc, String text) {
        try {
            doc.insertString(doc.getLength(), text, this.textAttrSet);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"Error adding text to Diff details.", (Throwable)e);
        }
    }

    private void addDangerColorText(String text) {
        this.addColorText(FG_COLOR_DANGER, this.detailsDoc, text);
    }

    private void addColorText(Color color, StyledDocument doc, String text) {
        this.color(color);
        try {
            doc.insertString(doc.getLength(), text, this.textAttrSet);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"Error adding color text to Diff details.", (Throwable)e);
        }
        this.color(null);
    }

    private class VariableLayout {
        int dtLen;
        int offsetLen;
        int firstUseLen;
        int nameLen;
        int sizeLen;
        int sourceLen;

        private VariableLayout(ProgramDiffDetails programDiffDetails) {
        }
    }
}

