/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import ghidra.util.bytesearch.ByteSequence;
import java.util.Objects;

public class ExtendedByteSequence
implements ByteSequence {
    private static final ByteSequence EMPTY = new EmptyByteSequence();
    private ByteSequence mainSequence;
    private ByteSequence postSequence;
    private ByteSequence preSequence;
    private int mainLength;
    private int extendedLength;
    private int preLength;

    public ExtendedByteSequence(ByteSequence main, ByteSequence pre, ByteSequence post, int overlap) {
        this.mainSequence = Objects.requireNonNull(main);
        this.preSequence = Objects.requireNonNullElse(pre, EMPTY);
        this.postSequence = Objects.requireNonNullElse(post, EMPTY);
        this.mainLength = this.mainSequence.getLength();
        this.extendedLength = main.getLength() + Math.min(overlap, this.postSequence.getLength());
        this.preLength = Math.min(overlap, this.preSequence.getLength());
    }

    @Override
    public int getLength() {
        return this.mainSequence.getLength();
    }

    public int getExtendedLength() {
        return this.extendedLength;
    }

    public int getPreLength() {
        return this.preLength;
    }

    @Override
    public byte getByte(int i) {
        if (i < 0) {
            return this.preSequence.getByte(i + this.preLength);
        }
        if (i >= this.mainLength) {
            return this.postSequence.getByte(i - this.mainLength);
        }
        return this.mainSequence.getByte(i);
    }

    @Override
    public byte[] getBytes(int index, int size) {
        if (index < -this.preLength || index + size > this.extendedLength) {
            throw new IndexOutOfBoundsException();
        }
        if (index < 0 && index + size <= 0) {
            return this.preSequence.getBytes(index + this.preLength, size);
        }
        if (index + size < this.mainLength) {
            return this.mainSequence.getBytes(index, size);
        }
        if (index >= this.mainLength) {
            return this.postSequence.getBytes(index - this.mainLength, size);
        }
        byte[] results = new byte[size];
        for (int i = 0; i < size; ++i) {
            results[i] = this.getByte(index + i);
        }
        return results;
    }

    @Override
    public boolean hasAvailableBytes(int index, int length) {
        return index >= -this.preLength && index + length <= this.extendedLength;
    }

    private static class EmptyByteSequence
    implements ByteSequence {
        private EmptyByteSequence() {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public byte getByte(int index) {
            return 0;
        }

        @Override
        public boolean hasAvailableBytes(int index, int length) {
            return false;
        }

        @Override
        public byte[] getBytes(int start, int length) {
            return new byte[0];
        }
    }
}

