/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.bytesearch.BulkPatternSearcher;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.MatchAction;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MemoryBytePatternSearcher {
    private static final long RESTRICTED_PATTERN_BYTE_RANGE = 32L;
    BulkPatternSearcher<Pattern> patternSearcher = null;
    ArrayList<Pattern> patternList;
    private String searchName = "";
    private boolean doExecutableBlocksOnly = false;
    private long numToSearch = 0L;
    private long numSearched = 0L;

    public MemoryBytePatternSearcher(String searchName, ArrayList<Pattern> patternList) {
        this.searchName = searchName;
        this.patternList = new ArrayList<Pattern>(patternList);
    }

    public MemoryBytePatternSearcher(String searchName, BulkPatternSearcher<Pattern> searcher) {
        this.searchName = searchName;
        this.patternSearcher = searcher;
    }

    public MemoryBytePatternSearcher(String searchName) {
        this.searchName = searchName;
        this.patternList = new ArrayList();
    }

    public void addPattern(Pattern pattern) {
        this.patternList.add(pattern);
    }

    public void setSearchExecutableOnly(boolean doExecutableBlocksOnly) {
        this.doExecutableBlocksOnly = doExecutableBlocksOnly;
    }

    public void search(Program program, AddressSetView searchSet, TaskMonitor monitor) throws CancelledException {
        MemoryBlock[] blocks;
        if (this.patternSearcher == null) {
            this.patternSearcher = new BulkPatternSearcher<Pattern>(this.patternList);
        }
        this.numToSearch = this.getNumToSearch(program, searchSet);
        monitor.setMessage(this.searchName + " Search");
        monitor.initialize(this.numToSearch);
        for (MemoryBlock block : blocks = program.getMemory().getBlocks()) {
            monitor.setProgress(this.numSearched);
            if (!block.isInitialized() || this.doExecutableBlocksOnly && !block.isExecute() || searchSet != null && !searchSet.isEmpty() && !searchSet.intersects(block.getStart(), block.getEnd())) continue;
            try {
                this.searchBlock(this.patternSearcher, program, block, searchSet, monitor);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)("Unable to scan block " + block.getName() + " for " + this.searchName));
            }
            this.numSearched += block.getSize();
        }
    }

    private long getNumToSearch(Program program, AddressSetView searchSet) {
        MemoryBlock[] blocks;
        long numAddresses = 0L;
        for (MemoryBlock block : blocks = program.getMemory().getBlocks()) {
            if (!block.isInitialized() || this.doExecutableBlocksOnly && !block.isExecute() || searchSet != null && !searchSet.isEmpty() && !searchSet.intersects(block.getStart(), block.getEnd())) continue;
            numAddresses += block.getSize();
        }
        return numAddresses;
    }

    private void searchBlock(BulkPatternSearcher<Pattern> searcher, Program program, MemoryBlock block, AddressSetView restrictSet, TaskMonitor monitor) throws IOException, CancelledException {
        AddressSet doneSet = restrictSet == null || restrictSet.isEmpty() ? new AddressSet(block.getStart(), block.getEnd()) : restrictSet.intersectRange(block.getStart(), block.getEnd());
        long numInDoneSet = doneSet.getNumAddresses();
        long numInBlock = block.getSize();
        Address blockStartAddr = block.getStart();
        long progress = monitor.getProgress();
        AddressRangeIterator addressRanges = doneSet.getAddressRanges();
        long numDone = 0L;
        while (addressRanges.hasNext()) {
            monitor.checkCancelled();
            monitor.setMessage(this.searchName + " Search");
            monitor.setProgress(progress + (long)((float)numInBlock * ((float)numDone / (float)numInDoneSet)));
            AddressRange addressRange = (AddressRange)addressRanges.next();
            long numAddressesInRange = addressRange.getLength();
            ArrayList mymatches = new ArrayList();
            long streamoffset = blockStartAddr.getOffset();
            long blockOffset = addressRange.getMinAddress().subtract(blockStartAddr);
            if ((blockOffset -= 32L) <= 0L) {
                blockOffset = 0L;
            }
            long maxBlockSearchLength = addressRange.getMaxAddress().subtract(blockStartAddr) - blockOffset + 1L;
            InputStream data = block.getData();
            data.skip(blockOffset);
            searcher.search(data, maxBlockSearchLength, mymatches, monitor);
            monitor.checkCancelled();
            monitor.setMessage(this.searchName + " (Examine Matches)");
            long matchProgress = progress + (long)((float)numInBlock * ((float)numDone / (float)numInDoneSet));
            for (int i = 0; i < mymatches.size(); ++i) {
                monitor.checkCancelled();
                monitor.setProgress(matchProgress + (long)((float)numAddressesInRange * ((float)i / (float)mymatches.size())));
                Match<Pattern> match = mymatches.get(i);
                Pattern pattern = (Pattern)match.getPattern();
                Address addr = blockStartAddr.add((long)pattern.getMarkOffset() + match.getStart() + blockOffset);
                long totalOffset = streamoffset + blockOffset + match.getStart();
                if (!pattern.checkPostRules(totalOffset)) continue;
                MatchAction[] matchactions = pattern.getMatchActions();
                this.preMatchApply(matchactions, addr);
                for (MatchAction matchaction : matchactions) {
                    matchaction.apply(program, addr, match);
                }
                this.postMatchApply(matchactions, addr);
            }
            numDone += numAddressesInRange;
        }
    }

    public void preMatchApply(MatchAction[] matchactions, Address addr) {
    }

    public void postMatchApply(MatchAction[] matchactions, Address addr) {
    }
}

