/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.charset.picker;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GLabel;
import docking.widgets.list.GListCellRenderer;
import generic.theme.Gui;
import ghidra.app.plugin.core.strings.CharacterScriptUtils;
import ghidra.util.charset.CharsetInfo;
import ghidra.util.layout.VariableHeightPairLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class CharsetInfoPanel
extends JPanel {
    private Map<Character.UnicodeScript, String> scriptExampleStrings = new HashMap<Character.UnicodeScript, String>();
    private JTextField nameTF;
    private JTextArea commentTA;
    private GCheckBox fixedCB;
    private JTextField minmaxTF;
    private JTextField alignTF;
    private JList<Character.UnicodeScript> scriptsList;

    public CharsetInfoPanel() {
        super((LayoutManager)new VariableHeightPairLayout());
        this.build();
    }

    private void build() {
        this.nameTF = new JTextField();
        this.nameTF.setEditable(false);
        this.nameTF.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.newLabel("Name:", "Charset name", this.nameTF, false));
        this.add(this.nameTF);
        this.commentTA = new JTextArea(2, 100);
        this.commentTA.setEditable(false);
        this.commentTA.setLineWrap(true);
        this.commentTA.setWrapStyleWord(true);
        Gui.registerFont((Component)this.commentTA, (String)"font.textarea.astextfield");
        this.add((Component)this.newLabel("Description:", "Charset description", this.commentTA, true));
        this.add(this.commentTA);
        this.fixedCB = new GCheckBox();
        this.fixedCB.setEnabled(false);
        this.add((Component)this.newLabel("Fixed Length:", "Charset uses a fixed number of bytes to produce a character", (JComponent)this.fixedCB, false));
        this.add((Component)this.fixedCB);
        this.minmaxTF = new JTextField();
        this.minmaxTF.setEditable(false);
        this.minmaxTF.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.newLabel("Min/Max Bytes Per Char:", "Number of bytes a charset needs to produce a character", this.minmaxTF, false));
        this.add(this.minmaxTF);
        this.alignTF = new JTextField();
        this.alignTF.setEditable(false);
        this.alignTF.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.newLabel("Aligned Size:", "Byte offset that is valid to start a character", this.alignTF, false));
        this.add(this.alignTF);
        this.scriptsList = new JList<Character.UnicodeScript>((Character.UnicodeScript[])List.of().toArray(Character.UnicodeScript[]::new));
        this.scriptsList.setCellRenderer((ListCellRenderer<Character.UnicodeScript>)GListCellRenderer.createDefaultTextRenderer(this::getScriptCellRendererText));
        this.scriptsList.setVisibleRowCount(5);
        JScrollPane scriptsSP = new JScrollPane();
        scriptsSP.setFocusable(false);
        scriptsSP.getVerticalScrollBar().setFocusable(false);
        scriptsSP.setHorizontalScrollBarPolicy(31);
        scriptsSP.getViewport().add(this.scriptsList);
        this.add((Component)this.newLabel("Scripts:", "The scripts that this charset produce", scriptsSP, true));
        this.add(scriptsSP);
    }

    private GLabel newLabel(String text, String tooltip, JComponent comp, boolean top) {
        GLabel label = new GLabel(text);
        if (top) {
            label.setVerticalAlignment(1);
        }
        label.setToolTipText(tooltip);
        label.setLabelFor((Component)comp);
        return label;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.scriptExampleStrings != null) {
            this.scriptExampleStrings.clear();
        }
    }

    public void setCharset(CharsetInfo csi) {
        this.nameTF.setText(csi.getName());
        this.nameTF.setCaretPosition(0);
        this.commentTA.setText(csi.getComment());
        this.commentTA.setCaretPosition(0);
        this.fixedCB.setSelected(csi.hasFixedLengthChars());
        String min = csi.getMinBytesPerChar() > 0 ? Integer.toString(csi.getMinBytesPerChar()) : "unknown";
        String max = csi.getMaxBytesPerChar() > 0 ? Integer.toString(csi.getMaxBytesPerChar()) : "unknown";
        this.minmaxTF.setText("%s / %s".formatted(min, max));
        this.minmaxTF.setCaretPosition(0);
        this.alignTF.setText("%d".formatted(csi.getAlignment()));
        this.alignTF.setCaretPosition(0);
        this.scriptsList.setListData((Character.UnicodeScript[])((Character.UnicodeScript[])List.copyOf(csi.getScripts()).toArray(Character.UnicodeScript[]::new)));
    }

    private String getScriptCellRendererText(Character.UnicodeScript script) {
        this.buildScriptExamplesMap(this.getFont());
        if (script == null) {
            return "";
        }
        String name = script.name();
        Object example = this.scriptExampleStrings.getOrDefault((Object)script, "");
        if (!((String)example).isEmpty()) {
            example = " \u2014 " + (String)example;
        }
        return name + (String)example;
    }

    private void buildScriptExamplesMap(Font f) {
        if (this.scriptExampleStrings.isEmpty()) {
            this.scriptExampleStrings.putAll(CharacterScriptUtils.getDisplayableScriptExamples(f, 7));
        }
    }
}

