/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.charset.picker;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.util.charset.CharsetInfo;
import ghidra.util.charset.CharsetInfoManager;
import ghidra.util.charset.picker.CharsetTableRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class CharsetTableModel
extends AbstractSortedTableModel<CharsetTableRow> {
    static final int NAME_COL = 0;
    static final int COMMENT_COL = 1;
    static final int FIXEDLEN_COL = 2;
    static final int MINLEN_COL = 3;
    static final int MAXLEN_COL = 4;
    static final int SCRIPTS_COL = 5;
    static final String[] COL_NAMES = new String[]{"Name", "Description", "Fixed Length", "Min BPC", "Max BPC", "Scripts"};
    private List<CharsetTableRow> charsets = new ArrayList<CharsetTableRow>();

    public CharsetTableModel() {
        CharsetInfoManager.getInstance().getCharsets().stream().map(csi -> new CharsetTableRow((CharsetInfo)csi, CharsetTableModel.getScriptsString(csi.getScripts()))).forEach(this.charsets::add);
    }

    private static String getScriptsString(Set<Character.UnicodeScript> scripts) {
        StringBuilder sb = new StringBuilder();
        for (Character.UnicodeScript script : scripts) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(script.name());
        }
        return sb.toString();
    }

    public int findCharset(CharsetInfo csi) {
        for (int i = 0; i < this.charsets.size(); ++i) {
            CharsetTableRow row = this.charsets.get(i);
            if (!row.csi().getName().equals(csi.getName())) continue;
            return i;
        }
        return -1;
    }

    public String getName() {
        return "Charsets";
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int column) {
        return 0 <= column && column < COL_NAMES.length ? COL_NAMES[column] : "<<unknown>>";
    }

    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return String.class;
            }
        }
        return Object.class;
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public List<CharsetTableRow> getModelData() {
        return this.charsets;
    }

    public Object getColumnValueForRow(CharsetTableRow row, int column) {
        return switch (column) {
            case 0 -> row.csi().getName();
            case 1 -> row.csi().getComment();
            case 2 -> row.csi().hasFixedLengthChars();
            case 3 -> row.csi().getMinBytesPerChar();
            case 4 -> row.csi().getMaxBytesPerChar();
            case 5 -> row.scripts();
            default -> "???";
        };
    }
}

