/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.plugin;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.debug.DbViewerProvider;
import ghidra.app.script.AskDialog;
import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FidFile;
import ghidra.feature.fid.db.FidFileManager;
import ghidra.feature.fid.debug.FidSearchDebugDialog;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.feature.fid.service.FidService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PluginInfo(status=PluginStatus.STABLE, packageName="Developer", category="Diagnostic", shortDescription="Function ID Debug", description="This plugin is for debugging function identification libraries.")
public class FidDebugPlugin
extends ProgramPlugin
implements ChangeListener {
    static final String FUNCTION_ID_NAME = "Function ID";
    private static final String MENU_GROUP_2 = "group2";
    private FidService service;
    private FidFileManager fidFileManager;
    private List<DockingAction> debugActions;
    private DockingAction createRawFileAction;

    public FidDebugPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(() -> this.updateActions());
    }

    private void updateActions() {
        this.createDynamicDebugActions();
        this.enableActions();
    }

    protected void init() {
        super.init();
        this.fidFileManager = FidFileManager.getInstance();
        this.fidFileManager.addChangeListener(this);
        this.service = new FidService();
        this.debugActions = new ArrayList<DockingAction>();
        this.createDebugActions();
        this.createDynamicDebugActions();
        this.enableActions();
    }

    protected void cleanup() {
        this.fidFileManager.removeChangeListener(this);
        super.dispose();
    }

    private void createDebugActions() {
        if (this.tool == null) {
            throw new AssertException("Called create debug actions with tool null");
        }
        Object action = new DockingAction("Launch Debug Search Window", this.getName()){

            public void actionPerformed(ActionContext context) {
                try {
                    FidSearchDebugDialog fidSearchDebugDialog = new FidSearchDebugDialog(FidDebugPlugin.this.service);
                    FidDebugPlugin.this.tool.showDialog((DialogComponentProvider)fidSearchDebugDialog);
                }
                catch (VersionException | IOException e) {
                    Msg.showError((Object)((Object)this), null, (String)"Can't open Fid Query Service", (Object)e);
                }
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", FUNCTION_ID_NAME, "Debug Search Window"}, null, MENU_GROUP_2, -1, "7"));
        action.setDescription("Open a window to search the FID DBs in debug mode");
        action.setHelpLocation(new HelpLocation("FunctionID", "FunctionIDDebug"));
        this.tool.addAction((DockingActionIf)action);
        action = new HashAction(this);
        action.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", FUNCTION_ID_NAME, "Debug Search Window (Current Function)"}, null, MENU_GROUP_2, -1, "1"));
        action.setDescription("FidHashes the current function for debug purposes");
        action.setHelpLocation(new HelpLocation("FunctionID", "FunctionIDDebug"));
        this.tool.addAction((DockingActionIf)action);
        this.createRawFileAction = new DockingAction("raw file", this.getName()){

            public void actionPerformed(ActionContext context) {
                FidDebugPlugin.this.createRawFile();
            }
        };
        this.createRawFileAction.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", FUNCTION_ID_NAME, "Create Read-only Database"}, null, MENU_GROUP_2, -1, "1"));
        this.createRawFileAction.setDescription("Creates a raw read-only database suitable for distribution in the installation directory");
        this.createRawFileAction.setHelpLocation(new HelpLocation("FunctionID", "FunctionIDDebug"));
        this.tool.addAction((DockingActionIf)this.createRawFileAction);
    }

    protected void createRawFile() {
        FidFile fidFile = this.askChoice("Choose destination FidDb", "Please choose the destination FidDb for population", this.fidFileManager.getUserAddedFiles(), null);
        if (fidFile == null) {
            return;
        }
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
        chooser.setTitle("Where do you want to create the read-only installable database?");
        chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
        File selectedFile = chooser.getSelectedFile();
        chooser.dispose();
        if (selectedFile == null) {
            return;
        }
        File outputFile = new File(selectedFile, fidFile.getBaseName() + ".fidbf");
        try (FidDB fidDB = fidFile.getFidDB(false);){
            fidDB.saveRawDatabaseFile(outputFile, TaskMonitor.DUMMY);
        }
        catch (CancelledException | VersionException | IOException e) {
            Msg.showError((Object)this, null, (String)"Error saving read-only installable database", (Object)e.getMessage(), (Throwable)e);
        }
    }

    private void createDynamicDebugActions() {
        for (DockingAction action : this.debugActions) {
            PluginTool pluginTool = this.tool;
            if (pluginTool == null) continue;
            pluginTool.removeAction((DockingActionIf)action);
        }
        this.debugActions.clear();
        List<FidFile> allFidFiles = this.fidFileManager.getFidFiles();
        for (final FidFile fidFile : allFidFiles) {
            String actionName = "Table Viewer - " + fidFile.getName();
            DockingAction action = new DockingAction(actionName, this.getName()){

                public void actionPerformed(ActionContext context) {
                    List componentProviders = FidDebugPlugin.this.tool.getWindowManager().getComponentProviders(FidDbViewerProvider.class);
                    for (ComponentProvider comp : componentProviders) {
                        if (!((FidDbViewerProvider)comp).fidDB.getPath().equals(fidFile.getPath())) continue;
                        FidDebugPlugin.this.tool.getWindowManager().showComponent(comp, true);
                        return;
                    }
                    try {
                        new FidDbViewerProvider(FidDebugPlugin.this, fidFile);
                    }
                    catch (VersionException | IOException e) {
                        Msg.error((Object)FidDebugPlugin.this, (Object)"Error opening Fid database", (Throwable)e);
                    }
                }
            };
            action.setMenuBarData(new MenuData(new String[]{"&\u5de5\u5177", FUNCTION_ID_NAME, "Table Viewer", fidFile.getName()}, null, MENU_GROUP_2, -1, "6"));
            action.setDescription("Opens new DB Table Viewer to browse the database in " + fidFile.getName());
            action.setHelpLocation(new HelpLocation("FunctionID", "FunctionIDPlugin"));
            action.setEnabled(true);
            if (this.tool != null) {
                this.tool.addAction((DockingActionIf)action);
            }
            this.debugActions.add(action);
        }
        this.tool.setMenuGroup(new String[]{"&\u5de5\u5177", FUNCTION_ID_NAME, "Table Viewer"}, "zzz");
    }

    private void enableActions() {
        boolean atLeastOneUserFidDb = this.fidFileManager.getUserAddedFiles().size() > 0;
        this.createRawFileAction.setEnabled(atLeastOneUserFidDb);
    }

    protected <T> T askChoice(String title, String message, List<T> choices, T defaultValue) {
        AskDialog dialog = new AskDialog(null, title, message, 0, choices, defaultValue);
        if (dialog.isCanceled()) {
            return null;
        }
        Object s = dialog.getChoiceValue();
        return (T)s;
    }

    class HashAction
    extends ListingContextAction {
        FidDebugPlugin plugin;

        public HashAction(FidDebugPlugin plugin) {
            super("FidDbHash Function", plugin.getName());
            this.plugin = plugin;
        }

        public void actionPerformed(ListingActionContext context) {
            Address address = context.getAddress();
            Program program = context.getProgram();
            FunctionManager functionManager = program.getFunctionManager();
            Function function = functionManager.getFunctionContaining(address);
            if (function != null) {
                StringBuilder buffer = new StringBuilder();
                try {
                    FidHashQuad hash = this.plugin.service.hashFunction(function);
                    if (hash == null) {
                        Msg.showError((Object)((Object)this), null, (String)"Function too small", (Object)("Please select a function with at least " + this.plugin.service.getShortHashCodeUnitLength() + " code units"));
                        return;
                    }
                    String fullHashSearch = String.format("0x%016x", hash.getFullHash());
                    String specificHashSearch = String.format("0x%016x", hash.getSpecificHash());
                    FidSearchDebugDialog fidSearchDebugDialog = new FidSearchDebugDialog(FidDebugPlugin.this.service);
                    fidSearchDebugDialog.setFullHashText(fullHashSearch);
                    fidSearchDebugDialog.setSpecificHashText(specificHashSearch);
                    FidDebugPlugin.this.tool.showDialog((DialogComponentProvider)fidSearchDebugDialog);
                }
                catch (MemoryAccessException e) {
                    buffer.append("MemoryAccessException during hash: " + e.getMessage());
                }
                catch (VersionException e) {
                    buffer.append("VersionException during hash: " + e.getMessage());
                }
                catch (IOException e) {
                    buffer.append("IOException during hash: " + e.getMessage());
                }
            }
        }

        protected boolean isEnabledForContext(ListingActionContext context) {
            Address address = context.getAddress();
            if (context.hasSelection() || address == null) {
                return false;
            }
            return context.getProgram().getFunctionManager().getFunctionContaining(address) != null;
        }
    }

    private class FidDbViewerProvider
    extends DbViewerProvider {
        private FidDB fidDB;

        FidDbViewerProvider(FidDebugPlugin fidDebugPlugin, FidFile fidFile) throws VersionException, IOException {
            super((Plugin)fidDebugPlugin);
            this.fidDB = fidFile.getFidDB(false);
            this.setTransient();
            this.setWindowGroup("FID DbViewer");
            this.setTitle("FID DbViewer: " + this.fidDB.getName());
            this.openDatabase(this.fidDB.getPath(), this.fidDB.getDBHandle());
            this.tool.addComponentProvider((ComponentProvider)this, true);
        }

        public void closeComponent() {
            super.closeComponent();
            this.fidDB.close();
        }
    }
}

