/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentNode;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.DetachedWindowNode;
import docking.DockableComponent;
import docking.DockingUtils;
import docking.Node;
import docking.WindowNode;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import generic.timer.ExpiringSwingTimer;
import ghidra.util.exception.AssertException;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class ComponentPlaceholder {
    private String name;
    private String owner;
    private String group;
    private String title;
    private String subTitle;
    private String tabText;
    private Icon icon;
    private ComponentProvider componentProvider;
    private List<DockingActionIf> actions;
    private boolean isShowing;
    private ComponentNode compNode;
    private DockableComponent comp;
    private boolean showHeader = true;
    private boolean disposed = false;
    private long instanceID = 0L;

    ComponentPlaceholder(ComponentProvider provider) {
        this.componentProvider = provider;
        this.updateInfo(provider);
        this.actions = new ArrayList<DockingActionIf>();
        this.instanceID = provider.getInstanceID();
    }

    ComponentPlaceholder(String name, String owner, String group, String title, boolean show, ComponentNode node, long instanceID) {
        this.name = name;
        this.owner = owner;
        this.title = title;
        this.isShowing = show;
        this.group = group;
        this.compNode = node;
        this.instanceID = instanceID;
        this.actions = new ArrayList<DockingActionIf>();
    }

    long getInstanceID() {
        return this.instanceID;
    }

    ComponentNode getNode() {
        return this.compNode;
    }

    void showHeader(boolean b) {
        this.showHeader = b;
        this.invalidateComponentNode();
    }

    boolean isHeaderShowing() {
        return this.showHeader;
    }

    void setNode(ComponentNode node) {
        this.compNode = node;
    }

    boolean isParented() {
        return this.compNode != null;
    }

    boolean isShowing() {
        return this.isShowing && this.comp != null && this.comp.isShowing();
    }

    boolean isActive() {
        return this.isShowing && this.componentProvider != null;
    }

    boolean wantsToBeShowing() {
        return this.isShowing;
    }

    private void invalidateComponentNode() {
        if (this.compNode != null) {
            this.compNode.invalidate();
        }
    }

    String getGroup() {
        if (this.componentProvider != null) {
            this.group = this.getGroup(this.componentProvider);
        }
        return this.group;
    }

    DetachedWindowNode getDetachedWindowNode() {
        Node node = this.compNode.parent;
        while (node != null) {
            if (node instanceof DetachedWindowNode) {
                return (DetachedWindowNode)node;
            }
            node = node.parent;
        }
        return null;
    }

    WindowNode getWindowNode() {
        Node node = this.compNode.parent;
        while (node != null) {
            if (node instanceof WindowNode) {
                return (WindowNode)node;
            }
            node = node.parent;
        }
        return null;
    }

    WindowNode getTopLevelNode() {
        if (this.compNode == null) {
            return null;
        }
        return this.compNode.getTopLevelNode();
    }

    void reset() {
        this.isShowing = false;
        this.invalidate();
    }

    void show(boolean doShow) {
        if (doShow == this.isShowing) {
            return;
        }
        this.isShowing = doShow;
        this.invalidate();
    }

    private void invalidate() {
        this.invalidateComponentNode();
        this.disposeComponent();
        if (this.componentProvider != null) {
            if (this.isShowing) {
                this.componentProvider.componentShown();
            } else {
                this.componentProvider.componentHidden();
            }
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    void dispose() {
        this.disposed = true;
        if (this.comp != null) {
            this.comp.dispose();
            this.comp = null;
        }
        if (this.compNode == null) {
            return;
        }
        WindowNode windowNode = this.compNode.getTopLevelNode();
        if (windowNode != null) {
            windowNode.componentRemoved(this);
        }
        this.compNode.remove(this);
        this.compNode = null;
    }

    private void disposeComponent() {
        if (this.comp == null) {
            return;
        }
        this.comp.dispose();
        this.comp = null;
    }

    boolean canTakeFocus() {
        return this.comp != null;
    }

    void toFront() {
        if (this.comp != null) {
            this.compNode.makeSelectedTab(this);
        }
    }

    void requestFocusWhenReady() {
        DockableComponent tmp = this.comp;
        if (tmp == null) {
            return;
        }
        this.compNode.makeSelectedTab(this);
        this.activateWindow();
        ExpiringSwingTimer.runWhen(this::isShowing, () -> this.doRequestFocus(tmp));
    }

    private void doRequestFocus(DockableComponent dockableComponent) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = kfm.getActiveWindow();
        if (activeWindow == null) {
            return;
        }
        dockableComponent.requestFocus();
        this.contextChanged();
    }

    private void activateWindow() {
        Window window;
        DetachedWindowNode windowNode = this.getDetachedWindowNode();
        if (windowNode != null && (window = this.getDetachedWindowNode().getWindow()) instanceof Frame) {
            Frame frame = (Frame)window;
            frame.setState(0);
        }
    }

    void close() {
        if (this.componentProvider != null) {
            this.componentProvider.closeComponent();
        }
    }

    public DockableComponent getComponent() {
        if (this.disposed) {
            throw new AssertException("Attempted to get a component for a disposed placeholder - " + String.valueOf(this));
        }
        boolean isDocking = true;
        if (this.compNode != null) {
            isDocking = this.compNode.winMgr.isDocking();
        }
        if (this.comp == null && this.isShowing) {
            this.comp = new DockableComponent(this, isDocking);
        }
        return this.comp;
    }

    void setIcon(Icon icon) {
        this.icon = icon = DockingUtils.scaleIconAsNeeded(icon);
        if (this.comp != null) {
            this.comp.setIcon(icon);
        }
        if (this.compNode != null) {
            this.compNode.iconChanged(this);
        }
    }

    Icon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public String getTabText() {
        return this.tabText;
    }

    public String getName() {
        return this.name;
    }

    String getOwner() {
        return this.owner;
    }

    JComponent getProviderComponent() {
        if (this.componentProvider != null) {
            return this.componentProvider.doGetComponent();
        }
        return new JPanel();
    }

    boolean isStacked() {
        if (this.compNode != null) {
            return this.compNode.isStacked();
        }
        return false;
    }

    boolean hasProvider() {
        return this.componentProvider != null;
    }

    void setProvider(ComponentProvider newProvider) {
        this.componentProvider = newProvider;
        this.actions.clear();
        if (newProvider != null) {
            this.updateInfo(newProvider);
        }
        this.disposeComponent();
    }

    public void update() {
        this.updateInfo(this.componentProvider);
    }

    private void updateTitle(ComponentProvider provider) {
        this.title = provider.getTitle();
        this.subTitle = provider.getSubTitle();
        this.tabText = provider.getTabText();
        String string = this.tabText = this.tabText == null ? this.title : this.tabText;
        if (this.comp != null) {
            this.comp.setTitle(this.getFullTitle());
        }
        if (this.compNode != null) {
            this.compNode.titleChanged(this);
        }
    }

    private void updateInfo(ComponentProvider updatedProvider) {
        if (updatedProvider == null) {
            return;
        }
        this.updateTitle(updatedProvider);
        this.owner = updatedProvider.getOwner();
        this.name = updatedProvider.getName();
        this.group = this.getGroup(updatedProvider);
        this.setIcon(updatedProvider.getIcon());
        this.instanceID = this.componentProvider.getInstanceID();
    }

    private String getGroup(ComponentProvider provider) {
        String providerGroup = provider.getWindowGroup();
        if (providerGroup == null || providerGroup.isEmpty()) {
            return "Default";
        }
        return providerGroup;
    }

    public ComponentProvider getProvider() {
        return this.componentProvider;
    }

    void addAction(DockingActionIf action) {
        if (this.actions.contains(action)) {
            throw new RuntimeException("Duplicate action added");
        }
        this.actions.add(action);
        if (this.comp != null) {
            this.comp.actionAdded(action);
        }
    }

    void removeAllActions() {
        if (this.comp != null) {
            for (DockingActionIf action : this.actions) {
                this.comp.actionRemoved(action);
            }
        }
        this.actions.clear();
    }

    void removeAction(DockingActionIf action) {
        if (this.actions.remove(action) && this.comp != null) {
            this.comp.actionRemoved(action);
        }
    }

    void contextChanged() {
        if (this.componentProvider == null) {
            return;
        }
        ActionContext actionContext = this.componentProvider.getActionContext(null);
        if (actionContext == null) {
            actionContext = new DefaultActionContext(this.componentProvider, null);
        }
        for (DockingActionIf action : this.actions) {
            action.setEnabled(action.isValidContext(actionContext) && action.isEnabledForContext(actionContext));
        }
    }

    boolean hasAction(DockingAction action) {
        return this.actions.contains(action);
    }

    Iterator<DockingActionIf> getActions() {
        return this.actions.iterator();
    }

    void setSelected(boolean state) {
        if (this.comp != null) {
            this.comp.setSelected(state);
            this.setProviderActivated(state);
        }
    }

    void emphasize() {
        if (this.comp != null) {
            this.comp.emphasize();
        }
    }

    private void setProviderActivated(boolean activated) {
        if (this.componentProvider == null) {
            return;
        }
        if (activated) {
            this.componentProvider.componentActivated();
        } else {
            this.componentProvider.componentDeactived();
        }
    }

    public String getFullTitle() {
        Object text = this.title;
        if (!StringUtils.isBlank((CharSequence)this.subTitle)) {
            text = (String)text + " - " + this.subTitle;
        }
        return text;
    }

    public String toString() {
        return "name=\"" + this.name + "\", fullTitle=\"" + this.getFullTitle() + "\"";
    }
}

