/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import docking.framework.ApplicationInformationDisplayFactory;
import docking.help.CalloutRequest;
import docking.help.HelpViewSearcher;
import docking.help.NavigationAidToggleAction;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import help.CustomTOCView;
import help.GHelpBroker;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.NavigatorView;
import javax.help.WindowPresentation;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JToolBar;
import resources.Icons;

public class DockingHelpBroker
extends GHelpBroker {
    private static final List<Image> ICONS = ApplicationInformationDisplayFactory.getWindowIcons();
    private HelpModelListener helpModelListener = new HelpIDChangedListener();
    private CalloutRequest callout;

    public DockingHelpBroker(HelpSet hs) {
        super(hs);
    }

    protected List<Image> getApplicationIcons() {
        return ICONS;
    }

    protected HelpModel getCustomHelpModel() {
        WindowPresentation windowPresentation = this.getWindowPresentation();
        HelpSet helpSet = windowPresentation.getHelpSet();
        NavigatorView tocView = helpSet.getNavigatorView("TOC");
        if (!(tocView instanceof CustomTOCView)) {
            Msg.debug((Object)((Object)this), (Object)"The help system is not using the CustomTOCView class!");
            return null;
        }
        CustomTOCView customTOCView = (CustomTOCView)tocView;
        return customTOCView.getHelpModel();
    }

    protected void installHelpSearcher(JHelp jHelp, HelpModel helpModel) {
        helpModel.addHelpModelListener(this.helpModelListener);
        new HelpViewSearcher(jHelp);
    }

    protected void showNavigationAid(URL url) {
        this.prepareToCallout(url);
    }

    protected void installActions(JHelp help) {
        Component[] components;
        JToolBar toolbar = null;
        for (Component c : components = help.getComponents()) {
            if (!(c instanceof JToolBar)) continue;
            toolbar = (JToolBar)c;
            break;
        }
        if (toolbar == null) {
            return;
        }
        toolbar.addSeparator();
        NavigationAidToggleAction action = new NavigationAidToggleAction();
        toolbar.add(new JButton(action));
        if (SystemUtilities.isInDevelopmentMode()) {
            AbstractAction refreshAction = new AbstractAction(){
                {
                    this.putValue("SmallIcon", Icons.REFRESH_ICON);
                    this.putValue("ShortDescription", "Reload the current page");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    DockingHelpBroker.this.reloadHelpPage(DockingHelpBroker.this.getCurrentURL(), true);
                }
            };
            toolbar.add(new JButton(refreshAction));
        }
    }

    protected void reloadHelpPage(URL url, boolean preserveLocation) {
        super.reloadHelpPage(url, preserveLocation);
    }

    private void prepareToCallout(URL url) {
        if (this.callout != null) {
            this.callout.dispose();
            this.callout = null;
        }
        this.callout = new CalloutRequest(this, this.htmlEditorPane, url);
        this.callout.runLater();
    }

    private class HelpIDChangedListener
    implements HelpModelListener {
        private HelpIDChangedListener() {
        }

        public void idChanged(HelpModelEvent e) {
            DockingHelpBroker.this.prepareToCallout(e.getURL());
        }
    }
}

