/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.actions.KeyBindingUtils;
import docking.widgets.FindDialog;
import docking.widgets.SearchLocation;
import docking.widgets.search.SearchResults;
import docking.widgets.search.TextComponentSearchLocation;
import docking.widgets.search.TextComponentSearchResults;
import docking.widgets.search.TextComponentSearcher;
import generic.util.WindowUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Worker;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.time.Duration;
import java.util.Enumeration;
import java.util.Objects;
import java.util.TreeMap;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.JHelpSearchNavigator;
import javax.help.TextHelpModel;
import javax.help.search.SearchEngine;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.text.Document;

class HelpViewSearcher {
    private static final String FIND_ACTION_NAME = "find.action";
    private static KeyStroke FIND_KEYSTROKE = KeyStroke.getKeyStroke(70, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private JHelp jHelp;
    private SearchEngine searchEngine;
    private JEditorPane htmlEditorPane;
    private FindDialog findDialog;

    HelpViewSearcher(JHelp jHelp) {
        this.jHelp = jHelp;
        this.grabSearchEngine();
        JHelpContentViewer contentViewer = jHelp.getContentViewer();
        this.htmlEditorPane = this.getHTMLEditorPane(contentViewer);
        HtmlTextSearcher searcher = new HtmlTextSearcher(this.htmlEditorPane);
        this.findDialog = new FindDialog("Help Find", searcher);
        this.htmlEditorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HelpViewSearcher.this.htmlEditorPane.getCaret().setVisible(true);
            }
        });
        this.installPopup();
        this.installKeybindings();
    }

    private void grabSearchEngine() {
        Enumeration navigators = this.jHelp.getHelpNavigators();
        while (navigators.hasMoreElements()) {
            Object element = navigators.nextElement();
            if (!(element instanceof JHelpSearchNavigator)) continue;
            this.searchEngine = ((JHelpSearchNavigator)element).getSearchEngine();
        }
        if (this.searchEngine == null) {
            throw new AssertException("Unable to locate help search engine");
        }
    }

    private void installPopup() {
        this.htmlEditorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpViewSearcher.this.showPopupMenu(e);
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpViewSearcher.this.showPopupMenu(e);
                    return;
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpViewSearcher.this.showPopupMenu(e);
                    return;
                }
            }
        });
    }

    private void installKeybindings() {
        KeyBindingUtils.registerAction((JComponent)this.htmlEditorPane, FIND_KEYSTROKE, new FindDialogAction(), 1);
    }

    private void showPopupMenu(MouseEvent e) {
        JMenuItem menuItem = new JMenuItem("Find on Page...");
        menuItem.setAction(new FindDialogAction());
        menuItem.setText("Find on Page...");
        JPopupMenu menu = new JPopupMenu();
        menu.add(menuItem);
        menu.show(this.htmlEditorPane, e.getX(), e.getY());
    }

    private JEditorPane getHTMLEditorPane(JHelpContentViewer contentViewer) {
        Component[] components = contentViewer.getComponents();
        JScrollPane scrollPane = (JScrollPane)components[0];
        JViewport viewport = scrollPane.getViewport();
        return (JEditorPane)viewport.getView();
    }

    private class HtmlTextSearcher
    extends TextComponentSearcher {
        public HtmlTextSearcher(JEditorPane editorPane) {
            super(editorPane);
        }

        @Override
        protected HtmlSearchResults createSearchResults(Worker worker, JEditorPane jEditorPane, String searchText, TreeMap<Integer, TextComponentSearchLocation> matchesByPosition) {
            HtmlSearchResults results = new HtmlSearchResults(worker, jEditorPane, searchText, matchesByPosition);
            TextHelpModel model = HelpViewSearcher.this.jHelp.getModel();
            URL url = model.getCurrentURL();
            results.setUrl(url);
            return results;
        }
    }

    private class FindDialogAction
    extends AbstractAction {
        FindDialogAction() {
            super(HelpViewSearcher.FIND_ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window helpWindow = WindowUtilities.windowForComponent((Component)HelpViewSearcher.this.htmlEditorPane);
            DockingWindowManager.showDialog(helpWindow, HelpViewSearcher.this.findDialog);
        }
    }

    private class HtmlSearchResults
    extends TextComponentSearchResults {
        private PageLoadedListener pageLoadListener;
        private URL searchUrl;
        private int fullDocumentLength;
        private String name;

        HtmlSearchResults(Worker worker, JEditorPane editorPane, String searchText, TreeMap<Integer, TextComponentSearchLocation> matchesByPosition) {
            super(worker, editorPane, searchText, matchesByPosition);
            this.pageLoadListener = new PageLoadedListener(this, this);
            editorPane.addPropertyChangeListener("page", this.pageLoadListener);
            Document doc = editorPane.getDocument();
            this.fullDocumentLength = doc.getLength();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        protected boolean isInvalid(String otherSearchText) {
            if (!this.isMyHelpPageShowing()) {
                return true;
            }
            return super.isInvalid(otherSearchText);
        }

        private boolean isMyHelpPageShowing() {
            TextHelpModel model = HelpViewSearcher.this.jHelp.getModel();
            URL htmlViewerURL = model.getCurrentURL();
            if (!Objects.equals(htmlViewerURL, this.searchUrl)) {
                return false;
            }
            Document doc = this.editorPane.getDocument();
            int currentLength = doc.getLength();
            return this.fullDocumentLength == currentLength;
        }

        private void loadMyHelpPage(TaskMonitor m) {
            if (this.isMyHelpPageShowing()) {
                return;
            }
            HelpViewSearcher.this.jHelp.setCurrentURL(this.searchUrl);
        }

        @Override
        protected SearchResults.ActivationJob createActivationJob() {
            return (SearchResults.ActivationJob)super.createActivationJob().thenRun(this::loadMyHelpPage).thenWait(this::isMyHelpPageShowing, Duration.ofSeconds(3L));
        }

        @Override
        public void activate() {
            SearchLocation lastActiveLocation = this.getActiveLocation();
            SearchResults.FindJob job = this.startActivation().thenRunSwing(() -> this.restoreLocation(lastActiveLocation));
            this.runActivationJob((SearchResults.ActivationJob)job);
        }

        private void restoreLocation(SearchLocation lastActiveLocation) {
            if (lastActiveLocation != null) {
                this.setActiveLocation(null);
                this.setActiveLocation(lastActiveLocation);
            }
        }

        @Override
        public void dispose() {
            this.editorPane.removePropertyChangeListener("page", this.pageLoadListener);
            super.dispose();
        }

        void setUrl(URL url) {
            this.searchUrl = url;
            this.name = this.getFilename(this.searchUrl);
        }

        private URL getUrl() {
            return this.searchUrl;
        }

        private class PageLoadedListener
        implements PropertyChangeListener {
            private HtmlSearchResults htmlResults;

            PageLoadedListener(HtmlSearchResults htmlSearchResults, HtmlSearchResults htmlResults) {
                this.htmlResults = htmlResults;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                URL newPage = (URL)evt.getNewValue();
                if (!Objects.equals(newPage, this.htmlResults.getUrl())) {
                    this.htmlResults.deactivate();
                }
            }
        }
    }
}

