/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.CursorPosition;
import docking.widgets.search.SearchLocationContext;

public class SearchLocation {
    private final int startIndexInclusive;
    private final int endIndexInclusive;
    private final String text;
    private SearchLocationContext context;
    private int lineNumber;

    public SearchLocation(int startIndexInclusive, int endIndexInclusive, String text) {
        this.startIndexInclusive = startIndexInclusive;
        this.endIndexInclusive = endIndexInclusive;
        this.text = text;
    }

    public SearchLocation(int startIndexInclusive, int endIndexInclusive, String text, int lineNumber, SearchLocationContext context) {
        this.startIndexInclusive = startIndexInclusive;
        this.endIndexInclusive = endIndexInclusive;
        this.text = text;
        this.context = context;
        this.lineNumber = lineNumber;
    }

    public SearchLocationContext getContext() {
        return this.context;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public CursorPosition getCursorPosition() {
        return new CursorPosition(this.startIndexInclusive);
    }

    public int getEndIndexInclusive() {
        return this.endIndexInclusive;
    }

    public int getStartIndexInclusive() {
        return this.startIndexInclusive;
    }

    public boolean contains(int pos) {
        return this.startIndexInclusive <= pos && this.endIndexInclusive >= pos;
    }

    public int getMatchLength() {
        return this.endIndexInclusive - this.startIndexInclusive + 1;
    }

    public String toString() {
        return this.text + "[" + this.fieldsToString() + "]";
    }

    protected String fieldsToString() {
        return "line=%s, start=%s, end=%s".formatted(this.lineNumber, this.startIndexInclusive, this.endIndexInclusive);
    }
}

