/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.MappedColumnConstraint;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import generic.json.Json;
import java.awt.Component;
import javax.swing.event.ChangeListener;

public class MappedColumnConstraintEditor<T, M>
implements ColumnConstraintEditor<T> {
    private ColumnConstraintEditor<M> delegateEditor;
    private MappedColumnConstraint<T, M> constraint;

    public MappedColumnConstraintEditor(MappedColumnConstraint<T, M> constraint, ColumnConstraintEditor<M> delegateEditor) {
        this.constraint = constraint;
        this.delegateEditor = delegateEditor;
    }

    @Override
    public Component getInlineComponent() {
        return this.delegateEditor.getInlineComponent();
    }

    @Override
    public Component getDetailComponent() {
        return this.delegateEditor.getDetailComponent();
    }

    @Override
    public ColumnConstraint<T> getValue() {
        ColumnConstraint<M> value = this.delegateEditor.getValue();
        return this.constraint.copy(value);
    }

    @Override
    public void setValue(ColumnConstraint<T> value) {
        MappedColumnConstraint newConstraint = (MappedColumnConstraint)value;
        this.delegateEditor.setValue(newConstraint.getDelegate());
    }

    @Override
    public void reset() {
        this.delegateEditor.reset();
    }

    @Override
    public boolean hasValidValue() {
        return this.delegateEditor.hasValidValue();
    }

    @Override
    public String getErrorMessage() {
        return this.delegateEditor.getErrorMessage();
    }

    @Override
    public void addChangeListener(ChangeListener constraintEditorChangeListener) {
        this.delegateEditor.addChangeListener(constraintEditorChangeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener constraintEditorChangeListener) {
        this.delegateEditor.addChangeListener(constraintEditorChangeListener);
    }

    public String toString() {
        return Json.toString((Object)this);
    }
}

