/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import docking.widgets.textfield.PreviewTextField;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Iterator;

public class ElidingFilePathTextField
extends PreviewTextField {
    private static final int ELLIPSE_LEN = "...".length();

    public ElidingFilePathTextField() {
        this(null, null);
    }

    public ElidingFilePathTextField(String text) {
        this(text, null);
    }

    public ElidingFilePathTextField(String text, String hint) {
        super(text, hint, false, null);
    }

    protected boolean isShortEnough(String s, FontMetrics fm, int maxWidth) {
        return fm.stringWidth(s) < maxWidth;
    }

    @Override
    protected String getPreviewString(String s, FontMetrics fm, int maxWidth) {
        PathPartInfo ppi2;
        String[] pathParts = s.split("/");
        if (pathParts.length < 2) {
            return s;
        }
        ArrayList<PathPartInfo> sortedParts = new ArrayList<PathPartInfo>();
        for (int i = 0; i < pathParts.length - 1; ++i) {
            sortedParts.add(new PathPartInfo(i, pathParts[i]));
        }
        sortedParts.sort((s1, s2) -> PathPartInfo.pathPartCompare(pathParts, s2, s1, true));
        String result = s;
        Iterator iterator = sortedParts.iterator();
        while (iterator.hasNext() && (ppi2 = (PathPartInfo)iterator.next()).getLen(pathParts) > ELLIPSE_LEN) {
            String part = pathParts[ppi2.origIndex];
            for (int i = part.length() - ELLIPSE_LEN; i >= 0; --i) {
                pathParts[ppi2.origIndex] = i > 0 ? part.substring(0, i) + "..." : null;
                result = this.partsToString(pathParts);
                if (!this.isShortEnough(result, fm, maxWidth)) continue;
                return result;
            }
        }
        for (PathPartInfo ppi2 : sortedParts) {
            if (pathParts[ppi2.origIndex] == null) continue;
            pathParts[ppi2.origIndex] = null;
            result = this.partsToString(pathParts);
            if (!this.isShortEnough(result, fm, maxWidth)) continue;
            break;
        }
        return result;
    }

    private String partsToString(String[] pathParts) {
        StringBuilder sb = new StringBuilder();
        int nullrun = 0;
        for (int i = 0; i < pathParts.length; ++i) {
            String part = pathParts[i];
            if (part != null) {
                if (i == 0 && part.isEmpty() && (pathParts.length < 2 || pathParts[1] != null)) {
                    part = "/";
                }
                if (nullrun != 0) {
                    this.appendPath(sb, nullrun == 1 ? "..." : "....");
                    nullrun = 0;
                }
                this.appendPath(sb, part);
                continue;
            }
            ++nullrun;
        }
        return sb.toString();
    }

    private void appendPath(StringBuilder sb, String s) {
        if (!sb.isEmpty() && sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(s);
    }

    record PathPartInfo(int origIndex, String s) {
        int getLen(String[] pathParts) {
            String partStr = pathParts[this.origIndex];
            return partStr != null ? partStr.length() : ELLIPSE_LEN;
        }

        static int pathPartCompare(String[] pathParts, PathPartInfo ppi1, PathPartInfo ppi2, boolean boostOutsideElements) {
            int s1len = ppi1.getLen(pathParts);
            int s2len = ppi2.getLen(pathParts);
            if (boostOutsideElements) {
                if (ppi1.origIndex < 2 || ppi1.origIndex > pathParts.length - 3) {
                    s1len /= 2;
                }
                if (ppi2.origIndex < 2 || ppi2.origIndex > pathParts.length - 3) {
                    s2len /= 2;
                }
            }
            return Integer.compare(s1len, s2len);
        }
    }
}

