/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import docking.widgets.textfield.HintTextField;
import ghidra.util.HTMLUtilities;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.Objects;
import javax.swing.InputVerifier;

public abstract class PreviewTextField
extends HintTextField {
    private String origToolTip;
    private boolean previewWasTruncated;

    protected PreviewTextField(String text, String hint, boolean required, InputVerifier verifier) {
        super(text, hint, required, verifier);
    }

    protected abstract String getPreviewString(String var1, FontMetrics var2, int var3);

    @Override
    public void paintComponent(Graphics g) {
        boolean oldTrucatedFlag = this.previewWasTruncated;
        this.previewWasTruncated = false;
        if (this.isFocusOwner() || this.getText().isEmpty()) {
            super.paintComponent(g);
        } else {
            this.paintPreviewText((Graphics2D)g);
        }
        if (oldTrucatedFlag != this.previewWasTruncated) {
            this.updatePreviewToolTip();
        }
    }

    private void paintPreviewText(Graphics2D g2) {
        g2.setColor(this.getForeground());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = g2.getFontMetrics();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int fontHt = fm.getDescent() + fm.getAscent();
        int compHt = size.height - insets.top - insets.bottom;
        int compW = size.width - insets.left - insets.right;
        int baselineY = insets.top + fm.getAscent() + (compHt - fontHt) / 2;
        String s = this.getText();
        int strW = fm.stringWidth(s);
        if (strW > compW) {
            this.previewWasTruncated = true;
            s = this.getPreviewString(s, fm, compW);
            strW = fm.stringWidth(s);
        }
        int n = insets.left;
        int x = n + (switch (this.getHorizontalAlignment()) {
            case 2 -> 0;
            case 0 -> compW / 2 - strW / 2;
            case 4 -> compW - strW;
            default -> 0;
        });
        g2.drawString(s, x, baselineY);
    }

    protected String getPreviewToolTipAdditionalText() {
        return this.getText();
    }

    private void updatePreviewToolTip() {
        super.setToolTipText(this.getPreviewToolTip());
    }

    private String getPreviewToolTip() {
        String text;
        String string = text = this.previewWasTruncated ? Objects.requireNonNullElse(this.getPreviewToolTipAdditionalText(), "") : "";
        if (text.isEmpty()) {
            return this.origToolTip;
        }
        Object s = Objects.requireNonNullElse(this.origToolTip, "");
        if (!((String)s).isEmpty()) {
            s = (String)s + (HTMLUtilities.isHTML((String)s) ? "<br><br>" : "\n\n");
        }
        s = (String)s + text;
        return s;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.updatePreviewToolTip();
    }

    @Override
    public void setToolTipText(String text) {
        this.origToolTip = text;
        this.updatePreviewToolTip();
    }
}

