/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV0;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV1;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV2;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV3;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV4;
import ghidra.program.database.util.AndQuery;
import ghidra.program.database.util.FieldMatchQuery;
import ghidra.program.database.util.Query;
import ghidra.program.database.util.QueryRecordIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

abstract class SymbolDatabaseAdapter {
    static final String SYMBOL_TABLE_NAME = "Symbols";
    static final int SYMBOL_NAME_COL = 0;
    static final int SYMBOL_ADDR_COL = 1;
    static final int SYMBOL_PARENT_ID_COL = 2;
    static final int SYMBOL_TYPE_COL = 3;
    static final int SYMBOL_FLAGS_COL = 4;
    static final int SYMBOL_HASH_COL = 5;
    static final int SYMBOL_PRIMARY_COL = 6;
    static final int SYMBOL_DATATYPE_COL = 7;
    static final int SYMBOL_VAROFFSET_COL = 8;
    static final int SYMBOL_ORIGINAL_IMPORTED_NAME_COL = 9;
    static final int SYMBOL_EXTERNAL_PROG_ADDR_COL = 10;
    static final int SYMBOL_COMMENT_COL = 11;
    static final int SYMBOL_LIBPATH_COL = 12;
    static final Schema SYMBOL_SCHEMA = SymbolDatabaseAdapterV4.V4_SYMBOL_SCHEMA;
    static final byte SYMBOL_SOURCE_LO_BITS = 3;
    static final byte SYMBOL_PINNED_FLAG = 4;
    static final byte SYMBOL_SOURCE_HI_BIT = 8;
    static final byte SYMBOL_SOURCE_MASK = 11;
    static final int SYMBOL_SOURCE_LO_BITS_SHIFT = 0;
    static final int SYMBOL_SOURCE_HI_BIT_SHIFT = 3;
    static final int MAX_SOURCE_VALUE = 7;
    static final int SYMBOL_TYPE_LABEL = SymbolType.LABEL.getID();
    static final int SYMBOL_TYPE_LIBRARY = SymbolType.LIBRARY.getID();
    static final int SYMBOL_TYPE_NAMESPACE = SymbolType.NAMESPACE.getID();
    static final int SYMBOL_TYPE_CLASS = SymbolType.CLASS.getID();
    static final int SYMBOL_TYPE_FUNCTION = SymbolType.FUNCTION.getID();
    static final int SYMBOL_TYPE_PARAMETER = SymbolType.PARAMETER.getID();
    static final int SYMBOL_TYPE_LOCAL_VAR = SymbolType.LOCAL_VAR.getID();
    static final int SYMBOL_TYPE_GLOBAL_VAR = SymbolType.GLOBAL_VAR.getID();

    SymbolDatabaseAdapter() {
    }

    static SymbolDatabaseAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == OpenMode.CREATE) {
            return new SymbolDatabaseAdapterV4(dbHandle, addrMap, true);
        }
        try {
            SymbolDatabaseAdapterV4 adapter = new SymbolDatabaseAdapterV4(dbHandle, addrMap, false);
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            SymbolDatabaseAdapter adapter = SymbolDatabaseAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == OpenMode.UPGRADE) {
                adapter = SymbolDatabaseAdapter.upgrade(dbHandle, addrMap, adapter, monitor);
            } else if (adapter instanceof SymbolDatabaseAdapterV0) {
                throw e;
            }
            return adapter;
        }
    }

    private static SymbolDatabaseAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws VersionException {
        try {
            return new SymbolDatabaseAdapterV3(handle, addrMap.getOldAddressMap());
        }
        catch (VersionException versionException) {
            try {
                return new SymbolDatabaseAdapterV2(handle, addrMap.getOldAddressMap());
            }
            catch (VersionException versionException2) {
                try {
                    return new SymbolDatabaseAdapterV1(handle, addrMap.getOldAddressMap());
                }
                catch (VersionException versionException3) {
                    try {
                        return new SymbolDatabaseAdapterV0(handle, addrMap.getOldAddressMap());
                    }
                    catch (VersionException versionException4) {
                        throw new VersionException(false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SymbolDatabaseAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, SymbolDatabaseAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        monitor.setMessage("Upgrading Symbol Table...");
        monitor.initialize((long)(oldAdapter.getSymbolCount() * 2));
        DBHandle tmpHandle = dbHandle.getScratchPad();
        try {
            SymbolDatabaseAdapter tmpAdapter = SymbolDatabaseAdapter.copyToTempAndFixupRecords(addrMap, oldAdapter, tmpHandle, monitor);
            dbHandle.deleteTable(SYMBOL_TABLE_NAME);
            SymbolDatabaseAdapterV4 newAdapter = new SymbolDatabaseAdapterV4(dbHandle, addrMap, true);
            SymbolDatabaseAdapter.copyTempToNewAdapter(tmpAdapter, newAdapter, monitor);
            SymbolDatabaseAdapterV4 symbolDatabaseAdapterV4 = newAdapter;
            return symbolDatabaseAdapterV4;
        }
        finally {
            tmpHandle.deleteTable(SYMBOL_TABLE_NAME);
        }
    }

    private static SymbolDatabaseAdapter copyToTempAndFixupRecords(AddressMap addrMap, SymbolDatabaseAdapter oldAdapter, DBHandle tmpHandle, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        long zeroIdRemap = -1L;
        if (oldAdapter instanceof SymbolDatabaseAdapterV0) {
            zeroIdRemap = ((SymbolDatabaseAdapterV0)oldAdapter).extractLocalSymbols(tmpHandle, monitor);
        }
        SymbolDatabaseAdapterV4 tmpAdapter = new SymbolDatabaseAdapterV4(tmpHandle, addrMap, true);
        RecordIterator iter = oldAdapter.getSymbols();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            DBRecord rec = iter.next();
            Address addr = oldAddrMap.decodeAddress(rec.getLongValue(1));
            rec.setLongValue(1, addrMap.getKey(addr, true));
            if (zeroIdRemap > 0L && rec.getKey() == 0L) {
                rec.setKey(zeroIdRemap);
            }
            tmpAdapter.updateSymbolRecord(rec);
            monitor.incrementProgress(1L);
        }
        return tmpAdapter;
    }

    private static void copyTempToNewAdapter(SymbolDatabaseAdapter tmpAdapter, SymbolDatabaseAdapter newAdapter, TaskMonitor monitor) throws IOException, CancelledException {
        RecordIterator iter = tmpAdapter.getSymbols();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            newAdapter.updateSymbolRecord(iter.next());
            monitor.incrementProgress(1L);
        }
    }

    static byte getSourceTypeFlagsBits(SourceType sourceType) {
        int sourceTypeId = sourceType.getStorageId();
        if (sourceTypeId > 7) {
            throw new RuntimeException("Unsupported SourceType storage ID: " + sourceTypeId);
        }
        int sourceTypeLoBits = (sourceTypeId & 3) << 0;
        int sourceTypeHiBit = sourceTypeId >>> 2 << 3;
        return (byte)(sourceTypeHiBit | sourceTypeLoBits);
    }

    static SourceType decodeSourceTypeFromFlags(byte flags) {
        int sourceTypeLoBits = (flags & 3) >>> 0;
        int sourceTypeHiBit = (flags & 8) >>> 1;
        int sourceTypeId = sourceTypeHiBit | sourceTypeLoBits;
        return SourceType.getSourceType(sourceTypeId);
    }

    abstract DBRecord createSymbolRecord(String var1, long var2, Address var4, SymbolType var5, boolean var6, SourceType var7);

    abstract DBRecord getSymbolRecord(long var1) throws IOException;

    abstract void removeSymbol(long var1) throws IOException;

    abstract boolean hasSymbol(Address var1) throws IOException;

    abstract Field[] getSymbolIDs(Address var1) throws IOException;

    abstract int getSymbolCount();

    abstract RecordIterator getSymbolsByAddress(boolean var1) throws IOException;

    abstract RecordIterator getSymbolsByAddress(Address var1, boolean var2) throws IOException;

    abstract void updateSymbolRecord(DBRecord var1) throws IOException;

    abstract RecordIterator getSymbols() throws IOException;

    abstract RecordIterator getSymbols(Address var1, Address var2, boolean var3) throws IOException;

    abstract RecordIterator getSymbols(AddressSetView var1, boolean var2) throws IOException;

    abstract RecordIterator getPrimarySymbols(AddressSetView var1, boolean var2) throws IOException;

    abstract DBRecord getPrimarySymbol(Address var1) throws IOException;

    abstract void moveAddress(Address var1, Address var2) throws IOException;

    abstract Set<Address> deleteAddressRange(Address var1, Address var2, TaskMonitor var3) throws CancelledException, IOException;

    abstract RecordIterator getSymbolsByNamespace(long var1) throws IOException;

    abstract RecordIterator getSymbolsByName(String var1) throws IOException;

    abstract RecordIterator scanSymbolsByName(String var1) throws IOException;

    abstract RecordIterator getExternalSymbolsByOriginalImportName(String var1) throws IOException;

    abstract RecordIterator getExternalSymbolsByMemoryAddress(Address var1) throws IOException;

    abstract RecordIterator getSymbolsByNameAndNamespace(String var1, long var2) throws IOException;

    abstract DBRecord getSymbolRecord(Address var1, String var2, long var3) throws IOException;

    abstract Address getMaxSymbolAddress(AddressSpace var1) throws IOException;

    abstract Table getTable();

    protected static LongField computeLocatorHash(String name, long namespaceID, long addressKey) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        long nameNamespaceHash = Objects.hash(name, namespaceID);
        long combinedHash = nameNamespaceHash << 32 | addressKey & 0xFFFFFFFFL;
        return new LongField(combinedHash);
    }

    protected static RecordIterator getNameAndNamespaceFilterIterator(String name, long namespaceId, RecordIterator it) {
        FieldMatchQuery nameQuery = new FieldMatchQuery(0, (Field)new StringField(name));
        FieldMatchQuery namespaceQuery = new FieldMatchQuery(2, (Field)new LongField(namespaceId));
        AndQuery nameAndNamespaceQuery = new AndQuery(nameQuery, namespaceQuery);
        return new QueryRecordIterator(it, nameAndNamespaceQuery);
    }

    protected static RecordIterator getNameNamespaceAddressFilterIterator(String name, long namespaceId, long addressKey, RecordIterator it) {
        FieldMatchQuery nameQuery = new FieldMatchQuery(0, (Field)new StringField(name));
        FieldMatchQuery namespaceQuery = new FieldMatchQuery(2, (Field)new LongField(namespaceId));
        FieldMatchQuery addressQuery = new FieldMatchQuery(1, (Field)new LongField(addressKey));
        AndQuery nameAndNamespaceQuery = new AndQuery(nameQuery, namespaceQuery);
        AndQuery fullQuery = new AndQuery(nameAndNamespaceQuery, addressQuery);
        return new QueryRecordIterator(it, fullQuery);
    }

    protected static RecordIterator getPrimaryFilterRecordIterator(RecordIterator it) {
        Query query = record -> !record.getFieldValue(6).isNull();
        return new QueryRecordIterator(it, query);
    }
}

