/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Iterator;

public class AddressRangeImpl
implements AddressRange,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Address minAddress;
    private final Address maxAddress;

    public AddressRangeImpl(AddressRange range) {
        this.minAddress = range.getMinAddress();
        this.maxAddress = range.getMaxAddress();
    }

    public AddressRangeImpl(Address start, Address end) {
        if (start.compareTo(end) < 0) {
            this.minAddress = start;
            this.maxAddress = end;
        } else {
            this.minAddress = end;
            this.maxAddress = start;
        }
        AddressRange.checkValidRange(this.minAddress, this.maxAddress);
    }

    public AddressRangeImpl(Address start, long length) throws AddressOverflowException {
        this.minAddress = start;
        this.maxAddress = start.addNoWrap(length - 1L);
    }

    @Override
    public boolean contains(Address addr) {
        return this.minAddress.compareTo(addr) <= 0 && this.maxAddress.compareTo(addr) >= 0;
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.minAddress.getAddressSpace();
    }

    @Override
    public Address getMinAddress() {
        return this.minAddress;
    }

    @Override
    public Address getMaxAddress() {
        return this.maxAddress;
    }

    @Override
    public long getLength() {
        return this.maxAddress.subtract(this.minAddress) + 1L;
    }

    @Override
    public BigInteger getBigLength() {
        return this.maxAddress.getOffsetAsBigInteger().subtract(this.minAddress.getOffsetAsBigInteger()).add(BigInteger.ONE);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressRange range = (AddressRange)obj;
        return this.minAddress.equals(range.getMinAddress()) && this.maxAddress.equals(range.getMaxAddress());
    }

    public int hashCode() {
        return this.minAddress.hashCode();
    }

    @Override
    public int compareTo(Address addr) {
        if (this.maxAddress.compareTo(addr) < 0) {
            return -1;
        }
        if (this.minAddress.compareTo(addr) > 0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[" + String.valueOf(this.minAddress) + ", " + String.valueOf(this.maxAddress) + "]";
    }

    @Override
    public boolean intersects(AddressRange range) {
        return this.intersects(range.getMinAddress(), range.getMaxAddress());
    }

    @Override
    public boolean intersects(Address start, Address end) {
        return end.compareTo(this.minAddress) >= 0 && start.compareTo(this.maxAddress) <= 0;
    }

    @Override
    public AddressRange intersect(AddressRange range) {
        return this.intersectRange(range.getMinAddress(), range.getMaxAddress());
    }

    @Override
    public AddressRange intersectRange(Address start, Address end) {
        Address max;
        if (start.compareTo(end) > 0) {
            Address tmp = start;
            start = end;
            end = tmp;
        }
        Address min = this.minAddress.compareTo(start) >= 0 ? this.minAddress : start;
        Address address = max = this.maxAddress.compareTo(end) <= 0 ? this.maxAddress : end;
        if (min.compareTo(max) <= 0) {
            return new AddressRangeImpl(min, max);
        }
        return null;
    }

    @Override
    public int compareTo(AddressRange o) {
        int result = this.minAddress.compareTo(o.getMinAddress());
        if (result == 0) {
            result = this.maxAddress.compareTo(o.getMaxAddress());
        }
        return result;
    }

    @Override
    public Iterator<Address> iterator() {
        return new MyAddressIterator();
    }

    private class MyAddressIterator
    implements Iterator<Address> {
        private Address curr;

        public MyAddressIterator() {
            this.curr = AddressRangeImpl.this.minAddress;
        }

        @Override
        public boolean hasNext() {
            return this.curr != null;
        }

        @Override
        public Address next() {
            Address next = this.curr;
            if (this.curr != null) {
                this.curr = this.curr.equals(AddressRangeImpl.this.maxAddress) ? null : this.curr.next();
            }
            return next;
        }
    }
}

