/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class Varnode {
    private static final long[] masks = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    private Address address;
    private int size;
    private int spaceID;
    private long offset;

    public Varnode(Address a, int sz) {
        this.address = a;
        AddressSpace space = this.address.getAddressSpace();
        this.spaceID = space.getSpaceID();
        this.size = sz;
        this.offset = this.address.getOffset();
    }

    public Varnode(Address a, int sz, int symbolKey) {
        this(a, sz);
    }

    public int getSize() {
        return this.size;
    }

    public int getSpace() {
        return this.spaceID;
    }

    public Address getAddress() {
        return this.address;
    }

    public Address getPCAddress() {
        if (this.isInput()) {
            return Address.NO_ADDRESS;
        }
        return this.getDef().getSeqnum().getTarget();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getWordOffset() {
        return this.address.getAddressableWordOffset();
    }

    public boolean isFree() {
        return true;
    }

    public boolean contains(Address addr) {
        if (this.spaceID != addr.getAddressSpace().getSpaceID()) {
            return false;
        }
        if (this.isConstant() || this.isHash()) {
            return this.offset == addr.getOffset();
        }
        long endOffset = this.offset;
        if (this.size > 0) {
            endOffset = this.offset + (long)this.size - 1L;
        }
        long addrOffset = addr.getOffset();
        if (this.offset > endOffset) {
            return this.offset <= addrOffset;
        }
        return this.offset <= addrOffset && endOffset >= addrOffset;
    }

    public boolean intersects(Varnode varnode) {
        if (this.spaceID != varnode.spaceID) {
            return false;
        }
        if (this.isConstant() || this.isHash()) {
            return this.offset == varnode.getOffset();
        }
        long endOtherOffset = varnode.offset;
        if (varnode.size > 0) {
            endOtherOffset = varnode.offset + (long)varnode.size - 1L;
        }
        return this.rangeIntersects(varnode.offset, endOtherOffset);
    }

    public boolean isContiguous(Varnode lo, boolean bigEndian) {
        long nextoff;
        AddressSpace spc = this.address.getAddressSpace();
        if (spc != lo.address.getAddressSpace()) {
            return false;
        }
        return bigEndian ? (nextoff = spc.truncateOffset(this.offset + (long)this.size)) == lo.offset : (nextoff = spc.truncateOffset(lo.offset + (long)lo.size)) == this.offset;
    }

    private boolean rangeIntersects(long otherOffset, long otherEndOffset) {
        long endOffset = this.offset;
        if (this.size > 0) {
            endOffset = this.offset + (long)this.size - 1L;
        }
        if (this.offset > endOffset) {
            if (otherOffset > otherEndOffset) {
                return true;
            }
            return this.offset <= otherEndOffset;
        }
        if (otherOffset > otherEndOffset) {
            return endOffset >= otherOffset;
        }
        return this.offset <= otherEndOffset && endOffset >= otherOffset;
    }

    public boolean intersects(AddressSetView set) {
        if (this.isConstant() || this.isUnique() || this.isHash() || set == null || set.isEmpty()) {
            return false;
        }
        for (AddressRange range : set.getAddressRanges()) {
            Address minAddr = range.getMinAddress();
            if (minAddr.getAddressSpace().getSpaceID() != this.spaceID) continue;
            Address maxAddr = range.getMaxAddress();
            if (!this.rangeIntersects(minAddr.getOffset(), maxAddr.getOffset())) continue;
            return true;
        }
        return false;
    }

    public boolean isAddress() {
        int type = 0xF & this.spaceID;
        return type == 1;
    }

    public boolean isRegister() {
        int type = 0xF & this.spaceID;
        return type == 4;
    }

    public boolean isConstant() {
        int type = 0xF & this.spaceID;
        return type == 0;
    }

    public boolean isUnique() {
        int type = 0xF & this.spaceID;
        return type == 3;
    }

    public boolean isHash() {
        return this.spaceID == AddressSpace.HASH_SPACE.getSpaceID();
    }

    public boolean isInput() {
        return false;
    }

    public boolean isPersistent() {
        return false;
    }

    public boolean isAddrTied() {
        return false;
    }

    public boolean isUnaffected() {
        return false;
    }

    public PcodeOp getDef() {
        return null;
    }

    public Iterator<PcodeOp> getDescendants() {
        return null;
    }

    public PcodeOp getLoneDescend() {
        return null;
    }

    public boolean hasNoDescend() {
        return true;
    }

    public HighVariable getHigh() {
        return null;
    }

    public short getMergeGroup() {
        return 0;
    }

    public void encodeRaw(Encoder encoder) throws IOException {
        AddressXML.encode(encoder, this.address, this.size);
    }

    public String encodePiece() {
        StringBuilder buffer = new StringBuilder();
        Address addr = this.address;
        AddressSpace space = addr.getAddressSpace();
        buffer.append(space.getName());
        buffer.append(":0x");
        long off = addr.getUnsignedOffset();
        buffer.append(Long.toHexString(off));
        buffer.append(':');
        buffer.append(Integer.toString(this.size));
        return buffer.toString();
    }

    public static Varnode decode(Decoder decoder, PcodeFactory factory) throws DecoderException {
        int attribId;
        int attribId2;
        int el = decoder.peekElement();
        if (el == ElementId.ELEM_VOID.id()) {
            decoder.openElement();
            decoder.closeElement(el);
            return null;
        }
        if (el == ElementId.ELEM_SPACEID.id() || el == ElementId.ELEM_IOP.id()) {
            Address addr = AddressXML.decode(decoder);
            return factory.newVarnode(4, addr);
        }
        el = decoder.openElement();
        int ref = -1;
        int sz = 4;
        while ((attribId2 = decoder.getNextAttributeId()) != 0) {
            if (attribId2 == AttributeId.ATTRIB_REF.id()) {
                ref = (int)decoder.readUnsignedInteger();
                Varnode vn = factory.getRef(ref);
                if (vn == null) continue;
                decoder.closeElement(el);
                return vn;
            }
            if (attribId2 != AttributeId.ATTRIB_SIZE.id()) continue;
            sz = (int)decoder.readSignedInteger();
        }
        decoder.rewindAttributes();
        Address addr = AddressXML.decodeFromAttributes(decoder);
        AddressSpace spc = addr.getAddressSpace();
        if (spc != null && spc.getType() == 11) {
            decoder.rewindAttributes();
            try {
                Join join = Varnode.decodePieces(decoder);
                VariableStorage storage = factory.getJoinStorage(join.pieces);
                addr = factory.getJoinAddress(storage);
                sz = join.logicalSize;
            }
            catch (InvalidInputException e) {
                throw new DecoderException("Invalid varnode pieces: " + e.getMessage());
            }
        }
        Varnode vn = ref != -1 ? factory.newVarnode(sz, addr, ref) : factory.newVarnode(sz, addr);
        decoder.rewindAttributes();
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_GRP.id()) {
                short val = (short)decoder.readSignedInteger();
                factory.setMergeGroup(vn, val);
                continue;
            }
            if (attribId == AttributeId.ATTRIB_PERSISTS.id()) {
                if (!decoder.readBool()) continue;
                factory.setPersistent(vn, true);
                continue;
            }
            if (attribId == AttributeId.ATTRIB_ADDRTIED.id()) {
                if (!decoder.readBool()) continue;
                factory.setAddrTied(vn, true);
                continue;
            }
            if (attribId == AttributeId.ATTRIB_UNAFF.id()) {
                if (!decoder.readBool()) continue;
                factory.setUnaffected(vn, true);
                continue;
            }
            if (attribId == AttributeId.ATTRIB_INPUT.id()) {
                if (!decoder.readBool()) continue;
                vn = factory.setInput(vn, true);
                continue;
            }
            if (attribId != AttributeId.ATTRIB_VOLATILE.id() || !decoder.readBool()) continue;
            factory.setVolatile(vn, true);
        }
        decoder.closeElement(el);
        return vn;
    }

    private static Varnode decodePiece(String pieceStr, AddressFactory addrFactory) throws DecoderException {
        int size;
        long offset;
        String[] varnodeTokens = pieceStr.split(":");
        if (varnodeTokens.length != 3) {
            throw new DecoderException("Invalid \"join\" address piece: " + pieceStr);
        }
        AddressSpace space = addrFactory.getAddressSpace(varnodeTokens[0]);
        if (space == null) {
            throw new DecoderException("Invalid space for \"join\" address piece: " + pieceStr);
        }
        if (!varnodeTokens[1].startsWith("0x")) {
            throw new DecoderException("Invalid offset for \"join\" address piece: " + pieceStr);
        }
        try {
            offset = Long.parseUnsignedLong(varnodeTokens[1].substring(2), 16);
        }
        catch (NumberFormatException e) {
            throw new DecoderException("Invalid offset for \"join\" address piece: " + pieceStr);
        }
        try {
            size = Integer.parseInt(varnodeTokens[2]);
        }
        catch (NumberFormatException e) {
            throw new DecoderException("Invalid size for \"join\" address piece: " + pieceStr);
        }
        return new Varnode(space.getAddress(offset), size);
    }

    public static Join decodePieces(Decoder decoder) throws DecoderException {
        int attribId;
        ArrayList<Varnode> list = new ArrayList<Varnode>();
        int sizeAccum = 0;
        int logicalSize = 0;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            int index;
            if (attribId == AttributeId.ATTRIB_LOGICALSIZE.id()) {
                logicalSize = (int)decoder.readUnsignedInteger();
            } else if (attribId == AttributeId.ATTRIB_UNKNOWN.id()) {
                attribId = decoder.getIndexedAttributeId(AttributeId.ATTRIB_PIECE);
            }
            if (attribId < AttributeId.ATTRIB_PIECE.id() || (index = attribId - AttributeId.ATTRIB_PIECE.id()) > AddressXML.MAX_PIECES) continue;
            if (index != list.size()) {
                throw new DecoderException("\"piece\" attributes must be in order");
            }
            Varnode vn = Varnode.decodePiece(decoder.readString(), decoder.getAddressFactory());
            list.add(vn);
            sizeAccum += vn.getSize();
        }
        Join join = new Join();
        join.pieces = new Varnode[list.size()];
        join.logicalSize = logicalSize != 0 ? logicalSize : sizeAccum;
        list.toArray(join.pieces);
        return join;
    }

    public void trim() {
        if (this.address.getAddressSpace().getType() == 0) {
            this.offset &= masks[this.size];
            this.address = this.address.getNewAddress(this.offset);
        }
    }

    public String toString() {
        return "(" + this.address.getAddressSpace().getName() + ", 0x" + Long.toHexString(this.offset) + ", " + this.size + ")";
    }

    public String toString(Language language) {
        Register reg;
        if ((this.isAddress() || this.isRegister()) && (reg = language.getRegister(this.address, this.size)) != null) {
            return reg.getName();
        }
        if (this.isUnique()) {
            return "u_" + Long.toHexString(this.offset) + ":" + this.size;
        }
        if (this.isConstant()) {
            return "0x" + Long.toHexString(this.offset);
        }
        return "A_" + String.valueOf(this.address) + ":" + this.size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Varnode)) {
            return false;
        }
        Varnode vn = (Varnode)o;
        if (!vn.isFree()) {
            return false;
        }
        return this.offset == vn.getOffset() && this.size == vn.getSize() && this.spaceID == vn.getSpace();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + this.size;
        result = 31 * result + this.spaceID;
        return result;
    }

    public static class Join {
        public Varnode[] pieces;
        public int logicalSize;
    }
}

