/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.charset;

import generic.json.Json;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class CharsetInfo {
    static final Set<String> FIELDS_TO_EXCLUDE_FROM_JSON = Set.of("standardCharset");
    static final int UNICODESCRIPT_COUNT = Character.UnicodeScript.UNKNOWN.ordinal() + 1;
    static final EnumSet<Character.UnicodeScript> ALL_SCRIPTS = EnumSet.allOf(Character.UnicodeScript.class);
    static final EnumSet<Character.UnicodeScript> NO_SCRIPTS = EnumSet.noneOf(Character.UnicodeScript.class);
    private final String name;
    private final String comment;
    private final int minBytesPerChar;
    private final int maxBytesPerChar;
    private final int alignment;
    private final int codePointCount;
    private final EnumSet<Character.UnicodeScript> scripts;
    private final Set<String> contains;
    private final boolean canProduceError;
    private final boolean standardCharset;

    public CharsetInfo(Charset cs) {
        this(cs.name(), null, 1, -1, 1, -1, false, true, NO_SCRIPTS, Set.of());
    }

    public CharsetInfo(String name, String comment, int minBytesPerChar, int maxBytesPerChar, int alignment, int codePointCount, boolean standardCharset, boolean canProduceError, EnumSet<Character.UnicodeScript> scripts, Set<String> contains) {
        this.name = name;
        this.comment = comment;
        this.minBytesPerChar = minBytesPerChar;
        this.maxBytesPerChar = maxBytesPerChar;
        this.alignment = alignment;
        this.codePointCount = codePointCount;
        this.standardCharset = standardCharset;
        this.canProduceError = canProduceError;
        this.scripts = scripts;
        this.contains = contains;
    }

    public CharsetInfo withComment(String newComment) {
        return new CharsetInfo(this.name, newComment, this.minBytesPerChar, this.maxBytesPerChar, this.alignment, this.codePointCount, this.standardCharset, this.canProduceError, this.scripts, this.contains);
    }

    public Charset getCharset() {
        return Charset.forName(this.name, null);
    }

    public String getName() {
        return this.name;
    }

    public boolean isStandardCharset() {
        return this.standardCharset;
    }

    public boolean isCanProduceError() {
        return this.canProduceError;
    }

    public boolean supportsAllScripts() {
        return this.scripts.size() >= UNICODESCRIPT_COUNT - 1;
    }

    public Set<Character.UnicodeScript> getScripts() {
        return this.scripts;
    }

    public boolean hasFixedLengthChars() {
        return this.minBytesPerChar > 0 && this.minBytesPerChar == this.maxBytesPerChar;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMinBytesPerChar() {
        return this.minBytesPerChar;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public int getCodePointCount() {
        return this.codePointCount;
    }

    public Set<String> getContains() {
        return this.contains;
    }

    public String getComment() {
        return this.comment;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharsetInfo)) {
            return false;
        }
        CharsetInfo other = (CharsetInfo)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return Json.toString((Object)this);
    }
}

