/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.XmlProperties;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class SaveState
extends XmlProperties {
    private static final String XML_TYPE = "SaveState";
    static final String SAVE_STATE_TAG_NAME = "SAVE_STATE";
    static final String DEFAULT_NAME = "UNNAMED";

    public SaveState(String name) {
        super(name);
    }

    public SaveState() {
        this(SAVE_STATE_TAG_NAME);
    }

    public SaveState(File file) throws IOException {
        super(file);
    }

    public SaveState(Element element) {
        super(element);
    }

    public void saveToFile(File file) throws IOException {
        this.saveToXmlFile(file);
    }

    public void putSaveState(String name, SaveState value) {
        this.map.put(name, value);
    }

    public SaveState getSaveState(String name) {
        return this.getAsType(name, null, SaveState.class);
    }

    @Override
    protected void processElement(Element element) {
        String tag = element.getName();
        if (!tag.equals(SAVE_STATE_TAG_NAME)) {
            super.processElement(element);
            return;
        }
        if (this.isOldStyleSaveState(element)) {
            this.restoreSaveStateWithoutKeyAttribute(element);
            return;
        }
        String key = element.getAttributeValue("KEY");
        String name = element.getAttributeValue("NAME");
        SaveState saveState = this.createSaveState(name);
        List children = element.getChildren();
        for (Element e : children) {
            saveState.processElement(e);
        }
        this.map.put(key, saveState);
    }

    private void restoreSaveStateWithoutKeyAttribute(Element element) {
        String key = element.getAttributeValue("NAME");
        SaveState saveState = this.createSaveState(null);
        List children = element.getChildren();
        if (children.isEmpty()) {
            this.map.put(key, saveState);
            return;
        }
        Element child = (Element)element.getChildren().get(0);
        if (child == null) {
            return;
        }
        String childTag = child.getName();
        if (!childTag.equals("STATE")) {
            children = child.getChildren();
        }
        for (Element e : children) {
            saveState.processElement(e);
        }
        this.map.put(key, saveState);
    }

    private boolean isOldStyleSaveState(Element element) {
        return element.getAttribute("KEY") == null;
    }

    @Override
    protected Element createElement(String key, Object value) {
        if (!(value instanceof SaveState)) {
            return super.createElement(key, value);
        }
        SaveState saveState = (SaveState)value;
        Element savedElement = saveState.saveToXml();
        Element element = new Element(SAVE_STATE_TAG_NAME);
        String name = saveState.getName();
        if (SAVE_STATE_TAG_NAME.equals(name)) {
            name = DEFAULT_NAME;
        }
        element.setAttribute("NAME", name);
        element.setAttribute("KEY", key);
        element.setAttribute("TYPE", XML_TYPE);
        List children = savedElement.getChildren();
        for (Element e : children) {
            Element newElement = (Element)e.clone();
            element.addContent((Content)newElement);
        }
        return element;
    }

    protected SaveState createSaveState(String name) {
        if (name == null) {
            return new SaveState();
        }
        return new SaveState(name);
    }
}

