/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.gen.util.Types.BNonVoid;

/**
 * A field request for a pre-fetched or pre-constructed element
 * 
 * @param <T> the type of the field
 */
public interface FieldReq<T extends BNonVoid> {
	/**
	 * Derive a suitable name for the field
	 * 
	 * @return the name
	 */
	String name();

}
