/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.pcode.emu.jit.gen.opnd;

import ghidra.pcode.emu.jit.analysis.JitType.SimpleJitType;
import ghidra.pcode.emu.jit.gen.util.Local;
import ghidra.pcode.emu.jit.gen.util.Types.BPrim;

/**
 * A mutable operand that can be contained in a single JVM local
 * 
 * @param <T> the JVM type
 * @param <JT> the p-code type
 */
interface LocalOpnd<T extends BPrim<?>, JT extends SimpleJitType<T, JT>>
		extends SimpleOpnd<T, JT> {

	/**
	 * {@return the local handle}
	 */
	Local<T> local();

	@Override
	default String name() {
		return local().name();
	}
}
