from __future__ import annotations
import collections.abc
import datetime
import typing
from warnings import deprecated # type: ignore

import jpype # type: ignore
import jpype.protocol # type: ignore

import com.google.protobuf # type: ignore
import java.io # type: ignore
import java.lang # type: ignore
import java.nio # type: ignore
import java.util # type: ignore


class TraceRmi(java.lang.Object):

    class MemoryState(java.lang.Enum[TraceRmi.MemoryState], com.google.protobuf.ProtocolMessageEnum):
        """
        Protobuf enum ``ghidra.rmi.trace.MemoryState``
        """

        class_: typing.ClassVar[java.lang.Class]
        MS_UNKNOWN: typing.Final[TraceRmi.MemoryState]
        """
        ``MS_UNKNOWN = 0;``
        """

        MS_KNOWN: typing.Final[TraceRmi.MemoryState]
        """
        ``MS_KNOWN = 1;``
        """

        MS_ERROR: typing.Final[TraceRmi.MemoryState]
        """
        ``MS_ERROR = 2;``
        """

        UNRECOGNIZED: typing.Final[TraceRmi.MemoryState]
        MS_UNKNOWN_VALUE: typing.Final = 0
        """
        ``MS_UNKNOWN = 0;``
        """

        MS_KNOWN_VALUE: typing.Final = 1
        """
        ``MS_KNOWN = 1;``
        """

        MS_ERROR_VALUE: typing.Final = 2
        """
        ``MS_ERROR = 2;``
        """


        @staticmethod
        def forNumber(value: typing.Union[jpype.JInt, int]) -> TraceRmi.MemoryState:
            """
            
            
            :param jpype.JInt or int value: The numeric wire value of the corresponding enum entry.
            :return: The enum associated with the given numeric wire value.
            :rtype: TraceRmi.MemoryState
            """

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.EnumDescriptor:
            ...

        def getDescriptorForType(self) -> com.google.protobuf.Descriptors.EnumDescriptor:
            ...

        def getNumber(self) -> int:
            ...

        def getValueDescriptor(self) -> com.google.protobuf.Descriptors.EnumValueDescriptor:
            ...

        @staticmethod
        def internalGetValueMap() -> com.google.protobuf.Internal.EnumLiteMap[TraceRmi.MemoryState]:
            ...

        @staticmethod
        @typing.overload
        def valueOf(name: typing.Union[java.lang.String, str]) -> TraceRmi.MemoryState:
            ...

        @staticmethod
        @typing.overload
        @deprecated("Use forNumber(int) instead.")
        def valueOf(value: typing.Union[jpype.JInt, int]) -> TraceRmi.MemoryState:
            """
            
            
            :param jpype.JInt or int value: The numeric wire value of the corresponding enum entry.
            :return: The enum associated with the given numeric wire value.
            :rtype: TraceRmi.MemoryState
            
            .. deprecated::
            
            Use :meth:`forNumber(int) <.forNumber>` instead.
            """

        @staticmethod
        @typing.overload
        def valueOf(desc: com.google.protobuf.Descriptors.EnumValueDescriptor) -> TraceRmi.MemoryState:
            ...

        @staticmethod
        def values() -> jpype.JArray[TraceRmi.MemoryState]:
            ...

        @property
        def number(self) -> jpype.JInt:
            ...

        @property
        def descriptorForType(self) -> com.google.protobuf.Descriptors.EnumDescriptor:
            ...

        @property
        def valueDescriptor(self) -> com.google.protobuf.Descriptors.EnumValueDescriptor:
            ...


    class Resolution(java.lang.Enum[TraceRmi.Resolution], com.google.protobuf.ProtocolMessageEnum):
        """
        Protobuf enum ``ghidra.rmi.trace.Resolution``
        """

        class_: typing.ClassVar[java.lang.Class]
        CR_TRUNCATE: typing.Final[TraceRmi.Resolution]
        """
        ``CR_TRUNCATE = 0;``
        """

        CR_DENY: typing.Final[TraceRmi.Resolution]
        """
        ``CR_DENY = 1;``
        """

        CR_ADJUST: typing.Final[TraceRmi.Resolution]
        """
        ``CR_ADJUST = 2;``
        """

        UNRECOGNIZED: typing.Final[TraceRmi.Resolution]
        CR_TRUNCATE_VALUE: typing.Final = 0
        """
        ``CR_TRUNCATE = 0;``
        """

        CR_DENY_VALUE: typing.Final = 1
        """
        ``CR_DENY = 1;``
        """

        CR_ADJUST_VALUE: typing.Final = 2
        """
        ``CR_ADJUST = 2;``
        """


        @staticmethod
        def forNumber(value: typing.Union[jpype.JInt, int]) -> TraceRmi.Resolution:
            """
            
            
            :param jpype.JInt or int value: The numeric wire value of the corresponding enum entry.
            :return: The enum associated with the given numeric wire value.
            :rtype: TraceRmi.Resolution
            """

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.EnumDescriptor:
            ...

        def getDescriptorForType(self) -> com.google.protobuf.Descriptors.EnumDescriptor:
            ...

        def getNumber(self) -> int:
            ...

        def getValueDescriptor(self) -> com.google.protobuf.Descriptors.EnumValueDescriptor:
            ...

        @staticmethod
        def internalGetValueMap() -> com.google.protobuf.Internal.EnumLiteMap[TraceRmi.Resolution]:
            ...

        @staticmethod
        @typing.overload
        def valueOf(name: typing.Union[java.lang.String, str]) -> TraceRmi.Resolution:
            ...

        @staticmethod
        @typing.overload
        @deprecated("Use forNumber(int) instead.")
        def valueOf(value: typing.Union[jpype.JInt, int]) -> TraceRmi.Resolution:
            """
            
            
            :param jpype.JInt or int value: The numeric wire value of the corresponding enum entry.
            :return: The enum associated with the given numeric wire value.
            :rtype: TraceRmi.Resolution
            
            .. deprecated::
            
            Use :meth:`forNumber(int) <.forNumber>` instead.
            """

        @staticmethod
        @typing.overload
        def valueOf(desc: com.google.protobuf.Descriptors.EnumValueDescriptor) -> TraceRmi.Resolution:
            ...

        @staticmethod
        def values() -> jpype.JArray[TraceRmi.Resolution]:
            ...

        @property
        def number(self) -> jpype.JInt:
            ...

        @property
        def descriptorForType(self) -> com.google.protobuf.Descriptors.EnumDescriptor:
            ...

        @property
        def valueDescriptor(self) -> com.google.protobuf.Descriptors.EnumValueDescriptor:
            ...


    class ValueKinds(java.lang.Enum[TraceRmi.ValueKinds], com.google.protobuf.ProtocolMessageEnum):
        """
        Protobuf enum ``ghidra.rmi.trace.ValueKinds``
        """

        class_: typing.ClassVar[java.lang.Class]
        VK_ELEMENTS: typing.Final[TraceRmi.ValueKinds]
        """
        ``VK_ELEMENTS = 0;``
        """

        VK_ATTRIBUTES: typing.Final[TraceRmi.ValueKinds]
        """
        ``VK_ATTRIBUTES = 1;``
        """

        VK_BOTH: typing.Final[TraceRmi.ValueKinds]
        """
        ``VK_BOTH = 2;``
        """

        UNRECOGNIZED: typing.Final[TraceRmi.ValueKinds]
        VK_ELEMENTS_VALUE: typing.Final = 0
        """
        ``VK_ELEMENTS = 0;``
        """

        VK_ATTRIBUTES_VALUE: typing.Final = 1
        """
        ``VK_ATTRIBUTES = 1;``
        """

        VK_BOTH_VALUE: typing.Final = 2
        """
        ``VK_BOTH = 2;``
        """


        @staticmethod
        def forNumber(value: typing.Union[jpype.JInt, int]) -> TraceRmi.ValueKinds:
            """
            
            
            :param jpype.JInt or int value: The numeric wire value of the corresponding enum entry.
            :return: The enum associated with the given numeric wire value.
            :rtype: TraceRmi.ValueKinds
            """

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.EnumDescriptor:
            ...

        def getDescriptorForType(self) -> com.google.protobuf.Descriptors.EnumDescriptor:
            ...

        def getNumber(self) -> int:
            ...

        def getValueDescriptor(self) -> com.google.protobuf.Descriptors.EnumValueDescriptor:
            ...

        @staticmethod
        def internalGetValueMap() -> com.google.protobuf.Internal.EnumLiteMap[TraceRmi.ValueKinds]:
            ...

        @staticmethod
        @typing.overload
        def valueOf(name: typing.Union[java.lang.String, str]) -> TraceRmi.ValueKinds:
            ...

        @staticmethod
        @typing.overload
        @deprecated("Use forNumber(int) instead.")
        def valueOf(value: typing.Union[jpype.JInt, int]) -> TraceRmi.ValueKinds:
            """
            
            
            :param jpype.JInt or int value: The numeric wire value of the corresponding enum entry.
            :return: The enum associated with the given numeric wire value.
            :rtype: TraceRmi.ValueKinds
            
            .. deprecated::
            
            Use :meth:`forNumber(int) <.forNumber>` instead.
            """

        @staticmethod
        @typing.overload
        def valueOf(desc: com.google.protobuf.Descriptors.EnumValueDescriptor) -> TraceRmi.ValueKinds:
            ...

        @staticmethod
        def values() -> jpype.JArray[TraceRmi.ValueKinds]:
            ...

        @property
        def number(self) -> jpype.JInt:
            ...

        @property
        def descriptorForType(self) -> com.google.protobuf.Descriptors.EnumDescriptor:
            ...

        @property
        def valueDescriptor(self) -> com.google.protobuf.Descriptors.EnumValueDescriptor:
            ...


    class FilePathOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getPath(self) -> str:
            """
            ``string path = 1;``
            
            :return: The path.
            :rtype: str
            """

        def getPathBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string path = 1;``
            
            :return: The bytes for path.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def path(self) -> java.lang.String:
            ...

        @property
        def pathBytes(self) -> com.google.protobuf.ByteString:
            ...


    class FilePath(com.google.protobuf.GeneratedMessage, TraceRmi.FilePathOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.FilePath``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.FilePath.Builder], TraceRmi.FilePathOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.FilePath``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearPath(self) -> TraceRmi.FilePath.Builder:
                """
                ``string path = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.FilePath.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getPath(self) -> str:
                """
                ``string path = 1;``
                
                :return: The path.
                :rtype: str
                """

            def getPathBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string path = 1;``
                
                :return: The bytes for path.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.FilePath) -> TraceRmi.FilePath.Builder:
                ...

            def setPath(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.FilePath.Builder:
                """
                ``string path = 1;``
                
                :param java.lang.String or str value: The path to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.FilePath.Builder
                """

            def setPathBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.FilePath.Builder:
                """
                ``string path = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for path to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.FilePath.Builder
                """

            @property
            def path(self) -> java.lang.String:
                ...

            @property
            def pathBytes(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        PATH_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.FilePath:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getPath(self) -> str:
            """
            ``string path = 1;``
            
            :return: The path.
            :rtype: str
            """

        def getPathBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string path = 1;``
            
            :return: The bytes for path.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.FilePath.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.FilePath) -> TraceRmi.FilePath.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.FilePath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.FilePath:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.FilePath]:
            ...

        @property
        def path(self) -> java.lang.String:
            ...

        @property
        def pathBytes(self) -> com.google.protobuf.ByteString:
            ...


    class DomObjIdOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getId(self) -> int:
            """
            ``uint32 id = 1;``
            
            :return: The id.
            :rtype: int
            """

        @property
        def id(self) -> jpype.JInt:
            ...


    class DomObjId(com.google.protobuf.GeneratedMessage, TraceRmi.DomObjIdOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.DomObjId``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.DomObjId.Builder], TraceRmi.DomObjIdOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.DomObjId``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearId(self) -> TraceRmi.DomObjId.Builder:
                """
                ``uint32 id = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.DomObjId.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getId(self) -> int:
                """
                ``uint32 id = 1;``
                
                :return: The id.
                :rtype: int
                """

            def mergeFrom(self, other: TraceRmi.DomObjId) -> TraceRmi.DomObjId.Builder:
                ...

            def setId(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.DomObjId.Builder:
                """
                ``uint32 id = 1;``
                
                :param jpype.JInt or int value: The id to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.DomObjId.Builder
                """

            @property
            def id(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ID_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.DomObjId:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getId(self) -> int:
            """
            ``uint32 id = 1;``
            
            :return: The id.
            :rtype: int
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.DomObjId.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.DomObjId) -> TraceRmi.DomObjId.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.DomObjId:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.DomObjId]:
            ...

        @property
        def id(self) -> jpype.JInt:
            ...


    class TxIdOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getId(self) -> int:
            """
            ``int32 id = 1;``
            
            :return: The id.
            :rtype: int
            """

        @property
        def id(self) -> jpype.JInt:
            ...


    class TxId(com.google.protobuf.GeneratedMessage, TraceRmi.TxIdOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.TxId``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.TxId.Builder], TraceRmi.TxIdOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.TxId``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearId(self) -> TraceRmi.TxId.Builder:
                """
                ``int32 id = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.TxId.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getId(self) -> int:
                """
                ``int32 id = 1;``
                
                :return: The id.
                :rtype: int
                """

            def mergeFrom(self, other: TraceRmi.TxId) -> TraceRmi.TxId.Builder:
                ...

            def setId(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.TxId.Builder:
                """
                ``int32 id = 1;``
                
                :param jpype.JInt or int value: The id to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.TxId.Builder
                """

            @property
            def id(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ID_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.TxId:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getId(self) -> int:
            """
            ``int32 id = 1;``
            
            :return: The id.
            :rtype: int
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.TxId.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.TxId) -> TraceRmi.TxId.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.TxId:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.TxId:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.TxId]:
            ...

        @property
        def id(self) -> jpype.JInt:
            ...


    class ObjPathOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getPath(self) -> str:
            """
            ``string path = 1;``
            
            :return: The path.
            :rtype: str
            """

        def getPathBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string path = 1;``
            
            :return: The bytes for path.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def path(self) -> java.lang.String:
            ...

        @property
        def pathBytes(self) -> com.google.protobuf.ByteString:
            ...


    class ObjPath(com.google.protobuf.GeneratedMessage, TraceRmi.ObjPathOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ObjPath``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ObjPath.Builder], TraceRmi.ObjPathOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ObjPath``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearPath(self) -> TraceRmi.ObjPath.Builder:
                """
                ``string path = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ObjPath.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getPath(self) -> str:
                """
                ``string path = 1;``
                
                :return: The path.
                :rtype: str
                """

            def getPathBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string path = 1;``
                
                :return: The bytes for path.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.ObjPath) -> TraceRmi.ObjPath.Builder:
                ...

            def setPath(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.ObjPath.Builder:
                """
                ``string path = 1;``
                
                :param java.lang.String or str value: The path to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ObjPath.Builder
                """

            def setPathBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.ObjPath.Builder:
                """
                ``string path = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for path to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ObjPath.Builder
                """

            @property
            def path(self) -> java.lang.String:
                ...

            @property
            def pathBytes(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        PATH_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ObjPath:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getPath(self) -> str:
            """
            ``string path = 1;``
            
            :return: The path.
            :rtype: str
            """

        def getPathBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string path = 1;``
            
            :return: The bytes for path.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ObjPath.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ObjPath) -> TraceRmi.ObjPath.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjPath:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ObjPath]:
            ...

        @property
        def path(self) -> java.lang.String:
            ...

        @property
        def pathBytes(self) -> com.google.protobuf.ByteString:
            ...


    class LanguageOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getId(self) -> str:
            """
            ``string id = 1;``
            
            :return: The id.
            :rtype: str
            """

        def getIdBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string id = 1;``
            
            :return: The bytes for id.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def id(self) -> java.lang.String:
            ...

        @property
        def idBytes(self) -> com.google.protobuf.ByteString:
            ...


    class Language(com.google.protobuf.GeneratedMessage, TraceRmi.LanguageOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Language``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Language.Builder], TraceRmi.LanguageOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Language``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearId(self) -> TraceRmi.Language.Builder:
                """
                ``string id = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Language.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getId(self) -> str:
                """
                ``string id = 1;``
                
                :return: The id.
                :rtype: str
                """

            def getIdBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string id = 1;``
                
                :return: The bytes for id.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.Language) -> TraceRmi.Language.Builder:
                ...

            def setId(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Language.Builder:
                """
                ``string id = 1;``
                
                :param java.lang.String or str value: The id to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Language.Builder
                """

            def setIdBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Language.Builder:
                """
                ``string id = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for id to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Language.Builder
                """

            @property
            def id(self) -> java.lang.String:
                ...

            @property
            def idBytes(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ID_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Language:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getId(self) -> str:
            """
            ``string id = 1;``
            
            :return: The id.
            :rtype: str
            """

        def getIdBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string id = 1;``
            
            :return: The bytes for id.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Language.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Language) -> TraceRmi.Language.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Language:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Language:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Language]:
            ...

        @property
        def id(self) -> java.lang.String:
            ...

        @property
        def idBytes(self) -> com.google.protobuf.ByteString:
            ...


    class CompilerOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getId(self) -> str:
            """
            ``string id = 1;``
            
            :return: The id.
            :rtype: str
            """

        def getIdBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string id = 1;``
            
            :return: The bytes for id.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def id(self) -> java.lang.String:
            ...

        @property
        def idBytes(self) -> com.google.protobuf.ByteString:
            ...


    class Compiler(com.google.protobuf.GeneratedMessage, TraceRmi.CompilerOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Compiler``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Compiler.Builder], TraceRmi.CompilerOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Compiler``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearId(self) -> TraceRmi.Compiler.Builder:
                """
                ``string id = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Compiler.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getId(self) -> str:
                """
                ``string id = 1;``
                
                :return: The id.
                :rtype: str
                """

            def getIdBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string id = 1;``
                
                :return: The bytes for id.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.Compiler) -> TraceRmi.Compiler.Builder:
                ...

            def setId(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Compiler.Builder:
                """
                ``string id = 1;``
                
                :param java.lang.String or str value: The id to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Compiler.Builder
                """

            def setIdBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Compiler.Builder:
                """
                ``string id = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for id to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Compiler.Builder
                """

            @property
            def id(self) -> java.lang.String:
                ...

            @property
            def idBytes(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ID_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Compiler:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getId(self) -> str:
            """
            ``string id = 1;``
            
            :return: The id.
            :rtype: str
            """

        def getIdBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string id = 1;``
            
            :return: The bytes for id.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Compiler.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Compiler) -> TraceRmi.Compiler.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Compiler:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Compiler:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Compiler]:
            ...

        @property
        def id(self) -> java.lang.String:
            ...

        @property
        def idBytes(self) -> com.google.protobuf.ByteString:
            ...


    class AddrOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOffset(self) -> int:
            """
            ``uint64 offset = 2;``
            
            :return: The offset.
            :rtype: int
            """

        def getSpace(self) -> str:
            """
            ``string space = 1;``
            
            :return: The space.
            :rtype: str
            """

        def getSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string space = 1;``
            
            :return: The bytes for space.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def offset(self) -> jpype.JLong:
            ...

        @property
        def spaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def space(self) -> java.lang.String:
            ...


    class Addr(com.google.protobuf.GeneratedMessage, TraceRmi.AddrOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Addr``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Addr.Builder], TraceRmi.AddrOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Addr``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOffset(self) -> TraceRmi.Addr.Builder:
                """
                ``uint64 offset = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Addr.Builder
                """

            def clearSpace(self) -> TraceRmi.Addr.Builder:
                """
                ``string space = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Addr.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOffset(self) -> int:
                """
                ``uint64 offset = 2;``
                
                :return: The offset.
                :rtype: int
                """

            def getSpace(self) -> str:
                """
                ``string space = 1;``
                
                :return: The space.
                :rtype: str
                """

            def getSpaceBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string space = 1;``
                
                :return: The bytes for space.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.Addr) -> TraceRmi.Addr.Builder:
                ...

            def setOffset(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.Addr.Builder:
                """
                ``uint64 offset = 2;``
                
                :param jpype.JLong or int value: The offset to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Addr.Builder
                """

            def setSpace(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Addr.Builder:
                """
                ``string space = 1;``
                
                :param java.lang.String or str value: The space to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Addr.Builder
                """

            def setSpaceBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Addr.Builder:
                """
                ``string space = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for space to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Addr.Builder
                """

            @property
            def offset(self) -> jpype.JLong:
                ...

            @property
            def spaceBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def space(self) -> java.lang.String:
                ...


        class_: typing.ClassVar[java.lang.Class]
        SPACE_FIELD_NUMBER: typing.Final = 1
        OFFSET_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Addr:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOffset(self) -> int:
            """
            ``uint64 offset = 2;``
            
            :return: The offset.
            :rtype: int
            """

        def getSpace(self) -> str:
            """
            ``string space = 1;``
            
            :return: The space.
            :rtype: str
            """

        def getSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string space = 1;``
            
            :return: The bytes for space.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Addr.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Addr) -> TraceRmi.Addr.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Addr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Addr:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Addr]:
            ...

        @property
        def offset(self) -> jpype.JLong:
            ...

        @property
        def spaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def space(self) -> java.lang.String:
            ...


    class AddrRangeOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getExtend(self) -> int:
            """
            ``uint64 extend = 3;``
            
            :return: The extend.
            :rtype: int
            """

        def getOffset(self) -> int:
            """
            ``uint64 offset = 2;``
            
            :return: The offset.
            :rtype: int
            """

        def getSpace(self) -> str:
            """
            ``string space = 1;``
            
            :return: The space.
            :rtype: str
            """

        def getSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string space = 1;``
            
            :return: The bytes for space.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def extend(self) -> jpype.JLong:
            ...

        @property
        def offset(self) -> jpype.JLong:
            ...

        @property
        def spaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def space(self) -> java.lang.String:
            ...


    class AddrRange(com.google.protobuf.GeneratedMessage, TraceRmi.AddrRangeOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.AddrRange``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.AddrRange.Builder], TraceRmi.AddrRangeOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.AddrRange``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearExtend(self) -> TraceRmi.AddrRange.Builder:
                """
                ``uint64 extend = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.AddrRange.Builder
                """

            def clearOffset(self) -> TraceRmi.AddrRange.Builder:
                """
                ``uint64 offset = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.AddrRange.Builder
                """

            def clearSpace(self) -> TraceRmi.AddrRange.Builder:
                """
                ``string space = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.AddrRange.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getExtend(self) -> int:
                """
                ``uint64 extend = 3;``
                
                :return: The extend.
                :rtype: int
                """

            def getOffset(self) -> int:
                """
                ``uint64 offset = 2;``
                
                :return: The offset.
                :rtype: int
                """

            def getSpace(self) -> str:
                """
                ``string space = 1;``
                
                :return: The space.
                :rtype: str
                """

            def getSpaceBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string space = 1;``
                
                :return: The bytes for space.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.AddrRange) -> TraceRmi.AddrRange.Builder:
                ...

            def setExtend(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.AddrRange.Builder:
                """
                ``uint64 extend = 3;``
                
                :param jpype.JLong or int value: The extend to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.AddrRange.Builder
                """

            def setOffset(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.AddrRange.Builder:
                """
                ``uint64 offset = 2;``
                
                :param jpype.JLong or int value: The offset to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.AddrRange.Builder
                """

            def setSpace(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.AddrRange.Builder:
                """
                ``string space = 1;``
                
                :param java.lang.String or str value: The space to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.AddrRange.Builder
                """

            def setSpaceBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.AddrRange.Builder:
                """
                ``string space = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for space to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.AddrRange.Builder
                """

            @property
            def extend(self) -> jpype.JLong:
                ...

            @property
            def offset(self) -> jpype.JLong:
                ...

            @property
            def spaceBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def space(self) -> java.lang.String:
                ...


        class_: typing.ClassVar[java.lang.Class]
        SPACE_FIELD_NUMBER: typing.Final = 1
        OFFSET_FIELD_NUMBER: typing.Final = 2
        EXTEND_FIELD_NUMBER: typing.Final = 3

        @staticmethod
        def getDefaultInstance() -> TraceRmi.AddrRange:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getExtend(self) -> int:
            """
            ``uint64 extend = 3;``
            
            :return: The extend.
            :rtype: int
            """

        def getOffset(self) -> int:
            """
            ``uint64 offset = 2;``
            
            :return: The offset.
            :rtype: int
            """

        def getSpace(self) -> str:
            """
            ``string space = 1;``
            
            :return: The space.
            :rtype: str
            """

        def getSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string space = 1;``
            
            :return: The bytes for space.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.AddrRange.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.AddrRange) -> TraceRmi.AddrRange.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.AddrRange:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.AddrRange]:
            ...

        @property
        def extend(self) -> jpype.JLong:
            ...

        @property
        def offset(self) -> jpype.JLong:
            ...

        @property
        def spaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def space(self) -> java.lang.String:
            ...


    class SnapOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getSnap(self) -> int:
            """
            ``int64 snap = 1;``
            
            :return: The snap.
            :rtype: int
            """

        @property
        def snap(self) -> jpype.JLong:
            ...


    class Snap(com.google.protobuf.GeneratedMessage, TraceRmi.SnapOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Snap``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Snap.Builder], TraceRmi.SnapOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Snap``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearSnap(self) -> TraceRmi.Snap.Builder:
                """
                ``int64 snap = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Snap.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getSnap(self) -> int:
                """
                ``int64 snap = 1;``
                
                :return: The snap.
                :rtype: int
                """

            def mergeFrom(self, other: TraceRmi.Snap) -> TraceRmi.Snap.Builder:
                ...

            def setSnap(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.Snap.Builder:
                """
                ``int64 snap = 1;``
                
                :param jpype.JLong or int value: The snap to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Snap.Builder
                """

            @property
            def snap(self) -> jpype.JLong:
                ...


        class_: typing.ClassVar[java.lang.Class]
        SNAP_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Snap:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getSnap(self) -> int:
            """
            ``int64 snap = 1;``
            
            :return: The snap.
            :rtype: int
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Snap.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Snap) -> TraceRmi.Snap.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Snap:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Snap:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Snap]:
            ...

        @property
        def snap(self) -> jpype.JLong:
            ...


    class ScheduleOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getSchedule(self) -> str:
            """
            ``string schedule = 1;``
            
            :return: The schedule.
            :rtype: str
            """

        def getScheduleBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string schedule = 1;``
            
            :return: The bytes for schedule.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def schedule(self) -> java.lang.String:
            ...

        @property
        def scheduleBytes(self) -> com.google.protobuf.ByteString:
            ...


    class Schedule(com.google.protobuf.GeneratedMessage, TraceRmi.ScheduleOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Schedule``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Schedule.Builder], TraceRmi.ScheduleOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Schedule``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearSchedule(self) -> TraceRmi.Schedule.Builder:
                """
                ``string schedule = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Schedule.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getSchedule(self) -> str:
                """
                ``string schedule = 1;``
                
                :return: The schedule.
                :rtype: str
                """

            def getScheduleBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string schedule = 1;``
                
                :return: The bytes for schedule.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.Schedule) -> TraceRmi.Schedule.Builder:
                ...

            def setSchedule(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Schedule.Builder:
                """
                ``string schedule = 1;``
                
                :param java.lang.String or str value: The schedule to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Schedule.Builder
                """

            def setScheduleBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Schedule.Builder:
                """
                ``string schedule = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for schedule to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Schedule.Builder
                """

            @property
            def schedule(self) -> java.lang.String:
                ...

            @property
            def scheduleBytes(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        SCHEDULE_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Schedule:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getSchedule(self) -> str:
            """
            ``string schedule = 1;``
            
            :return: The schedule.
            :rtype: str
            """

        def getScheduleBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string schedule = 1;``
            
            :return: The bytes for schedule.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Schedule.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Schedule) -> TraceRmi.Schedule.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Schedule:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Schedule:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Schedule]:
            ...

        @property
        def schedule(self) -> java.lang.String:
            ...

        @property
        def scheduleBytes(self) -> com.google.protobuf.ByteString:
            ...


    class SpanOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getMax(self) -> int:
            """
            ``int64 max = 2;``
            
            :return: The max.
            :rtype: int
            """

        def getMin(self) -> int:
            """
            ``int64 min = 1;``
            
            :return: The min.
            :rtype: int
            """

        @property
        def min(self) -> jpype.JLong:
            ...

        @property
        def max(self) -> jpype.JLong:
            ...


    class Span(com.google.protobuf.GeneratedMessage, TraceRmi.SpanOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Span``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Span.Builder], TraceRmi.SpanOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Span``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearMax(self) -> TraceRmi.Span.Builder:
                """
                ``int64 max = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Span.Builder
                """

            def clearMin(self) -> TraceRmi.Span.Builder:
                """
                ``int64 min = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Span.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getMax(self) -> int:
                """
                ``int64 max = 2;``
                
                :return: The max.
                :rtype: int
                """

            def getMin(self) -> int:
                """
                ``int64 min = 1;``
                
                :return: The min.
                :rtype: int
                """

            def mergeFrom(self, other: TraceRmi.Span) -> TraceRmi.Span.Builder:
                ...

            def setMax(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.Span.Builder:
                """
                ``int64 max = 2;``
                
                :param jpype.JLong or int value: The max to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Span.Builder
                """

            def setMin(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.Span.Builder:
                """
                ``int64 min = 1;``
                
                :param jpype.JLong or int value: The min to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Span.Builder
                """

            @property
            def min(self) -> jpype.JLong:
                ...

            @property
            def max(self) -> jpype.JLong:
                ...


        class_: typing.ClassVar[java.lang.Class]
        MIN_FIELD_NUMBER: typing.Final = 1
        MAX_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Span:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getMax(self) -> int:
            """
            ``int64 max = 2;``
            
            :return: The max.
            :rtype: int
            """

        def getMin(self) -> int:
            """
            ``int64 min = 1;``
            
            :return: The min.
            :rtype: int
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Span.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Span) -> TraceRmi.Span.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Span:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Span:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Span]:
            ...

        @property
        def min(self) -> jpype.JLong:
            ...

        @property
        def max(self) -> jpype.JLong:
            ...


    class BoxOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getRange(self) -> TraceRmi.AddrRange:
            """
            ``.ghidra.rmi.trace.AddrRange range = 2;``
            
            :return: The range.
            :rtype: TraceRmi.AddrRange
            """

        def getRangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            """
            ``.ghidra.rmi.trace.AddrRange range = 2;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            """

        def hasRange(self) -> bool:
            """
            ``.ghidra.rmi.trace.AddrRange range = 2;``
            
            :return: Whether the range field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def rangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            ...

        @property
        def range(self) -> TraceRmi.AddrRange:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class Box(com.google.protobuf.GeneratedMessage, TraceRmi.BoxOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Box``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Box.Builder], TraceRmi.BoxOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Box``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearRange(self) -> TraceRmi.Box.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 2;``
                """

            def clearSpan(self) -> TraceRmi.Box.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getRange(self) -> TraceRmi.AddrRange:
                """
                ``.ghidra.rmi.trace.AddrRange range = 2;``
                
                :return: The range.
                :rtype: TraceRmi.AddrRange
                """

            def getRangeBuilder(self) -> TraceRmi.AddrRange.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 2;``
                """

            def getRangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 2;``
                """

            def getSpan(self) -> TraceRmi.Span:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                
                :return: The span.
                :rtype: TraceRmi.Span
                """

            def getSpanBuilder(self) -> TraceRmi.Span.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            def hasRange(self) -> bool:
                """
                ``.ghidra.rmi.trace.AddrRange range = 2;``
                
                :return: Whether the range field is set.
                :rtype: bool
                """

            def hasSpan(self) -> bool:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                
                :return: Whether the span field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.Box) -> TraceRmi.Box.Builder:
                ...

            def mergeRange(self, value: TraceRmi.AddrRange) -> TraceRmi.Box.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 2;``
                """

            def mergeSpan(self, value: TraceRmi.Span) -> TraceRmi.Box.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @typing.overload
            def setRange(self, value: TraceRmi.AddrRange) -> TraceRmi.Box.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 2;``
                """

            @typing.overload
            def setRange(self, builderForValue: TraceRmi.AddrRange.Builder) -> TraceRmi.Box.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 2;``
                """

            @typing.overload
            def setSpan(self, value: TraceRmi.Span) -> TraceRmi.Box.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @typing.overload
            def setSpan(self, builderForValue: TraceRmi.Span.Builder) -> TraceRmi.Box.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @property
            def rangeBuilder(self) -> TraceRmi.AddrRange.Builder:
                ...

            @property
            def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                ...

            @property
            def rangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
                ...

            @property
            def spanBuilder(self) -> TraceRmi.Span.Builder:
                ...

            @property
            def range(self) -> TraceRmi.AddrRange:
                ...

            @property
            def span(self) -> TraceRmi.Span:
                ...


        class_: typing.ClassVar[java.lang.Class]
        SPAN_FIELD_NUMBER: typing.Final = 1
        RANGE_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Box:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getRange(self) -> TraceRmi.AddrRange:
            """
            ``.ghidra.rmi.trace.AddrRange range = 2;``
            
            :return: The range.
            :rtype: TraceRmi.AddrRange
            """

        def getRangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            """
            ``.ghidra.rmi.trace.AddrRange range = 2;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            """

        def hasRange(self) -> bool:
            """
            ``.ghidra.rmi.trace.AddrRange range = 2;``
            
            :return: Whether the range field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Box.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Box) -> TraceRmi.Box.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Box:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Box:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Box]:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def rangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            ...

        @property
        def range(self) -> TraceRmi.AddrRange:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class ReplyErrorOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getMessage(self) -> str:
            """
            ``string message = 1;``
            
            :return: The message.
            :rtype: str
            """

        def getMessageBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string message = 1;``
            
            :return: The bytes for message.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def messageBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def message(self) -> java.lang.String:
            ...


    class ReplyError(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyErrorOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyError``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyError.Builder], TraceRmi.ReplyErrorOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyError``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearMessage(self) -> TraceRmi.ReplyError.Builder:
                """
                ``string message = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyError.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getMessage(self) -> str:
                """
                ``string message = 1;``
                
                :return: The message.
                :rtype: str
                """

            def getMessageBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string message = 1;``
                
                :return: The bytes for message.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.ReplyError) -> TraceRmi.ReplyError.Builder:
                ...

            def setMessage(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.ReplyError.Builder:
                """
                ``string message = 1;``
                
                :param java.lang.String or str value: The message to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyError.Builder
                """

            def setMessageBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.ReplyError.Builder:
                """
                ``string message = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for message to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyError.Builder
                """

            @property
            def messageBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def message(self) -> java.lang.String:
                ...


        class_: typing.ClassVar[java.lang.Class]
        MESSAGE_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyError:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getMessage(self) -> str:
            """
            ``string message = 1;``
            
            :return: The message.
            :rtype: str
            """

        def getMessageBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string message = 1;``
            
            :return: The bytes for message.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyError.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyError) -> TraceRmi.ReplyError.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyError:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyError]:
            ...

        @property
        def messageBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def message(self) -> java.lang.String:
            ...


    class RequestCreateTraceOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getCompiler(self) -> TraceRmi.Compiler:
            """
            ``.ghidra.rmi.trace.Compiler compiler = 3;``
            
            :return: The compiler.
            :rtype: TraceRmi.Compiler
            """

        def getCompilerOrBuilder(self) -> TraceRmi.CompilerOrBuilder:
            """
            ``.ghidra.rmi.trace.Compiler compiler = 3;``
            """

        def getLanguage(self) -> TraceRmi.Language:
            """
            ``.ghidra.rmi.trace.Language language = 2;``
            
            :return: The language.
            :rtype: TraceRmi.Language
            """

        def getLanguageOrBuilder(self) -> TraceRmi.LanguageOrBuilder:
            """
            ``.ghidra.rmi.trace.Language language = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 4;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 4;``
            """

        def getPath(self) -> TraceRmi.FilePath:
            """
            ``.ghidra.rmi.trace.FilePath path = 1;``
            
            :return: The path.
            :rtype: TraceRmi.FilePath
            """

        def getPathOrBuilder(self) -> TraceRmi.FilePathOrBuilder:
            """
            ``.ghidra.rmi.trace.FilePath path = 1;``
            """

        def hasCompiler(self) -> bool:
            """
            ``.ghidra.rmi.trace.Compiler compiler = 3;``
            
            :return: Whether the compiler field is set.
            :rtype: bool
            """

        def hasLanguage(self) -> bool:
            """
            ``.ghidra.rmi.trace.Language language = 2;``
            
            :return: Whether the language field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 4;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasPath(self) -> bool:
            """
            ``.ghidra.rmi.trace.FilePath path = 1;``
            
            :return: Whether the path field is set.
            :rtype: bool
            """

        @property
        def path(self) -> TraceRmi.FilePath:
            ...

        @property
        def languageOrBuilder(self) -> TraceRmi.LanguageOrBuilder:
            ...

        @property
        def pathOrBuilder(self) -> TraceRmi.FilePathOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def language(self) -> TraceRmi.Language:
            ...

        @property
        def compilerOrBuilder(self) -> TraceRmi.CompilerOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def compiler(self) -> TraceRmi.Compiler:
            ...


    class RequestCreateTrace(com.google.protobuf.GeneratedMessage, TraceRmi.RequestCreateTraceOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestCreateTrace``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestCreateTrace.Builder], TraceRmi.RequestCreateTraceOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestCreateTrace``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearCompiler(self) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.Compiler compiler = 3;``
                """

            def clearLanguage(self) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.Language language = 2;``
                """

            def clearOid(self) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 4;``
                """

            def clearPath(self) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.FilePath path = 1;``
                """

            def getCompiler(self) -> TraceRmi.Compiler:
                """
                ``.ghidra.rmi.trace.Compiler compiler = 3;``
                
                :return: The compiler.
                :rtype: TraceRmi.Compiler
                """

            def getCompilerBuilder(self) -> TraceRmi.Compiler.Builder:
                """
                ``.ghidra.rmi.trace.Compiler compiler = 3;``
                """

            def getCompilerOrBuilder(self) -> TraceRmi.CompilerOrBuilder:
                """
                ``.ghidra.rmi.trace.Compiler compiler = 3;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getLanguage(self) -> TraceRmi.Language:
                """
                ``.ghidra.rmi.trace.Language language = 2;``
                
                :return: The language.
                :rtype: TraceRmi.Language
                """

            def getLanguageBuilder(self) -> TraceRmi.Language.Builder:
                """
                ``.ghidra.rmi.trace.Language language = 2;``
                """

            def getLanguageOrBuilder(self) -> TraceRmi.LanguageOrBuilder:
                """
                ``.ghidra.rmi.trace.Language language = 2;``
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 4;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 4;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 4;``
                """

            def getPath(self) -> TraceRmi.FilePath:
                """
                ``.ghidra.rmi.trace.FilePath path = 1;``
                
                :return: The path.
                :rtype: TraceRmi.FilePath
                """

            def getPathBuilder(self) -> TraceRmi.FilePath.Builder:
                """
                ``.ghidra.rmi.trace.FilePath path = 1;``
                """

            def getPathOrBuilder(self) -> TraceRmi.FilePathOrBuilder:
                """
                ``.ghidra.rmi.trace.FilePath path = 1;``
                """

            def hasCompiler(self) -> bool:
                """
                ``.ghidra.rmi.trace.Compiler compiler = 3;``
                
                :return: Whether the compiler field is set.
                :rtype: bool
                """

            def hasLanguage(self) -> bool:
                """
                ``.ghidra.rmi.trace.Language language = 2;``
                
                :return: Whether the language field is set.
                :rtype: bool
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 4;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasPath(self) -> bool:
                """
                ``.ghidra.rmi.trace.FilePath path = 1;``
                
                :return: Whether the path field is set.
                :rtype: bool
                """

            def mergeCompiler(self, value: TraceRmi.Compiler) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.Compiler compiler = 3;``
                """

            def mergeFrom(self, other: TraceRmi.RequestCreateTrace) -> TraceRmi.RequestCreateTrace.Builder:
                ...

            def mergeLanguage(self, value: TraceRmi.Language) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.Language language = 2;``
                """

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 4;``
                """

            def mergePath(self, value: TraceRmi.FilePath) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.FilePath path = 1;``
                """

            @typing.overload
            def setCompiler(self, value: TraceRmi.Compiler) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.Compiler compiler = 3;``
                """

            @typing.overload
            def setCompiler(self, builderForValue: TraceRmi.Compiler.Builder) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.Compiler compiler = 3;``
                """

            @typing.overload
            def setLanguage(self, value: TraceRmi.Language) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.Language language = 2;``
                """

            @typing.overload
            def setLanguage(self, builderForValue: TraceRmi.Language.Builder) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.Language language = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 4;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 4;``
                """

            @typing.overload
            def setPath(self, value: TraceRmi.FilePath) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.FilePath path = 1;``
                """

            @typing.overload
            def setPath(self, builderForValue: TraceRmi.FilePath.Builder) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.FilePath path = 1;``
                """

            @property
            def path(self) -> TraceRmi.FilePath:
                ...

            @property
            def languageOrBuilder(self) -> TraceRmi.LanguageOrBuilder:
                ...

            @property
            def languageBuilder(self) -> TraceRmi.Language.Builder:
                ...

            @property
            def pathOrBuilder(self) -> TraceRmi.FilePathOrBuilder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def language(self) -> TraceRmi.Language:
                ...

            @property
            def compilerOrBuilder(self) -> TraceRmi.CompilerOrBuilder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def compiler(self) -> TraceRmi.Compiler:
                ...

            @property
            def pathBuilder(self) -> TraceRmi.FilePath.Builder:
                ...

            @property
            def compilerBuilder(self) -> TraceRmi.Compiler.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]
        PATH_FIELD_NUMBER: typing.Final = 1
        LANGUAGE_FIELD_NUMBER: typing.Final = 2
        COMPILER_FIELD_NUMBER: typing.Final = 3
        OID_FIELD_NUMBER: typing.Final = 4

        def getCompiler(self) -> TraceRmi.Compiler:
            """
            ``.ghidra.rmi.trace.Compiler compiler = 3;``
            
            :return: The compiler.
            :rtype: TraceRmi.Compiler
            """

        def getCompilerOrBuilder(self) -> TraceRmi.CompilerOrBuilder:
            """
            ``.ghidra.rmi.trace.Compiler compiler = 3;``
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getLanguage(self) -> TraceRmi.Language:
            """
            ``.ghidra.rmi.trace.Language language = 2;``
            
            :return: The language.
            :rtype: TraceRmi.Language
            """

        def getLanguageOrBuilder(self) -> TraceRmi.LanguageOrBuilder:
            """
            ``.ghidra.rmi.trace.Language language = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 4;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 4;``
            """

        def getPath(self) -> TraceRmi.FilePath:
            """
            ``.ghidra.rmi.trace.FilePath path = 1;``
            
            :return: The path.
            :rtype: TraceRmi.FilePath
            """

        def getPathOrBuilder(self) -> TraceRmi.FilePathOrBuilder:
            """
            ``.ghidra.rmi.trace.FilePath path = 1;``
            """

        def hasCompiler(self) -> bool:
            """
            ``.ghidra.rmi.trace.Compiler compiler = 3;``
            
            :return: Whether the compiler field is set.
            :rtype: bool
            """

        def hasLanguage(self) -> bool:
            """
            ``.ghidra.rmi.trace.Language language = 2;``
            
            :return: Whether the language field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 4;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasPath(self) -> bool:
            """
            ``.ghidra.rmi.trace.FilePath path = 1;``
            
            :return: Whether the path field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestCreateTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestCreateTrace) -> TraceRmi.RequestCreateTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateTrace:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestCreateTrace]:
            ...

        @property
        def path(self) -> TraceRmi.FilePath:
            ...

        @property
        def languageOrBuilder(self) -> TraceRmi.LanguageOrBuilder:
            ...

        @property
        def pathOrBuilder(self) -> TraceRmi.FilePathOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def language(self) -> TraceRmi.Language:
            ...

        @property
        def compilerOrBuilder(self) -> TraceRmi.CompilerOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def compiler(self) -> TraceRmi.Compiler:
            ...


    class ReplyCreateTraceOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyCreateTrace(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyCreateTraceOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyCreateTrace``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyCreateTrace.Builder], TraceRmi.ReplyCreateTraceOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyCreateTrace``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyCreateTrace) -> TraceRmi.ReplyCreateTrace.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyCreateTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyCreateTrace) -> TraceRmi.ReplyCreateTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateTrace:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyCreateTrace]:
            ...


    class RequestSaveTraceOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class RequestSaveTrace(com.google.protobuf.GeneratedMessage, TraceRmi.RequestSaveTraceOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestSaveTrace``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestSaveTrace.Builder], TraceRmi.RequestSaveTraceOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestSaveTrace``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOid(self) -> TraceRmi.RequestSaveTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestSaveTrace) -> TraceRmi.RequestSaveTrace.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestSaveTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestSaveTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestSaveTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestSaveTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestSaveTrace) -> TraceRmi.RequestSaveTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSaveTrace:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestSaveTrace]:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class ReplySaveTraceOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplySaveTrace(com.google.protobuf.GeneratedMessage, TraceRmi.ReplySaveTraceOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplySaveTrace``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplySaveTrace.Builder], TraceRmi.ReplySaveTraceOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplySaveTrace``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplySaveTrace) -> TraceRmi.ReplySaveTrace.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplySaveTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplySaveTrace) -> TraceRmi.ReplySaveTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySaveTrace:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplySaveTrace]:
            ...


    class RequestCloseTraceOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class RequestCloseTrace(com.google.protobuf.GeneratedMessage, TraceRmi.RequestCloseTraceOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestCloseTrace``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestCloseTrace.Builder], TraceRmi.RequestCloseTraceOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestCloseTrace``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOid(self) -> TraceRmi.RequestCloseTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestCloseTrace) -> TraceRmi.RequestCloseTrace.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCloseTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCloseTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestCloseTrace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestCloseTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestCloseTrace) -> TraceRmi.RequestCloseTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCloseTrace:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestCloseTrace]:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class ReplyCloseTraceOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyCloseTrace(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyCloseTraceOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyCloseTrace``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyCloseTrace.Builder], TraceRmi.ReplyCloseTraceOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyCloseTrace``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyCloseTrace) -> TraceRmi.ReplyCloseTrace.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyCloseTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyCloseTrace) -> TraceRmi.ReplyCloseTrace.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCloseTrace:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyCloseTrace]:
            ...


    class RequestStartTxOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getDescription(self) -> str:
            """
            ``string description = 3;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 3;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getTxid(self) -> TraceRmi.TxId:
            """
            ``.ghidra.rmi.trace.TxId txid = 4;``
            
            :return: The txid.
            :rtype: TraceRmi.TxId
            """

        def getTxidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
            """
            ``.ghidra.rmi.trace.TxId txid = 4;``
            """

        def getUndoable(self) -> bool:
            """
            ``bool undoable = 2;``
            
            :return: The undoable.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasTxid(self) -> bool:
            """
            ``.ghidra.rmi.trace.TxId txid = 4;``
            
            :return: Whether the txid field is set.
            :rtype: bool
            """

        @property
        def txid(self) -> TraceRmi.TxId:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def undoable(self) -> jpype.JBoolean:
            ...

        @property
        def txidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...


    class RequestStartTx(com.google.protobuf.GeneratedMessage, TraceRmi.RequestStartTxOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestStartTx``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestStartTx.Builder], TraceRmi.RequestStartTxOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestStartTx``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearDescription(self) -> TraceRmi.RequestStartTx.Builder:
                """
                ``string description = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestStartTx.Builder
                """

            def clearOid(self) -> TraceRmi.RequestStartTx.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearTxid(self) -> TraceRmi.RequestStartTx.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 4;``
                """

            def clearUndoable(self) -> TraceRmi.RequestStartTx.Builder:
                """
                ``bool undoable = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestStartTx.Builder
                """

            def getDescription(self) -> str:
                """
                ``string description = 3;``
                
                :return: The description.
                :rtype: str
                """

            def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string description = 3;``
                
                :return: The bytes for description.
                :rtype: com.google.protobuf.ByteString
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getTxid(self) -> TraceRmi.TxId:
                """
                ``.ghidra.rmi.trace.TxId txid = 4;``
                
                :return: The txid.
                :rtype: TraceRmi.TxId
                """

            def getTxidBuilder(self) -> TraceRmi.TxId.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 4;``
                """

            def getTxidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
                """
                ``.ghidra.rmi.trace.TxId txid = 4;``
                """

            def getUndoable(self) -> bool:
                """
                ``bool undoable = 2;``
                
                :return: The undoable.
                :rtype: bool
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasTxid(self) -> bool:
                """
                ``.ghidra.rmi.trace.TxId txid = 4;``
                
                :return: Whether the txid field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestStartTx) -> TraceRmi.RequestStartTx.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestStartTx.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeTxid(self, value: TraceRmi.TxId) -> TraceRmi.RequestStartTx.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 4;``
                """

            def setDescription(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestStartTx.Builder:
                """
                ``string description = 3;``
                
                :param java.lang.String or str value: The description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestStartTx.Builder
                """

            def setDescriptionBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestStartTx.Builder:
                """
                ``string description = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestStartTx.Builder
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestStartTx.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestStartTx.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setTxid(self, value: TraceRmi.TxId) -> TraceRmi.RequestStartTx.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 4;``
                """

            @typing.overload
            def setTxid(self, builderForValue: TraceRmi.TxId.Builder) -> TraceRmi.RequestStartTx.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 4;``
                """

            def setUndoable(self, value: typing.Union[jpype.JBoolean, bool]) -> TraceRmi.RequestStartTx.Builder:
                """
                ``bool undoable = 2;``
                
                :param jpype.JBoolean or bool value: The undoable to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestStartTx.Builder
                """

            @property
            def txid(self) -> TraceRmi.TxId:
                ...

            @property
            def description(self) -> java.lang.String:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def undoable(self) -> jpype.JBoolean:
                ...

            @property
            def txidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def descriptionBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def txidBuilder(self) -> TraceRmi.TxId.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        UNDOABLE_FIELD_NUMBER: typing.Final = 2
        DESCRIPTION_FIELD_NUMBER: typing.Final = 3
        TXID_FIELD_NUMBER: typing.Final = 4

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestStartTx:
            ...

        def getDescription(self) -> str:
            """
            ``string description = 3;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 3;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getTxid(self) -> TraceRmi.TxId:
            """
            ``.ghidra.rmi.trace.TxId txid = 4;``
            
            :return: The txid.
            :rtype: TraceRmi.TxId
            """

        def getTxidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
            """
            ``.ghidra.rmi.trace.TxId txid = 4;``
            """

        def getUndoable(self) -> bool:
            """
            ``bool undoable = 2;``
            
            :return: The undoable.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasTxid(self) -> bool:
            """
            ``.ghidra.rmi.trace.TxId txid = 4;``
            
            :return: Whether the txid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestStartTx.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestStartTx) -> TraceRmi.RequestStartTx.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestStartTx:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestStartTx]:
            ...

        @property
        def txid(self) -> TraceRmi.TxId:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def undoable(self) -> jpype.JBoolean:
            ...

        @property
        def txidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...


    class ReplyStartTxOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyStartTx(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyStartTxOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyStartTx``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyStartTx.Builder], TraceRmi.ReplyStartTxOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyStartTx``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyStartTx) -> TraceRmi.ReplyStartTx.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyStartTx.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyStartTx) -> TraceRmi.ReplyStartTx.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyStartTx:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyStartTx]:
            ...


    class RequestEndTxOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getAbort(self) -> bool:
            """
            ``bool abort = 3;``
            
            :return: The abort.
            :rtype: bool
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getTxid(self) -> TraceRmi.TxId:
            """
            ``.ghidra.rmi.trace.TxId txid = 2;``
            
            :return: The txid.
            :rtype: TraceRmi.TxId
            """

        def getTxidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
            """
            ``.ghidra.rmi.trace.TxId txid = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasTxid(self) -> bool:
            """
            ``.ghidra.rmi.trace.TxId txid = 2;``
            
            :return: Whether the txid field is set.
            :rtype: bool
            """

        @property
        def abort(self) -> jpype.JBoolean:
            ...

        @property
        def txid(self) -> TraceRmi.TxId:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def txidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class RequestEndTx(com.google.protobuf.GeneratedMessage, TraceRmi.RequestEndTxOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestEndTx``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestEndTx.Builder], TraceRmi.RequestEndTxOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestEndTx``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearAbort(self) -> TraceRmi.RequestEndTx.Builder:
                """
                ``bool abort = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestEndTx.Builder
                """

            def clearOid(self) -> TraceRmi.RequestEndTx.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearTxid(self) -> TraceRmi.RequestEndTx.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 2;``
                """

            def getAbort(self) -> bool:
                """
                ``bool abort = 3;``
                
                :return: The abort.
                :rtype: bool
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getTxid(self) -> TraceRmi.TxId:
                """
                ``.ghidra.rmi.trace.TxId txid = 2;``
                
                :return: The txid.
                :rtype: TraceRmi.TxId
                """

            def getTxidBuilder(self) -> TraceRmi.TxId.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 2;``
                """

            def getTxidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
                """
                ``.ghidra.rmi.trace.TxId txid = 2;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasTxid(self) -> bool:
                """
                ``.ghidra.rmi.trace.TxId txid = 2;``
                
                :return: Whether the txid field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestEndTx) -> TraceRmi.RequestEndTx.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestEndTx.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeTxid(self, value: TraceRmi.TxId) -> TraceRmi.RequestEndTx.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 2;``
                """

            def setAbort(self, value: typing.Union[jpype.JBoolean, bool]) -> TraceRmi.RequestEndTx.Builder:
                """
                ``bool abort = 3;``
                
                :param jpype.JBoolean or bool value: The abort to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestEndTx.Builder
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestEndTx.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestEndTx.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setTxid(self, value: TraceRmi.TxId) -> TraceRmi.RequestEndTx.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 2;``
                """

            @typing.overload
            def setTxid(self, builderForValue: TraceRmi.TxId.Builder) -> TraceRmi.RequestEndTx.Builder:
                """
                ``.ghidra.rmi.trace.TxId txid = 2;``
                """

            @property
            def abort(self) -> jpype.JBoolean:
                ...

            @property
            def txid(self) -> TraceRmi.TxId:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def txidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def txidBuilder(self) -> TraceRmi.TxId.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        TXID_FIELD_NUMBER: typing.Final = 2
        ABORT_FIELD_NUMBER: typing.Final = 3

        def getAbort(self) -> bool:
            """
            ``bool abort = 3;``
            
            :return: The abort.
            :rtype: bool
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getTxid(self) -> TraceRmi.TxId:
            """
            ``.ghidra.rmi.trace.TxId txid = 2;``
            
            :return: The txid.
            :rtype: TraceRmi.TxId
            """

        def getTxidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
            """
            ``.ghidra.rmi.trace.TxId txid = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasTxid(self) -> bool:
            """
            ``.ghidra.rmi.trace.TxId txid = 2;``
            
            :return: Whether the txid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestEndTx.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestEndTx) -> TraceRmi.RequestEndTx.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestEndTx:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestEndTx]:
            ...

        @property
        def abort(self) -> jpype.JBoolean:
            ...

        @property
        def txid(self) -> TraceRmi.TxId:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def txidOrBuilder(self) -> TraceRmi.TxIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class ReplyEndTxOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyEndTx(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyEndTxOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyEndTx``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyEndTx.Builder], TraceRmi.ReplyEndTxOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyEndTx``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyEndTx) -> TraceRmi.ReplyEndTx.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyEndTx.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyEndTx) -> TraceRmi.ReplyEndTx.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyEndTx:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyEndTx]:
            ...


    class RequestCreateOverlaySpaceOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getBaseSpace(self) -> str:
            """
            ``string baseSpace = 2;``
            
            :return: The baseSpace.
            :rtype: str
            """

        def getBaseSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string baseSpace = 2;``
            
            :return: The bytes for baseSpace.
            :rtype: com.google.protobuf.ByteString
            """

        def getName(self) -> str:
            """
            ``string name = 3;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 3;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def baseSpaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def baseSpace(self) -> java.lang.String:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class RequestCreateOverlaySpace(com.google.protobuf.GeneratedMessage, TraceRmi.RequestCreateOverlaySpaceOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestCreateOverlaySpace``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestCreateOverlaySpace.Builder], TraceRmi.RequestCreateOverlaySpaceOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestCreateOverlaySpace``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearBaseSpace(self) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``string baseSpace = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateOverlaySpace.Builder
                """

            def clearName(self) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``string name = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateOverlaySpace.Builder
                """

            def clearOid(self) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getBaseSpace(self) -> str:
                """
                ``string baseSpace = 2;``
                
                :return: The baseSpace.
                :rtype: str
                """

            def getBaseSpaceBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string baseSpace = 2;``
                
                :return: The bytes for baseSpace.
                :rtype: com.google.protobuf.ByteString
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getName(self) -> str:
                """
                ``string name = 3;``
                
                :return: The name.
                :rtype: str
                """

            def getNameBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string name = 3;``
                
                :return: The bytes for name.
                :rtype: com.google.protobuf.ByteString
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestCreateOverlaySpace) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def setBaseSpace(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``string baseSpace = 2;``
                
                :param java.lang.String or str value: The baseSpace to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateOverlaySpace.Builder
                """

            def setBaseSpaceBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``string baseSpace = 2;``
                
                :param com.google.protobuf.ByteString value: The bytes for baseSpace to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateOverlaySpace.Builder
                """

            def setName(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``string name = 3;``
                
                :param java.lang.String or str value: The name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateOverlaySpace.Builder
                """

            def setNameBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``string name = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateOverlaySpace.Builder
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @property
            def nameBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def baseSpaceBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def baseSpace(self) -> java.lang.String:
                ...

            @property
            def name(self) -> java.lang.String:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        BASESPACE_FIELD_NUMBER: typing.Final = 2
        NAME_FIELD_NUMBER: typing.Final = 3

        def getBaseSpace(self) -> str:
            """
            ``string baseSpace = 2;``
            
            :return: The baseSpace.
            :rtype: str
            """

        def getBaseSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string baseSpace = 2;``
            
            :return: The bytes for baseSpace.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getName(self) -> str:
            """
            ``string name = 3;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 3;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestCreateOverlaySpace.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestCreateOverlaySpace) -> TraceRmi.RequestCreateOverlaySpace.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestCreateOverlaySpace]:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def baseSpaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def baseSpace(self) -> java.lang.String:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class ReplyCreateOverlaySpaceOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyCreateOverlaySpace(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyCreateOverlaySpaceOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyCreateOverlaySpace``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyCreateOverlaySpace.Builder], TraceRmi.ReplyCreateOverlaySpaceOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyCreateOverlaySpace``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyCreateOverlaySpace) -> TraceRmi.ReplyCreateOverlaySpace.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyCreateOverlaySpace.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyCreateOverlaySpace) -> TraceRmi.ReplyCreateOverlaySpace.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyCreateOverlaySpace]:
            ...


    class RequestSetMemoryStateOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getRange(self) -> TraceRmi.AddrRange:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            
            :return: The range.
            :rtype: TraceRmi.AddrRange
            """

        def getRangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getState(self) -> TraceRmi.MemoryState:
            """
            ``.ghidra.rmi.trace.MemoryState state = 4;``
            
            :return: The state.
            :rtype: TraceRmi.MemoryState
            """

        def getStateValue(self) -> int:
            """
            ``.ghidra.rmi.trace.MemoryState state = 4;``
            
            :return: The enum numeric value on the wire for state.
            :rtype: int
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasRange(self) -> bool:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            
            :return: Whether the range field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def rangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            ...

        @property
        def stateValue(self) -> jpype.JInt:
            ...

        @property
        def range(self) -> TraceRmi.AddrRange:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def state(self) -> TraceRmi.MemoryState:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class RequestSetMemoryState(com.google.protobuf.GeneratedMessage, TraceRmi.RequestSetMemoryStateOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestSetMemoryState``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestSetMemoryState.Builder], TraceRmi.RequestSetMemoryStateOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestSetMemoryState``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOid(self) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearRange(self) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            def clearSnap(self) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def clearState(self) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.MemoryState state = 4;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSetMemoryState.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getRange(self) -> TraceRmi.AddrRange:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                
                :return: The range.
                :rtype: TraceRmi.AddrRange
                """

            def getRangeBuilder(self) -> TraceRmi.AddrRange.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            def getRangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            def getSnap(self) -> TraceRmi.Snap:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: The snap.
                :rtype: TraceRmi.Snap
                """

            def getSnapBuilder(self) -> TraceRmi.Snap.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getState(self) -> TraceRmi.MemoryState:
                """
                ``.ghidra.rmi.trace.MemoryState state = 4;``
                
                :return: The state.
                :rtype: TraceRmi.MemoryState
                """

            def getStateValue(self) -> int:
                """
                ``.ghidra.rmi.trace.MemoryState state = 4;``
                
                :return: The enum numeric value on the wire for state.
                :rtype: int
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasRange(self) -> bool:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                
                :return: Whether the range field is set.
                :rtype: bool
                """

            def hasSnap(self) -> bool:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: Whether the snap field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestSetMemoryState) -> TraceRmi.RequestSetMemoryState.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeRange(self, value: TraceRmi.AddrRange) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            def mergeSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setRange(self, value: TraceRmi.AddrRange) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            @typing.overload
            def setRange(self, builderForValue: TraceRmi.AddrRange.Builder) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            @typing.overload
            def setSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setSnap(self, builderForValue: TraceRmi.Snap.Builder) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def setState(self, value: TraceRmi.MemoryState) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.MemoryState state = 4;``
                
                :param TraceRmi.MemoryState value: The state to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSetMemoryState.Builder
                """

            def setStateValue(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.MemoryState state = 4;``
                
                :param jpype.JInt or int value: The enum numeric value on the wire for state to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSetMemoryState.Builder
                """

            @property
            def rangeBuilder(self) -> TraceRmi.AddrRange.Builder:
                ...

            @property
            def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                ...

            @property
            def rangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
                ...

            @property
            def stateValue(self) -> jpype.JInt:
                ...

            @property
            def snapBuilder(self) -> TraceRmi.Snap.Builder:
                ...

            @property
            def range(self) -> TraceRmi.AddrRange:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def state(self) -> TraceRmi.MemoryState:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def snap(self) -> TraceRmi.Snap:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        SNAP_FIELD_NUMBER: typing.Final = 2
        RANGE_FIELD_NUMBER: typing.Final = 3
        STATE_FIELD_NUMBER: typing.Final = 4

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getRange(self) -> TraceRmi.AddrRange:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            
            :return: The range.
            :rtype: TraceRmi.AddrRange
            """

        def getRangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getState(self) -> TraceRmi.MemoryState:
            """
            ``.ghidra.rmi.trace.MemoryState state = 4;``
            
            :return: The state.
            :rtype: TraceRmi.MemoryState
            """

        def getStateValue(self) -> int:
            """
            ``.ghidra.rmi.trace.MemoryState state = 4;``
            
            :return: The enum numeric value on the wire for state.
            :rtype: int
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasRange(self) -> bool:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            
            :return: Whether the range field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestSetMemoryState.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestSetMemoryState) -> TraceRmi.RequestSetMemoryState.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetMemoryState:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestSetMemoryState]:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def rangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            ...

        @property
        def stateValue(self) -> jpype.JInt:
            ...

        @property
        def range(self) -> TraceRmi.AddrRange:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def state(self) -> TraceRmi.MemoryState:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class ReplySetMemoryStateOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplySetMemoryState(com.google.protobuf.GeneratedMessage, TraceRmi.ReplySetMemoryStateOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplySetMemoryState``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplySetMemoryState.Builder], TraceRmi.ReplySetMemoryStateOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplySetMemoryState``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplySetMemoryState) -> TraceRmi.ReplySetMemoryState.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplySetMemoryState.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplySetMemoryState) -> TraceRmi.ReplySetMemoryState.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetMemoryState:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplySetMemoryState]:
            ...


    class RequestPutBytesOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getData(self) -> com.google.protobuf.ByteString:
            """
            ``bytes data = 4;``
            
            :return: The data.
            :rtype: com.google.protobuf.ByteString
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getStart(self) -> TraceRmi.Addr:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            
            :return: The start.
            :rtype: TraceRmi.Addr
            """

        def getStartOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        def hasStart(self) -> bool:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            
            :return: Whether the start field is set.
            :rtype: bool
            """

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def data(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def start(self) -> TraceRmi.Addr:
            ...

        @property
        def startOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class RequestPutBytes(com.google.protobuf.GeneratedMessage, TraceRmi.RequestPutBytesOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestPutBytes``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestPutBytes.Builder], TraceRmi.RequestPutBytesOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestPutBytes``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearData(self) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``bytes data = 4;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestPutBytes.Builder
                """

            def clearOid(self) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearSnap(self) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def clearStart(self) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            def getData(self) -> com.google.protobuf.ByteString:
                """
                ``bytes data = 4;``
                
                :return: The data.
                :rtype: com.google.protobuf.ByteString
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getSnap(self) -> TraceRmi.Snap:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: The snap.
                :rtype: TraceRmi.Snap
                """

            def getSnapBuilder(self) -> TraceRmi.Snap.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getStart(self) -> TraceRmi.Addr:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                
                :return: The start.
                :rtype: TraceRmi.Addr
                """

            def getStartBuilder(self) -> TraceRmi.Addr.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            def getStartOrBuilder(self) -> TraceRmi.AddrOrBuilder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasSnap(self) -> bool:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: Whether the snap field is set.
                :rtype: bool
                """

            def hasStart(self) -> bool:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                
                :return: Whether the start field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestPutBytes) -> TraceRmi.RequestPutBytes.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def mergeStart(self, value: TraceRmi.Addr) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            def setData(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``bytes data = 4;``
                
                :param com.google.protobuf.ByteString value: The data to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestPutBytes.Builder
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setSnap(self, builderForValue: TraceRmi.Snap.Builder) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setStart(self, value: TraceRmi.Addr) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            @typing.overload
            def setStart(self, builderForValue: TraceRmi.Addr.Builder) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            @property
            def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                ...

            @property
            def data(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def start(self) -> TraceRmi.Addr:
                ...

            @property
            def snapBuilder(self) -> TraceRmi.Snap.Builder:
                ...

            @property
            def startOrBuilder(self) -> TraceRmi.AddrOrBuilder:
                ...

            @property
            def startBuilder(self) -> TraceRmi.Addr.Builder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def snap(self) -> TraceRmi.Snap:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        SNAP_FIELD_NUMBER: typing.Final = 2
        START_FIELD_NUMBER: typing.Final = 3
        DATA_FIELD_NUMBER: typing.Final = 4

        def getData(self) -> com.google.protobuf.ByteString:
            """
            ``bytes data = 4;``
            
            :return: The data.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getStart(self) -> TraceRmi.Addr:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            
            :return: The start.
            :rtype: TraceRmi.Addr
            """

        def getStartOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        def hasStart(self) -> bool:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            
            :return: Whether the start field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestPutBytes.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestPutBytes) -> TraceRmi.RequestPutBytes.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutBytes:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestPutBytes]:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def data(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def start(self) -> TraceRmi.Addr:
            ...

        @property
        def startOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class ReplyPutBytesOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getWritten(self) -> int:
            """
            ``int32 written = 1;``
            
            :return: The written.
            :rtype: int
            """

        @property
        def written(self) -> jpype.JInt:
            ...


    class ReplyPutBytes(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyPutBytesOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyPutBytes``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyPutBytes.Builder], TraceRmi.ReplyPutBytesOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyPutBytes``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearWritten(self) -> TraceRmi.ReplyPutBytes.Builder:
                """
                ``int32 written = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyPutBytes.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getWritten(self) -> int:
                """
                ``int32 written = 1;``
                
                :return: The written.
                :rtype: int
                """

            def mergeFrom(self, other: TraceRmi.ReplyPutBytes) -> TraceRmi.ReplyPutBytes.Builder:
                ...

            def setWritten(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.ReplyPutBytes.Builder:
                """
                ``int32 written = 1;``
                
                :param jpype.JInt or int value: The written to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyPutBytes.Builder
                """

            @property
            def written(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        WRITTEN_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getWritten(self) -> int:
            """
            ``int32 written = 1;``
            
            :return: The written.
            :rtype: int
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyPutBytes.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyPutBytes) -> TraceRmi.ReplyPutBytes.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutBytes:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyPutBytes]:
            ...

        @property
        def written(self) -> jpype.JInt:
            ...


    class RequestDeleteBytesOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getRange(self) -> TraceRmi.AddrRange:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            
            :return: The range.
            :rtype: TraceRmi.AddrRange
            """

        def getRangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasRange(self) -> bool:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            
            :return: Whether the range field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def rangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            ...

        @property
        def range(self) -> TraceRmi.AddrRange:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class RequestDeleteBytes(com.google.protobuf.GeneratedMessage, TraceRmi.RequestDeleteBytesOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestDeleteBytes``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestDeleteBytes.Builder], TraceRmi.RequestDeleteBytesOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestDeleteBytes``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOid(self) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearRange(self) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            def clearSnap(self) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getRange(self) -> TraceRmi.AddrRange:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                
                :return: The range.
                :rtype: TraceRmi.AddrRange
                """

            def getRangeBuilder(self) -> TraceRmi.AddrRange.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            def getRangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            def getSnap(self) -> TraceRmi.Snap:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: The snap.
                :rtype: TraceRmi.Snap
                """

            def getSnapBuilder(self) -> TraceRmi.Snap.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasRange(self) -> bool:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                
                :return: Whether the range field is set.
                :rtype: bool
                """

            def hasSnap(self) -> bool:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: Whether the snap field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestDeleteBytes) -> TraceRmi.RequestDeleteBytes.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeRange(self, value: TraceRmi.AddrRange) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            def mergeSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setRange(self, value: TraceRmi.AddrRange) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            @typing.overload
            def setRange(self, builderForValue: TraceRmi.AddrRange.Builder) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range = 3;``
                """

            @typing.overload
            def setSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setSnap(self, builderForValue: TraceRmi.Snap.Builder) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @property
            def rangeBuilder(self) -> TraceRmi.AddrRange.Builder:
                ...

            @property
            def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                ...

            @property
            def rangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
                ...

            @property
            def snapBuilder(self) -> TraceRmi.Snap.Builder:
                ...

            @property
            def range(self) -> TraceRmi.AddrRange:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def snap(self) -> TraceRmi.Snap:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        SNAP_FIELD_NUMBER: typing.Final = 2
        RANGE_FIELD_NUMBER: typing.Final = 3

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getRange(self) -> TraceRmi.AddrRange:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            
            :return: The range.
            :rtype: TraceRmi.AddrRange
            """

        def getRangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasRange(self) -> bool:
            """
            ``.ghidra.rmi.trace.AddrRange range = 3;``
            
            :return: Whether the range field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestDeleteBytes.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestDeleteBytes) -> TraceRmi.RequestDeleteBytes.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteBytes:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestDeleteBytes]:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def rangeOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            ...

        @property
        def range(self) -> TraceRmi.AddrRange:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class ReplyDeleteBytesOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyDeleteBytes(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyDeleteBytesOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyDeleteBytes``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyDeleteBytes.Builder], TraceRmi.ReplyDeleteBytesOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyDeleteBytes``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyDeleteBytes) -> TraceRmi.ReplyDeleteBytes.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyDeleteBytes.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyDeleteBytes) -> TraceRmi.ReplyDeleteBytes.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteBytes:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyDeleteBytes]:
            ...


    class RegValOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getName(self) -> str:
            """
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getValue(self) -> com.google.protobuf.ByteString:
            """
            ``bytes value = 2;``
            
            :return: The value.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def value(self) -> com.google.protobuf.ByteString:
            ...


    class RegVal(com.google.protobuf.GeneratedMessage, TraceRmi.RegValOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RegVal``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RegVal.Builder], TraceRmi.RegValOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RegVal``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearName(self) -> TraceRmi.RegVal.Builder:
                """
                ``string name = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RegVal.Builder
                """

            def clearValue(self) -> TraceRmi.RegVal.Builder:
                """
                ``bytes value = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RegVal.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getName(self) -> str:
                """
                ``string name = 1;``
                
                :return: The name.
                :rtype: str
                """

            def getNameBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string name = 1;``
                
                :return: The bytes for name.
                :rtype: com.google.protobuf.ByteString
                """

            def getValue(self) -> com.google.protobuf.ByteString:
                """
                ``bytes value = 2;``
                
                :return: The value.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.RegVal) -> TraceRmi.RegVal.Builder:
                ...

            def setName(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RegVal.Builder:
                """
                ``string name = 1;``
                
                :param java.lang.String or str value: The name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RegVal.Builder
                """

            def setNameBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RegVal.Builder:
                """
                ``string name = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RegVal.Builder
                """

            def setValue(self, value: com.google.protobuf.ByteString) -> TraceRmi.RegVal.Builder:
                """
                ``bytes value = 2;``
                
                :param com.google.protobuf.ByteString value: The value to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RegVal.Builder
                """

            @property
            def nameBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def name(self) -> java.lang.String:
                ...

            @property
            def value(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        NAME_FIELD_NUMBER: typing.Final = 1
        VALUE_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RegVal:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getName(self) -> str:
            """
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getValue(self) -> com.google.protobuf.ByteString:
            """
            ``bytes value = 2;``
            
            :return: The value.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RegVal.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RegVal) -> TraceRmi.RegVal.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RegVal:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RegVal:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RegVal]:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def value(self) -> com.google.protobuf.ByteString:
            ...


    class RequestPutRegisterValueOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getSpace(self) -> str:
            """
            ``string space = 3;``
            
            :return: The space.
            :rtype: str
            """

        def getSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string space = 3;``
            
            :return: The bytes for space.
            :rtype: com.google.protobuf.ByteString
            """

        def getValues(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RegVal:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def getValuesCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def getValuesList(self) -> java.util.List[TraceRmi.RegVal]:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def getValuesOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RegValOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def getValuesOrBuilderList(self) -> java.util.List[TraceRmi.RegValOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @property
        def valuesCount(self) -> jpype.JInt:
            ...

        @property
        def valuesList(self) -> java.util.List[TraceRmi.RegVal]:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def values(self) -> TraceRmi.RegVal:
            ...

        @property
        def spaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def valuesOrBuilder(self) -> TraceRmi.RegValOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def space(self) -> java.lang.String:
            ...

        @property
        def valuesOrBuilderList(self) -> java.util.List[TraceRmi.RegValOrBuilder]:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class RequestPutRegisterValue(com.google.protobuf.GeneratedMessage, TraceRmi.RequestPutRegisterValueOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestPutRegisterValue``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestPutRegisterValue.Builder], TraceRmi.RequestPutRegisterValueOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestPutRegisterValue``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllValues(self, values: collections.abc.Sequence) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @typing.overload
            def addValues(self, value: TraceRmi.RegVal) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @typing.overload
            def addValues(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.RegVal) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @typing.overload
            def addValues(self, builderForValue: TraceRmi.RegVal.Builder) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @typing.overload
            def addValues(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.RegVal.Builder) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @typing.overload
            def addValuesBuilder(self) -> TraceRmi.RegVal.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @typing.overload
            def addValuesBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RegVal.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            def clearOid(self) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearSnap(self) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def clearSpace(self) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``string space = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestPutRegisterValue.Builder
                """

            def clearValues(self) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getSnap(self) -> TraceRmi.Snap:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: The snap.
                :rtype: TraceRmi.Snap
                """

            def getSnapBuilder(self) -> TraceRmi.Snap.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getSpace(self) -> str:
                """
                ``string space = 3;``
                
                :return: The space.
                :rtype: str
                """

            def getSpaceBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string space = 3;``
                
                :return: The bytes for space.
                :rtype: com.google.protobuf.ByteString
                """

            def getValues(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RegVal:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            def getValuesBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RegVal.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            def getValuesBuilderList(self) -> java.util.List[TraceRmi.RegVal.Builder]:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            def getValuesCount(self) -> int:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            def getValuesList(self) -> java.util.List[TraceRmi.RegVal]:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            def getValuesOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RegValOrBuilder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            def getValuesOrBuilderList(self) -> java.util.List[TraceRmi.RegValOrBuilder]:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasSnap(self) -> bool:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: Whether the snap field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestPutRegisterValue) -> TraceRmi.RequestPutRegisterValue.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def removeValues(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setSnap(self, builderForValue: TraceRmi.Snap.Builder) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def setSpace(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``string space = 3;``
                
                :param java.lang.String or str value: The space to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestPutRegisterValue.Builder
                """

            def setSpaceBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``string space = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for space to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestPutRegisterValue.Builder
                """

            @typing.overload
            def setValues(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.RegVal) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @typing.overload
            def setValues(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.RegVal.Builder) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``repeated .ghidra.rmi.trace.RegVal values = 4;``
                """

            @property
            def values(self) -> TraceRmi.RegVal:
                ...

            @property
            def snapBuilder(self) -> TraceRmi.Snap.Builder:
                ...

            @property
            def valuesOrBuilder(self) -> TraceRmi.RegValOrBuilder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def space(self) -> java.lang.String:
                ...

            @property
            def valuesCount(self) -> jpype.JInt:
                ...

            @property
            def valuesList(self) -> java.util.List[TraceRmi.RegVal]:
                ...

            @property
            def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                ...

            @property
            def spaceBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def valuesBuilder(self) -> TraceRmi.RegVal.Builder:
                ...

            @property
            def valuesOrBuilderList(self) -> java.util.List[TraceRmi.RegValOrBuilder]:
                ...

            @property
            def valuesBuilderList(self) -> java.util.List[TraceRmi.RegVal.Builder]:
                ...

            @property
            def snap(self) -> TraceRmi.Snap:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        SNAP_FIELD_NUMBER: typing.Final = 2
        SPACE_FIELD_NUMBER: typing.Final = 3
        VALUES_FIELD_NUMBER: typing.Final = 4

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getSpace(self) -> str:
            """
            ``string space = 3;``
            
            :return: The space.
            :rtype: str
            """

        def getSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string space = 3;``
            
            :return: The bytes for space.
            :rtype: com.google.protobuf.ByteString
            """

        def getValues(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RegVal:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def getValuesCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def getValuesList(self) -> java.util.List[TraceRmi.RegVal]:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def getValuesOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RegValOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def getValuesOrBuilderList(self) -> java.util.List[TraceRmi.RegValOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.RegVal values = 4;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestPutRegisterValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestPutRegisterValue) -> TraceRmi.RequestPutRegisterValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestPutRegisterValue:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestPutRegisterValue]:
            ...

        @property
        def valuesCount(self) -> jpype.JInt:
            ...

        @property
        def valuesList(self) -> java.util.List[TraceRmi.RegVal]:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def values(self) -> TraceRmi.RegVal:
            ...

        @property
        def spaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def valuesOrBuilder(self) -> TraceRmi.RegValOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def space(self) -> java.lang.String:
            ...

        @property
        def valuesOrBuilderList(self) -> java.util.List[TraceRmi.RegValOrBuilder]:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class ReplyPutRegisterValueOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getSkippedNames(self, index: typing.Union[jpype.JInt, int]) -> str:
            """
            ``repeated string skipped_names = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The skippedNames at the given index.
            :rtype: str
            """

        def getSkippedNamesBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
            """
            ``repeated string skipped_names = 1;``
            
            :param jpype.JInt or int index: The index of the value to return.
            :return: The bytes of the skippedNames at the given index.
            :rtype: com.google.protobuf.ByteString
            """

        def getSkippedNamesCount(self) -> int:
            """
            ``repeated string skipped_names = 1;``
            
            :return: The count of skippedNames.
            :rtype: int
            """

        def getSkippedNamesList(self) -> java.util.List[java.lang.String]:
            """
            ``repeated string skipped_names = 1;``
            
            :return: A list containing the skippedNames.
            :rtype: java.util.List[java.lang.String]
            """

        @property
        def skippedNames(self) -> java.lang.String:
            ...

        @property
        def skippedNamesCount(self) -> jpype.JInt:
            ...

        @property
        def skippedNamesList(self) -> java.util.List[java.lang.String]:
            ...

        @property
        def skippedNamesBytes(self) -> com.google.protobuf.ByteString:
            ...


    class ReplyPutRegisterValue(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyPutRegisterValueOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyPutRegisterValue``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyPutRegisterValue.Builder], TraceRmi.ReplyPutRegisterValueOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyPutRegisterValue``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllSkippedNames(self, values: collections.abc.Sequence) -> TraceRmi.ReplyPutRegisterValue.Builder:
                """
                ``repeated string skipped_names = 1;``
                
                :param collections.abc.Sequence values: The skippedNames to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyPutRegisterValue.Builder
                """

            def addSkippedNames(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.ReplyPutRegisterValue.Builder:
                """
                ``repeated string skipped_names = 1;``
                
                :param java.lang.String or str value: The skippedNames to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyPutRegisterValue.Builder
                """

            def addSkippedNamesBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.ReplyPutRegisterValue.Builder:
                """
                ``repeated string skipped_names = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes of the skippedNames to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyPutRegisterValue.Builder
                """

            def clearSkippedNames(self) -> TraceRmi.ReplyPutRegisterValue.Builder:
                """
                ``repeated string skipped_names = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyPutRegisterValue.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getSkippedNames(self, index: typing.Union[jpype.JInt, int]) -> str:
                """
                ``repeated string skipped_names = 1;``
                
                :param jpype.JInt or int index: The index of the element to return.
                :return: The skippedNames at the given index.
                :rtype: str
                """

            def getSkippedNamesBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
                """
                ``repeated string skipped_names = 1;``
                
                :param jpype.JInt or int index: The index of the value to return.
                :return: The bytes of the skippedNames at the given index.
                :rtype: com.google.protobuf.ByteString
                """

            def getSkippedNamesCount(self) -> int:
                """
                ``repeated string skipped_names = 1;``
                
                :return: The count of skippedNames.
                :rtype: int
                """

            def getSkippedNamesList(self) -> com.google.protobuf.ProtocolStringList:
                """
                ``repeated string skipped_names = 1;``
                
                :return: A list containing the skippedNames.
                :rtype: com.google.protobuf.ProtocolStringList
                """

            def mergeFrom(self, other: TraceRmi.ReplyPutRegisterValue) -> TraceRmi.ReplyPutRegisterValue.Builder:
                ...

            def setSkippedNames(self, index: typing.Union[jpype.JInt, int], value: typing.Union[java.lang.String, str]) -> TraceRmi.ReplyPutRegisterValue.Builder:
                """
                ``repeated string skipped_names = 1;``
                
                :param jpype.JInt or int index: The index to set the value at.
                :param java.lang.String or str value: The skippedNames to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyPutRegisterValue.Builder
                """

            @property
            def skippedNames(self) -> java.lang.String:
                ...

            @property
            def skippedNamesCount(self) -> jpype.JInt:
                ...

            @property
            def skippedNamesList(self) -> com.google.protobuf.ProtocolStringList:
                ...

            @property
            def skippedNamesBytes(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        SKIPPED_NAMES_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getSkippedNames(self, index: typing.Union[jpype.JInt, int]) -> str:
            """
            ``repeated string skipped_names = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The skippedNames at the given index.
            :rtype: str
            """

        def getSkippedNamesBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
            """
            ``repeated string skipped_names = 1;``
            
            :param jpype.JInt or int index: The index of the value to return.
            :return: The bytes of the skippedNames at the given index.
            :rtype: com.google.protobuf.ByteString
            """

        def getSkippedNamesCount(self) -> int:
            """
            ``repeated string skipped_names = 1;``
            
            :return: The count of skippedNames.
            :rtype: int
            """

        def getSkippedNamesList(self) -> com.google.protobuf.ProtocolStringList:
            """
            ``repeated string skipped_names = 1;``
            
            :return: A list containing the skippedNames.
            :rtype: com.google.protobuf.ProtocolStringList
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyPutRegisterValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyPutRegisterValue) -> TraceRmi.ReplyPutRegisterValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyPutRegisterValue]:
            ...

        @property
        def skippedNames(self) -> java.lang.String:
            ...

        @property
        def skippedNamesCount(self) -> jpype.JInt:
            ...

        @property
        def skippedNamesList(self) -> com.google.protobuf.ProtocolStringList:
            ...

        @property
        def skippedNamesBytes(self) -> com.google.protobuf.ByteString:
            ...


    class RequestDeleteRegisterValueOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getNames(self, index: typing.Union[jpype.JInt, int]) -> str:
            """
            ``repeated string names = 4;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The names at the given index.
            :rtype: str
            """

        def getNamesBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
            """
            ``repeated string names = 4;``
            
            :param jpype.JInt or int index: The index of the value to return.
            :return: The bytes of the names at the given index.
            :rtype: com.google.protobuf.ByteString
            """

        def getNamesCount(self) -> int:
            """
            ``repeated string names = 4;``
            
            :return: The count of names.
            :rtype: int
            """

        def getNamesList(self) -> java.util.List[java.lang.String]:
            """
            ``repeated string names = 4;``
            
            :return: A list containing the names.
            :rtype: java.util.List[java.lang.String]
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getSpace(self) -> str:
            """
            ``string space = 3;``
            
            :return: The space.
            :rtype: str
            """

        def getSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string space = 3;``
            
            :return: The bytes for space.
            :rtype: com.google.protobuf.ByteString
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @property
        def names(self) -> java.lang.String:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def namesCount(self) -> jpype.JInt:
            ...

        @property
        def namesList(self) -> java.util.List[java.lang.String]:
            ...

        @property
        def spaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def namesBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def space(self) -> java.lang.String:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class RequestDeleteRegisterValue(com.google.protobuf.GeneratedMessage, TraceRmi.RequestDeleteRegisterValueOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestDeleteRegisterValue``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestDeleteRegisterValue.Builder], TraceRmi.RequestDeleteRegisterValueOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestDeleteRegisterValue``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllNames(self, values: collections.abc.Sequence) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``repeated string names = 4;``
                
                :param collections.abc.Sequence values: The names to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestDeleteRegisterValue.Builder
                """

            def addNames(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``repeated string names = 4;``
                
                :param java.lang.String or str value: The names to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestDeleteRegisterValue.Builder
                """

            def addNamesBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``repeated string names = 4;``
                
                :param com.google.protobuf.ByteString value: The bytes of the names to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestDeleteRegisterValue.Builder
                """

            def clearNames(self) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``repeated string names = 4;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestDeleteRegisterValue.Builder
                """

            def clearOid(self) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearSnap(self) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def clearSpace(self) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``string space = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestDeleteRegisterValue.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getNames(self, index: typing.Union[jpype.JInt, int]) -> str:
                """
                ``repeated string names = 4;``
                
                :param jpype.JInt or int index: The index of the element to return.
                :return: The names at the given index.
                :rtype: str
                """

            def getNamesBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
                """
                ``repeated string names = 4;``
                
                :param jpype.JInt or int index: The index of the value to return.
                :return: The bytes of the names at the given index.
                :rtype: com.google.protobuf.ByteString
                """

            def getNamesCount(self) -> int:
                """
                ``repeated string names = 4;``
                
                :return: The count of names.
                :rtype: int
                """

            def getNamesList(self) -> com.google.protobuf.ProtocolStringList:
                """
                ``repeated string names = 4;``
                
                :return: A list containing the names.
                :rtype: com.google.protobuf.ProtocolStringList
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getSnap(self) -> TraceRmi.Snap:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: The snap.
                :rtype: TraceRmi.Snap
                """

            def getSnapBuilder(self) -> TraceRmi.Snap.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getSpace(self) -> str:
                """
                ``string space = 3;``
                
                :return: The space.
                :rtype: str
                """

            def getSpaceBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string space = 3;``
                
                :return: The bytes for space.
                :rtype: com.google.protobuf.ByteString
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasSnap(self) -> bool:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: Whether the snap field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestDeleteRegisterValue) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def setNames(self, index: typing.Union[jpype.JInt, int], value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``repeated string names = 4;``
                
                :param jpype.JInt or int index: The index to set the value at.
                :param java.lang.String or str value: The names to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestDeleteRegisterValue.Builder
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setSnap(self, builderForValue: TraceRmi.Snap.Builder) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def setSpace(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``string space = 3;``
                
                :param java.lang.String or str value: The space to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestDeleteRegisterValue.Builder
                """

            def setSpaceBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``string space = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for space to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestDeleteRegisterValue.Builder
                """

            @property
            def names(self) -> java.lang.String:
                ...

            @property
            def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                ...

            @property
            def namesCount(self) -> jpype.JInt:
                ...

            @property
            def namesList(self) -> com.google.protobuf.ProtocolStringList:
                ...

            @property
            def spaceBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def snapBuilder(self) -> TraceRmi.Snap.Builder:
                ...

            @property
            def namesBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def space(self) -> java.lang.String:
                ...

            @property
            def snap(self) -> TraceRmi.Snap:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        SNAP_FIELD_NUMBER: typing.Final = 2
        SPACE_FIELD_NUMBER: typing.Final = 3
        NAMES_FIELD_NUMBER: typing.Final = 4

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getNames(self, index: typing.Union[jpype.JInt, int]) -> str:
            """
            ``repeated string names = 4;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The names at the given index.
            :rtype: str
            """

        def getNamesBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
            """
            ``repeated string names = 4;``
            
            :param jpype.JInt or int index: The index of the value to return.
            :return: The bytes of the names at the given index.
            :rtype: com.google.protobuf.ByteString
            """

        def getNamesCount(self) -> int:
            """
            ``repeated string names = 4;``
            
            :return: The count of names.
            :rtype: int
            """

        def getNamesList(self) -> com.google.protobuf.ProtocolStringList:
            """
            ``repeated string names = 4;``
            
            :return: A list containing the names.
            :rtype: com.google.protobuf.ProtocolStringList
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getSpace(self) -> str:
            """
            ``string space = 3;``
            
            :return: The space.
            :rtype: str
            """

        def getSpaceBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string space = 3;``
            
            :return: The bytes for space.
            :rtype: com.google.protobuf.ByteString
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestDeleteRegisterValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestDeleteRegisterValue) -> TraceRmi.RequestDeleteRegisterValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestDeleteRegisterValue]:
            ...

        @property
        def names(self) -> java.lang.String:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def namesCount(self) -> jpype.JInt:
            ...

        @property
        def namesList(self) -> com.google.protobuf.ProtocolStringList:
            ...

        @property
        def spaceBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def namesBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def space(self) -> java.lang.String:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class ReplyDeleteRegisterValueOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyDeleteRegisterValue(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyDeleteRegisterValueOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyDeleteRegisterValue``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyDeleteRegisterValue.Builder], TraceRmi.ReplyDeleteRegisterValueOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyDeleteRegisterValue``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyDeleteRegisterValue) -> TraceRmi.ReplyDeleteRegisterValue.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyDeleteRegisterValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyDeleteRegisterValue) -> TraceRmi.ReplyDeleteRegisterValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyDeleteRegisterValue]:
            ...


    class ObjSpecOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getId(self) -> int:
            """
            ``int64 id = 1;``
            
            :return: The id.
            :rtype: int
            """

        def getKeyCase(self) -> TraceRmi.ObjSpec.KeyCase:
            ...

        def getPath(self) -> TraceRmi.ObjPath:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: The path.
            :rtype: TraceRmi.ObjPath
            """

        def getPathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            """

        def hasId(self) -> bool:
            """
            ``int64 id = 1;``
            
            :return: Whether the id field is set.
            :rtype: bool
            """

        def hasPath(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: Whether the path field is set.
            :rtype: bool
            """

        @property
        def path(self) -> TraceRmi.ObjPath:
            ...

        @property
        def keyCase(self) -> TraceRmi.ObjSpec.KeyCase:
            ...

        @property
        def pathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            ...

        @property
        def id(self) -> jpype.JLong:
            ...


    class ObjSpec(com.google.protobuf.GeneratedMessage, TraceRmi.ObjSpecOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ObjSpec``
        """

        class KeyCase(java.lang.Enum[TraceRmi.ObjSpec.KeyCase], com.google.protobuf.Internal.EnumLite, com.google.protobuf.AbstractMessageLite.InternalOneOfEnum):

            class_: typing.ClassVar[java.lang.Class]
            ID: typing.Final[TraceRmi.ObjSpec.KeyCase]
            PATH: typing.Final[TraceRmi.ObjSpec.KeyCase]
            KEY_NOT_SET: typing.Final[TraceRmi.ObjSpec.KeyCase]

            @staticmethod
            def forNumber(value: typing.Union[jpype.JInt, int]) -> TraceRmi.ObjSpec.KeyCase:
                ...

            def getNumber(self) -> int:
                ...

            @staticmethod
            @typing.overload
            def valueOf(name: typing.Union[java.lang.String, str]) -> TraceRmi.ObjSpec.KeyCase:
                ...

            @staticmethod
            @typing.overload
            @deprecated("Use forNumber(int) instead.")
            def valueOf(value: typing.Union[jpype.JInt, int]) -> TraceRmi.ObjSpec.KeyCase:
                """
                
                
                :param jpype.JInt or int value: The number of the enum to look for.
                :return: The enum associated with the given number.
                :rtype: TraceRmi.ObjSpec.KeyCase
                
                .. deprecated::
                
                Use :meth:`forNumber(int) <.forNumber>` instead.
                """

            @staticmethod
            def values() -> jpype.JArray[TraceRmi.ObjSpec.KeyCase]:
                ...

            @property
            def number(self) -> jpype.JInt:
                ...


        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ObjSpec.Builder], TraceRmi.ObjSpecOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ObjSpec``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearId(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``int64 id = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ObjSpec.Builder
                """

            def clearKey(self) -> TraceRmi.ObjSpec.Builder:
                ...

            def clearPath(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getId(self) -> int:
                """
                ``int64 id = 1;``
                
                :return: The id.
                :rtype: int
                """

            def getKeyCase(self) -> TraceRmi.ObjSpec.KeyCase:
                ...

            def getPath(self) -> TraceRmi.ObjPath:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                
                :return: The path.
                :rtype: TraceRmi.ObjPath
                """

            def getPathBuilder(self) -> TraceRmi.ObjPath.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            def getPathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            def hasId(self) -> bool:
                """
                ``int64 id = 1;``
                
                :return: Whether the id field is set.
                :rtype: bool
                """

            def hasPath(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                
                :return: Whether the path field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.ObjSpec) -> TraceRmi.ObjSpec.Builder:
                ...

            def mergePath(self, value: TraceRmi.ObjPath) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            def setId(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.ObjSpec.Builder:
                """
                ``int64 id = 1;``
                
                :param jpype.JLong or int value: The id to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ObjSpec.Builder
                """

            @typing.overload
            def setPath(self, value: TraceRmi.ObjPath) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @typing.overload
            def setPath(self, builderForValue: TraceRmi.ObjPath.Builder) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @property
            def path(self) -> TraceRmi.ObjPath:
                ...

            @property
            def keyCase(self) -> TraceRmi.ObjSpec.KeyCase:
                ...

            @property
            def pathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
                ...

            @property
            def id(self) -> jpype.JLong:
                ...

            @property
            def pathBuilder(self) -> TraceRmi.ObjPath.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ID_FIELD_NUMBER: typing.Final = 1
        PATH_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getId(self) -> int:
            """
            ``int64 id = 1;``
            
            :return: The id.
            :rtype: int
            """

        def getKeyCase(self) -> TraceRmi.ObjSpec.KeyCase:
            ...

        def getPath(self) -> TraceRmi.ObjPath:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: The path.
            :rtype: TraceRmi.ObjPath
            """

        def getPathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            """

        def hasId(self) -> bool:
            """
            ``int64 id = 1;``
            
            :return: Whether the id field is set.
            :rtype: bool
            """

        def hasPath(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: Whether the path field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ObjSpec.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ObjSpec) -> TraceRmi.ObjSpec.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjSpec:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ObjSpec]:
            ...

        @property
        def path(self) -> TraceRmi.ObjPath:
            ...

        @property
        def keyCase(self) -> TraceRmi.ObjSpec.KeyCase:
            ...

        @property
        def pathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            ...

        @property
        def id(self) -> jpype.JLong:
            ...


    class ObjDescOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getId(self) -> int:
            """
            ``int64 id = 1;``
            
            :return: The id.
            :rtype: int
            """

        def getPath(self) -> TraceRmi.ObjPath:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: The path.
            :rtype: TraceRmi.ObjPath
            """

        def getPathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            """

        def hasPath(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: Whether the path field is set.
            :rtype: bool
            """

        @property
        def path(self) -> TraceRmi.ObjPath:
            ...

        @property
        def pathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            ...

        @property
        def id(self) -> jpype.JLong:
            ...


    class ObjDesc(com.google.protobuf.GeneratedMessage, TraceRmi.ObjDescOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ObjDesc``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ObjDesc.Builder], TraceRmi.ObjDescOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ObjDesc``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearId(self) -> TraceRmi.ObjDesc.Builder:
                """
                ``int64 id = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ObjDesc.Builder
                """

            def clearPath(self) -> TraceRmi.ObjDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getId(self) -> int:
                """
                ``int64 id = 1;``
                
                :return: The id.
                :rtype: int
                """

            def getPath(self) -> TraceRmi.ObjPath:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                
                :return: The path.
                :rtype: TraceRmi.ObjPath
                """

            def getPathBuilder(self) -> TraceRmi.ObjPath.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            def getPathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            def hasPath(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                
                :return: Whether the path field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.ObjDesc) -> TraceRmi.ObjDesc.Builder:
                ...

            def mergePath(self, value: TraceRmi.ObjPath) -> TraceRmi.ObjDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            def setId(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.ObjDesc.Builder:
                """
                ``int64 id = 1;``
                
                :param jpype.JLong or int value: The id to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ObjDesc.Builder
                """

            @typing.overload
            def setPath(self, value: TraceRmi.ObjPath) -> TraceRmi.ObjDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @typing.overload
            def setPath(self, builderForValue: TraceRmi.ObjPath.Builder) -> TraceRmi.ObjDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @property
            def path(self) -> TraceRmi.ObjPath:
                ...

            @property
            def pathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
                ...

            @property
            def id(self) -> jpype.JLong:
                ...

            @property
            def pathBuilder(self) -> TraceRmi.ObjPath.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ID_FIELD_NUMBER: typing.Final = 1
        PATH_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getId(self) -> int:
            """
            ``int64 id = 1;``
            
            :return: The id.
            :rtype: int
            """

        def getPath(self) -> TraceRmi.ObjPath:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: The path.
            :rtype: TraceRmi.ObjPath
            """

        def getPathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            """

        def hasPath(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: Whether the path field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ObjDesc.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ObjDesc) -> TraceRmi.ObjDesc.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ObjDesc:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ObjDesc]:
            ...

        @property
        def path(self) -> TraceRmi.ObjPath:
            ...

        @property
        def pathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            ...

        @property
        def id(self) -> jpype.JLong:
            ...


    class ValSpecOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getKey(self) -> str:
            """
            ``string key = 3;``
            
            :return: The key.
            :rtype: str
            """

        def getKeyBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string key = 3;``
            
            :return: The bytes for key.
            :rtype: com.google.protobuf.ByteString
            """

        def getParent(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec parent = 1;``
            
            :return: The parent.
            :rtype: TraceRmi.ObjSpec
            """

        def getParentOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec parent = 1;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            """

        def getValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            
            :return: The value.
            :rtype: TraceRmi.Value
            """

        def getValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            """

        def hasParent(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec parent = 1;``
            
            :return: Whether the parent field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        def hasValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            
            :return: Whether the value field is set.
            :rtype: bool
            """

        @property
        def parent(self) -> TraceRmi.ObjSpec:
            ...

        @property
        def keyBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def valueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def value(self) -> TraceRmi.Value:
            ...

        @property
        def parentOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def key(self) -> java.lang.String:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class ValSpec(com.google.protobuf.GeneratedMessage, TraceRmi.ValSpecOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ValSpec``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ValSpec.Builder], TraceRmi.ValSpecOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ValSpec``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearKey(self) -> TraceRmi.ValSpec.Builder:
                """
                ``string key = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ValSpec.Builder
                """

            def clearParent(self) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec parent = 1;``
                """

            def clearSpan(self) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def clearValue(self) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getKey(self) -> str:
                """
                ``string key = 3;``
                
                :return: The key.
                :rtype: str
                """

            def getKeyBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string key = 3;``
                
                :return: The bytes for key.
                :rtype: com.google.protobuf.ByteString
                """

            def getParent(self) -> TraceRmi.ObjSpec:
                """
                ``.ghidra.rmi.trace.ObjSpec parent = 1;``
                
                :return: The parent.
                :rtype: TraceRmi.ObjSpec
                """

            def getParentBuilder(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec parent = 1;``
                """

            def getParentOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjSpec parent = 1;``
                """

            def getSpan(self) -> TraceRmi.Span:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                
                :return: The span.
                :rtype: TraceRmi.Span
                """

            def getSpanBuilder(self) -> TraceRmi.Span.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def getValue(self) -> TraceRmi.Value:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                
                :return: The value.
                :rtype: TraceRmi.Value
                """

            def getValueBuilder(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            def getValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            def hasParent(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjSpec parent = 1;``
                
                :return: Whether the parent field is set.
                :rtype: bool
                """

            def hasSpan(self) -> bool:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                
                :return: Whether the span field is set.
                :rtype: bool
                """

            def hasValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                
                :return: Whether the value field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.ValSpec) -> TraceRmi.ValSpec.Builder:
                ...

            def mergeParent(self, value: TraceRmi.ObjSpec) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec parent = 1;``
                """

            def mergeSpan(self, value: TraceRmi.Span) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def mergeValue(self, value: TraceRmi.Value) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            def setKey(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.ValSpec.Builder:
                """
                ``string key = 3;``
                
                :param java.lang.String or str value: The key to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ValSpec.Builder
                """

            def setKeyBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.ValSpec.Builder:
                """
                ``string key = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for key to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ValSpec.Builder
                """

            @typing.overload
            def setParent(self, value: TraceRmi.ObjSpec) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec parent = 1;``
                """

            @typing.overload
            def setParent(self, builderForValue: TraceRmi.ObjSpec.Builder) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec parent = 1;``
                """

            @typing.overload
            def setSpan(self, value: TraceRmi.Span) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            @typing.overload
            def setSpan(self, builderForValue: TraceRmi.Span.Builder) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            @typing.overload
            def setValue(self, value: TraceRmi.Value) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            @typing.overload
            def setValue(self, builderForValue: TraceRmi.Value.Builder) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            @property
            def parentBuilder(self) -> TraceRmi.ObjSpec.Builder:
                ...

            @property
            def parent(self) -> TraceRmi.ObjSpec:
                ...

            @property
            def keyBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def valueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                ...

            @property
            def valueBuilder(self) -> TraceRmi.Value.Builder:
                ...

            @property
            def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                ...

            @property
            def spanBuilder(self) -> TraceRmi.Span.Builder:
                ...

            @property
            def value(self) -> TraceRmi.Value:
                ...

            @property
            def parentOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                ...

            @property
            def key(self) -> java.lang.String:
                ...

            @property
            def span(self) -> TraceRmi.Span:
                ...


        class_: typing.ClassVar[java.lang.Class]
        PARENT_FIELD_NUMBER: typing.Final = 1
        SPAN_FIELD_NUMBER: typing.Final = 2
        KEY_FIELD_NUMBER: typing.Final = 3
        VALUE_FIELD_NUMBER: typing.Final = 4

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ValSpec:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getKey(self) -> str:
            """
            ``string key = 3;``
            
            :return: The key.
            :rtype: str
            """

        def getKeyBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string key = 3;``
            
            :return: The bytes for key.
            :rtype: com.google.protobuf.ByteString
            """

        def getParent(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec parent = 1;``
            
            :return: The parent.
            :rtype: TraceRmi.ObjSpec
            """

        def getParentOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec parent = 1;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            """

        def getValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            
            :return: The value.
            :rtype: TraceRmi.Value
            """

        def getValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            """

        def hasParent(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec parent = 1;``
            
            :return: Whether the parent field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        def hasValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            
            :return: Whether the value field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ValSpec.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ValSpec) -> TraceRmi.ValSpec.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValSpec:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ValSpec]:
            ...

        @property
        def parent(self) -> TraceRmi.ObjSpec:
            ...

        @property
        def keyBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def valueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def value(self) -> TraceRmi.Value:
            ...

        @property
        def parentOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def key(self) -> java.lang.String:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class ValDescOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getKey(self) -> str:
            """
            ``string key = 3;``
            
            :return: The key.
            :rtype: str
            """

        def getKeyBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string key = 3;``
            
            :return: The bytes for key.
            :rtype: com.google.protobuf.ByteString
            """

        def getParent(self) -> TraceRmi.ObjDesc:
            """
            ``.ghidra.rmi.trace.ObjDesc parent = 1;``
            
            :return: The parent.
            :rtype: TraceRmi.ObjDesc
            """

        def getParentOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjDesc parent = 1;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            """

        def getValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            
            :return: The value.
            :rtype: TraceRmi.Value
            """

        def getValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            """

        def hasParent(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjDesc parent = 1;``
            
            :return: Whether the parent field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        def hasValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            
            :return: Whether the value field is set.
            :rtype: bool
            """

        @property
        def parent(self) -> TraceRmi.ObjDesc:
            ...

        @property
        def keyBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def valueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def value(self) -> TraceRmi.Value:
            ...

        @property
        def parentOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            ...

        @property
        def key(self) -> java.lang.String:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class ValDesc(com.google.protobuf.GeneratedMessage, TraceRmi.ValDescOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ValDesc``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ValDesc.Builder], TraceRmi.ValDescOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ValDesc``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearKey(self) -> TraceRmi.ValDesc.Builder:
                """
                ``string key = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ValDesc.Builder
                """

            def clearParent(self) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc parent = 1;``
                """

            def clearSpan(self) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def clearValue(self) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getKey(self) -> str:
                """
                ``string key = 3;``
                
                :return: The key.
                :rtype: str
                """

            def getKeyBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string key = 3;``
                
                :return: The bytes for key.
                :rtype: com.google.protobuf.ByteString
                """

            def getParent(self) -> TraceRmi.ObjDesc:
                """
                ``.ghidra.rmi.trace.ObjDesc parent = 1;``
                
                :return: The parent.
                :rtype: TraceRmi.ObjDesc
                """

            def getParentBuilder(self) -> TraceRmi.ObjDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc parent = 1;``
                """

            def getParentOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjDesc parent = 1;``
                """

            def getSpan(self) -> TraceRmi.Span:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                
                :return: The span.
                :rtype: TraceRmi.Span
                """

            def getSpanBuilder(self) -> TraceRmi.Span.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def getValue(self) -> TraceRmi.Value:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                
                :return: The value.
                :rtype: TraceRmi.Value
                """

            def getValueBuilder(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            def getValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            def hasParent(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjDesc parent = 1;``
                
                :return: Whether the parent field is set.
                :rtype: bool
                """

            def hasSpan(self) -> bool:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                
                :return: Whether the span field is set.
                :rtype: bool
                """

            def hasValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                
                :return: Whether the value field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.ValDesc) -> TraceRmi.ValDesc.Builder:
                ...

            def mergeParent(self, value: TraceRmi.ObjDesc) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc parent = 1;``
                """

            def mergeSpan(self, value: TraceRmi.Span) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def mergeValue(self, value: TraceRmi.Value) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            def setKey(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.ValDesc.Builder:
                """
                ``string key = 3;``
                
                :param java.lang.String or str value: The key to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ValDesc.Builder
                """

            def setKeyBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.ValDesc.Builder:
                """
                ``string key = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for key to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ValDesc.Builder
                """

            @typing.overload
            def setParent(self, value: TraceRmi.ObjDesc) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc parent = 1;``
                """

            @typing.overload
            def setParent(self, builderForValue: TraceRmi.ObjDesc.Builder) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc parent = 1;``
                """

            @typing.overload
            def setSpan(self, value: TraceRmi.Span) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            @typing.overload
            def setSpan(self, builderForValue: TraceRmi.Span.Builder) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            @typing.overload
            def setValue(self, value: TraceRmi.Value) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            @typing.overload
            def setValue(self, builderForValue: TraceRmi.Value.Builder) -> TraceRmi.ValDesc.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 4;``
                """

            @property
            def parentBuilder(self) -> TraceRmi.ObjDesc.Builder:
                ...

            @property
            def parent(self) -> TraceRmi.ObjDesc:
                ...

            @property
            def keyBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def valueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                ...

            @property
            def valueBuilder(self) -> TraceRmi.Value.Builder:
                ...

            @property
            def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                ...

            @property
            def spanBuilder(self) -> TraceRmi.Span.Builder:
                ...

            @property
            def value(self) -> TraceRmi.Value:
                ...

            @property
            def parentOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
                ...

            @property
            def key(self) -> java.lang.String:
                ...

            @property
            def span(self) -> TraceRmi.Span:
                ...


        class_: typing.ClassVar[java.lang.Class]
        PARENT_FIELD_NUMBER: typing.Final = 1
        SPAN_FIELD_NUMBER: typing.Final = 2
        KEY_FIELD_NUMBER: typing.Final = 3
        VALUE_FIELD_NUMBER: typing.Final = 4

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ValDesc:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getKey(self) -> str:
            """
            ``string key = 3;``
            
            :return: The key.
            :rtype: str
            """

        def getKeyBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string key = 3;``
            
            :return: The bytes for key.
            :rtype: com.google.protobuf.ByteString
            """

        def getParent(self) -> TraceRmi.ObjDesc:
            """
            ``.ghidra.rmi.trace.ObjDesc parent = 1;``
            
            :return: The parent.
            :rtype: TraceRmi.ObjDesc
            """

        def getParentOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjDesc parent = 1;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            """

        def getValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            
            :return: The value.
            :rtype: TraceRmi.Value
            """

        def getValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            """

        def hasParent(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjDesc parent = 1;``
            
            :return: Whether the parent field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        def hasValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value value = 4;``
            
            :return: Whether the value field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ValDesc.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ValDesc) -> TraceRmi.ValDesc.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValDesc:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ValDesc]:
            ...

        @property
        def parent(self) -> TraceRmi.ObjDesc:
            ...

        @property
        def keyBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def valueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def value(self) -> TraceRmi.Value:
            ...

        @property
        def parentOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            ...

        @property
        def key(self) -> java.lang.String:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class NullOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class Null(com.google.protobuf.GeneratedMessage, TraceRmi.NullOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Null``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Null.Builder], TraceRmi.NullOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Null``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.Null) -> TraceRmi.Null.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Null:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Null.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Null) -> TraceRmi.Null.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Null:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Null:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Null]:
            ...


    class BoolArrOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> bool:
            """
            ``repeated bool arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: bool
            """

        def getArrCount(self) -> int:
            """
            ``repeated bool arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> java.util.List[java.lang.Boolean]:
            """
            ``repeated bool arr = 1;``
            
            :return: A list containing the arr.
            :rtype: java.util.List[java.lang.Boolean]
            """

        @property
        def arrList(self) -> java.util.List[java.lang.Boolean]:
            ...

        @property
        def arr(self) -> jpype.JBoolean:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class BoolArr(com.google.protobuf.GeneratedMessage, TraceRmi.BoolArrOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.BoolArr``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.BoolArr.Builder], TraceRmi.BoolArrOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.BoolArr``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllArr(self, values: collections.abc.Sequence) -> TraceRmi.BoolArr.Builder:
                """
                ``repeated bool arr = 1;``
                
                :param collections.abc.Sequence values: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.BoolArr.Builder
                """

            def addArr(self, value: typing.Union[jpype.JBoolean, bool]) -> TraceRmi.BoolArr.Builder:
                """
                ``repeated bool arr = 1;``
                
                :param jpype.JBoolean or bool value: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.BoolArr.Builder
                """

            def clearArr(self) -> TraceRmi.BoolArr.Builder:
                """
                ``repeated bool arr = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.BoolArr.Builder
                """

            def getArr(self, index: typing.Union[jpype.JInt, int]) -> bool:
                """
                ``repeated bool arr = 1;``
                
                :param jpype.JInt or int index: The index of the element to return.
                :return: The arr at the given index.
                :rtype: bool
                """

            def getArrCount(self) -> int:
                """
                ``repeated bool arr = 1;``
                
                :return: The count of arr.
                :rtype: int
                """

            def getArrList(self) -> java.util.List[java.lang.Boolean]:
                """
                ``repeated bool arr = 1;``
                
                :return: A list containing the arr.
                :rtype: java.util.List[java.lang.Boolean]
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.BoolArr) -> TraceRmi.BoolArr.Builder:
                ...

            def setArr(self, index: typing.Union[jpype.JInt, int], value: typing.Union[jpype.JBoolean, bool]) -> TraceRmi.BoolArr.Builder:
                """
                ``repeated bool arr = 1;``
                
                :param jpype.JInt or int index: The index to set the value at.
                :param jpype.JBoolean or bool value: The arr to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.BoolArr.Builder
                """

            @property
            def arrList(self) -> java.util.List[java.lang.Boolean]:
                ...

            @property
            def arr(self) -> jpype.JBoolean:
                ...

            @property
            def arrCount(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ARR_FIELD_NUMBER: typing.Final = 1

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> bool:
            """
            ``repeated bool arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: bool
            """

        def getArrCount(self) -> int:
            """
            ``repeated bool arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> java.util.List[java.lang.Boolean]:
            """
            ``repeated bool arr = 1;``
            
            :return: A list containing the arr.
            :rtype: java.util.List[java.lang.Boolean]
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.BoolArr:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.BoolArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.BoolArr) -> TraceRmi.BoolArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.BoolArr:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.BoolArr]:
            ...

        @property
        def arrList(self) -> java.util.List[java.lang.Boolean]:
            ...

        @property
        def arr(self) -> jpype.JBoolean:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class ShortArrOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> int:
            """
            ``repeated int32 arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: int
            """

        def getArrCount(self) -> int:
            """
            ``repeated int32 arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> java.util.List[java.lang.Integer]:
            """
            ``repeated int32 arr = 1;``
            
            :return: A list containing the arr.
            :rtype: java.util.List[java.lang.Integer]
            """

        @property
        def arrList(self) -> java.util.List[java.lang.Integer]:
            ...

        @property
        def arr(self) -> jpype.JInt:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class ShortArr(com.google.protobuf.GeneratedMessage, TraceRmi.ShortArrOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ShortArr``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ShortArr.Builder], TraceRmi.ShortArrOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ShortArr``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllArr(self, values: collections.abc.Sequence) -> TraceRmi.ShortArr.Builder:
                """
                ``repeated int32 arr = 1;``
                
                :param collections.abc.Sequence values: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.ShortArr.Builder
                """

            def addArr(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.ShortArr.Builder:
                """
                ``repeated int32 arr = 1;``
                
                :param jpype.JInt or int value: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.ShortArr.Builder
                """

            def clearArr(self) -> TraceRmi.ShortArr.Builder:
                """
                ``repeated int32 arr = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ShortArr.Builder
                """

            def getArr(self, index: typing.Union[jpype.JInt, int]) -> int:
                """
                ``repeated int32 arr = 1;``
                
                :param jpype.JInt or int index: The index of the element to return.
                :return: The arr at the given index.
                :rtype: int
                """

            def getArrCount(self) -> int:
                """
                ``repeated int32 arr = 1;``
                
                :return: The count of arr.
                :rtype: int
                """

            def getArrList(self) -> java.util.List[java.lang.Integer]:
                """
                ``repeated int32 arr = 1;``
                
                :return: A list containing the arr.
                :rtype: java.util.List[java.lang.Integer]
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ShortArr) -> TraceRmi.ShortArr.Builder:
                ...

            def setArr(self, index: typing.Union[jpype.JInt, int], value: typing.Union[jpype.JInt, int]) -> TraceRmi.ShortArr.Builder:
                """
                ``repeated int32 arr = 1;``
                
                :param jpype.JInt or int index: The index to set the value at.
                :param jpype.JInt or int value: The arr to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ShortArr.Builder
                """

            @property
            def arrList(self) -> java.util.List[java.lang.Integer]:
                ...

            @property
            def arr(self) -> jpype.JInt:
                ...

            @property
            def arrCount(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ARR_FIELD_NUMBER: typing.Final = 1

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> int:
            """
            ``repeated int32 arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: int
            """

        def getArrCount(self) -> int:
            """
            ``repeated int32 arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> java.util.List[java.lang.Integer]:
            """
            ``repeated int32 arr = 1;``
            
            :return: A list containing the arr.
            :rtype: java.util.List[java.lang.Integer]
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ShortArr:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ShortArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ShortArr) -> TraceRmi.ShortArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ShortArr:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ShortArr]:
            ...

        @property
        def arrList(self) -> java.util.List[java.lang.Integer]:
            ...

        @property
        def arr(self) -> jpype.JInt:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class IntArrOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> int:
            """
            ``repeated int32 arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: int
            """

        def getArrCount(self) -> int:
            """
            ``repeated int32 arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> java.util.List[java.lang.Integer]:
            """
            ``repeated int32 arr = 1;``
            
            :return: A list containing the arr.
            :rtype: java.util.List[java.lang.Integer]
            """

        @property
        def arrList(self) -> java.util.List[java.lang.Integer]:
            ...

        @property
        def arr(self) -> jpype.JInt:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class IntArr(com.google.protobuf.GeneratedMessage, TraceRmi.IntArrOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.IntArr``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.IntArr.Builder], TraceRmi.IntArrOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.IntArr``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllArr(self, values: collections.abc.Sequence) -> TraceRmi.IntArr.Builder:
                """
                ``repeated int32 arr = 1;``
                
                :param collections.abc.Sequence values: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.IntArr.Builder
                """

            def addArr(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.IntArr.Builder:
                """
                ``repeated int32 arr = 1;``
                
                :param jpype.JInt or int value: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.IntArr.Builder
                """

            def clearArr(self) -> TraceRmi.IntArr.Builder:
                """
                ``repeated int32 arr = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.IntArr.Builder
                """

            def getArr(self, index: typing.Union[jpype.JInt, int]) -> int:
                """
                ``repeated int32 arr = 1;``
                
                :param jpype.JInt or int index: The index of the element to return.
                :return: The arr at the given index.
                :rtype: int
                """

            def getArrCount(self) -> int:
                """
                ``repeated int32 arr = 1;``
                
                :return: The count of arr.
                :rtype: int
                """

            def getArrList(self) -> java.util.List[java.lang.Integer]:
                """
                ``repeated int32 arr = 1;``
                
                :return: A list containing the arr.
                :rtype: java.util.List[java.lang.Integer]
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.IntArr) -> TraceRmi.IntArr.Builder:
                ...

            def setArr(self, index: typing.Union[jpype.JInt, int], value: typing.Union[jpype.JInt, int]) -> TraceRmi.IntArr.Builder:
                """
                ``repeated int32 arr = 1;``
                
                :param jpype.JInt or int index: The index to set the value at.
                :param jpype.JInt or int value: The arr to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.IntArr.Builder
                """

            @property
            def arrList(self) -> java.util.List[java.lang.Integer]:
                ...

            @property
            def arr(self) -> jpype.JInt:
                ...

            @property
            def arrCount(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ARR_FIELD_NUMBER: typing.Final = 1

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> int:
            """
            ``repeated int32 arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: int
            """

        def getArrCount(self) -> int:
            """
            ``repeated int32 arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> java.util.List[java.lang.Integer]:
            """
            ``repeated int32 arr = 1;``
            
            :return: A list containing the arr.
            :rtype: java.util.List[java.lang.Integer]
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.IntArr:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.IntArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.IntArr) -> TraceRmi.IntArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.IntArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.IntArr:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.IntArr]:
            ...

        @property
        def arrList(self) -> java.util.List[java.lang.Integer]:
            ...

        @property
        def arr(self) -> jpype.JInt:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class LongArrOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> int:
            """
            ``repeated int64 arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: int
            """

        def getArrCount(self) -> int:
            """
            ``repeated int64 arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> java.util.List[java.lang.Long]:
            """
            ``repeated int64 arr = 1;``
            
            :return: A list containing the arr.
            :rtype: java.util.List[java.lang.Long]
            """

        @property
        def arrList(self) -> java.util.List[java.lang.Long]:
            ...

        @property
        def arr(self) -> jpype.JLong:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class LongArr(com.google.protobuf.GeneratedMessage, TraceRmi.LongArrOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.LongArr``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.LongArr.Builder], TraceRmi.LongArrOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.LongArr``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllArr(self, values: collections.abc.Sequence) -> TraceRmi.LongArr.Builder:
                """
                ``repeated int64 arr = 1;``
                
                :param collections.abc.Sequence values: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.LongArr.Builder
                """

            def addArr(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.LongArr.Builder:
                """
                ``repeated int64 arr = 1;``
                
                :param jpype.JLong or int value: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.LongArr.Builder
                """

            def clearArr(self) -> TraceRmi.LongArr.Builder:
                """
                ``repeated int64 arr = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.LongArr.Builder
                """

            def getArr(self, index: typing.Union[jpype.JInt, int]) -> int:
                """
                ``repeated int64 arr = 1;``
                
                :param jpype.JInt or int index: The index of the element to return.
                :return: The arr at the given index.
                :rtype: int
                """

            def getArrCount(self) -> int:
                """
                ``repeated int64 arr = 1;``
                
                :return: The count of arr.
                :rtype: int
                """

            def getArrList(self) -> java.util.List[java.lang.Long]:
                """
                ``repeated int64 arr = 1;``
                
                :return: A list containing the arr.
                :rtype: java.util.List[java.lang.Long]
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.LongArr) -> TraceRmi.LongArr.Builder:
                ...

            def setArr(self, index: typing.Union[jpype.JInt, int], value: typing.Union[jpype.JLong, int]) -> TraceRmi.LongArr.Builder:
                """
                ``repeated int64 arr = 1;``
                
                :param jpype.JInt or int index: The index to set the value at.
                :param jpype.JLong or int value: The arr to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.LongArr.Builder
                """

            @property
            def arrList(self) -> java.util.List[java.lang.Long]:
                ...

            @property
            def arr(self) -> jpype.JLong:
                ...

            @property
            def arrCount(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ARR_FIELD_NUMBER: typing.Final = 1

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> int:
            """
            ``repeated int64 arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: int
            """

        def getArrCount(self) -> int:
            """
            ``repeated int64 arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> java.util.List[java.lang.Long]:
            """
            ``repeated int64 arr = 1;``
            
            :return: A list containing the arr.
            :rtype: java.util.List[java.lang.Long]
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.LongArr:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.LongArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.LongArr) -> TraceRmi.LongArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.LongArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.LongArr:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.LongArr]:
            ...

        @property
        def arrList(self) -> java.util.List[java.lang.Long]:
            ...

        @property
        def arr(self) -> jpype.JLong:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class StringArrOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> str:
            """
            ``repeated string arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: str
            """

        def getArrBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
            """
            ``repeated string arr = 1;``
            
            :param jpype.JInt or int index: The index of the value to return.
            :return: The bytes of the arr at the given index.
            :rtype: com.google.protobuf.ByteString
            """

        def getArrCount(self) -> int:
            """
            ``repeated string arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> java.util.List[java.lang.String]:
            """
            ``repeated string arr = 1;``
            
            :return: A list containing the arr.
            :rtype: java.util.List[java.lang.String]
            """

        @property
        def arrList(self) -> java.util.List[java.lang.String]:
            ...

        @property
        def arr(self) -> java.lang.String:
            ...

        @property
        def arrBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class StringArr(com.google.protobuf.GeneratedMessage, TraceRmi.StringArrOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.StringArr``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.StringArr.Builder], TraceRmi.StringArrOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.StringArr``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllArr(self, values: collections.abc.Sequence) -> TraceRmi.StringArr.Builder:
                """
                ``repeated string arr = 1;``
                
                :param collections.abc.Sequence values: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.StringArr.Builder
                """

            def addArr(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.StringArr.Builder:
                """
                ``repeated string arr = 1;``
                
                :param java.lang.String or str value: The arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.StringArr.Builder
                """

            def addArrBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.StringArr.Builder:
                """
                ``repeated string arr = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes of the arr to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.StringArr.Builder
                """

            def clearArr(self) -> TraceRmi.StringArr.Builder:
                """
                ``repeated string arr = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.StringArr.Builder
                """

            def getArr(self, index: typing.Union[jpype.JInt, int]) -> str:
                """
                ``repeated string arr = 1;``
                
                :param jpype.JInt or int index: The index of the element to return.
                :return: The arr at the given index.
                :rtype: str
                """

            def getArrBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
                """
                ``repeated string arr = 1;``
                
                :param jpype.JInt or int index: The index of the value to return.
                :return: The bytes of the arr at the given index.
                :rtype: com.google.protobuf.ByteString
                """

            def getArrCount(self) -> int:
                """
                ``repeated string arr = 1;``
                
                :return: The count of arr.
                :rtype: int
                """

            def getArrList(self) -> com.google.protobuf.ProtocolStringList:
                """
                ``repeated string arr = 1;``
                
                :return: A list containing the arr.
                :rtype: com.google.protobuf.ProtocolStringList
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.StringArr) -> TraceRmi.StringArr.Builder:
                ...

            def setArr(self, index: typing.Union[jpype.JInt, int], value: typing.Union[java.lang.String, str]) -> TraceRmi.StringArr.Builder:
                """
                ``repeated string arr = 1;``
                
                :param jpype.JInt or int index: The index to set the value at.
                :param java.lang.String or str value: The arr to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.StringArr.Builder
                """

            @property
            def arrList(self) -> com.google.protobuf.ProtocolStringList:
                ...

            @property
            def arr(self) -> java.lang.String:
                ...

            @property
            def arrBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def arrCount(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ARR_FIELD_NUMBER: typing.Final = 1

        def getArr(self, index: typing.Union[jpype.JInt, int]) -> str:
            """
            ``repeated string arr = 1;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The arr at the given index.
            :rtype: str
            """

        def getArrBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
            """
            ``repeated string arr = 1;``
            
            :param jpype.JInt or int index: The index of the value to return.
            :return: The bytes of the arr at the given index.
            :rtype: com.google.protobuf.ByteString
            """

        def getArrCount(self) -> int:
            """
            ``repeated string arr = 1;``
            
            :return: The count of arr.
            :rtype: int
            """

        def getArrList(self) -> com.google.protobuf.ProtocolStringList:
            """
            ``repeated string arr = 1;``
            
            :return: A list containing the arr.
            :rtype: com.google.protobuf.ProtocolStringList
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.StringArr:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.StringArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.StringArr) -> TraceRmi.StringArr.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.StringArr:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.StringArr:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.StringArr]:
            ...

        @property
        def arrList(self) -> com.google.protobuf.ProtocolStringList:
            ...

        @property
        def arr(self) -> java.lang.String:
            ...

        @property
        def arrBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def arrCount(self) -> jpype.JInt:
            ...


    class ValueTypeOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getName(self) -> str:
            """
            
            Names from schema context
             
            
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            
            Names from schema context
             
            
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def name(self) -> java.lang.String:
            ...


    class ValueType(com.google.protobuf.GeneratedMessage, TraceRmi.ValueTypeOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ValueType``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ValueType.Builder], TraceRmi.ValueTypeOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ValueType``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearName(self) -> TraceRmi.ValueType.Builder:
                """
                
                Names from schema context
                 
                
                ``string name = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ValueType.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getName(self) -> str:
                """
                
                Names from schema context
                 
                
                ``string name = 1;``
                
                :return: The name.
                :rtype: str
                """

            def getNameBytes(self) -> com.google.protobuf.ByteString:
                """
                
                Names from schema context
                 
                
                ``string name = 1;``
                
                :return: The bytes for name.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.ValueType) -> TraceRmi.ValueType.Builder:
                ...

            def setName(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.ValueType.Builder:
                """
                
                Names from schema context
                 
                
                ``string name = 1;``
                
                :param java.lang.String or str value: The name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ValueType.Builder
                """

            def setNameBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.ValueType.Builder:
                """
                
                Names from schema context
                 
                
                ``string name = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ValueType.Builder
                """

            @property
            def nameBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def name(self) -> java.lang.String:
                ...


        class_: typing.ClassVar[java.lang.Class]
        NAME_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ValueType:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getName(self) -> str:
            """
            
            Names from schema context
             
            
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            
            Names from schema context
             
            
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ValueType.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ValueType) -> TraceRmi.ValueType.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ValueType:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ValueType:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ValueType]:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def name(self) -> java.lang.String:
            ...


    class ValueOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getAddressValue(self) -> TraceRmi.Addr:
            """
            ``.ghidra.rmi.trace.Addr address_value = 16;``
            
            :return: The addressValue.
            :rtype: TraceRmi.Addr
            """

        def getAddressValueOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            """
            ``.ghidra.rmi.trace.Addr address_value = 16;``
            """

        def getBoolArrValue(self) -> TraceRmi.BoolArr:
            """
            ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
            
            :return: The boolArrValue.
            :rtype: TraceRmi.BoolArr
            """

        def getBoolArrValueOrBuilder(self) -> TraceRmi.BoolArrOrBuilder:
            """
            ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
            """

        def getBoolValue(self) -> bool:
            """
            ``bool bool_value = 2;``
            
            :return: The boolValue.
            :rtype: bool
            """

        def getByteValue(self) -> int:
            """
            ``int32 byte_value = 3;``
            
            :return: The byteValue.
            :rtype: int
            """

        def getBytesValue(self) -> com.google.protobuf.ByteString:
            """
            ``bytes bytes_value = 10;``
            
            :return: The bytesValue.
            :rtype: com.google.protobuf.ByteString
            """

        def getCharArrValue(self) -> str:
            """
            ``string char_arr_value = 11;``
            
            :return: The charArrValue.
            :rtype: str
            """

        def getCharArrValueBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string char_arr_value = 11;``
            
            :return: The bytes for charArrValue.
            :rtype: com.google.protobuf.ByteString
            """

        def getCharValue(self) -> int:
            """
            ``uint32 char_value = 4;``
            
            :return: The charValue.
            :rtype: int
            """

        def getChildDesc(self) -> TraceRmi.ObjDesc:
            """
            ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
            
            :return: The childDesc.
            :rtype: TraceRmi.ObjDesc
            """

        def getChildDescOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
            """

        def getChildSpec(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
            
            :return: The childSpec.
            :rtype: TraceRmi.ObjSpec
            """

        def getChildSpecOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
            """

        def getIntArrValue(self) -> TraceRmi.IntArr:
            """
            ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
            
            :return: The intArrValue.
            :rtype: TraceRmi.IntArr
            """

        def getIntArrValueOrBuilder(self) -> TraceRmi.IntArrOrBuilder:
            """
            ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
            """

        def getIntValue(self) -> int:
            """
            ``int32 int_value = 6;``
            
            :return: The intValue.
            :rtype: int
            """

        def getLongArrValue(self) -> TraceRmi.LongArr:
            """
            ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
            
            :return: The longArrValue.
            :rtype: TraceRmi.LongArr
            """

        def getLongArrValueOrBuilder(self) -> TraceRmi.LongArrOrBuilder:
            """
            ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
            """

        def getLongValue(self) -> int:
            """
            ``int64 long_value = 7;``
            
            :return: The longValue.
            :rtype: int
            """

        def getNullValue(self) -> TraceRmi.Null:
            """
            ``.ghidra.rmi.trace.Null null_value = 1;``
            
            :return: The nullValue.
            :rtype: TraceRmi.Null
            """

        def getNullValueOrBuilder(self) -> TraceRmi.NullOrBuilder:
            """
            ``.ghidra.rmi.trace.Null null_value = 1;``
            """

        def getRangeValue(self) -> TraceRmi.AddrRange:
            """
            ``.ghidra.rmi.trace.AddrRange range_value = 17;``
            
            :return: The rangeValue.
            :rtype: TraceRmi.AddrRange
            """

        def getRangeValueOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            """
            ``.ghidra.rmi.trace.AddrRange range_value = 17;``
            """

        def getShortArrValue(self) -> TraceRmi.ShortArr:
            """
            ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
            
            :return: The shortArrValue.
            :rtype: TraceRmi.ShortArr
            """

        def getShortArrValueOrBuilder(self) -> TraceRmi.ShortArrOrBuilder:
            """
            ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
            """

        def getShortValue(self) -> int:
            """
            ``int32 short_value = 5;``
            
            :return: The shortValue.
            :rtype: int
            """

        def getStringArrValue(self) -> TraceRmi.StringArr:
            """
            ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
            
            :return: The stringArrValue.
            :rtype: TraceRmi.StringArr
            """

        def getStringArrValueOrBuilder(self) -> TraceRmi.StringArrOrBuilder:
            """
            ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
            """

        def getStringValue(self) -> str:
            """
            ``string string_value = 8;``
            
            :return: The stringValue.
            :rtype: str
            """

        def getStringValueBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string string_value = 8;``
            
            :return: The bytes for stringValue.
            :rtype: com.google.protobuf.ByteString
            """

        def getValueCase(self) -> TraceRmi.Value.ValueCase:
            ...

        def hasAddressValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Addr address_value = 16;``
            
            :return: Whether the addressValue field is set.
            :rtype: bool
            """

        def hasBoolArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
            
            :return: Whether the boolArrValue field is set.
            :rtype: bool
            """

        def hasBoolValue(self) -> bool:
            """
            ``bool bool_value = 2;``
            
            :return: Whether the boolValue field is set.
            :rtype: bool
            """

        def hasByteValue(self) -> bool:
            """
            ``int32 byte_value = 3;``
            
            :return: Whether the byteValue field is set.
            :rtype: bool
            """

        def hasBytesValue(self) -> bool:
            """
            ``bytes bytes_value = 10;``
            
            :return: Whether the bytesValue field is set.
            :rtype: bool
            """

        def hasCharArrValue(self) -> bool:
            """
            ``string char_arr_value = 11;``
            
            :return: Whether the charArrValue field is set.
            :rtype: bool
            """

        def hasCharValue(self) -> bool:
            """
            ``uint32 char_value = 4;``
            
            :return: Whether the charValue field is set.
            :rtype: bool
            """

        def hasChildDesc(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
            
            :return: Whether the childDesc field is set.
            :rtype: bool
            """

        def hasChildSpec(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
            
            :return: Whether the childSpec field is set.
            :rtype: bool
            """

        def hasIntArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
            
            :return: Whether the intArrValue field is set.
            :rtype: bool
            """

        def hasIntValue(self) -> bool:
            """
            ``int32 int_value = 6;``
            
            :return: Whether the intValue field is set.
            :rtype: bool
            """

        def hasLongArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
            
            :return: Whether the longArrValue field is set.
            :rtype: bool
            """

        def hasLongValue(self) -> bool:
            """
            ``int64 long_value = 7;``
            
            :return: Whether the longValue field is set.
            :rtype: bool
            """

        def hasNullValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Null null_value = 1;``
            
            :return: Whether the nullValue field is set.
            :rtype: bool
            """

        def hasRangeValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.AddrRange range_value = 17;``
            
            :return: Whether the rangeValue field is set.
            :rtype: bool
            """

        def hasShortArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
            
            :return: Whether the shortArrValue field is set.
            :rtype: bool
            """

        def hasShortValue(self) -> bool:
            """
            ``int32 short_value = 5;``
            
            :return: Whether the shortValue field is set.
            :rtype: bool
            """

        def hasStringArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
            
            :return: Whether the stringArrValue field is set.
            :rtype: bool
            """

        def hasStringValue(self) -> bool:
            """
            ``string string_value = 8;``
            
            :return: Whether the stringValue field is set.
            :rtype: bool
            """

        @property
        def childDesc(self) -> TraceRmi.ObjDesc:
            ...

        @property
        def nullValueOrBuilder(self) -> TraceRmi.NullOrBuilder:
            ...

        @property
        def charArrValue(self) -> java.lang.String:
            ...

        @property
        def longArrValueOrBuilder(self) -> TraceRmi.LongArrOrBuilder:
            ...

        @property
        def shortArrValueOrBuilder(self) -> TraceRmi.ShortArrOrBuilder:
            ...

        @property
        def nullValue(self) -> TraceRmi.Null:
            ...

        @property
        def longValue(self) -> jpype.JLong:
            ...

        @property
        def stringValue(self) -> java.lang.String:
            ...

        @property
        def boolArrValueOrBuilder(self) -> TraceRmi.BoolArrOrBuilder:
            ...

        @property
        def valueCase(self) -> TraceRmi.Value.ValueCase:
            ...

        @property
        def shortValue(self) -> jpype.JInt:
            ...

        @property
        def intArrValue(self) -> TraceRmi.IntArr:
            ...

        @property
        def boolArrValue(self) -> TraceRmi.BoolArr:
            ...

        @property
        def charArrValueBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def addressValueOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            ...

        @property
        def shortArrValue(self) -> TraceRmi.ShortArr:
            ...

        @property
        def stringArrValue(self) -> TraceRmi.StringArr:
            ...

        @property
        def childSpec(self) -> TraceRmi.ObjSpec:
            ...

        @property
        def charValue(self) -> jpype.JInt:
            ...

        @property
        def addressValue(self) -> TraceRmi.Addr:
            ...

        @property
        def intValue(self) -> jpype.JInt:
            ...

        @property
        def childSpecOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def intArrValueOrBuilder(self) -> TraceRmi.IntArrOrBuilder:
            ...

        @property
        def childDescOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            ...

        @property
        def stringValueBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def rangeValueOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            ...

        @property
        def boolValue(self) -> jpype.JBoolean:
            ...

        @property
        def longArrValue(self) -> TraceRmi.LongArr:
            ...

        @property
        def stringArrValueOrBuilder(self) -> TraceRmi.StringArrOrBuilder:
            ...

        @property
        def rangeValue(self) -> TraceRmi.AddrRange:
            ...

        @property
        def bytesValue(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def byteValue(self) -> jpype.JInt:
            ...


    class Value(com.google.protobuf.GeneratedMessage, TraceRmi.ValueOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Value``
        """

        class ValueCase(java.lang.Enum[TraceRmi.Value.ValueCase], com.google.protobuf.Internal.EnumLite, com.google.protobuf.AbstractMessageLite.InternalOneOfEnum):

            class_: typing.ClassVar[java.lang.Class]
            NULL_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            BOOL_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            BYTE_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            CHAR_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            SHORT_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            INT_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            LONG_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            STRING_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            BOOL_ARR_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            BYTES_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            CHAR_ARR_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            SHORT_ARR_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            INT_ARR_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            LONG_ARR_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            STRING_ARR_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            ADDRESS_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            RANGE_VALUE: typing.Final[TraceRmi.Value.ValueCase]
            CHILD_SPEC: typing.Final[TraceRmi.Value.ValueCase]
            CHILD_DESC: typing.Final[TraceRmi.Value.ValueCase]
            VALUE_NOT_SET: typing.Final[TraceRmi.Value.ValueCase]

            @staticmethod
            def forNumber(value: typing.Union[jpype.JInt, int]) -> TraceRmi.Value.ValueCase:
                ...

            def getNumber(self) -> int:
                ...

            @staticmethod
            @typing.overload
            def valueOf(name: typing.Union[java.lang.String, str]) -> TraceRmi.Value.ValueCase:
                ...

            @staticmethod
            @typing.overload
            @deprecated("Use forNumber(int) instead.")
            def valueOf(value: typing.Union[jpype.JInt, int]) -> TraceRmi.Value.ValueCase:
                """
                
                
                :param jpype.JInt or int value: The number of the enum to look for.
                :return: The enum associated with the given number.
                :rtype: TraceRmi.Value.ValueCase
                
                .. deprecated::
                
                Use :meth:`forNumber(int) <.forNumber>` instead.
                """

            @staticmethod
            def values() -> jpype.JArray[TraceRmi.Value.ValueCase]:
                ...

            @property
            def number(self) -> jpype.JInt:
                ...


        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Value.Builder], TraceRmi.ValueOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Value``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearAddressValue(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Addr address_value = 16;``
                """

            def clearBoolArrValue(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
                """

            def clearBoolValue(self) -> TraceRmi.Value.Builder:
                """
                ``bool bool_value = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def clearByteValue(self) -> TraceRmi.Value.Builder:
                """
                ``int32 byte_value = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def clearBytesValue(self) -> TraceRmi.Value.Builder:
                """
                ``bytes bytes_value = 10;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def clearCharArrValue(self) -> TraceRmi.Value.Builder:
                """
                ``string char_arr_value = 11;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def clearCharValue(self) -> TraceRmi.Value.Builder:
                """
                ``uint32 char_value = 4;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def clearChildDesc(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
                """

            def clearChildSpec(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
                """

            def clearIntArrValue(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
                """

            def clearIntValue(self) -> TraceRmi.Value.Builder:
                """
                ``int32 int_value = 6;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def clearLongArrValue(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
                """

            def clearLongValue(self) -> TraceRmi.Value.Builder:
                """
                ``int64 long_value = 7;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def clearNullValue(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Null null_value = 1;``
                """

            def clearRangeValue(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range_value = 17;``
                """

            def clearShortArrValue(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
                """

            def clearShortValue(self) -> TraceRmi.Value.Builder:
                """
                ``int32 short_value = 5;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def clearStringArrValue(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
                """

            def clearStringValue(self) -> TraceRmi.Value.Builder:
                """
                ``string string_value = 8;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def clearValue(self) -> TraceRmi.Value.Builder:
                ...

            def getAddressValue(self) -> TraceRmi.Addr:
                """
                ``.ghidra.rmi.trace.Addr address_value = 16;``
                
                :return: The addressValue.
                :rtype: TraceRmi.Addr
                """

            def getAddressValueBuilder(self) -> TraceRmi.Addr.Builder:
                """
                ``.ghidra.rmi.trace.Addr address_value = 16;``
                """

            def getAddressValueOrBuilder(self) -> TraceRmi.AddrOrBuilder:
                """
                ``.ghidra.rmi.trace.Addr address_value = 16;``
                """

            def getBoolArrValue(self) -> TraceRmi.BoolArr:
                """
                ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
                
                :return: The boolArrValue.
                :rtype: TraceRmi.BoolArr
                """

            def getBoolArrValueBuilder(self) -> TraceRmi.BoolArr.Builder:
                """
                ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
                """

            def getBoolArrValueOrBuilder(self) -> TraceRmi.BoolArrOrBuilder:
                """
                ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
                """

            def getBoolValue(self) -> bool:
                """
                ``bool bool_value = 2;``
                
                :return: The boolValue.
                :rtype: bool
                """

            def getByteValue(self) -> int:
                """
                ``int32 byte_value = 3;``
                
                :return: The byteValue.
                :rtype: int
                """

            def getBytesValue(self) -> com.google.protobuf.ByteString:
                """
                ``bytes bytes_value = 10;``
                
                :return: The bytesValue.
                :rtype: com.google.protobuf.ByteString
                """

            def getCharArrValue(self) -> str:
                """
                ``string char_arr_value = 11;``
                
                :return: The charArrValue.
                :rtype: str
                """

            def getCharArrValueBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string char_arr_value = 11;``
                
                :return: The bytes for charArrValue.
                :rtype: com.google.protobuf.ByteString
                """

            def getCharValue(self) -> int:
                """
                ``uint32 char_value = 4;``
                
                :return: The charValue.
                :rtype: int
                """

            def getChildDesc(self) -> TraceRmi.ObjDesc:
                """
                ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
                
                :return: The childDesc.
                :rtype: TraceRmi.ObjDesc
                """

            def getChildDescBuilder(self) -> TraceRmi.ObjDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
                """

            def getChildDescOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
                """

            def getChildSpec(self) -> TraceRmi.ObjSpec:
                """
                ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
                
                :return: The childSpec.
                :rtype: TraceRmi.ObjSpec
                """

            def getChildSpecBuilder(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
                """

            def getChildSpecOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getIntArrValue(self) -> TraceRmi.IntArr:
                """
                ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
                
                :return: The intArrValue.
                :rtype: TraceRmi.IntArr
                """

            def getIntArrValueBuilder(self) -> TraceRmi.IntArr.Builder:
                """
                ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
                """

            def getIntArrValueOrBuilder(self) -> TraceRmi.IntArrOrBuilder:
                """
                ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
                """

            def getIntValue(self) -> int:
                """
                ``int32 int_value = 6;``
                
                :return: The intValue.
                :rtype: int
                """

            def getLongArrValue(self) -> TraceRmi.LongArr:
                """
                ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
                
                :return: The longArrValue.
                :rtype: TraceRmi.LongArr
                """

            def getLongArrValueBuilder(self) -> TraceRmi.LongArr.Builder:
                """
                ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
                """

            def getLongArrValueOrBuilder(self) -> TraceRmi.LongArrOrBuilder:
                """
                ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
                """

            def getLongValue(self) -> int:
                """
                ``int64 long_value = 7;``
                
                :return: The longValue.
                :rtype: int
                """

            def getNullValue(self) -> TraceRmi.Null:
                """
                ``.ghidra.rmi.trace.Null null_value = 1;``
                
                :return: The nullValue.
                :rtype: TraceRmi.Null
                """

            def getNullValueBuilder(self) -> TraceRmi.Null.Builder:
                """
                ``.ghidra.rmi.trace.Null null_value = 1;``
                """

            def getNullValueOrBuilder(self) -> TraceRmi.NullOrBuilder:
                """
                ``.ghidra.rmi.trace.Null null_value = 1;``
                """

            def getRangeValue(self) -> TraceRmi.AddrRange:
                """
                ``.ghidra.rmi.trace.AddrRange range_value = 17;``
                
                :return: The rangeValue.
                :rtype: TraceRmi.AddrRange
                """

            def getRangeValueBuilder(self) -> TraceRmi.AddrRange.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range_value = 17;``
                """

            def getRangeValueOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
                """
                ``.ghidra.rmi.trace.AddrRange range_value = 17;``
                """

            def getShortArrValue(self) -> TraceRmi.ShortArr:
                """
                ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
                
                :return: The shortArrValue.
                :rtype: TraceRmi.ShortArr
                """

            def getShortArrValueBuilder(self) -> TraceRmi.ShortArr.Builder:
                """
                ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
                """

            def getShortArrValueOrBuilder(self) -> TraceRmi.ShortArrOrBuilder:
                """
                ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
                """

            def getShortValue(self) -> int:
                """
                ``int32 short_value = 5;``
                
                :return: The shortValue.
                :rtype: int
                """

            def getStringArrValue(self) -> TraceRmi.StringArr:
                """
                ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
                
                :return: The stringArrValue.
                :rtype: TraceRmi.StringArr
                """

            def getStringArrValueBuilder(self) -> TraceRmi.StringArr.Builder:
                """
                ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
                """

            def getStringArrValueOrBuilder(self) -> TraceRmi.StringArrOrBuilder:
                """
                ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
                """

            def getStringValue(self) -> str:
                """
                ``string string_value = 8;``
                
                :return: The stringValue.
                :rtype: str
                """

            def getStringValueBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string string_value = 8;``
                
                :return: The bytes for stringValue.
                :rtype: com.google.protobuf.ByteString
                """

            def getValueCase(self) -> TraceRmi.Value.ValueCase:
                ...

            def hasAddressValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.Addr address_value = 16;``
                
                :return: Whether the addressValue field is set.
                :rtype: bool
                """

            def hasBoolArrValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
                
                :return: Whether the boolArrValue field is set.
                :rtype: bool
                """

            def hasBoolValue(self) -> bool:
                """
                ``bool bool_value = 2;``
                
                :return: Whether the boolValue field is set.
                :rtype: bool
                """

            def hasByteValue(self) -> bool:
                """
                ``int32 byte_value = 3;``
                
                :return: Whether the byteValue field is set.
                :rtype: bool
                """

            def hasBytesValue(self) -> bool:
                """
                ``bytes bytes_value = 10;``
                
                :return: Whether the bytesValue field is set.
                :rtype: bool
                """

            def hasCharArrValue(self) -> bool:
                """
                ``string char_arr_value = 11;``
                
                :return: Whether the charArrValue field is set.
                :rtype: bool
                """

            def hasCharValue(self) -> bool:
                """
                ``uint32 char_value = 4;``
                
                :return: Whether the charValue field is set.
                :rtype: bool
                """

            def hasChildDesc(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
                
                :return: Whether the childDesc field is set.
                :rtype: bool
                """

            def hasChildSpec(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
                
                :return: Whether the childSpec field is set.
                :rtype: bool
                """

            def hasIntArrValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
                
                :return: Whether the intArrValue field is set.
                :rtype: bool
                """

            def hasIntValue(self) -> bool:
                """
                ``int32 int_value = 6;``
                
                :return: Whether the intValue field is set.
                :rtype: bool
                """

            def hasLongArrValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
                
                :return: Whether the longArrValue field is set.
                :rtype: bool
                """

            def hasLongValue(self) -> bool:
                """
                ``int64 long_value = 7;``
                
                :return: Whether the longValue field is set.
                :rtype: bool
                """

            def hasNullValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.Null null_value = 1;``
                
                :return: Whether the nullValue field is set.
                :rtype: bool
                """

            def hasRangeValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.AddrRange range_value = 17;``
                
                :return: Whether the rangeValue field is set.
                :rtype: bool
                """

            def hasShortArrValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
                
                :return: Whether the shortArrValue field is set.
                :rtype: bool
                """

            def hasShortValue(self) -> bool:
                """
                ``int32 short_value = 5;``
                
                :return: Whether the shortValue field is set.
                :rtype: bool
                """

            def hasStringArrValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
                
                :return: Whether the stringArrValue field is set.
                :rtype: bool
                """

            def hasStringValue(self) -> bool:
                """
                ``string string_value = 8;``
                
                :return: Whether the stringValue field is set.
                :rtype: bool
                """

            def mergeAddressValue(self, value: TraceRmi.Addr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Addr address_value = 16;``
                """

            def mergeBoolArrValue(self, value: TraceRmi.BoolArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
                """

            def mergeChildDesc(self, value: TraceRmi.ObjDesc) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
                """

            def mergeChildSpec(self, value: TraceRmi.ObjSpec) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
                """

            def mergeFrom(self, other: TraceRmi.Value) -> TraceRmi.Value.Builder:
                ...

            def mergeIntArrValue(self, value: TraceRmi.IntArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
                """

            def mergeLongArrValue(self, value: TraceRmi.LongArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
                """

            def mergeNullValue(self, value: TraceRmi.Null) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Null null_value = 1;``
                """

            def mergeRangeValue(self, value: TraceRmi.AddrRange) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range_value = 17;``
                """

            def mergeShortArrValue(self, value: TraceRmi.ShortArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
                """

            def mergeStringArrValue(self, value: TraceRmi.StringArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
                """

            @typing.overload
            def setAddressValue(self, value: TraceRmi.Addr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Addr address_value = 16;``
                """

            @typing.overload
            def setAddressValue(self, builderForValue: TraceRmi.Addr.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Addr address_value = 16;``
                """

            @typing.overload
            def setBoolArrValue(self, value: TraceRmi.BoolArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
                """

            @typing.overload
            def setBoolArrValue(self, builderForValue: TraceRmi.BoolArr.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
                """

            def setBoolValue(self, value: typing.Union[jpype.JBoolean, bool]) -> TraceRmi.Value.Builder:
                """
                ``bool bool_value = 2;``
                
                :param jpype.JBoolean or bool value: The boolValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def setByteValue(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.Value.Builder:
                """
                ``int32 byte_value = 3;``
                
                :param jpype.JInt or int value: The byteValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def setBytesValue(self, value: com.google.protobuf.ByteString) -> TraceRmi.Value.Builder:
                """
                ``bytes bytes_value = 10;``
                
                :param com.google.protobuf.ByteString value: The bytesValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def setCharArrValue(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Value.Builder:
                """
                ``string char_arr_value = 11;``
                
                :param java.lang.String or str value: The charArrValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def setCharArrValueBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Value.Builder:
                """
                ``string char_arr_value = 11;``
                
                :param com.google.protobuf.ByteString value: The bytes for charArrValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def setCharValue(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.Value.Builder:
                """
                ``uint32 char_value = 4;``
                
                :param jpype.JInt or int value: The charValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            @typing.overload
            def setChildDesc(self, value: TraceRmi.ObjDesc) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
                """

            @typing.overload
            def setChildDesc(self, builderForValue: TraceRmi.ObjDesc.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
                """

            @typing.overload
            def setChildSpec(self, value: TraceRmi.ObjSpec) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
                """

            @typing.overload
            def setChildSpec(self, builderForValue: TraceRmi.ObjSpec.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
                """

            @typing.overload
            def setIntArrValue(self, value: TraceRmi.IntArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
                """

            @typing.overload
            def setIntArrValue(self, builderForValue: TraceRmi.IntArr.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
                """

            def setIntValue(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.Value.Builder:
                """
                ``int32 int_value = 6;``
                
                :param jpype.JInt or int value: The intValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            @typing.overload
            def setLongArrValue(self, value: TraceRmi.LongArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
                """

            @typing.overload
            def setLongArrValue(self, builderForValue: TraceRmi.LongArr.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
                """

            def setLongValue(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.Value.Builder:
                """
                ``int64 long_value = 7;``
                
                :param jpype.JLong or int value: The longValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            @typing.overload
            def setNullValue(self, value: TraceRmi.Null) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Null null_value = 1;``
                """

            @typing.overload
            def setNullValue(self, builderForValue: TraceRmi.Null.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Null null_value = 1;``
                """

            @typing.overload
            def setRangeValue(self, value: TraceRmi.AddrRange) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range_value = 17;``
                """

            @typing.overload
            def setRangeValue(self, builderForValue: TraceRmi.AddrRange.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.AddrRange range_value = 17;``
                """

            @typing.overload
            def setShortArrValue(self, value: TraceRmi.ShortArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
                """

            @typing.overload
            def setShortArrValue(self, builderForValue: TraceRmi.ShortArr.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
                """

            def setShortValue(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.Value.Builder:
                """
                ``int32 short_value = 5;``
                
                :param jpype.JInt or int value: The shortValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            @typing.overload
            def setStringArrValue(self, value: TraceRmi.StringArr) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
                """

            @typing.overload
            def setStringArrValue(self, builderForValue: TraceRmi.StringArr.Builder) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
                """

            def setStringValue(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Value.Builder:
                """
                ``string string_value = 8;``
                
                :param java.lang.String or str value: The stringValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            def setStringValueBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Value.Builder:
                """
                ``string string_value = 8;``
                
                :param com.google.protobuf.ByteString value: The bytes for stringValue to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Value.Builder
                """

            @property
            def childDesc(self) -> TraceRmi.ObjDesc:
                ...

            @property
            def longArrValueBuilder(self) -> TraceRmi.LongArr.Builder:
                ...

            @property
            def boolArrValueBuilder(self) -> TraceRmi.BoolArr.Builder:
                ...

            @property
            def nullValueOrBuilder(self) -> TraceRmi.NullOrBuilder:
                ...

            @property
            def charArrValue(self) -> java.lang.String:
                ...

            @property
            def longArrValueOrBuilder(self) -> TraceRmi.LongArrOrBuilder:
                ...

            @property
            def shortArrValueOrBuilder(self) -> TraceRmi.ShortArrOrBuilder:
                ...

            @property
            def rangeValueBuilder(self) -> TraceRmi.AddrRange.Builder:
                ...

            @property
            def nullValue(self) -> TraceRmi.Null:
                ...

            @property
            def longValue(self) -> jpype.JLong:
                ...

            @property
            def stringValue(self) -> java.lang.String:
                ...

            @property
            def boolArrValueOrBuilder(self) -> TraceRmi.BoolArrOrBuilder:
                ...

            @property
            def valueCase(self) -> TraceRmi.Value.ValueCase:
                ...

            @property
            def intArrValueBuilder(self) -> TraceRmi.IntArr.Builder:
                ...

            @property
            def shortValue(self) -> jpype.JInt:
                ...

            @property
            def intArrValue(self) -> TraceRmi.IntArr:
                ...

            @property
            def boolArrValue(self) -> TraceRmi.BoolArr:
                ...

            @property
            def charArrValueBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def addressValueOrBuilder(self) -> TraceRmi.AddrOrBuilder:
                ...

            @property
            def shortArrValue(self) -> TraceRmi.ShortArr:
                ...

            @property
            def childSpecBuilder(self) -> TraceRmi.ObjSpec.Builder:
                ...

            @property
            def stringArrValue(self) -> TraceRmi.StringArr:
                ...

            @property
            def childSpec(self) -> TraceRmi.ObjSpec:
                ...

            @property
            def charValue(self) -> jpype.JInt:
                ...

            @property
            def addressValue(self) -> TraceRmi.Addr:
                ...

            @property
            def nullValueBuilder(self) -> TraceRmi.Null.Builder:
                ...

            @property
            def intValue(self) -> jpype.JInt:
                ...

            @property
            def shortArrValueBuilder(self) -> TraceRmi.ShortArr.Builder:
                ...

            @property
            def childSpecOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                ...

            @property
            def addressValueBuilder(self) -> TraceRmi.Addr.Builder:
                ...

            @property
            def intArrValueOrBuilder(self) -> TraceRmi.IntArrOrBuilder:
                ...

            @property
            def stringArrValueBuilder(self) -> TraceRmi.StringArr.Builder:
                ...

            @property
            def childDescOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
                ...

            @property
            def stringValueBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def childDescBuilder(self) -> TraceRmi.ObjDesc.Builder:
                ...

            @property
            def rangeValueOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
                ...

            @property
            def boolValue(self) -> jpype.JBoolean:
                ...

            @property
            def longArrValue(self) -> TraceRmi.LongArr:
                ...

            @property
            def stringArrValueOrBuilder(self) -> TraceRmi.StringArrOrBuilder:
                ...

            @property
            def rangeValue(self) -> TraceRmi.AddrRange:
                ...

            @property
            def bytesValue(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def byteValue(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        NULL_VALUE_FIELD_NUMBER: typing.Final = 1
        BOOL_VALUE_FIELD_NUMBER: typing.Final = 2
        BYTE_VALUE_FIELD_NUMBER: typing.Final = 3
        CHAR_VALUE_FIELD_NUMBER: typing.Final = 4
        SHORT_VALUE_FIELD_NUMBER: typing.Final = 5
        INT_VALUE_FIELD_NUMBER: typing.Final = 6
        LONG_VALUE_FIELD_NUMBER: typing.Final = 7
        STRING_VALUE_FIELD_NUMBER: typing.Final = 8
        BOOL_ARR_VALUE_FIELD_NUMBER: typing.Final = 9
        BYTES_VALUE_FIELD_NUMBER: typing.Final = 10
        CHAR_ARR_VALUE_FIELD_NUMBER: typing.Final = 11
        SHORT_ARR_VALUE_FIELD_NUMBER: typing.Final = 12
        INT_ARR_VALUE_FIELD_NUMBER: typing.Final = 13
        LONG_ARR_VALUE_FIELD_NUMBER: typing.Final = 14
        STRING_ARR_VALUE_FIELD_NUMBER: typing.Final = 15
        ADDRESS_VALUE_FIELD_NUMBER: typing.Final = 16
        RANGE_VALUE_FIELD_NUMBER: typing.Final = 17
        CHILD_SPEC_FIELD_NUMBER: typing.Final = 18
        CHILD_DESC_FIELD_NUMBER: typing.Final = 19

        def getAddressValue(self) -> TraceRmi.Addr:
            """
            ``.ghidra.rmi.trace.Addr address_value = 16;``
            
            :return: The addressValue.
            :rtype: TraceRmi.Addr
            """

        def getAddressValueOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            """
            ``.ghidra.rmi.trace.Addr address_value = 16;``
            """

        def getBoolArrValue(self) -> TraceRmi.BoolArr:
            """
            ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
            
            :return: The boolArrValue.
            :rtype: TraceRmi.BoolArr
            """

        def getBoolArrValueOrBuilder(self) -> TraceRmi.BoolArrOrBuilder:
            """
            ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
            """

        def getBoolValue(self) -> bool:
            """
            ``bool bool_value = 2;``
            
            :return: The boolValue.
            :rtype: bool
            """

        def getByteValue(self) -> int:
            """
            ``int32 byte_value = 3;``
            
            :return: The byteValue.
            :rtype: int
            """

        def getBytesValue(self) -> com.google.protobuf.ByteString:
            """
            ``bytes bytes_value = 10;``
            
            :return: The bytesValue.
            :rtype: com.google.protobuf.ByteString
            """

        def getCharArrValue(self) -> str:
            """
            ``string char_arr_value = 11;``
            
            :return: The charArrValue.
            :rtype: str
            """

        def getCharArrValueBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string char_arr_value = 11;``
            
            :return: The bytes for charArrValue.
            :rtype: com.google.protobuf.ByteString
            """

        def getCharValue(self) -> int:
            """
            ``uint32 char_value = 4;``
            
            :return: The charValue.
            :rtype: int
            """

        def getChildDesc(self) -> TraceRmi.ObjDesc:
            """
            ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
            
            :return: The childDesc.
            :rtype: TraceRmi.ObjDesc
            """

        def getChildDescOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
            """

        def getChildSpec(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
            
            :return: The childSpec.
            :rtype: TraceRmi.ObjSpec
            """

        def getChildSpecOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Value:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getIntArrValue(self) -> TraceRmi.IntArr:
            """
            ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
            
            :return: The intArrValue.
            :rtype: TraceRmi.IntArr
            """

        def getIntArrValueOrBuilder(self) -> TraceRmi.IntArrOrBuilder:
            """
            ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
            """

        def getIntValue(self) -> int:
            """
            ``int32 int_value = 6;``
            
            :return: The intValue.
            :rtype: int
            """

        def getLongArrValue(self) -> TraceRmi.LongArr:
            """
            ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
            
            :return: The longArrValue.
            :rtype: TraceRmi.LongArr
            """

        def getLongArrValueOrBuilder(self) -> TraceRmi.LongArrOrBuilder:
            """
            ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
            """

        def getLongValue(self) -> int:
            """
            ``int64 long_value = 7;``
            
            :return: The longValue.
            :rtype: int
            """

        def getNullValue(self) -> TraceRmi.Null:
            """
            ``.ghidra.rmi.trace.Null null_value = 1;``
            
            :return: The nullValue.
            :rtype: TraceRmi.Null
            """

        def getNullValueOrBuilder(self) -> TraceRmi.NullOrBuilder:
            """
            ``.ghidra.rmi.trace.Null null_value = 1;``
            """

        def getRangeValue(self) -> TraceRmi.AddrRange:
            """
            ``.ghidra.rmi.trace.AddrRange range_value = 17;``
            
            :return: The rangeValue.
            :rtype: TraceRmi.AddrRange
            """

        def getRangeValueOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            """
            ``.ghidra.rmi.trace.AddrRange range_value = 17;``
            """

        def getShortArrValue(self) -> TraceRmi.ShortArr:
            """
            ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
            
            :return: The shortArrValue.
            :rtype: TraceRmi.ShortArr
            """

        def getShortArrValueOrBuilder(self) -> TraceRmi.ShortArrOrBuilder:
            """
            ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
            """

        def getShortValue(self) -> int:
            """
            ``int32 short_value = 5;``
            
            :return: The shortValue.
            :rtype: int
            """

        def getStringArrValue(self) -> TraceRmi.StringArr:
            """
            ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
            
            :return: The stringArrValue.
            :rtype: TraceRmi.StringArr
            """

        def getStringArrValueOrBuilder(self) -> TraceRmi.StringArrOrBuilder:
            """
            ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
            """

        def getStringValue(self) -> str:
            """
            ``string string_value = 8;``
            
            :return: The stringValue.
            :rtype: str
            """

        def getStringValueBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string string_value = 8;``
            
            :return: The bytes for stringValue.
            :rtype: com.google.protobuf.ByteString
            """

        def getValueCase(self) -> TraceRmi.Value.ValueCase:
            ...

        def hasAddressValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Addr address_value = 16;``
            
            :return: Whether the addressValue field is set.
            :rtype: bool
            """

        def hasBoolArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.BoolArr bool_arr_value = 9;``
            
            :return: Whether the boolArrValue field is set.
            :rtype: bool
            """

        def hasBoolValue(self) -> bool:
            """
            ``bool bool_value = 2;``
            
            :return: Whether the boolValue field is set.
            :rtype: bool
            """

        def hasByteValue(self) -> bool:
            """
            ``int32 byte_value = 3;``
            
            :return: Whether the byteValue field is set.
            :rtype: bool
            """

        def hasBytesValue(self) -> bool:
            """
            ``bytes bytes_value = 10;``
            
            :return: Whether the bytesValue field is set.
            :rtype: bool
            """

        def hasCharArrValue(self) -> bool:
            """
            ``string char_arr_value = 11;``
            
            :return: Whether the charArrValue field is set.
            :rtype: bool
            """

        def hasCharValue(self) -> bool:
            """
            ``uint32 char_value = 4;``
            
            :return: Whether the charValue field is set.
            :rtype: bool
            """

        def hasChildDesc(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjDesc child_desc = 19;``
            
            :return: Whether the childDesc field is set.
            :rtype: bool
            """

        def hasChildSpec(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec child_spec = 18;``
            
            :return: Whether the childSpec field is set.
            :rtype: bool
            """

        def hasIntArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.IntArr int_arr_value = 13;``
            
            :return: Whether the intArrValue field is set.
            :rtype: bool
            """

        def hasIntValue(self) -> bool:
            """
            ``int32 int_value = 6;``
            
            :return: Whether the intValue field is set.
            :rtype: bool
            """

        def hasLongArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.LongArr long_arr_value = 14;``
            
            :return: Whether the longArrValue field is set.
            :rtype: bool
            """

        def hasLongValue(self) -> bool:
            """
            ``int64 long_value = 7;``
            
            :return: Whether the longValue field is set.
            :rtype: bool
            """

        def hasNullValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Null null_value = 1;``
            
            :return: Whether the nullValue field is set.
            :rtype: bool
            """

        def hasRangeValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.AddrRange range_value = 17;``
            
            :return: Whether the rangeValue field is set.
            :rtype: bool
            """

        def hasShortArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.ShortArr short_arr_value = 12;``
            
            :return: Whether the shortArrValue field is set.
            :rtype: bool
            """

        def hasShortValue(self) -> bool:
            """
            ``int32 short_value = 5;``
            
            :return: Whether the shortValue field is set.
            :rtype: bool
            """

        def hasStringArrValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.StringArr string_arr_value = 15;``
            
            :return: Whether the stringArrValue field is set.
            :rtype: bool
            """

        def hasStringValue(self) -> bool:
            """
            ``string string_value = 8;``
            
            :return: Whether the stringValue field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Value.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Value) -> TraceRmi.Value.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Value:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Value:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Value]:
            ...

        @property
        def childDesc(self) -> TraceRmi.ObjDesc:
            ...

        @property
        def nullValueOrBuilder(self) -> TraceRmi.NullOrBuilder:
            ...

        @property
        def charArrValue(self) -> java.lang.String:
            ...

        @property
        def longArrValueOrBuilder(self) -> TraceRmi.LongArrOrBuilder:
            ...

        @property
        def shortArrValueOrBuilder(self) -> TraceRmi.ShortArrOrBuilder:
            ...

        @property
        def nullValue(self) -> TraceRmi.Null:
            ...

        @property
        def longValue(self) -> jpype.JLong:
            ...

        @property
        def stringValue(self) -> java.lang.String:
            ...

        @property
        def boolArrValueOrBuilder(self) -> TraceRmi.BoolArrOrBuilder:
            ...

        @property
        def valueCase(self) -> TraceRmi.Value.ValueCase:
            ...

        @property
        def shortValue(self) -> jpype.JInt:
            ...

        @property
        def intArrValue(self) -> TraceRmi.IntArr:
            ...

        @property
        def boolArrValue(self) -> TraceRmi.BoolArr:
            ...

        @property
        def charArrValueBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def addressValueOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            ...

        @property
        def shortArrValue(self) -> TraceRmi.ShortArr:
            ...

        @property
        def stringArrValue(self) -> TraceRmi.StringArr:
            ...

        @property
        def childSpec(self) -> TraceRmi.ObjSpec:
            ...

        @property
        def charValue(self) -> jpype.JInt:
            ...

        @property
        def addressValue(self) -> TraceRmi.Addr:
            ...

        @property
        def intValue(self) -> jpype.JInt:
            ...

        @property
        def childSpecOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def intArrValueOrBuilder(self) -> TraceRmi.IntArrOrBuilder:
            ...

        @property
        def childDescOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            ...

        @property
        def stringValueBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def rangeValueOrBuilder(self) -> TraceRmi.AddrRangeOrBuilder:
            ...

        @property
        def boolValue(self) -> jpype.JBoolean:
            ...

        @property
        def longArrValue(self) -> TraceRmi.LongArr:
            ...

        @property
        def stringArrValueOrBuilder(self) -> TraceRmi.StringArrOrBuilder:
            ...

        @property
        def rangeValue(self) -> TraceRmi.AddrRange:
            ...

        @property
        def bytesValue(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def byteValue(self) -> jpype.JInt:
            ...


    class RequestCreateRootObjectOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getRootSchema(self) -> str:
            """
            ``string root_schema = 3;``
            
            :return: The rootSchema.
            :rtype: str
            """

        def getRootSchemaBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string root_schema = 3;``
            
            :return: The bytes for rootSchema.
            :rtype: com.google.protobuf.ByteString
            """

        def getSchemaContext(self) -> str:
            """
            ``string schema_context = 2;``
            
            :return: The schemaContext.
            :rtype: str
            """

        def getSchemaContextBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string schema_context = 2;``
            
            :return: The bytes for schemaContext.
            :rtype: com.google.protobuf.ByteString
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @property
        def schemaContextBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def schemaContext(self) -> java.lang.String:
            ...

        @property
        def rootSchema(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def rootSchemaBytes(self) -> com.google.protobuf.ByteString:
            ...


    class RequestCreateRootObject(com.google.protobuf.GeneratedMessage, TraceRmi.RequestCreateRootObjectOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestCreateRootObject``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestCreateRootObject.Builder], TraceRmi.RequestCreateRootObjectOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestCreateRootObject``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOid(self) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearRootSchema(self) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``string root_schema = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateRootObject.Builder
                """

            def clearSchemaContext(self) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``string schema_context = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateRootObject.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getRootSchema(self) -> str:
                """
                ``string root_schema = 3;``
                
                :return: The rootSchema.
                :rtype: str
                """

            def getRootSchemaBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string root_schema = 3;``
                
                :return: The bytes for rootSchema.
                :rtype: com.google.protobuf.ByteString
                """

            def getSchemaContext(self) -> str:
                """
                ``string schema_context = 2;``
                
                :return: The schemaContext.
                :rtype: str
                """

            def getSchemaContextBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string schema_context = 2;``
                
                :return: The bytes for schemaContext.
                :rtype: com.google.protobuf.ByteString
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestCreateRootObject) -> TraceRmi.RequestCreateRootObject.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def setRootSchema(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``string root_schema = 3;``
                
                :param java.lang.String or str value: The rootSchema to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateRootObject.Builder
                """

            def setRootSchemaBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``string root_schema = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for rootSchema to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateRootObject.Builder
                """

            def setSchemaContext(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``string schema_context = 2;``
                
                :param java.lang.String or str value: The schemaContext to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateRootObject.Builder
                """

            def setSchemaContextBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``string schema_context = 2;``
                
                :param com.google.protobuf.ByteString value: The bytes for schemaContext to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestCreateRootObject.Builder
                """

            @property
            def schemaContextBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def schemaContext(self) -> java.lang.String:
                ...

            @property
            def rootSchema(self) -> java.lang.String:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def rootSchemaBytes(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        SCHEMA_CONTEXT_FIELD_NUMBER: typing.Final = 2
        ROOT_SCHEMA_FIELD_NUMBER: typing.Final = 3

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getRootSchema(self) -> str:
            """
            ``string root_schema = 3;``
            
            :return: The rootSchema.
            :rtype: str
            """

        def getRootSchemaBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string root_schema = 3;``
            
            :return: The bytes for rootSchema.
            :rtype: com.google.protobuf.ByteString
            """

        def getSchemaContext(self) -> str:
            """
            ``string schema_context = 2;``
            
            :return: The schemaContext.
            :rtype: str
            """

        def getSchemaContextBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string schema_context = 2;``
            
            :return: The bytes for schemaContext.
            :rtype: com.google.protobuf.ByteString
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestCreateRootObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestCreateRootObject) -> TraceRmi.RequestCreateRootObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateRootObject:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestCreateRootObject]:
            ...

        @property
        def schemaContextBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def schemaContext(self) -> java.lang.String:
            ...

        @property
        def rootSchema(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def rootSchemaBytes(self) -> com.google.protobuf.ByteString:
            ...


    class RequestCreateObjectOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getPath(self) -> TraceRmi.ObjPath:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: The path.
            :rtype: TraceRmi.ObjPath
            """

        def getPathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasPath(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: Whether the path field is set.
            :rtype: bool
            """

        @property
        def path(self) -> TraceRmi.ObjPath:
            ...

        @property
        def pathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class RequestCreateObject(com.google.protobuf.GeneratedMessage, TraceRmi.RequestCreateObjectOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestCreateObject``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestCreateObject.Builder], TraceRmi.RequestCreateObjectOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestCreateObject``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOid(self) -> TraceRmi.RequestCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearPath(self) -> TraceRmi.RequestCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getPath(self) -> TraceRmi.ObjPath:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                
                :return: The path.
                :rtype: TraceRmi.ObjPath
                """

            def getPathBuilder(self) -> TraceRmi.ObjPath.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            def getPathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasPath(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                
                :return: Whether the path field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestCreateObject) -> TraceRmi.RequestCreateObject.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergePath(self, value: TraceRmi.ObjPath) -> TraceRmi.RequestCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setPath(self, value: TraceRmi.ObjPath) -> TraceRmi.RequestCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @typing.overload
            def setPath(self, builderForValue: TraceRmi.ObjPath.Builder) -> TraceRmi.RequestCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath path = 2;``
                """

            @property
            def path(self) -> TraceRmi.ObjPath:
                ...

            @property
            def pathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def pathBuilder(self) -> TraceRmi.ObjPath.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        PATH_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getPath(self) -> TraceRmi.ObjPath:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: The path.
            :rtype: TraceRmi.ObjPath
            """

        def getPathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasPath(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjPath path = 2;``
            
            :return: Whether the path field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestCreateObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestCreateObject) -> TraceRmi.RequestCreateObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestCreateObject:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestCreateObject]:
            ...

        @property
        def path(self) -> TraceRmi.ObjPath:
            ...

        @property
        def pathOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...


    class ReplyCreateObjectOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 1;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 1;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 1;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class ReplyCreateObject(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyCreateObjectOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyCreateObject``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyCreateObject.Builder], TraceRmi.ReplyCreateObjectOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyCreateObject``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearObject(self) -> TraceRmi.ReplyCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getObject(self) -> TraceRmi.ObjSpec:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 1;``
                
                :return: The object.
                :rtype: TraceRmi.ObjSpec
                """

            def getObjectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 1;``
                """

            def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 1;``
                """

            def hasObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 1;``
                
                :return: Whether the object field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.ReplyCreateObject) -> TraceRmi.ReplyCreateObject.Builder:
                ...

            def mergeObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.ReplyCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 1;``
                """

            @typing.overload
            def setObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.ReplyCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 1;``
                """

            @typing.overload
            def setObject(self, builderForValue: TraceRmi.ObjSpec.Builder) -> TraceRmi.ReplyCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 1;``
                """

            @property
            def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                ...

            @property
            def objectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                ...

            @property
            def object(self) -> TraceRmi.ObjSpec:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OBJECT_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 1;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 1;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 1;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyCreateObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyCreateObject) -> TraceRmi.ReplyCreateObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyCreateObject:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyCreateObject]:
            ...

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class RequestInsertObjectOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getResolution(self) -> TraceRmi.Resolution:
            """
            ``.ghidra.rmi.trace.Resolution resolution = 4;``
            
            :return: The resolution.
            :rtype: TraceRmi.Resolution
            """

        def getResolutionValue(self) -> int:
            """
            ``.ghidra.rmi.trace.Resolution resolution = 4;``
            
            :return: The enum numeric value on the wire for resolution.
            :rtype: int
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @property
        def resolutionValue(self) -> jpype.JInt:
            ...

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def resolution(self) -> TraceRmi.Resolution:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class RequestInsertObject(com.google.protobuf.GeneratedMessage, TraceRmi.RequestInsertObjectOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestInsertObject``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestInsertObject.Builder], TraceRmi.RequestInsertObjectOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestInsertObject``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearObject(self) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def clearOid(self) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearResolution(self) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 4;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestInsertObject.Builder
                """

            def clearSpan(self) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getObject(self) -> TraceRmi.ObjSpec:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: The object.
                :rtype: TraceRmi.ObjSpec
                """

            def getObjectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getResolution(self) -> TraceRmi.Resolution:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 4;``
                
                :return: The resolution.
                :rtype: TraceRmi.Resolution
                """

            def getResolutionValue(self) -> int:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 4;``
                
                :return: The enum numeric value on the wire for resolution.
                :rtype: int
                """

            def getSpan(self) -> TraceRmi.Span:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                
                :return: The span.
                :rtype: TraceRmi.Span
                """

            def getSpanBuilder(self) -> TraceRmi.Span.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            def hasObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: Whether the object field is set.
                :rtype: bool
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasSpan(self) -> bool:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                
                :return: Whether the span field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestInsertObject) -> TraceRmi.RequestInsertObject.Builder:
                ...

            def mergeObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeSpan(self, value: TraceRmi.Span) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            @typing.overload
            def setObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setObject(self, builderForValue: TraceRmi.ObjSpec.Builder) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def setResolution(self, value: TraceRmi.Resolution) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 4;``
                
                :param TraceRmi.Resolution value: The resolution to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestInsertObject.Builder
                """

            def setResolutionValue(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 4;``
                
                :param jpype.JInt or int value: The enum numeric value on the wire for resolution to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestInsertObject.Builder
                """

            @typing.overload
            def setSpan(self, value: TraceRmi.Span) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            @typing.overload
            def setSpan(self, builderForValue: TraceRmi.Span.Builder) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            @property
            def resolutionValue(self) -> jpype.JInt:
                ...

            @property
            def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                ...

            @property
            def objectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                ...

            @property
            def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                ...

            @property
            def spanBuilder(self) -> TraceRmi.Span.Builder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def resolution(self) -> TraceRmi.Resolution:
                ...

            @property
            def span(self) -> TraceRmi.Span:
                ...

            @property
            def object(self) -> TraceRmi.ObjSpec:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        OBJECT_FIELD_NUMBER: typing.Final = 2
        SPAN_FIELD_NUMBER: typing.Final = 3
        RESOLUTION_FIELD_NUMBER: typing.Final = 4

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getResolution(self) -> TraceRmi.Resolution:
            """
            ``.ghidra.rmi.trace.Resolution resolution = 4;``
            
            :return: The resolution.
            :rtype: TraceRmi.Resolution
            """

        def getResolutionValue(self) -> int:
            """
            ``.ghidra.rmi.trace.Resolution resolution = 4;``
            
            :return: The enum numeric value on the wire for resolution.
            :rtype: int
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestInsertObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestInsertObject) -> TraceRmi.RequestInsertObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestInsertObject:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestInsertObject]:
            ...

        @property
        def resolutionValue(self) -> jpype.JInt:
            ...

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def resolution(self) -> TraceRmi.Resolution:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class ReplyInsertObjectOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class ReplyInsertObject(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyInsertObjectOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyInsertObject``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyInsertObject.Builder], TraceRmi.ReplyInsertObjectOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyInsertObject``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearSpan(self) -> TraceRmi.ReplyInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getSpan(self) -> TraceRmi.Span:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                
                :return: The span.
                :rtype: TraceRmi.Span
                """

            def getSpanBuilder(self) -> TraceRmi.Span.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            def hasSpan(self) -> bool:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                
                :return: Whether the span field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.ReplyInsertObject) -> TraceRmi.ReplyInsertObject.Builder:
                ...

            def mergeSpan(self, value: TraceRmi.Span) -> TraceRmi.ReplyInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @typing.overload
            def setSpan(self, value: TraceRmi.Span) -> TraceRmi.ReplyInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @typing.overload
            def setSpan(self, builderForValue: TraceRmi.Span.Builder) -> TraceRmi.ReplyInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @property
            def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                ...

            @property
            def spanBuilder(self) -> TraceRmi.Span.Builder:
                ...

            @property
            def span(self) -> TraceRmi.Span:
                ...


        class_: typing.ClassVar[java.lang.Class]
        SPAN_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyInsertObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyInsertObject) -> TraceRmi.ReplyInsertObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyInsertObject:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyInsertObject]:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class RequestRemoveObjectOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            """

        def getTree(self) -> bool:
            """
            ``bool tree = 4;``
            
            :return: The tree.
            :rtype: bool
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def tree(self) -> jpype.JBoolean:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class RequestRemoveObject(com.google.protobuf.GeneratedMessage, TraceRmi.RequestRemoveObjectOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestRemoveObject``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestRemoveObject.Builder], TraceRmi.RequestRemoveObjectOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestRemoveObject``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearObject(self) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def clearOid(self) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearSpan(self) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            def clearTree(self) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``bool tree = 4;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRemoveObject.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getObject(self) -> TraceRmi.ObjSpec:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: The object.
                :rtype: TraceRmi.ObjSpec
                """

            def getObjectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getSpan(self) -> TraceRmi.Span:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                
                :return: The span.
                :rtype: TraceRmi.Span
                """

            def getSpanBuilder(self) -> TraceRmi.Span.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            def getTree(self) -> bool:
                """
                ``bool tree = 4;``
                
                :return: The tree.
                :rtype: bool
                """

            def hasObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: Whether the object field is set.
                :rtype: bool
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasSpan(self) -> bool:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                
                :return: Whether the span field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestRemoveObject) -> TraceRmi.RequestRemoveObject.Builder:
                ...

            def mergeObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeSpan(self, value: TraceRmi.Span) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            @typing.overload
            def setObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setObject(self, builderForValue: TraceRmi.ObjSpec.Builder) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setSpan(self, value: TraceRmi.Span) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            @typing.overload
            def setSpan(self, builderForValue: TraceRmi.Span.Builder) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            def setTree(self, value: typing.Union[jpype.JBoolean, bool]) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``bool tree = 4;``
                
                :param jpype.JBoolean or bool value: The tree to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRemoveObject.Builder
                """

            @property
            def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                ...

            @property
            def objectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                ...

            @property
            def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                ...

            @property
            def tree(self) -> jpype.JBoolean:
                ...

            @property
            def spanBuilder(self) -> TraceRmi.Span.Builder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def span(self) -> TraceRmi.Span:
                ...

            @property
            def object(self) -> TraceRmi.ObjSpec:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        OBJECT_FIELD_NUMBER: typing.Final = 2
        SPAN_FIELD_NUMBER: typing.Final = 3
        TREE_FIELD_NUMBER: typing.Final = 4

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            """

        def getTree(self) -> bool:
            """
            ``bool tree = 4;``
            
            :return: The tree.
            :rtype: bool
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestRemoveObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestRemoveObject) -> TraceRmi.RequestRemoveObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRemoveObject:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestRemoveObject]:
            ...

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def tree(self) -> jpype.JBoolean:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class ReplyRemoveObjectOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyRemoveObject(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyRemoveObjectOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyRemoveObject``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyRemoveObject.Builder], TraceRmi.ReplyRemoveObjectOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyRemoveObject``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyRemoveObject) -> TraceRmi.ReplyRemoveObject.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyRemoveObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyRemoveObject) -> TraceRmi.ReplyRemoveObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRemoveObject:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyRemoveObject]:
            ...


    class RequestSetValueOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getResolution(self) -> TraceRmi.Resolution:
            """
            ``.ghidra.rmi.trace.Resolution resolution = 3;``
            
            :return: The resolution.
            :rtype: TraceRmi.Resolution
            """

        def getResolutionValue(self) -> int:
            """
            ``.ghidra.rmi.trace.Resolution resolution = 3;``
            
            :return: The enum numeric value on the wire for resolution.
            :rtype: int
            """

        def getValue(self) -> TraceRmi.ValSpec:
            """
            ``.ghidra.rmi.trace.ValSpec value = 2;``
            
            :return: The value.
            :rtype: TraceRmi.ValSpec
            """

        def getValueOrBuilder(self) -> TraceRmi.ValSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ValSpec value = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.ValSpec value = 2;``
            
            :return: Whether the value field is set.
            :rtype: bool
            """

        @property
        def resolutionValue(self) -> jpype.JInt:
            ...

        @property
        def valueOrBuilder(self) -> TraceRmi.ValSpecOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def value(self) -> TraceRmi.ValSpec:
            ...

        @property
        def resolution(self) -> TraceRmi.Resolution:
            ...


    class RequestSetValue(com.google.protobuf.GeneratedMessage, TraceRmi.RequestSetValueOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestSetValue``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestSetValue.Builder], TraceRmi.RequestSetValueOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestSetValue``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOid(self) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearResolution(self) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSetValue.Builder
                """

            def clearValue(self) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.ValSpec value = 2;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getResolution(self) -> TraceRmi.Resolution:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 3;``
                
                :return: The resolution.
                :rtype: TraceRmi.Resolution
                """

            def getResolutionValue(self) -> int:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 3;``
                
                :return: The enum numeric value on the wire for resolution.
                :rtype: int
                """

            def getValue(self) -> TraceRmi.ValSpec:
                """
                ``.ghidra.rmi.trace.ValSpec value = 2;``
                
                :return: The value.
                :rtype: TraceRmi.ValSpec
                """

            def getValueBuilder(self) -> TraceRmi.ValSpec.Builder:
                """
                ``.ghidra.rmi.trace.ValSpec value = 2;``
                """

            def getValueOrBuilder(self) -> TraceRmi.ValSpecOrBuilder:
                """
                ``.ghidra.rmi.trace.ValSpec value = 2;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.ValSpec value = 2;``
                
                :return: Whether the value field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestSetValue) -> TraceRmi.RequestSetValue.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeValue(self, value: TraceRmi.ValSpec) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.ValSpec value = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def setResolution(self, value: TraceRmi.Resolution) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 3;``
                
                :param TraceRmi.Resolution value: The resolution to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSetValue.Builder
                """

            def setResolutionValue(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.Resolution resolution = 3;``
                
                :param jpype.JInt or int value: The enum numeric value on the wire for resolution to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSetValue.Builder
                """

            @typing.overload
            def setValue(self, value: TraceRmi.ValSpec) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.ValSpec value = 2;``
                """

            @typing.overload
            def setValue(self, builderForValue: TraceRmi.ValSpec.Builder) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.ValSpec value = 2;``
                """

            @property
            def resolutionValue(self) -> jpype.JInt:
                ...

            @property
            def valueOrBuilder(self) -> TraceRmi.ValSpecOrBuilder:
                ...

            @property
            def valueBuilder(self) -> TraceRmi.ValSpec.Builder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def value(self) -> TraceRmi.ValSpec:
                ...

            @property
            def resolution(self) -> TraceRmi.Resolution:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        VALUE_FIELD_NUMBER: typing.Final = 2
        RESOLUTION_FIELD_NUMBER: typing.Final = 3

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getResolution(self) -> TraceRmi.Resolution:
            """
            ``.ghidra.rmi.trace.Resolution resolution = 3;``
            
            :return: The resolution.
            :rtype: TraceRmi.Resolution
            """

        def getResolutionValue(self) -> int:
            """
            ``.ghidra.rmi.trace.Resolution resolution = 3;``
            
            :return: The enum numeric value on the wire for resolution.
            :rtype: int
            """

        def getValue(self) -> TraceRmi.ValSpec:
            """
            ``.ghidra.rmi.trace.ValSpec value = 2;``
            
            :return: The value.
            :rtype: TraceRmi.ValSpec
            """

        def getValueOrBuilder(self) -> TraceRmi.ValSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ValSpec value = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.ValSpec value = 2;``
            
            :return: Whether the value field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestSetValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestSetValue) -> TraceRmi.RequestSetValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSetValue:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestSetValue]:
            ...

        @property
        def resolutionValue(self) -> jpype.JInt:
            ...

        @property
        def valueOrBuilder(self) -> TraceRmi.ValSpecOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def value(self) -> TraceRmi.ValSpec:
            ...

        @property
        def resolution(self) -> TraceRmi.Resolution:
            ...


    class ReplySetValueOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class ReplySetValue(com.google.protobuf.GeneratedMessage, TraceRmi.ReplySetValueOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplySetValue``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplySetValue.Builder], TraceRmi.ReplySetValueOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplySetValue``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearSpan(self) -> TraceRmi.ReplySetValue.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getSpan(self) -> TraceRmi.Span:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                
                :return: The span.
                :rtype: TraceRmi.Span
                """

            def getSpanBuilder(self) -> TraceRmi.Span.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            def hasSpan(self) -> bool:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                
                :return: Whether the span field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.ReplySetValue) -> TraceRmi.ReplySetValue.Builder:
                ...

            def mergeSpan(self, value: TraceRmi.Span) -> TraceRmi.ReplySetValue.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @typing.overload
            def setSpan(self, value: TraceRmi.Span) -> TraceRmi.ReplySetValue.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @typing.overload
            def setSpan(self, builderForValue: TraceRmi.Span.Builder) -> TraceRmi.ReplySetValue.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 1;``
                """

            @property
            def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                ...

            @property
            def spanBuilder(self) -> TraceRmi.Span.Builder:
                ...

            @property
            def span(self) -> TraceRmi.Span:
                ...


        class_: typing.ClassVar[java.lang.Class]
        SPAN_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 1;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplySetValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplySetValue) -> TraceRmi.ReplySetValue.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySetValue:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplySetValue]:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class RequestRetainValuesOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getKeys(self, index: typing.Union[jpype.JInt, int]) -> str:
            """
            ``repeated string keys = 5;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The keys at the given index.
            :rtype: str
            """

        def getKeysBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
            """
            ``repeated string keys = 5;``
            
            :param jpype.JInt or int index: The index of the value to return.
            :return: The bytes of the keys at the given index.
            :rtype: com.google.protobuf.ByteString
            """

        def getKeysCount(self) -> int:
            """
            ``repeated string keys = 5;``
            
            :return: The count of keys.
            :rtype: int
            """

        def getKeysList(self) -> java.util.List[java.lang.String]:
            """
            ``repeated string keys = 5;``
            
            :return: A list containing the keys.
            :rtype: java.util.List[java.lang.String]
            """

        def getKinds(self) -> TraceRmi.ValueKinds:
            """
            ``.ghidra.rmi.trace.ValueKinds kinds = 4;``
            
            :return: The kinds.
            :rtype: TraceRmi.ValueKinds
            """

        def getKindsValue(self) -> int:
            """
            ``.ghidra.rmi.trace.ValueKinds kinds = 4;``
            
            :return: The enum numeric value on the wire for kinds.
            :rtype: int
            """

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def keysList(self) -> java.util.List[java.lang.String]:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def keys(self) -> java.lang.String:
            ...

        @property
        def kindsValue(self) -> jpype.JInt:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def kinds(self) -> TraceRmi.ValueKinds:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def keysBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...

        @property
        def keysCount(self) -> jpype.JInt:
            ...


    class RequestRetainValues(com.google.protobuf.GeneratedMessage, TraceRmi.RequestRetainValuesOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestRetainValues``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestRetainValues.Builder], TraceRmi.RequestRetainValuesOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestRetainValues``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllKeys(self, values: collections.abc.Sequence) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``repeated string keys = 5;``
                
                :param collections.abc.Sequence values: The keys to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRetainValues.Builder
                """

            def addKeys(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``repeated string keys = 5;``
                
                :param java.lang.String or str value: The keys to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRetainValues.Builder
                """

            def addKeysBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``repeated string keys = 5;``
                
                :param com.google.protobuf.ByteString value: The bytes of the keys to add.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRetainValues.Builder
                """

            def clearKeys(self) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``repeated string keys = 5;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRetainValues.Builder
                """

            def clearKinds(self) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.ValueKinds kinds = 4;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRetainValues.Builder
                """

            def clearObject(self) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def clearOid(self) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearSpan(self) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getKeys(self, index: typing.Union[jpype.JInt, int]) -> str:
                """
                ``repeated string keys = 5;``
                
                :param jpype.JInt or int index: The index of the element to return.
                :return: The keys at the given index.
                :rtype: str
                """

            def getKeysBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
                """
                ``repeated string keys = 5;``
                
                :param jpype.JInt or int index: The index of the value to return.
                :return: The bytes of the keys at the given index.
                :rtype: com.google.protobuf.ByteString
                """

            def getKeysCount(self) -> int:
                """
                ``repeated string keys = 5;``
                
                :return: The count of keys.
                :rtype: int
                """

            def getKeysList(self) -> com.google.protobuf.ProtocolStringList:
                """
                ``repeated string keys = 5;``
                
                :return: A list containing the keys.
                :rtype: com.google.protobuf.ProtocolStringList
                """

            def getKinds(self) -> TraceRmi.ValueKinds:
                """
                ``.ghidra.rmi.trace.ValueKinds kinds = 4;``
                
                :return: The kinds.
                :rtype: TraceRmi.ValueKinds
                """

            def getKindsValue(self) -> int:
                """
                ``.ghidra.rmi.trace.ValueKinds kinds = 4;``
                
                :return: The enum numeric value on the wire for kinds.
                :rtype: int
                """

            def getObject(self) -> TraceRmi.ObjSpec:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: The object.
                :rtype: TraceRmi.ObjSpec
                """

            def getObjectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getSpan(self) -> TraceRmi.Span:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                
                :return: The span.
                :rtype: TraceRmi.Span
                """

            def getSpanBuilder(self) -> TraceRmi.Span.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            def hasObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: Whether the object field is set.
                :rtype: bool
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasSpan(self) -> bool:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                
                :return: Whether the span field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestRetainValues) -> TraceRmi.RequestRetainValues.Builder:
                ...

            def mergeObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeSpan(self, value: TraceRmi.Span) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            def setKeys(self, index: typing.Union[jpype.JInt, int], value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``repeated string keys = 5;``
                
                :param jpype.JInt or int index: The index to set the value at.
                :param java.lang.String or str value: The keys to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRetainValues.Builder
                """

            def setKinds(self, value: TraceRmi.ValueKinds) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.ValueKinds kinds = 4;``
                
                :param TraceRmi.ValueKinds value: The kinds to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRetainValues.Builder
                """

            def setKindsValue(self, value: typing.Union[jpype.JInt, int]) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.ValueKinds kinds = 4;``
                
                :param jpype.JInt or int value: The enum numeric value on the wire for kinds to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestRetainValues.Builder
                """

            @typing.overload
            def setObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setObject(self, builderForValue: TraceRmi.ObjSpec.Builder) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setSpan(self, value: TraceRmi.Span) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            @typing.overload
            def setSpan(self, builderForValue: TraceRmi.Span.Builder) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 3;``
                """

            @property
            def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                ...

            @property
            def objectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                ...

            @property
            def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                ...

            @property
            def keys(self) -> java.lang.String:
                ...

            @property
            def kindsValue(self) -> jpype.JInt:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def kinds(self) -> TraceRmi.ValueKinds:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def keysBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def keysList(self) -> com.google.protobuf.ProtocolStringList:
                ...

            @property
            def spanBuilder(self) -> TraceRmi.Span.Builder:
                ...

            @property
            def span(self) -> TraceRmi.Span:
                ...

            @property
            def object(self) -> TraceRmi.ObjSpec:
                ...

            @property
            def keysCount(self) -> jpype.JInt:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        OBJECT_FIELD_NUMBER: typing.Final = 2
        SPAN_FIELD_NUMBER: typing.Final = 3
        KINDS_FIELD_NUMBER: typing.Final = 4
        KEYS_FIELD_NUMBER: typing.Final = 5

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getKeys(self, index: typing.Union[jpype.JInt, int]) -> str:
            """
            ``repeated string keys = 5;``
            
            :param jpype.JInt or int index: The index of the element to return.
            :return: The keys at the given index.
            :rtype: str
            """

        def getKeysBytes(self, index: typing.Union[jpype.JInt, int]) -> com.google.protobuf.ByteString:
            """
            ``repeated string keys = 5;``
            
            :param jpype.JInt or int index: The index of the value to return.
            :return: The bytes of the keys at the given index.
            :rtype: com.google.protobuf.ByteString
            """

        def getKeysCount(self) -> int:
            """
            ``repeated string keys = 5;``
            
            :return: The count of keys.
            :rtype: int
            """

        def getKeysList(self) -> com.google.protobuf.ProtocolStringList:
            """
            ``repeated string keys = 5;``
            
            :return: A list containing the keys.
            :rtype: com.google.protobuf.ProtocolStringList
            """

        def getKinds(self) -> TraceRmi.ValueKinds:
            """
            ``.ghidra.rmi.trace.ValueKinds kinds = 4;``
            
            :return: The kinds.
            :rtype: TraceRmi.ValueKinds
            """

        def getKindsValue(self) -> int:
            """
            ``.ghidra.rmi.trace.ValueKinds kinds = 4;``
            
            :return: The enum numeric value on the wire for kinds.
            :rtype: int
            """

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 3;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestRetainValues.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestRetainValues) -> TraceRmi.RequestRetainValues.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestRetainValues:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestRetainValues]:
            ...

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def keysList(self) -> com.google.protobuf.ProtocolStringList:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def keys(self) -> java.lang.String:
            ...

        @property
        def kindsValue(self) -> jpype.JInt:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def kinds(self) -> TraceRmi.ValueKinds:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def keysBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...

        @property
        def keysCount(self) -> jpype.JInt:
            ...


    class ReplyRetainValuesOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyRetainValues(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyRetainValuesOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyRetainValues``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyRetainValues.Builder], TraceRmi.ReplyRetainValuesOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyRetainValues``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyRetainValues) -> TraceRmi.ReplyRetainValues.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyRetainValues.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyRetainValues) -> TraceRmi.ReplyRetainValues.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyRetainValues:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyRetainValues]:
            ...


    class RequestGetObjectOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class RequestGetObject(com.google.protobuf.GeneratedMessage, TraceRmi.RequestGetObjectOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestGetObject``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestGetObject.Builder], TraceRmi.RequestGetObjectOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestGetObject``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearObject(self) -> TraceRmi.RequestGetObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def clearOid(self) -> TraceRmi.RequestGetObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getObject(self) -> TraceRmi.ObjSpec:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: The object.
                :rtype: TraceRmi.ObjSpec
                """

            def getObjectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def hasObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: Whether the object field is set.
                :rtype: bool
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestGetObject) -> TraceRmi.RequestGetObject.Builder:
                ...

            def mergeObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestGetObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestGetObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestGetObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setObject(self, builderForValue: TraceRmi.ObjSpec.Builder) -> TraceRmi.RequestGetObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestGetObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestGetObject.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @property
            def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                ...

            @property
            def objectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def object(self) -> TraceRmi.ObjSpec:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        OBJECT_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestGetObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestGetObject) -> TraceRmi.RequestGetObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetObject:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestGetObject]:
            ...

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class ReplyGetObjectOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getObject(self) -> TraceRmi.ObjDesc:
            """
            ``.ghidra.rmi.trace.ObjDesc object = 1;``
            
            :return: The object.
            :rtype: TraceRmi.ObjDesc
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjDesc object = 1;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjDesc object = 1;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            ...

        @property
        def object(self) -> TraceRmi.ObjDesc:
            ...


    class ReplyGetObject(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyGetObjectOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyGetObject``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyGetObject.Builder], TraceRmi.ReplyGetObjectOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyGetObject``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearObject(self) -> TraceRmi.ReplyGetObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc object = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getObject(self) -> TraceRmi.ObjDesc:
                """
                ``.ghidra.rmi.trace.ObjDesc object = 1;``
                
                :return: The object.
                :rtype: TraceRmi.ObjDesc
                """

            def getObjectBuilder(self) -> TraceRmi.ObjDesc.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc object = 1;``
                """

            def getObjectOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjDesc object = 1;``
                """

            def hasObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjDesc object = 1;``
                
                :return: Whether the object field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.ReplyGetObject) -> TraceRmi.ReplyGetObject.Builder:
                ...

            def mergeObject(self, value: TraceRmi.ObjDesc) -> TraceRmi.ReplyGetObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc object = 1;``
                """

            @typing.overload
            def setObject(self, value: TraceRmi.ObjDesc) -> TraceRmi.ReplyGetObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc object = 1;``
                """

            @typing.overload
            def setObject(self, builderForValue: TraceRmi.ObjDesc.Builder) -> TraceRmi.ReplyGetObject.Builder:
                """
                ``.ghidra.rmi.trace.ObjDesc object = 1;``
                """

            @property
            def objectOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
                ...

            @property
            def objectBuilder(self) -> TraceRmi.ObjDesc.Builder:
                ...

            @property
            def object(self) -> TraceRmi.ObjDesc:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OBJECT_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getObject(self) -> TraceRmi.ObjDesc:
            """
            ``.ghidra.rmi.trace.ObjDesc object = 1;``
            
            :return: The object.
            :rtype: TraceRmi.ObjDesc
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjDesc object = 1;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjDesc object = 1;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyGetObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyGetObject) -> TraceRmi.ReplyGetObject.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetObject:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyGetObject]:
            ...

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjDescOrBuilder:
            ...

        @property
        def object(self) -> TraceRmi.ObjDesc:
            ...


    class RequestGetValuesOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getPattern(self) -> TraceRmi.ObjPath:
            """
            ``.ghidra.rmi.trace.ObjPath pattern = 3;``
            
            :return: The pattern.
            :rtype: TraceRmi.ObjPath
            """

        def getPatternOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjPath pattern = 3;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasPattern(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjPath pattern = 3;``
            
            :return: Whether the pattern field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def patternOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            ...

        @property
        def pattern(self) -> TraceRmi.ObjPath:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class RequestGetValues(com.google.protobuf.GeneratedMessage, TraceRmi.RequestGetValuesOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestGetValues``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestGetValues.Builder], TraceRmi.RequestGetValuesOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestGetValues``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOid(self) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearPattern(self) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath pattern = 3;``
                """

            def clearSpan(self) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getPattern(self) -> TraceRmi.ObjPath:
                """
                ``.ghidra.rmi.trace.ObjPath pattern = 3;``
                
                :return: The pattern.
                :rtype: TraceRmi.ObjPath
                """

            def getPatternBuilder(self) -> TraceRmi.ObjPath.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath pattern = 3;``
                """

            def getPatternOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjPath pattern = 3;``
                """

            def getSpan(self) -> TraceRmi.Span:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                
                :return: The span.
                :rtype: TraceRmi.Span
                """

            def getSpanBuilder(self) -> TraceRmi.Span.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasPattern(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjPath pattern = 3;``
                
                :return: Whether the pattern field is set.
                :rtype: bool
                """

            def hasSpan(self) -> bool:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                
                :return: Whether the span field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestGetValues) -> TraceRmi.RequestGetValues.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergePattern(self, value: TraceRmi.ObjPath) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath pattern = 3;``
                """

            def mergeSpan(self, value: TraceRmi.Span) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setPattern(self, value: TraceRmi.ObjPath) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath pattern = 3;``
                """

            @typing.overload
            def setPattern(self, builderForValue: TraceRmi.ObjPath.Builder) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.ObjPath pattern = 3;``
                """

            @typing.overload
            def setSpan(self, value: TraceRmi.Span) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            @typing.overload
            def setSpan(self, builderForValue: TraceRmi.Span.Builder) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.Span span = 2;``
                """

            @property
            def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
                ...

            @property
            def patternBuilder(self) -> TraceRmi.ObjPath.Builder:
                ...

            @property
            def patternOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
                ...

            @property
            def spanBuilder(self) -> TraceRmi.Span.Builder:
                ...

            @property
            def pattern(self) -> TraceRmi.ObjPath:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def span(self) -> TraceRmi.Span:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        SPAN_FIELD_NUMBER: typing.Final = 2
        PATTERN_FIELD_NUMBER: typing.Final = 3

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getPattern(self) -> TraceRmi.ObjPath:
            """
            ``.ghidra.rmi.trace.ObjPath pattern = 3;``
            
            :return: The pattern.
            :rtype: TraceRmi.ObjPath
            """

        def getPatternOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjPath pattern = 3;``
            """

        def getSpan(self) -> TraceRmi.Span:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: The span.
            :rtype: TraceRmi.Span
            """

        def getSpanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasPattern(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjPath pattern = 3;``
            
            :return: Whether the pattern field is set.
            :rtype: bool
            """

        def hasSpan(self) -> bool:
            """
            ``.ghidra.rmi.trace.Span span = 2;``
            
            :return: Whether the span field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestGetValues.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestGetValues) -> TraceRmi.RequestGetValues.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValues:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestGetValues]:
            ...

        @property
        def spanOrBuilder(self) -> TraceRmi.SpanOrBuilder:
            ...

        @property
        def patternOrBuilder(self) -> TraceRmi.ObjPathOrBuilder:
            ...

        @property
        def pattern(self) -> TraceRmi.ObjPath:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def span(self) -> TraceRmi.Span:
            ...


    class ReplyGetValuesOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getValues(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.ValDesc:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        def getValuesCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        def getValuesList(self) -> java.util.List[TraceRmi.ValDesc]:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        def getValuesOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.ValDescOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        def getValuesOrBuilderList(self) -> java.util.List[TraceRmi.ValDescOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        @property
        def valuesCount(self) -> jpype.JInt:
            ...

        @property
        def valuesList(self) -> java.util.List[TraceRmi.ValDesc]:
            ...

        @property
        def values(self) -> TraceRmi.ValDesc:
            ...

        @property
        def valuesOrBuilder(self) -> TraceRmi.ValDescOrBuilder:
            ...

        @property
        def valuesOrBuilderList(self) -> java.util.List[TraceRmi.ValDescOrBuilder]:
            ...


    class ReplyGetValues(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyGetValuesOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyGetValues``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyGetValues.Builder], TraceRmi.ReplyGetValuesOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyGetValues``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllValues(self, values: collections.abc.Sequence) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @typing.overload
            def addValues(self, value: TraceRmi.ValDesc) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @typing.overload
            def addValues(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.ValDesc) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @typing.overload
            def addValues(self, builderForValue: TraceRmi.ValDesc.Builder) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @typing.overload
            def addValues(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.ValDesc.Builder) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @typing.overload
            def addValuesBuilder(self) -> TraceRmi.ValDesc.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @typing.overload
            def addValuesBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.ValDesc.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            def clearValues(self) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getValues(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.ValDesc:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            def getValuesBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.ValDesc.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            def getValuesBuilderList(self) -> java.util.List[TraceRmi.ValDesc.Builder]:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            def getValuesCount(self) -> int:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            def getValuesList(self) -> java.util.List[TraceRmi.ValDesc]:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            def getValuesOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.ValDescOrBuilder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            def getValuesOrBuilderList(self) -> java.util.List[TraceRmi.ValDescOrBuilder]:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            def mergeFrom(self, other: TraceRmi.ReplyGetValues) -> TraceRmi.ReplyGetValues.Builder:
                ...

            def removeValues(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @typing.overload
            def setValues(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.ValDesc) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @typing.overload
            def setValues(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.ValDesc.Builder) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
                """

            @property
            def valuesCount(self) -> jpype.JInt:
                ...

            @property
            def valuesList(self) -> java.util.List[TraceRmi.ValDesc]:
                ...

            @property
            def values(self) -> TraceRmi.ValDesc:
                ...

            @property
            def valuesOrBuilder(self) -> TraceRmi.ValDescOrBuilder:
                ...

            @property
            def valuesBuilder(self) -> TraceRmi.ValDesc.Builder:
                ...

            @property
            def valuesOrBuilderList(self) -> java.util.List[TraceRmi.ValDescOrBuilder]:
                ...

            @property
            def valuesBuilderList(self) -> java.util.List[TraceRmi.ValDesc.Builder]:
                ...


        class_: typing.ClassVar[java.lang.Class]
        VALUES_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getValues(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.ValDesc:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        def getValuesCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        def getValuesList(self) -> java.util.List[TraceRmi.ValDesc]:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        def getValuesOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.ValDescOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        def getValuesOrBuilderList(self) -> java.util.List[TraceRmi.ValDescOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.ValDesc values = 1;``
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyGetValues.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyGetValues) -> TraceRmi.ReplyGetValues.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyGetValues:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyGetValues]:
            ...

        @property
        def valuesCount(self) -> jpype.JInt:
            ...

        @property
        def valuesList(self) -> java.util.List[TraceRmi.ValDesc]:
            ...

        @property
        def values(self) -> TraceRmi.ValDesc:
            ...

        @property
        def valuesOrBuilder(self) -> TraceRmi.ValDescOrBuilder:
            ...

        @property
        def valuesOrBuilderList(self) -> java.util.List[TraceRmi.ValDescOrBuilder]:
            ...


    class RequestGetValuesIntersectingOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getBox(self) -> TraceRmi.Box:
            """
            ``.ghidra.rmi.trace.Box box = 2;``
            
            :return: The box.
            :rtype: TraceRmi.Box
            """

        def getBoxOrBuilder(self) -> TraceRmi.BoxOrBuilder:
            """
            ``.ghidra.rmi.trace.Box box = 2;``
            """

        def getKey(self) -> str:
            """
            ``string key = 3;``
            
            :return: The key.
            :rtype: str
            """

        def getKeyBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string key = 3;``
            
            :return: The bytes for key.
            :rtype: com.google.protobuf.ByteString
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasBox(self) -> bool:
            """
            ``.ghidra.rmi.trace.Box box = 2;``
            
            :return: Whether the box field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @property
        def keyBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def boxOrBuilder(self) -> TraceRmi.BoxOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def box(self) -> TraceRmi.Box:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def key(self) -> java.lang.String:
            ...


    class RequestGetValuesIntersecting(com.google.protobuf.GeneratedMessage, TraceRmi.RequestGetValuesIntersectingOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestGetValuesIntersecting``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestGetValuesIntersecting.Builder], TraceRmi.RequestGetValuesIntersectingOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestGetValuesIntersecting``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearBox(self) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``.ghidra.rmi.trace.Box box = 2;``
                """

            def clearKey(self) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``string key = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestGetValuesIntersecting.Builder
                """

            def clearOid(self) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getBox(self) -> TraceRmi.Box:
                """
                ``.ghidra.rmi.trace.Box box = 2;``
                
                :return: The box.
                :rtype: TraceRmi.Box
                """

            def getBoxBuilder(self) -> TraceRmi.Box.Builder:
                """
                ``.ghidra.rmi.trace.Box box = 2;``
                """

            def getBoxOrBuilder(self) -> TraceRmi.BoxOrBuilder:
                """
                ``.ghidra.rmi.trace.Box box = 2;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getKey(self) -> str:
                """
                ``string key = 3;``
                
                :return: The key.
                :rtype: str
                """

            def getKeyBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string key = 3;``
                
                :return: The bytes for key.
                :rtype: com.google.protobuf.ByteString
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def hasBox(self) -> bool:
                """
                ``.ghidra.rmi.trace.Box box = 2;``
                
                :return: Whether the box field is set.
                :rtype: bool
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def mergeBox(self, value: TraceRmi.Box) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``.ghidra.rmi.trace.Box box = 2;``
                """

            def mergeFrom(self, other: TraceRmi.RequestGetValuesIntersecting) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setBox(self, value: TraceRmi.Box) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``.ghidra.rmi.trace.Box box = 2;``
                """

            @typing.overload
            def setBox(self, builderForValue: TraceRmi.Box.Builder) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``.ghidra.rmi.trace.Box box = 2;``
                """

            def setKey(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``string key = 3;``
                
                :param java.lang.String or str value: The key to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestGetValuesIntersecting.Builder
                """

            def setKeyBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``string key = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for key to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestGetValuesIntersecting.Builder
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @property
            def boxBuilder(self) -> TraceRmi.Box.Builder:
                ...

            @property
            def keyBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def boxOrBuilder(self) -> TraceRmi.BoxOrBuilder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def box(self) -> TraceRmi.Box:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def key(self) -> java.lang.String:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        BOX_FIELD_NUMBER: typing.Final = 2
        KEY_FIELD_NUMBER: typing.Final = 3

        def getBox(self) -> TraceRmi.Box:
            """
            ``.ghidra.rmi.trace.Box box = 2;``
            
            :return: The box.
            :rtype: TraceRmi.Box
            """

        def getBoxOrBuilder(self) -> TraceRmi.BoxOrBuilder:
            """
            ``.ghidra.rmi.trace.Box box = 2;``
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getKey(self) -> str:
            """
            ``string key = 3;``
            
            :return: The key.
            :rtype: str
            """

        def getKeyBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string key = 3;``
            
            :return: The bytes for key.
            :rtype: com.google.protobuf.ByteString
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasBox(self) -> bool:
            """
            ``.ghidra.rmi.trace.Box box = 2;``
            
            :return: Whether the box field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestGetValuesIntersecting.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestGetValuesIntersecting) -> TraceRmi.RequestGetValuesIntersecting.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestGetValuesIntersecting]:
            ...

        @property
        def keyBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def boxOrBuilder(self) -> TraceRmi.BoxOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def box(self) -> TraceRmi.Box:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def key(self) -> java.lang.String:
            ...


    class RequestDisassembleOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getStart(self) -> TraceRmi.Addr:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            
            :return: The start.
            :rtype: TraceRmi.Addr
            """

        def getStartOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        def hasStart(self) -> bool:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            
            :return: Whether the start field is set.
            :rtype: bool
            """

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def start(self) -> TraceRmi.Addr:
            ...

        @property
        def startOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class RequestDisassemble(com.google.protobuf.GeneratedMessage, TraceRmi.RequestDisassembleOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestDisassemble``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestDisassemble.Builder], TraceRmi.RequestDisassembleOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestDisassemble``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearOid(self) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearSnap(self) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def clearStart(self) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getSnap(self) -> TraceRmi.Snap:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: The snap.
                :rtype: TraceRmi.Snap
                """

            def getSnapBuilder(self) -> TraceRmi.Snap.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def getStart(self) -> TraceRmi.Addr:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                
                :return: The start.
                :rtype: TraceRmi.Addr
                """

            def getStartBuilder(self) -> TraceRmi.Addr.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            def getStartOrBuilder(self) -> TraceRmi.AddrOrBuilder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasSnap(self) -> bool:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                
                :return: Whether the snap field is set.
                :rtype: bool
                """

            def hasStart(self) -> bool:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                
                :return: Whether the start field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestDisassemble) -> TraceRmi.RequestDisassemble.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            def mergeStart(self, value: TraceRmi.Addr) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setSnap(self, builderForValue: TraceRmi.Snap.Builder) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 2;``
                """

            @typing.overload
            def setStart(self, value: TraceRmi.Addr) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            @typing.overload
            def setStart(self, builderForValue: TraceRmi.Addr.Builder) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.Addr start = 3;``
                """

            @property
            def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                ...

            @property
            def start(self) -> TraceRmi.Addr:
                ...

            @property
            def snapBuilder(self) -> TraceRmi.Snap.Builder:
                ...

            @property
            def startOrBuilder(self) -> TraceRmi.AddrOrBuilder:
                ...

            @property
            def startBuilder(self) -> TraceRmi.Addr.Builder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def snap(self) -> TraceRmi.Snap:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        SNAP_FIELD_NUMBER: typing.Final = 2
        START_FIELD_NUMBER: typing.Final = 3

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            """

        def getStart(self) -> TraceRmi.Addr:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            
            :return: The start.
            :rtype: TraceRmi.Addr
            """

        def getStartOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 2;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        def hasStart(self) -> bool:
            """
            ``.ghidra.rmi.trace.Addr start = 3;``
            
            :return: Whether the start field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestDisassemble.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestDisassemble) -> TraceRmi.RequestDisassemble.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestDisassemble:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestDisassemble]:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def start(self) -> TraceRmi.Addr:
            ...

        @property
        def startOrBuilder(self) -> TraceRmi.AddrOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class ReplyDisassembleOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getLength(self) -> int:
            """
            ``int64 length = 1;``
            
            :return: The length.
            :rtype: int
            """

        @property
        def length(self) -> jpype.JLong:
            ...


    class ReplyDisassemble(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyDisassembleOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyDisassemble``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyDisassemble.Builder], TraceRmi.ReplyDisassembleOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyDisassemble``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearLength(self) -> TraceRmi.ReplyDisassemble.Builder:
                """
                ``int64 length = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyDisassemble.Builder
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getLength(self) -> int:
                """
                ``int64 length = 1;``
                
                :return: The length.
                :rtype: int
                """

            def mergeFrom(self, other: TraceRmi.ReplyDisassemble) -> TraceRmi.ReplyDisassemble.Builder:
                ...

            def setLength(self, value: typing.Union[jpype.JLong, int]) -> TraceRmi.ReplyDisassemble.Builder:
                """
                ``int64 length = 1;``
                
                :param jpype.JLong or int value: The length to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyDisassemble.Builder
                """

            @property
            def length(self) -> jpype.JLong:
                ...


        class_: typing.ClassVar[java.lang.Class]
        LENGTH_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getLength(self) -> int:
            """
            ``int64 length = 1;``
            
            :return: The length.
            :rtype: int
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyDisassemble.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyDisassemble) -> TraceRmi.ReplyDisassemble.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyDisassemble:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyDisassemble]:
            ...

        @property
        def length(self) -> jpype.JLong:
            ...


    class RequestActivateOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class RequestActivate(com.google.protobuf.GeneratedMessage, TraceRmi.RequestActivateOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestActivate``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestActivate.Builder], TraceRmi.RequestActivateOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestActivate``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearObject(self) -> TraceRmi.RequestActivate.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def clearOid(self) -> TraceRmi.RequestActivate.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getObject(self) -> TraceRmi.ObjSpec:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: The object.
                :rtype: TraceRmi.ObjSpec
                """

            def getObjectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def hasObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                
                :return: Whether the object field is set.
                :rtype: bool
                """

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestActivate) -> TraceRmi.RequestActivate.Builder:
                ...

            def mergeObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestActivate.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestActivate.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setObject(self, value: TraceRmi.ObjSpec) -> TraceRmi.RequestActivate.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setObject(self, builderForValue: TraceRmi.ObjSpec.Builder) -> TraceRmi.RequestActivate.Builder:
                """
                ``.ghidra.rmi.trace.ObjSpec object = 2;``
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestActivate.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestActivate.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @property
            def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
                ...

            @property
            def objectBuilder(self) -> TraceRmi.ObjSpec.Builder:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def object(self) -> TraceRmi.ObjSpec:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        OBJECT_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getObject(self) -> TraceRmi.ObjSpec:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: The object.
            :rtype: TraceRmi.ObjSpec
            """

        def getObjectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ObjSpec object = 2;``
            
            :return: Whether the object field is set.
            :rtype: bool
            """

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestActivate.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestActivate) -> TraceRmi.RequestActivate.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestActivate:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestActivate]:
            ...

        @property
        def objectOrBuilder(self) -> TraceRmi.ObjSpecOrBuilder:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def object(self) -> TraceRmi.ObjSpec:
            ...


    class ReplyActivateOrBuilder(com.google.protobuf.MessageOrBuilder):
        ...
        class_: typing.ClassVar[java.lang.Class]


    class ReplyActivate(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyActivateOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyActivate``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyActivate.Builder], TraceRmi.ReplyActivateOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyActivate``
            """

            class_: typing.ClassVar[java.lang.Class]

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyActivate) -> TraceRmi.ReplyActivate.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyActivate.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyActivate) -> TraceRmi.ReplyActivate.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyActivate:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyActivate]:
            ...


    class RequestSnapshotOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getDatetime(self) -> str:
            """
            ``string datetime = 3;``
            
            :return: The datetime.
            :rtype: str
            """

        def getDatetimeBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string datetime = 3;``
            
            :return: The bytes for datetime.
            :rtype: com.google.protobuf.ByteString
            """

        def getDescription(self) -> str:
            """
            ``string description = 2;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 2;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSchedule(self) -> TraceRmi.Schedule:
            """
            ``.ghidra.rmi.trace.Schedule schedule = 5;``
            
            :return: The schedule.
            :rtype: TraceRmi.Schedule
            """

        def getScheduleOrBuilder(self) -> TraceRmi.ScheduleOrBuilder:
            """
            ``.ghidra.rmi.trace.Schedule schedule = 5;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 4;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 4;``
            """

        def getTimeCase(self) -> TraceRmi.RequestSnapshot.TimeCase:
            ...

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSchedule(self) -> bool:
            """
            ``.ghidra.rmi.trace.Schedule schedule = 5;``
            
            :return: Whether the schedule field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 4;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @property
        def scheduleOrBuilder(self) -> TraceRmi.ScheduleOrBuilder:
            ...

        @property
        def schedule(self) -> TraceRmi.Schedule:
            ...

        @property
        def datetimeBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def datetime(self) -> java.lang.String:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def timeCase(self) -> TraceRmi.RequestSnapshot.TimeCase:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class RequestSnapshot(com.google.protobuf.GeneratedMessage, TraceRmi.RequestSnapshotOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestSnapshot``
        """

        class TimeCase(java.lang.Enum[TraceRmi.RequestSnapshot.TimeCase], com.google.protobuf.Internal.EnumLite, com.google.protobuf.AbstractMessageLite.InternalOneOfEnum):

            class_: typing.ClassVar[java.lang.Class]
            SNAP: typing.Final[TraceRmi.RequestSnapshot.TimeCase]
            SCHEDULE: typing.Final[TraceRmi.RequestSnapshot.TimeCase]
            TIME_NOT_SET: typing.Final[TraceRmi.RequestSnapshot.TimeCase]

            @staticmethod
            def forNumber(value: typing.Union[jpype.JInt, int]) -> TraceRmi.RequestSnapshot.TimeCase:
                ...

            def getNumber(self) -> int:
                ...

            @staticmethod
            @typing.overload
            def valueOf(name: typing.Union[java.lang.String, str]) -> TraceRmi.RequestSnapshot.TimeCase:
                ...

            @staticmethod
            @typing.overload
            @deprecated("Use forNumber(int) instead.")
            def valueOf(value: typing.Union[jpype.JInt, int]) -> TraceRmi.RequestSnapshot.TimeCase:
                """
                
                
                :param jpype.JInt or int value: The number of the enum to look for.
                :return: The enum associated with the given number.
                :rtype: TraceRmi.RequestSnapshot.TimeCase
                
                .. deprecated::
                
                Use :meth:`forNumber(int) <.forNumber>` instead.
                """

            @staticmethod
            def values() -> jpype.JArray[TraceRmi.RequestSnapshot.TimeCase]:
                ...

            @property
            def number(self) -> jpype.JInt:
                ...


        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestSnapshot.Builder], TraceRmi.RequestSnapshotOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestSnapshot``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearDatetime(self) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``string datetime = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSnapshot.Builder
                """

            def clearDescription(self) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``string description = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSnapshot.Builder
                """

            def clearOid(self) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def clearSchedule(self) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Schedule schedule = 5;``
                """

            def clearSnap(self) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 4;``
                """

            def clearTime(self) -> TraceRmi.RequestSnapshot.Builder:
                ...

            def getDatetime(self) -> str:
                """
                ``string datetime = 3;``
                
                :return: The datetime.
                :rtype: str
                """

            def getDatetimeBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string datetime = 3;``
                
                :return: The bytes for datetime.
                :rtype: com.google.protobuf.ByteString
                """

            def getDescription(self) -> str:
                """
                ``string description = 2;``
                
                :return: The description.
                :rtype: str
                """

            def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string description = 2;``
                
                :return: The bytes for description.
                :rtype: com.google.protobuf.ByteString
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getSchedule(self) -> TraceRmi.Schedule:
                """
                ``.ghidra.rmi.trace.Schedule schedule = 5;``
                
                :return: The schedule.
                :rtype: TraceRmi.Schedule
                """

            def getScheduleBuilder(self) -> TraceRmi.Schedule.Builder:
                """
                ``.ghidra.rmi.trace.Schedule schedule = 5;``
                """

            def getScheduleOrBuilder(self) -> TraceRmi.ScheduleOrBuilder:
                """
                ``.ghidra.rmi.trace.Schedule schedule = 5;``
                """

            def getSnap(self) -> TraceRmi.Snap:
                """
                ``.ghidra.rmi.trace.Snap snap = 4;``
                
                :return: The snap.
                :rtype: TraceRmi.Snap
                """

            def getSnapBuilder(self) -> TraceRmi.Snap.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 4;``
                """

            def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                """
                ``.ghidra.rmi.trace.Snap snap = 4;``
                """

            def getTimeCase(self) -> TraceRmi.RequestSnapshot.TimeCase:
                ...

            def hasOid(self) -> bool:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def hasSchedule(self) -> bool:
                """
                ``.ghidra.rmi.trace.Schedule schedule = 5;``
                
                :return: Whether the schedule field is set.
                :rtype: bool
                """

            def hasSnap(self) -> bool:
                """
                ``.ghidra.rmi.trace.Snap snap = 4;``
                
                :return: Whether the snap field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.RequestSnapshot) -> TraceRmi.RequestSnapshot.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def mergeSchedule(self, value: TraceRmi.Schedule) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Schedule schedule = 5;``
                """

            def mergeSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 4;``
                """

            def setDatetime(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``string datetime = 3;``
                
                :param java.lang.String or str value: The datetime to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSnapshot.Builder
                """

            def setDatetimeBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``string datetime = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for datetime to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSnapshot.Builder
                """

            def setDescription(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``string description = 2;``
                
                :param java.lang.String or str value: The description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSnapshot.Builder
                """

            def setDescriptionBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``string description = 2;``
                
                :param com.google.protobuf.ByteString value: The bytes for description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestSnapshot.Builder
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setSchedule(self, value: TraceRmi.Schedule) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Schedule schedule = 5;``
                """

            @typing.overload
            def setSchedule(self, builderForValue: TraceRmi.Schedule.Builder) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Schedule schedule = 5;``
                """

            @typing.overload
            def setSnap(self, value: TraceRmi.Snap) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 4;``
                """

            @typing.overload
            def setSnap(self, builderForValue: TraceRmi.Snap.Builder) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 4;``
                """

            @property
            def datetimeBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def snapBuilder(self) -> TraceRmi.Snap.Builder:
                ...

            @property
            def description(self) -> java.lang.String:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def descriptionBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def scheduleOrBuilder(self) -> TraceRmi.ScheduleOrBuilder:
                ...

            @property
            def schedule(self) -> TraceRmi.Schedule:
                ...

            @property
            def datetime(self) -> java.lang.String:
                ...

            @property
            def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                ...

            @property
            def timeCase(self) -> TraceRmi.RequestSnapshot.TimeCase:
                ...

            @property
            def scheduleBuilder(self) -> TraceRmi.Schedule.Builder:
                ...

            @property
            def snap(self) -> TraceRmi.Snap:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        DESCRIPTION_FIELD_NUMBER: typing.Final = 2
        DATETIME_FIELD_NUMBER: typing.Final = 3
        SNAP_FIELD_NUMBER: typing.Final = 4
        SCHEDULE_FIELD_NUMBER: typing.Final = 5

        def getDatetime(self) -> str:
            """
            ``string datetime = 3;``
            
            :return: The datetime.
            :rtype: str
            """

        def getDatetimeBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string datetime = 3;``
            
            :return: The bytes for datetime.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestSnapshot:
            ...

        def getDescription(self) -> str:
            """
            ``string description = 2;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 2;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def getSchedule(self) -> TraceRmi.Schedule:
            """
            ``.ghidra.rmi.trace.Schedule schedule = 5;``
            
            :return: The schedule.
            :rtype: TraceRmi.Schedule
            """

        def getScheduleOrBuilder(self) -> TraceRmi.ScheduleOrBuilder:
            """
            ``.ghidra.rmi.trace.Schedule schedule = 5;``
            """

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 4;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 4;``
            """

        def getTimeCase(self) -> TraceRmi.RequestSnapshot.TimeCase:
            ...

        def hasOid(self) -> bool:
            """
            ``.ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        def hasSchedule(self) -> bool:
            """
            ``.ghidra.rmi.trace.Schedule schedule = 5;``
            
            :return: Whether the schedule field is set.
            :rtype: bool
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 4;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestSnapshot.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestSnapshot) -> TraceRmi.RequestSnapshot.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestSnapshot:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestSnapshot]:
            ...

        @property
        def scheduleOrBuilder(self) -> TraceRmi.ScheduleOrBuilder:
            ...

        @property
        def schedule(self) -> TraceRmi.Schedule:
            ...

        @property
        def datetimeBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def datetime(self) -> java.lang.String:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def timeCase(self) -> TraceRmi.RequestSnapshot.TimeCase:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class ReplySnapshotOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 1;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 1;``
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 1;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class ReplySnapshot(com.google.protobuf.GeneratedMessage, TraceRmi.ReplySnapshotOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplySnapshot``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplySnapshot.Builder], TraceRmi.ReplySnapshotOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplySnapshot``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearSnap(self) -> TraceRmi.ReplySnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 1;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getSnap(self) -> TraceRmi.Snap:
                """
                ``.ghidra.rmi.trace.Snap snap = 1;``
                
                :return: The snap.
                :rtype: TraceRmi.Snap
                """

            def getSnapBuilder(self) -> TraceRmi.Snap.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 1;``
                """

            def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                """
                ``.ghidra.rmi.trace.Snap snap = 1;``
                """

            def hasSnap(self) -> bool:
                """
                ``.ghidra.rmi.trace.Snap snap = 1;``
                
                :return: Whether the snap field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.ReplySnapshot) -> TraceRmi.ReplySnapshot.Builder:
                ...

            def mergeSnap(self, value: TraceRmi.Snap) -> TraceRmi.ReplySnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 1;``
                """

            @typing.overload
            def setSnap(self, value: TraceRmi.Snap) -> TraceRmi.ReplySnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 1;``
                """

            @typing.overload
            def setSnap(self, builderForValue: TraceRmi.Snap.Builder) -> TraceRmi.ReplySnapshot.Builder:
                """
                ``.ghidra.rmi.trace.Snap snap = 1;``
                """

            @property
            def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
                ...

            @property
            def snapBuilder(self) -> TraceRmi.Snap.Builder:
                ...

            @property
            def snap(self) -> TraceRmi.Snap:
                ...


        class_: typing.ClassVar[java.lang.Class]
        SNAP_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getSnap(self) -> TraceRmi.Snap:
            """
            ``.ghidra.rmi.trace.Snap snap = 1;``
            
            :return: The snap.
            :rtype: TraceRmi.Snap
            """

        def getSnapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            """
            ``.ghidra.rmi.trace.Snap snap = 1;``
            """

        def hasSnap(self) -> bool:
            """
            ``.ghidra.rmi.trace.Snap snap = 1;``
            
            :return: Whether the snap field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplySnapshot.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplySnapshot) -> TraceRmi.ReplySnapshot.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplySnapshot:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplySnapshot]:
            ...

        @property
        def snapOrBuilder(self) -> TraceRmi.SnapOrBuilder:
            ...

        @property
        def snap(self) -> TraceRmi.Snap:
            ...


    class MethodParameterOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getDefaultValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value default_value = 4;``
            
            :return: The defaultValue.
            :rtype: TraceRmi.Value
            """

        def getDefaultValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value default_value = 4;``
            """

        def getDescription(self) -> str:
            """
            ``string description = 6;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 6;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        def getDisplay(self) -> str:
            """
            ``string display = 5;``
            
            :return: The display.
            :rtype: str
            """

        def getDisplayBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string display = 5;``
            
            :return: The bytes for display.
            :rtype: com.google.protobuf.ByteString
            """

        def getName(self) -> str:
            """
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getRequired(self) -> bool:
            """
            ``bool required = 3;``
            
            :return: The required.
            :rtype: bool
            """

        def getType(self) -> TraceRmi.ValueType:
            """
            ``.ghidra.rmi.trace.ValueType type = 2;``
            
            :return: The type.
            :rtype: TraceRmi.ValueType
            """

        def getTypeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
            """
            ``.ghidra.rmi.trace.ValueType type = 2;``
            """

        def hasDefaultValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value default_value = 4;``
            
            :return: Whether the defaultValue field is set.
            :rtype: bool
            """

        def hasType(self) -> bool:
            """
            ``.ghidra.rmi.trace.ValueType type = 2;``
            
            :return: Whether the type field is set.
            :rtype: bool
            """

        @property
        def typeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def defaultValue(self) -> TraceRmi.Value:
            ...

        @property
        def display(self) -> java.lang.String:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def displayBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def type(self) -> TraceRmi.ValueType:
            ...

        @property
        def defaultValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def required(self) -> jpype.JBoolean:
            ...


    class MethodParameter(com.google.protobuf.GeneratedMessage, TraceRmi.MethodParameterOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.MethodParameter``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.MethodParameter.Builder], TraceRmi.MethodParameterOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.MethodParameter``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearDefaultValue(self) -> TraceRmi.MethodParameter.Builder:
                """
                ``.ghidra.rmi.trace.Value default_value = 4;``
                """

            def clearDescription(self) -> TraceRmi.MethodParameter.Builder:
                """
                ``string description = 6;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def clearDisplay(self) -> TraceRmi.MethodParameter.Builder:
                """
                ``string display = 5;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def clearName(self) -> TraceRmi.MethodParameter.Builder:
                """
                ``string name = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def clearRequired(self) -> TraceRmi.MethodParameter.Builder:
                """
                ``bool required = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def clearType(self) -> TraceRmi.MethodParameter.Builder:
                """
                ``.ghidra.rmi.trace.ValueType type = 2;``
                """

            def getDefaultValue(self) -> TraceRmi.Value:
                """
                ``.ghidra.rmi.trace.Value default_value = 4;``
                
                :return: The defaultValue.
                :rtype: TraceRmi.Value
                """

            def getDefaultValueBuilder(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Value default_value = 4;``
                """

            def getDefaultValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                """
                ``.ghidra.rmi.trace.Value default_value = 4;``
                """

            def getDescription(self) -> str:
                """
                ``string description = 6;``
                
                :return: The description.
                :rtype: str
                """

            def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string description = 6;``
                
                :return: The bytes for description.
                :rtype: com.google.protobuf.ByteString
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getDisplay(self) -> str:
                """
                ``string display = 5;``
                
                :return: The display.
                :rtype: str
                """

            def getDisplayBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string display = 5;``
                
                :return: The bytes for display.
                :rtype: com.google.protobuf.ByteString
                """

            def getName(self) -> str:
                """
                ``string name = 1;``
                
                :return: The name.
                :rtype: str
                """

            def getNameBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string name = 1;``
                
                :return: The bytes for name.
                :rtype: com.google.protobuf.ByteString
                """

            def getRequired(self) -> bool:
                """
                ``bool required = 3;``
                
                :return: The required.
                :rtype: bool
                """

            def getType(self) -> TraceRmi.ValueType:
                """
                ``.ghidra.rmi.trace.ValueType type = 2;``
                
                :return: The type.
                :rtype: TraceRmi.ValueType
                """

            def getTypeBuilder(self) -> TraceRmi.ValueType.Builder:
                """
                ``.ghidra.rmi.trace.ValueType type = 2;``
                """

            def getTypeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
                """
                ``.ghidra.rmi.trace.ValueType type = 2;``
                """

            def hasDefaultValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.Value default_value = 4;``
                
                :return: Whether the defaultValue field is set.
                :rtype: bool
                """

            def hasType(self) -> bool:
                """
                ``.ghidra.rmi.trace.ValueType type = 2;``
                
                :return: Whether the type field is set.
                :rtype: bool
                """

            def mergeDefaultValue(self, value: TraceRmi.Value) -> TraceRmi.MethodParameter.Builder:
                """
                ``.ghidra.rmi.trace.Value default_value = 4;``
                """

            def mergeFrom(self, other: TraceRmi.MethodParameter) -> TraceRmi.MethodParameter.Builder:
                ...

            def mergeType(self, value: TraceRmi.ValueType) -> TraceRmi.MethodParameter.Builder:
                """
                ``.ghidra.rmi.trace.ValueType type = 2;``
                """

            @typing.overload
            def setDefaultValue(self, value: TraceRmi.Value) -> TraceRmi.MethodParameter.Builder:
                """
                ``.ghidra.rmi.trace.Value default_value = 4;``
                """

            @typing.overload
            def setDefaultValue(self, builderForValue: TraceRmi.Value.Builder) -> TraceRmi.MethodParameter.Builder:
                """
                ``.ghidra.rmi.trace.Value default_value = 4;``
                """

            def setDescription(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.MethodParameter.Builder:
                """
                ``string description = 6;``
                
                :param java.lang.String or str value: The description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def setDescriptionBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.MethodParameter.Builder:
                """
                ``string description = 6;``
                
                :param com.google.protobuf.ByteString value: The bytes for description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def setDisplay(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.MethodParameter.Builder:
                """
                ``string display = 5;``
                
                :param java.lang.String or str value: The display to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def setDisplayBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.MethodParameter.Builder:
                """
                ``string display = 5;``
                
                :param com.google.protobuf.ByteString value: The bytes for display to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def setName(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.MethodParameter.Builder:
                """
                ``string name = 1;``
                
                :param java.lang.String or str value: The name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def setNameBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.MethodParameter.Builder:
                """
                ``string name = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            def setRequired(self, value: typing.Union[jpype.JBoolean, bool]) -> TraceRmi.MethodParameter.Builder:
                """
                ``bool required = 3;``
                
                :param jpype.JBoolean or bool value: The required to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodParameter.Builder
                """

            @typing.overload
            def setType(self, value: TraceRmi.ValueType) -> TraceRmi.MethodParameter.Builder:
                """
                ``.ghidra.rmi.trace.ValueType type = 2;``
                """

            @typing.overload
            def setType(self, builderForValue: TraceRmi.ValueType.Builder) -> TraceRmi.MethodParameter.Builder:
                """
                ``.ghidra.rmi.trace.ValueType type = 2;``
                """

            @property
            def typeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
                ...

            @property
            def nameBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def defaultValue(self) -> TraceRmi.Value:
                ...

            @property
            def display(self) -> java.lang.String:
                ...

            @property
            def name(self) -> java.lang.String:
                ...

            @property
            def displayBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def description(self) -> java.lang.String:
                ...

            @property
            def defaultValueBuilder(self) -> TraceRmi.Value.Builder:
                ...

            @property
            def typeBuilder(self) -> TraceRmi.ValueType.Builder:
                ...

            @property
            def descriptionBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def type(self) -> TraceRmi.ValueType:
                ...

            @property
            def defaultValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                ...

            @property
            def required(self) -> jpype.JBoolean:
                ...


        class_: typing.ClassVar[java.lang.Class]
        NAME_FIELD_NUMBER: typing.Final = 1
        TYPE_FIELD_NUMBER: typing.Final = 2
        REQUIRED_FIELD_NUMBER: typing.Final = 3
        DEFAULT_VALUE_FIELD_NUMBER: typing.Final = 4
        DISPLAY_FIELD_NUMBER: typing.Final = 5
        DESCRIPTION_FIELD_NUMBER: typing.Final = 6

        @staticmethod
        def getDefaultInstance() -> TraceRmi.MethodParameter:
            ...

        def getDefaultValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value default_value = 4;``
            
            :return: The defaultValue.
            :rtype: TraceRmi.Value
            """

        def getDefaultValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value default_value = 4;``
            """

        def getDescription(self) -> str:
            """
            ``string description = 6;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 6;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getDisplay(self) -> str:
            """
            ``string display = 5;``
            
            :return: The display.
            :rtype: str
            """

        def getDisplayBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string display = 5;``
            
            :return: The bytes for display.
            :rtype: com.google.protobuf.ByteString
            """

        def getName(self) -> str:
            """
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getRequired(self) -> bool:
            """
            ``bool required = 3;``
            
            :return: The required.
            :rtype: bool
            """

        def getType(self) -> TraceRmi.ValueType:
            """
            ``.ghidra.rmi.trace.ValueType type = 2;``
            
            :return: The type.
            :rtype: TraceRmi.ValueType
            """

        def getTypeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
            """
            ``.ghidra.rmi.trace.ValueType type = 2;``
            """

        def hasDefaultValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value default_value = 4;``
            
            :return: Whether the defaultValue field is set.
            :rtype: bool
            """

        def hasType(self) -> bool:
            """
            ``.ghidra.rmi.trace.ValueType type = 2;``
            
            :return: Whether the type field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.MethodParameter.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.MethodParameter) -> TraceRmi.MethodParameter.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodParameter:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.MethodParameter]:
            ...

        @property
        def typeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def defaultValue(self) -> TraceRmi.Value:
            ...

        @property
        def display(self) -> java.lang.String:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def displayBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def type(self) -> TraceRmi.ValueType:
            ...

        @property
        def defaultValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def required(self) -> jpype.JBoolean:
            ...


    class MethodArgumentOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getName(self) -> str:
            """
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value value = 2;``
            
            :return: The value.
            :rtype: TraceRmi.Value
            """

        def getValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value value = 2;``
            """

        def hasValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value value = 2;``
            
            :return: Whether the value field is set.
            :rtype: bool
            """

        @property
        def valueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def value(self) -> TraceRmi.Value:
            ...


    class MethodArgument(com.google.protobuf.GeneratedMessage, TraceRmi.MethodArgumentOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.MethodArgument``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.MethodArgument.Builder], TraceRmi.MethodArgumentOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.MethodArgument``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearName(self) -> TraceRmi.MethodArgument.Builder:
                """
                ``string name = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodArgument.Builder
                """

            def clearValue(self) -> TraceRmi.MethodArgument.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 2;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getName(self) -> str:
                """
                ``string name = 1;``
                
                :return: The name.
                :rtype: str
                """

            def getNameBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string name = 1;``
                
                :return: The bytes for name.
                :rtype: com.google.protobuf.ByteString
                """

            def getValue(self) -> TraceRmi.Value:
                """
                ``.ghidra.rmi.trace.Value value = 2;``
                
                :return: The value.
                :rtype: TraceRmi.Value
                """

            def getValueBuilder(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 2;``
                """

            def getValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                """
                ``.ghidra.rmi.trace.Value value = 2;``
                """

            def hasValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.Value value = 2;``
                
                :return: Whether the value field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.MethodArgument) -> TraceRmi.MethodArgument.Builder:
                ...

            def mergeValue(self, value: TraceRmi.Value) -> TraceRmi.MethodArgument.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 2;``
                """

            def setName(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.MethodArgument.Builder:
                """
                ``string name = 1;``
                
                :param java.lang.String or str value: The name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodArgument.Builder
                """

            def setNameBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.MethodArgument.Builder:
                """
                ``string name = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.MethodArgument.Builder
                """

            @typing.overload
            def setValue(self, value: TraceRmi.Value) -> TraceRmi.MethodArgument.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 2;``
                """

            @typing.overload
            def setValue(self, builderForValue: TraceRmi.Value.Builder) -> TraceRmi.MethodArgument.Builder:
                """
                ``.ghidra.rmi.trace.Value value = 2;``
                """

            @property
            def valueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                ...

            @property
            def valueBuilder(self) -> TraceRmi.Value.Builder:
                ...

            @property
            def nameBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def name(self) -> java.lang.String:
                ...

            @property
            def value(self) -> TraceRmi.Value:
                ...


        class_: typing.ClassVar[java.lang.Class]
        NAME_FIELD_NUMBER: typing.Final = 1
        VALUE_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getName(self) -> str:
            """
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value value = 2;``
            
            :return: The value.
            :rtype: TraceRmi.Value
            """

        def getValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value value = 2;``
            """

        def hasValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value value = 2;``
            
            :return: Whether the value field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.MethodArgument.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.MethodArgument) -> TraceRmi.MethodArgument.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.MethodArgument:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.MethodArgument]:
            ...

        @property
        def valueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def value(self) -> TraceRmi.Value:
            ...


    class MethodOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getAction(self) -> str:
            """
            ``string action = 2;``
            
            :return: The action.
            :rtype: str
            """

        def getActionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string action = 2;``
            
            :return: The bytes for action.
            :rtype: com.google.protobuf.ByteString
            """

        def getDescription(self) -> str:
            """
            ``string description = 4;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 4;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        def getDisplay(self) -> str:
            """
            ``string display = 3;``
            
            :return: The display.
            :rtype: str
            """

        def getDisplayBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string display = 3;``
            
            :return: The bytes for display.
            :rtype: com.google.protobuf.ByteString
            """

        def getIcon(self) -> str:
            """
            ``string icon = 8;``
            
            :return: The icon.
            :rtype: str
            """

        def getIconBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string icon = 8;``
            
            :return: The bytes for icon.
            :rtype: com.google.protobuf.ByteString
            """

        def getName(self) -> str:
            """
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getOkText(self) -> str:
            """
            ``string ok_text = 7;``
            
            :return: The okText.
            :rtype: str
            """

        def getOkTextBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string ok_text = 7;``
            
            :return: The bytes for okText.
            :rtype: com.google.protobuf.ByteString
            """

        def getParameters(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodParameter:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getParametersCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getParametersList(self) -> java.util.List[TraceRmi.MethodParameter]:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getParametersOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodParameterOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getParametersOrBuilderList(self) -> java.util.List[TraceRmi.MethodParameterOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getReturnType(self) -> TraceRmi.ValueType:
            """
            
            I'd like to make them all void, but I think executing a command and capturing its output
            justifies being able to return a result. It should be used very sparingly.
             
            
            ``.ghidra.rmi.trace.ValueType return_type = 6;``
            
            :return: The returnType.
            :rtype: TraceRmi.ValueType
            """

        def getReturnTypeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
            """
            
            I'd like to make them all void, but I think executing a command and capturing its output
            justifies being able to return a result. It should be used very sparingly.
             
            
            ``.ghidra.rmi.trace.ValueType return_type = 6;``
            """

        def hasReturnType(self) -> bool:
            """
            
            I'd like to make them all void, but I think executing a command and capturing its output
            justifies being able to return a result. It should be used very sparingly.
             
            
            ``.ghidra.rmi.trace.ValueType return_type = 6;``
            
            :return: Whether the returnType field is set.
            :rtype: bool
            """

        @property
        def display(self) -> java.lang.String:
            ...

        @property
        def icon(self) -> java.lang.String:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def parametersCount(self) -> jpype.JInt:
            ...

        @property
        def parametersOrBuilderList(self) -> java.util.List[TraceRmi.MethodParameterOrBuilder]:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def displayBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def action(self) -> java.lang.String:
            ...

        @property
        def actionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def iconBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def parametersList(self) -> java.util.List[TraceRmi.MethodParameter]:
            ...

        @property
        def okText(self) -> java.lang.String:
            ...

        @property
        def parametersOrBuilder(self) -> TraceRmi.MethodParameterOrBuilder:
            ...

        @property
        def parameters(self) -> TraceRmi.MethodParameter:
            ...

        @property
        def okTextBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def returnTypeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
            ...

        @property
        def returnType(self) -> TraceRmi.ValueType:
            ...


    class Method(com.google.protobuf.GeneratedMessage, TraceRmi.MethodOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.Method``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.Method.Builder], TraceRmi.MethodOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.Method``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllParameters(self, values: collections.abc.Sequence) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            @typing.overload
            def addParameters(self, value: TraceRmi.MethodParameter) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            @typing.overload
            def addParameters(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.MethodParameter) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            @typing.overload
            def addParameters(self, builderForValue: TraceRmi.MethodParameter.Builder) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            @typing.overload
            def addParameters(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.MethodParameter.Builder) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            @typing.overload
            def addParametersBuilder(self) -> TraceRmi.MethodParameter.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            @typing.overload
            def addParametersBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodParameter.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def clearAction(self) -> TraceRmi.Method.Builder:
                """
                ``string action = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def clearDescription(self) -> TraceRmi.Method.Builder:
                """
                ``string description = 4;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def clearDisplay(self) -> TraceRmi.Method.Builder:
                """
                ``string display = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def clearIcon(self) -> TraceRmi.Method.Builder:
                """
                ``string icon = 8;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def clearName(self) -> TraceRmi.Method.Builder:
                """
                ``string name = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def clearOkText(self) -> TraceRmi.Method.Builder:
                """
                ``string ok_text = 7;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def clearParameters(self) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def clearReturnType(self) -> TraceRmi.Method.Builder:
                """
                
                I'd like to make them all void, but I think executing a command and capturing its output
                justifies being able to return a result. It should be used very sparingly.
                 
                
                ``.ghidra.rmi.trace.ValueType return_type = 6;``
                """

            def getAction(self) -> str:
                """
                ``string action = 2;``
                
                :return: The action.
                :rtype: str
                """

            def getActionBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string action = 2;``
                
                :return: The bytes for action.
                :rtype: com.google.protobuf.ByteString
                """

            def getDescription(self) -> str:
                """
                ``string description = 4;``
                
                :return: The description.
                :rtype: str
                """

            def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string description = 4;``
                
                :return: The bytes for description.
                :rtype: com.google.protobuf.ByteString
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getDisplay(self) -> str:
                """
                ``string display = 3;``
                
                :return: The display.
                :rtype: str
                """

            def getDisplayBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string display = 3;``
                
                :return: The bytes for display.
                :rtype: com.google.protobuf.ByteString
                """

            def getIcon(self) -> str:
                """
                ``string icon = 8;``
                
                :return: The icon.
                :rtype: str
                """

            def getIconBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string icon = 8;``
                
                :return: The bytes for icon.
                :rtype: com.google.protobuf.ByteString
                """

            def getName(self) -> str:
                """
                ``string name = 1;``
                
                :return: The name.
                :rtype: str
                """

            def getNameBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string name = 1;``
                
                :return: The bytes for name.
                :rtype: com.google.protobuf.ByteString
                """

            def getOkText(self) -> str:
                """
                ``string ok_text = 7;``
                
                :return: The okText.
                :rtype: str
                """

            def getOkTextBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string ok_text = 7;``
                
                :return: The bytes for okText.
                :rtype: com.google.protobuf.ByteString
                """

            def getParameters(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodParameter:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def getParametersBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodParameter.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def getParametersBuilderList(self) -> java.util.List[TraceRmi.MethodParameter.Builder]:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def getParametersCount(self) -> int:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def getParametersList(self) -> java.util.List[TraceRmi.MethodParameter]:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def getParametersOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodParameterOrBuilder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def getParametersOrBuilderList(self) -> java.util.List[TraceRmi.MethodParameterOrBuilder]:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def getReturnType(self) -> TraceRmi.ValueType:
                """
                
                I'd like to make them all void, but I think executing a command and capturing its output
                justifies being able to return a result. It should be used very sparingly.
                 
                
                ``.ghidra.rmi.trace.ValueType return_type = 6;``
                
                :return: The returnType.
                :rtype: TraceRmi.ValueType
                """

            def getReturnTypeBuilder(self) -> TraceRmi.ValueType.Builder:
                """
                
                I'd like to make them all void, but I think executing a command and capturing its output
                justifies being able to return a result. It should be used very sparingly.
                 
                
                ``.ghidra.rmi.trace.ValueType return_type = 6;``
                """

            def getReturnTypeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
                """
                
                I'd like to make them all void, but I think executing a command and capturing its output
                justifies being able to return a result. It should be used very sparingly.
                 
                
                ``.ghidra.rmi.trace.ValueType return_type = 6;``
                """

            def hasReturnType(self) -> bool:
                """
                
                I'd like to make them all void, but I think executing a command and capturing its output
                justifies being able to return a result. It should be used very sparingly.
                 
                
                ``.ghidra.rmi.trace.ValueType return_type = 6;``
                
                :return: Whether the returnType field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.Method) -> TraceRmi.Method.Builder:
                ...

            def mergeReturnType(self, value: TraceRmi.ValueType) -> TraceRmi.Method.Builder:
                """
                
                I'd like to make them all void, but I think executing a command and capturing its output
                justifies being able to return a result. It should be used very sparingly.
                 
                
                ``.ghidra.rmi.trace.ValueType return_type = 6;``
                """

            def removeParameters(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            def setAction(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Method.Builder:
                """
                ``string action = 2;``
                
                :param java.lang.String or str value: The action to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setActionBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Method.Builder:
                """
                ``string action = 2;``
                
                :param com.google.protobuf.ByteString value: The bytes for action to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setDescription(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Method.Builder:
                """
                ``string description = 4;``
                
                :param java.lang.String or str value: The description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setDescriptionBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Method.Builder:
                """
                ``string description = 4;``
                
                :param com.google.protobuf.ByteString value: The bytes for description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setDisplay(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Method.Builder:
                """
                ``string display = 3;``
                
                :param java.lang.String or str value: The display to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setDisplayBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Method.Builder:
                """
                ``string display = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for display to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setIcon(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Method.Builder:
                """
                ``string icon = 8;``
                
                :param java.lang.String or str value: The icon to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setIconBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Method.Builder:
                """
                ``string icon = 8;``
                
                :param com.google.protobuf.ByteString value: The bytes for icon to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setName(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Method.Builder:
                """
                ``string name = 1;``
                
                :param java.lang.String or str value: The name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setNameBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Method.Builder:
                """
                ``string name = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setOkText(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.Method.Builder:
                """
                ``string ok_text = 7;``
                
                :param java.lang.String or str value: The okText to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            def setOkTextBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.Method.Builder:
                """
                ``string ok_text = 7;``
                
                :param com.google.protobuf.ByteString value: The bytes for okText to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.Method.Builder
                """

            @typing.overload
            def setParameters(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.MethodParameter) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            @typing.overload
            def setParameters(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.MethodParameter.Builder) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
                """

            @typing.overload
            def setReturnType(self, value: TraceRmi.ValueType) -> TraceRmi.Method.Builder:
                """
                
                I'd like to make them all void, but I think executing a command and capturing its output
                justifies being able to return a result. It should be used very sparingly.
                 
                
                ``.ghidra.rmi.trace.ValueType return_type = 6;``
                """

            @typing.overload
            def setReturnType(self, builderForValue: TraceRmi.ValueType.Builder) -> TraceRmi.Method.Builder:
                """
                
                I'd like to make them all void, but I think executing a command and capturing its output
                justifies being able to return a result. It should be used very sparingly.
                 
                
                ``.ghidra.rmi.trace.ValueType return_type = 6;``
                """

            @property
            def display(self) -> java.lang.String:
                ...

            @property
            def icon(self) -> java.lang.String:
                ...

            @property
            def description(self) -> java.lang.String:
                ...

            @property
            def descriptionBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def parametersCount(self) -> jpype.JInt:
                ...

            @property
            def parametersBuilderList(self) -> java.util.List[TraceRmi.MethodParameter.Builder]:
                ...

            @property
            def parametersOrBuilderList(self) -> java.util.List[TraceRmi.MethodParameterOrBuilder]:
                ...

            @property
            def nameBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def name(self) -> java.lang.String:
                ...

            @property
            def displayBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def action(self) -> java.lang.String:
                ...

            @property
            def actionBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def iconBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def returnTypeBuilder(self) -> TraceRmi.ValueType.Builder:
                ...

            @property
            def parametersList(self) -> java.util.List[TraceRmi.MethodParameter]:
                ...

            @property
            def okText(self) -> java.lang.String:
                ...

            @property
            def parametersOrBuilder(self) -> TraceRmi.MethodParameterOrBuilder:
                ...

            @property
            def parametersBuilder(self) -> TraceRmi.MethodParameter.Builder:
                ...

            @property
            def parameters(self) -> TraceRmi.MethodParameter:
                ...

            @property
            def okTextBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def returnTypeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
                ...

            @property
            def returnType(self) -> TraceRmi.ValueType:
                ...


        class_: typing.ClassVar[java.lang.Class]
        NAME_FIELD_NUMBER: typing.Final = 1
        ACTION_FIELD_NUMBER: typing.Final = 2
        DISPLAY_FIELD_NUMBER: typing.Final = 3
        DESCRIPTION_FIELD_NUMBER: typing.Final = 4
        PARAMETERS_FIELD_NUMBER: typing.Final = 5
        RETURN_TYPE_FIELD_NUMBER: typing.Final = 6
        OK_TEXT_FIELD_NUMBER: typing.Final = 7
        ICON_FIELD_NUMBER: typing.Final = 8

        def getAction(self) -> str:
            """
            ``string action = 2;``
            
            :return: The action.
            :rtype: str
            """

        def getActionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string action = 2;``
            
            :return: The bytes for action.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.Method:
            ...

        def getDescription(self) -> str:
            """
            ``string description = 4;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 4;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getDisplay(self) -> str:
            """
            ``string display = 3;``
            
            :return: The display.
            :rtype: str
            """

        def getDisplayBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string display = 3;``
            
            :return: The bytes for display.
            :rtype: com.google.protobuf.ByteString
            """

        def getIcon(self) -> str:
            """
            ``string icon = 8;``
            
            :return: The icon.
            :rtype: str
            """

        def getIconBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string icon = 8;``
            
            :return: The bytes for icon.
            :rtype: com.google.protobuf.ByteString
            """

        def getName(self) -> str:
            """
            ``string name = 1;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 1;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getOkText(self) -> str:
            """
            ``string ok_text = 7;``
            
            :return: The okText.
            :rtype: str
            """

        def getOkTextBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string ok_text = 7;``
            
            :return: The bytes for okText.
            :rtype: com.google.protobuf.ByteString
            """

        def getParameters(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodParameter:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getParametersCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getParametersList(self) -> java.util.List[TraceRmi.MethodParameter]:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getParametersOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodParameterOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getParametersOrBuilderList(self) -> java.util.List[TraceRmi.MethodParameterOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.MethodParameter parameters = 5;``
            """

        def getReturnType(self) -> TraceRmi.ValueType:
            """
            
            I'd like to make them all void, but I think executing a command and capturing its output
            justifies being able to return a result. It should be used very sparingly.
             
            
            ``.ghidra.rmi.trace.ValueType return_type = 6;``
            
            :return: The returnType.
            :rtype: TraceRmi.ValueType
            """

        def getReturnTypeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
            """
            
            I'd like to make them all void, but I think executing a command and capturing its output
            justifies being able to return a result. It should be used very sparingly.
             
            
            ``.ghidra.rmi.trace.ValueType return_type = 6;``
            """

        def hasReturnType(self) -> bool:
            """
            
            I'd like to make them all void, but I think executing a command and capturing its output
            justifies being able to return a result. It should be used very sparingly.
             
            
            ``.ghidra.rmi.trace.ValueType return_type = 6;``
            
            :return: Whether the returnType field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.Method.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.Method) -> TraceRmi.Method.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.Method:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.Method:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.Method]:
            ...

        @property
        def display(self) -> java.lang.String:
            ...

        @property
        def icon(self) -> java.lang.String:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def parametersCount(self) -> jpype.JInt:
            ...

        @property
        def parametersOrBuilderList(self) -> java.util.List[TraceRmi.MethodParameterOrBuilder]:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def displayBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def action(self) -> java.lang.String:
            ...

        @property
        def actionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def iconBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def parametersList(self) -> java.util.List[TraceRmi.MethodParameter]:
            ...

        @property
        def okText(self) -> java.lang.String:
            ...

        @property
        def parametersOrBuilder(self) -> TraceRmi.MethodParameterOrBuilder:
            ...

        @property
        def parameters(self) -> TraceRmi.MethodParameter:
            ...

        @property
        def okTextBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def returnTypeOrBuilder(self) -> TraceRmi.ValueTypeOrBuilder:
            ...

        @property
        def returnType(self) -> TraceRmi.ValueType:
            ...


    class RequestNegotiateOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getDescription(self) -> str:
            """
            ``string description = 3;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 3;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        def getMethods(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.Method:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getMethodsCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getMethodsList(self) -> java.util.List[TraceRmi.Method]:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getMethodsOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getMethodsOrBuilderList(self) -> java.util.List[TraceRmi.MethodOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getVersion(self) -> str:
            """
            ``string version = 1;``
            
            :return: The version.
            :rtype: str
            """

        def getVersionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string version = 1;``
            
            :return: The bytes for version.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def methods(self) -> TraceRmi.Method:
            ...

        @property
        def methodsOrBuilder(self) -> TraceRmi.MethodOrBuilder:
            ...

        @property
        def methodsList(self) -> java.util.List[TraceRmi.Method]:
            ...

        @property
        def methodsCount(self) -> jpype.JInt:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def methodsOrBuilderList(self) -> java.util.List[TraceRmi.MethodOrBuilder]:
            ...

        @property
        def version(self) -> java.lang.String:
            ...

        @property
        def versionBytes(self) -> com.google.protobuf.ByteString:
            ...


    class RequestNegotiate(com.google.protobuf.GeneratedMessage, TraceRmi.RequestNegotiateOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RequestNegotiate``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RequestNegotiate.Builder], TraceRmi.RequestNegotiateOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RequestNegotiate``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllMethods(self, values: collections.abc.Sequence) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            @typing.overload
            def addMethods(self, value: TraceRmi.Method) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            @typing.overload
            def addMethods(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.Method) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            @typing.overload
            def addMethods(self, builderForValue: TraceRmi.Method.Builder) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            @typing.overload
            def addMethods(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.Method.Builder) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            @typing.overload
            def addMethodsBuilder(self) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            @typing.overload
            def addMethodsBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def clearDescription(self) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``string description = 3;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestNegotiate.Builder
                """

            def clearMethods(self) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def clearVersion(self) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``string version = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestNegotiate.Builder
                """

            def getDescription(self) -> str:
                """
                ``string description = 3;``
                
                :return: The description.
                :rtype: str
                """

            def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string description = 3;``
                
                :return: The bytes for description.
                :rtype: com.google.protobuf.ByteString
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getMethods(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.Method:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def getMethodsBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.Method.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def getMethodsBuilderList(self) -> java.util.List[TraceRmi.Method.Builder]:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def getMethodsCount(self) -> int:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def getMethodsList(self) -> java.util.List[TraceRmi.Method]:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def getMethodsOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodOrBuilder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def getMethodsOrBuilderList(self) -> java.util.List[TraceRmi.MethodOrBuilder]:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def getVersion(self) -> str:
                """
                ``string version = 1;``
                
                :return: The version.
                :rtype: str
                """

            def getVersionBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string version = 1;``
                
                :return: The bytes for version.
                :rtype: com.google.protobuf.ByteString
                """

            def mergeFrom(self, other: TraceRmi.RequestNegotiate) -> TraceRmi.RequestNegotiate.Builder:
                ...

            def removeMethods(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def setDescription(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``string description = 3;``
                
                :param java.lang.String or str value: The description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestNegotiate.Builder
                """

            def setDescriptionBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``string description = 3;``
                
                :param com.google.protobuf.ByteString value: The bytes for description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestNegotiate.Builder
                """

            @typing.overload
            def setMethods(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.Method) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            @typing.overload
            def setMethods(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.Method.Builder) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``repeated .ghidra.rmi.trace.Method methods = 2;``
                """

            def setVersion(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``string version = 1;``
                
                :param java.lang.String or str value: The version to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestNegotiate.Builder
                """

            def setVersionBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``string version = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for version to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.RequestNegotiate.Builder
                """

            @property
            def methodsBuilder(self) -> TraceRmi.Method.Builder:
                ...

            @property
            def methods(self) -> TraceRmi.Method:
                ...

            @property
            def methodsOrBuilder(self) -> TraceRmi.MethodOrBuilder:
                ...

            @property
            def methodsList(self) -> java.util.List[TraceRmi.Method]:
                ...

            @property
            def methodsCount(self) -> jpype.JInt:
                ...

            @property
            def methodsBuilderList(self) -> java.util.List[TraceRmi.Method.Builder]:
                ...

            @property
            def description(self) -> java.lang.String:
                ...

            @property
            def descriptionBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def methodsOrBuilderList(self) -> java.util.List[TraceRmi.MethodOrBuilder]:
                ...

            @property
            def version(self) -> java.lang.String:
                ...

            @property
            def versionBytes(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        VERSION_FIELD_NUMBER: typing.Final = 1
        METHODS_FIELD_NUMBER: typing.Final = 2
        DESCRIPTION_FIELD_NUMBER: typing.Final = 3

        @staticmethod
        def getDefaultInstance() -> TraceRmi.RequestNegotiate:
            ...

        def getDescription(self) -> str:
            """
            ``string description = 3;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 3;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getMethods(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.Method:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getMethodsCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getMethodsList(self) -> java.util.List[TraceRmi.Method]:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getMethodsOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getMethodsOrBuilderList(self) -> java.util.List[TraceRmi.MethodOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.Method methods = 2;``
            """

        def getVersion(self) -> str:
            """
            ``string version = 1;``
            
            :return: The version.
            :rtype: str
            """

        def getVersionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string version = 1;``
            
            :return: The bytes for version.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.RequestNegotiate.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.RequestNegotiate) -> TraceRmi.RequestNegotiate.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.RequestNegotiate:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.RequestNegotiate]:
            ...

        @property
        def methods(self) -> TraceRmi.Method:
            ...

        @property
        def methodsOrBuilder(self) -> TraceRmi.MethodOrBuilder:
            ...

        @property
        def methodsList(self) -> java.util.List[TraceRmi.Method]:
            ...

        @property
        def methodsCount(self) -> jpype.JInt:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def methodsOrBuilderList(self) -> java.util.List[TraceRmi.MethodOrBuilder]:
            ...

        @property
        def version(self) -> java.lang.String:
            ...

        @property
        def versionBytes(self) -> com.google.protobuf.ByteString:
            ...


    class ReplyNegotiateOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getDescription(self) -> str:
            """
            ``string description = 1;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 1;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...


    class ReplyNegotiate(com.google.protobuf.GeneratedMessage, TraceRmi.ReplyNegotiateOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.ReplyNegotiate``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.ReplyNegotiate.Builder], TraceRmi.ReplyNegotiateOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.ReplyNegotiate``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearDescription(self) -> TraceRmi.ReplyNegotiate.Builder:
                """
                ``string description = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyNegotiate.Builder
                """

            def getDescription(self) -> str:
                """
                ``string description = 1;``
                
                :return: The description.
                :rtype: str
                """

            def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string description = 1;``
                
                :return: The bytes for description.
                :rtype: com.google.protobuf.ByteString
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def mergeFrom(self, other: TraceRmi.ReplyNegotiate) -> TraceRmi.ReplyNegotiate.Builder:
                ...

            def setDescription(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.ReplyNegotiate.Builder:
                """
                ``string description = 1;``
                
                :param java.lang.String or str value: The description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyNegotiate.Builder
                """

            def setDescriptionBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.ReplyNegotiate.Builder:
                """
                ``string description = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for description to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.ReplyNegotiate.Builder
                """

            @property
            def description(self) -> java.lang.String:
                ...

            @property
            def descriptionBytes(self) -> com.google.protobuf.ByteString:
                ...


        class_: typing.ClassVar[java.lang.Class]
        DESCRIPTION_FIELD_NUMBER: typing.Final = 1

        @staticmethod
        def getDefaultInstance() -> TraceRmi.ReplyNegotiate:
            ...

        def getDescription(self) -> str:
            """
            ``string description = 1;``
            
            :return: The description.
            :rtype: str
            """

        def getDescriptionBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string description = 1;``
            
            :return: The bytes for description.
            :rtype: com.google.protobuf.ByteString
            """

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.ReplyNegotiate.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.ReplyNegotiate) -> TraceRmi.ReplyNegotiate.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.ReplyNegotiate:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.ReplyNegotiate]:
            ...

        @property
        def description(self) -> java.lang.String:
            ...

        @property
        def descriptionBytes(self) -> com.google.protobuf.ByteString:
            ...


    class XRequestInvokeMethodOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getArguments(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodArgument:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        def getArgumentsCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        def getArgumentsList(self) -> java.util.List[TraceRmi.MethodArgument]:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        def getArgumentsOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodArgumentOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        def getArgumentsOrBuilderList(self) -> java.util.List[TraceRmi.MethodArgumentOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        def getName(self) -> str:
            """
            ``string name = 2;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 2;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasOid(self) -> bool:
            """
            ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def argumentsCount(self) -> jpype.JInt:
            ...

        @property
        def argumentsOrBuilderList(self) -> java.util.List[TraceRmi.MethodArgumentOrBuilder]:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def argumentsOrBuilder(self) -> TraceRmi.MethodArgumentOrBuilder:
            ...

        @property
        def arguments(self) -> TraceRmi.MethodArgument:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def argumentsList(self) -> java.util.List[TraceRmi.MethodArgument]:
            ...


    class XRequestInvokeMethod(com.google.protobuf.GeneratedMessage, TraceRmi.XRequestInvokeMethodOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.XRequestInvokeMethod``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.XRequestInvokeMethod.Builder], TraceRmi.XRequestInvokeMethodOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.XRequestInvokeMethod``
            """

            class_: typing.ClassVar[java.lang.Class]

            def addAllArguments(self, values: collections.abc.Sequence) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            @typing.overload
            def addArguments(self, value: TraceRmi.MethodArgument) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            @typing.overload
            def addArguments(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.MethodArgument) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            @typing.overload
            def addArguments(self, builderForValue: TraceRmi.MethodArgument.Builder) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            @typing.overload
            def addArguments(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.MethodArgument.Builder) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            @typing.overload
            def addArgumentsBuilder(self) -> TraceRmi.MethodArgument.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            @typing.overload
            def addArgumentsBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodArgument.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            def clearArguments(self) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            def clearName(self) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``string name = 2;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.XRequestInvokeMethod.Builder
                """

            def clearOid(self) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getArguments(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodArgument:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            def getArgumentsBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodArgument.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            def getArgumentsBuilderList(self) -> java.util.List[TraceRmi.MethodArgument.Builder]:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            def getArgumentsCount(self) -> int:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            def getArgumentsList(self) -> java.util.List[TraceRmi.MethodArgument]:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            def getArgumentsOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodArgumentOrBuilder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            def getArgumentsOrBuilderList(self) -> java.util.List[TraceRmi.MethodArgumentOrBuilder]:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getName(self) -> str:
                """
                ``string name = 2;``
                
                :return: The name.
                :rtype: str
                """

            def getNameBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string name = 2;``
                
                :return: The bytes for name.
                :rtype: com.google.protobuf.ByteString
                """

            def getOid(self) -> TraceRmi.DomObjId:
                """
                ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: The oid.
                :rtype: TraceRmi.DomObjId
                """

            def getOidBuilder(self) -> TraceRmi.DomObjId.Builder:
                """
                ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                """
                ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def hasOid(self) -> bool:
                """
                ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
                
                :return: Whether the oid field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.XRequestInvokeMethod) -> TraceRmi.XRequestInvokeMethod.Builder:
                ...

            def mergeOid(self, value: TraceRmi.DomObjId) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
                """

            def removeArguments(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            @typing.overload
            def setArguments(self, index: typing.Union[jpype.JInt, int], value: TraceRmi.MethodArgument) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            @typing.overload
            def setArguments(self, index: typing.Union[jpype.JInt, int], builderForValue: TraceRmi.MethodArgument.Builder) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
                """

            def setName(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``string name = 2;``
                
                :param java.lang.String or str value: The name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.XRequestInvokeMethod.Builder
                """

            def setNameBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``string name = 2;``
                
                :param com.google.protobuf.ByteString value: The bytes for name to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.XRequestInvokeMethod.Builder
                """

            @typing.overload
            def setOid(self, value: TraceRmi.DomObjId) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @typing.overload
            def setOid(self, builderForValue: TraceRmi.DomObjId.Builder) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
                """

            @property
            def nameBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def argumentsCount(self) -> jpype.JInt:
                ...

            @property
            def argumentsOrBuilderList(self) -> java.util.List[TraceRmi.MethodArgumentOrBuilder]:
                ...

            @property
            def argumentsBuilderList(self) -> java.util.List[TraceRmi.MethodArgument.Builder]:
                ...

            @property
            def name(self) -> java.lang.String:
                ...

            @property
            def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
                ...

            @property
            def oidBuilder(self) -> TraceRmi.DomObjId.Builder:
                ...

            @property
            def argumentsOrBuilder(self) -> TraceRmi.MethodArgumentOrBuilder:
                ...

            @property
            def arguments(self) -> TraceRmi.MethodArgument:
                ...

            @property
            def oid(self) -> TraceRmi.DomObjId:
                ...

            @property
            def argumentsList(self) -> java.util.List[TraceRmi.MethodArgument]:
                ...

            @property
            def argumentsBuilder(self) -> TraceRmi.MethodArgument.Builder:
                ...


        class_: typing.ClassVar[java.lang.Class]
        OID_FIELD_NUMBER: typing.Final = 1
        NAME_FIELD_NUMBER: typing.Final = 2
        ARGUMENTS_FIELD_NUMBER: typing.Final = 3

        def getArguments(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodArgument:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        def getArgumentsCount(self) -> int:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        def getArgumentsList(self) -> java.util.List[TraceRmi.MethodArgument]:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        def getArgumentsOrBuilder(self, index: typing.Union[jpype.JInt, int]) -> TraceRmi.MethodArgumentOrBuilder:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        def getArgumentsOrBuilderList(self) -> java.util.List[TraceRmi.MethodArgumentOrBuilder]:
            """
            ``repeated .ghidra.rmi.trace.MethodArgument arguments = 3;``
            """

        @staticmethod
        def getDefaultInstance() -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getName(self) -> str:
            """
            ``string name = 2;``
            
            :return: The name.
            :rtype: str
            """

        def getNameBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string name = 2;``
            
            :return: The bytes for name.
            :rtype: com.google.protobuf.ByteString
            """

        def getOid(self) -> TraceRmi.DomObjId:
            """
            ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: The oid.
            :rtype: TraceRmi.DomObjId
            """

        def getOidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            """
            ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
            """

        def hasOid(self) -> bool:
            """
            ``optional .ghidra.rmi.trace.DomObjId oid = 1;``
            
            :return: Whether the oid field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.XRequestInvokeMethod.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.XRequestInvokeMethod) -> TraceRmi.XRequestInvokeMethod.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XRequestInvokeMethod:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.XRequestInvokeMethod]:
            ...

        @property
        def nameBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def argumentsCount(self) -> jpype.JInt:
            ...

        @property
        def argumentsOrBuilderList(self) -> java.util.List[TraceRmi.MethodArgumentOrBuilder]:
            ...

        @property
        def name(self) -> java.lang.String:
            ...

        @property
        def oidOrBuilder(self) -> TraceRmi.DomObjIdOrBuilder:
            ...

        @property
        def argumentsOrBuilder(self) -> TraceRmi.MethodArgumentOrBuilder:
            ...

        @property
        def arguments(self) -> TraceRmi.MethodArgument:
            ...

        @property
        def oid(self) -> TraceRmi.DomObjId:
            ...

        @property
        def argumentsList(self) -> java.util.List[TraceRmi.MethodArgument]:
            ...


    class XReplyInvokeMethodOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getError(self) -> str:
            """
            ``string error = 1;``
            
            :return: The error.
            :rtype: str
            """

        def getErrorBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string error = 1;``
            
            :return: The bytes for error.
            :rtype: com.google.protobuf.ByteString
            """

        def getReturnValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value return_value = 2;``
            
            :return: The returnValue.
            :rtype: TraceRmi.Value
            """

        def getReturnValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value return_value = 2;``
            """

        def hasReturnValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value return_value = 2;``
            
            :return: Whether the returnValue field is set.
            :rtype: bool
            """

        @property
        def returnValue(self) -> TraceRmi.Value:
            ...

        @property
        def errorBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def returnValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def error(self) -> java.lang.String:
            ...


    class XReplyInvokeMethod(com.google.protobuf.GeneratedMessage, TraceRmi.XReplyInvokeMethodOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.XReplyInvokeMethod``
        """

        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.XReplyInvokeMethod.Builder], TraceRmi.XReplyInvokeMethodOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.XReplyInvokeMethod``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearError(self) -> TraceRmi.XReplyInvokeMethod.Builder:
                """
                ``string error = 1;``
                
                :return: This builder for chaining.
                :rtype: TraceRmi.XReplyInvokeMethod.Builder
                """

            def clearReturnValue(self) -> TraceRmi.XReplyInvokeMethod.Builder:
                """
                ``.ghidra.rmi.trace.Value return_value = 2;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getError(self) -> str:
                """
                ``string error = 1;``
                
                :return: The error.
                :rtype: str
                """

            def getErrorBytes(self) -> com.google.protobuf.ByteString:
                """
                ``string error = 1;``
                
                :return: The bytes for error.
                :rtype: com.google.protobuf.ByteString
                """

            def getReturnValue(self) -> TraceRmi.Value:
                """
                ``.ghidra.rmi.trace.Value return_value = 2;``
                
                :return: The returnValue.
                :rtype: TraceRmi.Value
                """

            def getReturnValueBuilder(self) -> TraceRmi.Value.Builder:
                """
                ``.ghidra.rmi.trace.Value return_value = 2;``
                """

            def getReturnValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                """
                ``.ghidra.rmi.trace.Value return_value = 2;``
                """

            def hasReturnValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.Value return_value = 2;``
                
                :return: Whether the returnValue field is set.
                :rtype: bool
                """

            def mergeFrom(self, other: TraceRmi.XReplyInvokeMethod) -> TraceRmi.XReplyInvokeMethod.Builder:
                ...

            def mergeReturnValue(self, value: TraceRmi.Value) -> TraceRmi.XReplyInvokeMethod.Builder:
                """
                ``.ghidra.rmi.trace.Value return_value = 2;``
                """

            def setError(self, value: typing.Union[java.lang.String, str]) -> TraceRmi.XReplyInvokeMethod.Builder:
                """
                ``string error = 1;``
                
                :param java.lang.String or str value: The error to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.XReplyInvokeMethod.Builder
                """

            def setErrorBytes(self, value: com.google.protobuf.ByteString) -> TraceRmi.XReplyInvokeMethod.Builder:
                """
                ``string error = 1;``
                
                :param com.google.protobuf.ByteString value: The bytes for error to set.
                :return: This builder for chaining.
                :rtype: TraceRmi.XReplyInvokeMethod.Builder
                """

            @typing.overload
            def setReturnValue(self, value: TraceRmi.Value) -> TraceRmi.XReplyInvokeMethod.Builder:
                """
                ``.ghidra.rmi.trace.Value return_value = 2;``
                """

            @typing.overload
            def setReturnValue(self, builderForValue: TraceRmi.Value.Builder) -> TraceRmi.XReplyInvokeMethod.Builder:
                """
                ``.ghidra.rmi.trace.Value return_value = 2;``
                """

            @property
            def returnValue(self) -> TraceRmi.Value:
                ...

            @property
            def errorBytes(self) -> com.google.protobuf.ByteString:
                ...

            @property
            def returnValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
                ...

            @property
            def returnValueBuilder(self) -> TraceRmi.Value.Builder:
                ...

            @property
            def error(self) -> java.lang.String:
                ...


        class_: typing.ClassVar[java.lang.Class]
        ERROR_FIELD_NUMBER: typing.Final = 1
        RETURN_VALUE_FIELD_NUMBER: typing.Final = 2

        @staticmethod
        def getDefaultInstance() -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
            ...

        def getError(self) -> str:
            """
            ``string error = 1;``
            
            :return: The error.
            :rtype: str
            """

        def getErrorBytes(self) -> com.google.protobuf.ByteString:
            """
            ``string error = 1;``
            
            :return: The bytes for error.
            :rtype: com.google.protobuf.ByteString
            """

        def getReturnValue(self) -> TraceRmi.Value:
            """
            ``.ghidra.rmi.trace.Value return_value = 2;``
            
            :return: The returnValue.
            :rtype: TraceRmi.Value
            """

        def getReturnValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            """
            ``.ghidra.rmi.trace.Value return_value = 2;``
            """

        def hasReturnValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.Value return_value = 2;``
            
            :return: Whether the returnValue field is set.
            :rtype: bool
            """

        @staticmethod
        @typing.overload
        def newBuilder() -> TraceRmi.XReplyInvokeMethod.Builder:
            ...

        @staticmethod
        @typing.overload
        def newBuilder(prototype: TraceRmi.XReplyInvokeMethod) -> TraceRmi.XReplyInvokeMethod.Builder:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseDelimitedFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: java.nio.ByteBuffer, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: com.google.protobuf.ByteString, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte]) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(data: jpype.JArray[jpype.JByte], extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: java.io.InputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        @typing.overload
        def parseFrom(input: com.google.protobuf.CodedInputStream, extensionRegistry: com.google.protobuf.ExtensionRegistryLite) -> TraceRmi.XReplyInvokeMethod:
            ...

        @staticmethod
        def parser() -> com.google.protobuf.Parser[TraceRmi.XReplyInvokeMethod]:
            ...

        @property
        def returnValue(self) -> TraceRmi.Value:
            ...

        @property
        def errorBytes(self) -> com.google.protobuf.ByteString:
            ...

        @property
        def returnValueOrBuilder(self) -> TraceRmi.ValueOrBuilder:
            ...

        @property
        def error(self) -> java.lang.String:
            ...


    class RootMessageOrBuilder(com.google.protobuf.MessageOrBuilder):

        class_: typing.ClassVar[java.lang.Class]

        def getError(self) -> TraceRmi.ReplyError:
            """
            ``.ghidra.rmi.trace.ReplyError error = 1;``
            
            :return: The error.
            :rtype: TraceRmi.ReplyError
            """

        def getErrorOrBuilder(self) -> TraceRmi.ReplyErrorOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyError error = 1;``
            """

        def getMsgCase(self) -> TraceRmi.RootMessage.MsgCase:
            ...

        def getReplyActivate(self) -> TraceRmi.ReplyActivate:
            """
            ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
            
            :return: The replyActivate.
            :rtype: TraceRmi.ReplyActivate
            """

        def getReplyActivateOrBuilder(self) -> TraceRmi.ReplyActivateOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
            """

        def getReplyCloseTrace(self) -> TraceRmi.ReplyCloseTrace:
            """
            ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
            
            :return: The replyCloseTrace.
            :rtype: TraceRmi.ReplyCloseTrace
            """

        def getReplyCloseTraceOrBuilder(self) -> TraceRmi.ReplyCloseTraceOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
            """

        def getReplyCreateObject(self) -> TraceRmi.ReplyCreateObject:
            """
            ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
            
            :return: The replyCreateObject.
            :rtype: TraceRmi.ReplyCreateObject
            """

        def getReplyCreateObjectOrBuilder(self) -> TraceRmi.ReplyCreateObjectOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
            """

        def getReplyCreateOverlay(self) -> TraceRmi.ReplyCreateOverlaySpace:
            """
            ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
            
            :return: The replyCreateOverlay.
            :rtype: TraceRmi.ReplyCreateOverlaySpace
            """

        def getReplyCreateOverlayOrBuilder(self) -> TraceRmi.ReplyCreateOverlaySpaceOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
            """

        def getReplyCreateTrace(self) -> TraceRmi.ReplyCreateTrace:
            """
            ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
            
            :return: The replyCreateTrace.
            :rtype: TraceRmi.ReplyCreateTrace
            """

        def getReplyCreateTraceOrBuilder(self) -> TraceRmi.ReplyCreateTraceOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
            """

        def getReplyDeleteBytes(self) -> TraceRmi.ReplyDeleteBytes:
            """
            ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
            
            :return: The replyDeleteBytes.
            :rtype: TraceRmi.ReplyDeleteBytes
            """

        def getReplyDeleteBytesOrBuilder(self) -> TraceRmi.ReplyDeleteBytesOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
            """

        def getReplyDeleteRegisterValue(self) -> TraceRmi.ReplyDeleteRegisterValue:
            """
            ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
            
            :return: The replyDeleteRegisterValue.
            :rtype: TraceRmi.ReplyDeleteRegisterValue
            """

        def getReplyDeleteRegisterValueOrBuilder(self) -> TraceRmi.ReplyDeleteRegisterValueOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
            """

        def getReplyDisassemble(self) -> TraceRmi.ReplyDisassemble:
            """
            ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
            
            :return: The replyDisassemble.
            :rtype: TraceRmi.ReplyDisassemble
            """

        def getReplyDisassembleOrBuilder(self) -> TraceRmi.ReplyDisassembleOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
            """

        def getReplyEndTx(self) -> TraceRmi.ReplyEndTx:
            """
            ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
            
            :return: The replyEndTx.
            :rtype: TraceRmi.ReplyEndTx
            """

        def getReplyEndTxOrBuilder(self) -> TraceRmi.ReplyEndTxOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
            """

        def getReplyGetObject(self) -> TraceRmi.ReplyGetObject:
            """
            ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
            
            :return: The replyGetObject.
            :rtype: TraceRmi.ReplyGetObject
            """

        def getReplyGetObjectOrBuilder(self) -> TraceRmi.ReplyGetObjectOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
            """

        def getReplyGetValues(self) -> TraceRmi.ReplyGetValues:
            """
            ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
            
            :return: The replyGetValues.
            :rtype: TraceRmi.ReplyGetValues
            """

        def getReplyGetValuesOrBuilder(self) -> TraceRmi.ReplyGetValuesOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
            """

        def getReplyInsertObject(self) -> TraceRmi.ReplyInsertObject:
            """
            ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
            
            :return: The replyInsertObject.
            :rtype: TraceRmi.ReplyInsertObject
            """

        def getReplyInsertObjectOrBuilder(self) -> TraceRmi.ReplyInsertObjectOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
            """

        def getReplyNegotiate(self) -> TraceRmi.ReplyNegotiate:
            """
            ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
            
            :return: The replyNegotiate.
            :rtype: TraceRmi.ReplyNegotiate
            """

        def getReplyNegotiateOrBuilder(self) -> TraceRmi.ReplyNegotiateOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
            """

        def getReplyPutBytes(self) -> TraceRmi.ReplyPutBytes:
            """
            ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
            
            :return: The replyPutBytes.
            :rtype: TraceRmi.ReplyPutBytes
            """

        def getReplyPutBytesOrBuilder(self) -> TraceRmi.ReplyPutBytesOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
            """

        def getReplyPutRegisterValue(self) -> TraceRmi.ReplyPutRegisterValue:
            """
            ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
            
            :return: The replyPutRegisterValue.
            :rtype: TraceRmi.ReplyPutRegisterValue
            """

        def getReplyPutRegisterValueOrBuilder(self) -> TraceRmi.ReplyPutRegisterValueOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
            """

        def getReplyRemoveObject(self) -> TraceRmi.ReplyRemoveObject:
            """
            ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
            
            :return: The replyRemoveObject.
            :rtype: TraceRmi.ReplyRemoveObject
            """

        def getReplyRemoveObjectOrBuilder(self) -> TraceRmi.ReplyRemoveObjectOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
            """

        def getReplyRetainValues(self) -> TraceRmi.ReplyRetainValues:
            """
            ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
            
            :return: The replyRetainValues.
            :rtype: TraceRmi.ReplyRetainValues
            """

        def getReplyRetainValuesOrBuilder(self) -> TraceRmi.ReplyRetainValuesOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
            """

        def getReplySaveTrace(self) -> TraceRmi.ReplySaveTrace:
            """
            ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
            
            :return: The replySaveTrace.
            :rtype: TraceRmi.ReplySaveTrace
            """

        def getReplySaveTraceOrBuilder(self) -> TraceRmi.ReplySaveTraceOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
            """

        def getReplySetMemoryState(self) -> TraceRmi.ReplySetMemoryState:
            """
            ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
            
            :return: The replySetMemoryState.
            :rtype: TraceRmi.ReplySetMemoryState
            """

        def getReplySetMemoryStateOrBuilder(self) -> TraceRmi.ReplySetMemoryStateOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
            """

        def getReplySetValue(self) -> TraceRmi.ReplySetValue:
            """
            ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
            
            :return: The replySetValue.
            :rtype: TraceRmi.ReplySetValue
            """

        def getReplySetValueOrBuilder(self) -> TraceRmi.ReplySetValueOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
            """

        def getReplySnapshot(self) -> TraceRmi.ReplySnapshot:
            """
            ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
            
            :return: The replySnapshot.
            :rtype: TraceRmi.ReplySnapshot
            """

        def getReplySnapshotOrBuilder(self) -> TraceRmi.ReplySnapshotOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
            """

        def getReplyStartTx(self) -> TraceRmi.ReplyStartTx:
            """
            ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
            
            :return: The replyStartTx.
            :rtype: TraceRmi.ReplyStartTx
            """

        def getReplyStartTxOrBuilder(self) -> TraceRmi.ReplyStartTxOrBuilder:
            """
            ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
            """

        def getRequestActivate(self) -> TraceRmi.RequestActivate:
            """
            ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
            
            :return: The requestActivate.
            :rtype: TraceRmi.RequestActivate
            """

        def getRequestActivateOrBuilder(self) -> TraceRmi.RequestActivateOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
            """

        def getRequestCloseTrace(self) -> TraceRmi.RequestCloseTrace:
            """
            ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
            
            :return: The requestCloseTrace.
            :rtype: TraceRmi.RequestCloseTrace
            """

        def getRequestCloseTraceOrBuilder(self) -> TraceRmi.RequestCloseTraceOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
            """

        def getRequestCreateObject(self) -> TraceRmi.RequestCreateObject:
            """
            
            Use same reply as CreateObject
             
            
            ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
            
            :return: The requestCreateObject.
            :rtype: TraceRmi.RequestCreateObject
            """

        def getRequestCreateObjectOrBuilder(self) -> TraceRmi.RequestCreateObjectOrBuilder:
            """
            
            Use same reply as CreateObject
             
            
            ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
            """

        def getRequestCreateOverlay(self) -> TraceRmi.RequestCreateOverlaySpace:
            """
            ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
            
            :return: The requestCreateOverlay.
            :rtype: TraceRmi.RequestCreateOverlaySpace
            """

        def getRequestCreateOverlayOrBuilder(self) -> TraceRmi.RequestCreateOverlaySpaceOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
            """

        def getRequestCreateRootObject(self) -> TraceRmi.RequestCreateRootObject:
            """
            ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
            
            :return: The requestCreateRootObject.
            :rtype: TraceRmi.RequestCreateRootObject
            """

        def getRequestCreateRootObjectOrBuilder(self) -> TraceRmi.RequestCreateRootObjectOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
            """

        def getRequestCreateTrace(self) -> TraceRmi.RequestCreateTrace:
            """
            ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
            
            :return: The requestCreateTrace.
            :rtype: TraceRmi.RequestCreateTrace
            """

        def getRequestCreateTraceOrBuilder(self) -> TraceRmi.RequestCreateTraceOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
            """

        def getRequestDeleteBytes(self) -> TraceRmi.RequestDeleteBytes:
            """
            ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
            
            :return: The requestDeleteBytes.
            :rtype: TraceRmi.RequestDeleteBytes
            """

        def getRequestDeleteBytesOrBuilder(self) -> TraceRmi.RequestDeleteBytesOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
            """

        def getRequestDeleteRegisterValue(self) -> TraceRmi.RequestDeleteRegisterValue:
            """
            ``.ghidra.rmi.trace.RequestDeleteRegisterValue request_delete_register_value = 24;``
            
            :return: The requestDeleteRegisterValue.
            :rtype: TraceRmi.RequestDeleteRegisterValue
            """

        def getRequestDeleteRegisterValueOrBuilder(self) -> TraceRmi.RequestDeleteRegisterValueOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestDeleteRegisterValue request_delete_register_value = 24;``
            """

        def getRequestDisassemble(self) -> TraceRmi.RequestDisassemble:
            """
            ``.ghidra.rmi.trace.RequestDisassemble request_disassemble = 42;``
            
            :return: The requestDisassemble.
            :rtype: TraceRmi.RequestDisassemble
            """

        def getRequestDisassembleOrBuilder(self) -> TraceRmi.RequestDisassembleOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestDisassemble request_disassemble = 42;``
            """

        def getRequestEndTx(self) -> TraceRmi.RequestEndTx:
            """
            ``.ghidra.rmi.trace.RequestEndTx request_end_tx = 12;``
            
            :return: The requestEndTx.
            :rtype: TraceRmi.RequestEndTx
            """

        def getRequestEndTxOrBuilder(self) -> TraceRmi.RequestEndTxOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestEndTx request_end_tx = 12;``
            """

        def getRequestGetObject(self) -> TraceRmi.RequestGetObject:
            """
            ``.ghidra.rmi.trace.RequestGetObject request_get_object = 37;``
            
            :return: The requestGetObject.
            :rtype: TraceRmi.RequestGetObject
            """

        def getRequestGetObjectOrBuilder(self) -> TraceRmi.RequestGetObjectOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestGetObject request_get_object = 37;``
            """

        def getRequestGetValues(self) -> TraceRmi.RequestGetValues:
            """
            ``.ghidra.rmi.trace.RequestGetValues request_get_values = 39;``
            
            :return: The requestGetValues.
            :rtype: TraceRmi.RequestGetValues
            """

        def getRequestGetValuesIntersecting(self) -> TraceRmi.RequestGetValuesIntersecting:
            """
            
            Reuse reply_get_values
             
            
            ``.ghidra.rmi.trace.RequestGetValuesIntersecting request_get_values_intersecting = 41;``
            
            :return: The requestGetValuesIntersecting.
            :rtype: TraceRmi.RequestGetValuesIntersecting
            """

        def getRequestGetValuesIntersectingOrBuilder(self) -> TraceRmi.RequestGetValuesIntersectingOrBuilder:
            """
            
            Reuse reply_get_values
             
            
            ``.ghidra.rmi.trace.RequestGetValuesIntersecting request_get_values_intersecting = 41;``
            """

        def getRequestGetValuesOrBuilder(self) -> TraceRmi.RequestGetValuesOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestGetValues request_get_values = 39;``
            """

        def getRequestInsertObject(self) -> TraceRmi.RequestInsertObject:
            """
            ``.ghidra.rmi.trace.RequestInsertObject request_insert_object = 29;``
            
            :return: The requestInsertObject.
            :rtype: TraceRmi.RequestInsertObject
            """

        def getRequestInsertObjectOrBuilder(self) -> TraceRmi.RequestInsertObjectOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestInsertObject request_insert_object = 29;``
            """

        def getRequestNegotiate(self) -> TraceRmi.RequestNegotiate:
            """
            ``.ghidra.rmi.trace.RequestNegotiate request_negotiate = 2;``
            
            :return: The requestNegotiate.
            :rtype: TraceRmi.RequestNegotiate
            """

        def getRequestNegotiateOrBuilder(self) -> TraceRmi.RequestNegotiateOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestNegotiate request_negotiate = 2;``
            """

        def getRequestPutBytes(self) -> TraceRmi.RequestPutBytes:
            """
            ``.ghidra.rmi.trace.RequestPutBytes request_put_bytes = 18;``
            
            :return: The requestPutBytes.
            :rtype: TraceRmi.RequestPutBytes
            """

        def getRequestPutBytesOrBuilder(self) -> TraceRmi.RequestPutBytesOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestPutBytes request_put_bytes = 18;``
            """

        def getRequestPutRegisterValue(self) -> TraceRmi.RequestPutRegisterValue:
            """
            ``.ghidra.rmi.trace.RequestPutRegisterValue request_put_register_value = 22;``
            
            :return: The requestPutRegisterValue.
            :rtype: TraceRmi.RequestPutRegisterValue
            """

        def getRequestPutRegisterValueOrBuilder(self) -> TraceRmi.RequestPutRegisterValueOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestPutRegisterValue request_put_register_value = 22;``
            """

        def getRequestRemoveObject(self) -> TraceRmi.RequestRemoveObject:
            """
            ``.ghidra.rmi.trace.RequestRemoveObject request_remove_object = 31;``
            
            :return: The requestRemoveObject.
            :rtype: TraceRmi.RequestRemoveObject
            """

        def getRequestRemoveObjectOrBuilder(self) -> TraceRmi.RequestRemoveObjectOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestRemoveObject request_remove_object = 31;``
            """

        def getRequestRetainValues(self) -> TraceRmi.RequestRetainValues:
            """
            ``.ghidra.rmi.trace.RequestRetainValues request_retain_values = 35;``
            
            :return: The requestRetainValues.
            :rtype: TraceRmi.RequestRetainValues
            """

        def getRequestRetainValuesOrBuilder(self) -> TraceRmi.RequestRetainValuesOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestRetainValues request_retain_values = 35;``
            """

        def getRequestSaveTrace(self) -> TraceRmi.RequestSaveTrace:
            """
            ``.ghidra.rmi.trace.RequestSaveTrace request_save_trace = 6;``
            
            :return: The requestSaveTrace.
            :rtype: TraceRmi.RequestSaveTrace
            """

        def getRequestSaveTraceOrBuilder(self) -> TraceRmi.RequestSaveTraceOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestSaveTrace request_save_trace = 6;``
            """

        def getRequestSetMemoryState(self) -> TraceRmi.RequestSetMemoryState:
            """
            ``.ghidra.rmi.trace.RequestSetMemoryState request_set_memory_state = 16;``
            
            :return: The requestSetMemoryState.
            :rtype: TraceRmi.RequestSetMemoryState
            """

        def getRequestSetMemoryStateOrBuilder(self) -> TraceRmi.RequestSetMemoryStateOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestSetMemoryState request_set_memory_state = 16;``
            """

        def getRequestSetValue(self) -> TraceRmi.RequestSetValue:
            """
            ``.ghidra.rmi.trace.RequestSetValue request_set_value = 33;``
            
            :return: The requestSetValue.
            :rtype: TraceRmi.RequestSetValue
            """

        def getRequestSetValueOrBuilder(self) -> TraceRmi.RequestSetValueOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestSetValue request_set_value = 33;``
            """

        def getRequestSnapshot(self) -> TraceRmi.RequestSnapshot:
            """
            ``.ghidra.rmi.trace.RequestSnapshot request_snapshot = 46;``
            
            :return: The requestSnapshot.
            :rtype: TraceRmi.RequestSnapshot
            """

        def getRequestSnapshotOrBuilder(self) -> TraceRmi.RequestSnapshotOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestSnapshot request_snapshot = 46;``
            """

        def getRequestStartTx(self) -> TraceRmi.RequestStartTx:
            """
            ``.ghidra.rmi.trace.RequestStartTx request_start_tx = 10;``
            
            :return: The requestStartTx.
            :rtype: TraceRmi.RequestStartTx
            """

        def getRequestStartTxOrBuilder(self) -> TraceRmi.RequestStartTxOrBuilder:
            """
            ``.ghidra.rmi.trace.RequestStartTx request_start_tx = 10;``
            """

        def getXreplyInvokeMethod(self) -> TraceRmi.XReplyInvokeMethod:
            """
            ``.ghidra.rmi.trace.XReplyInvokeMethod xreply_invoke_method = 49;``
            
            :return: The xreplyInvokeMethod.
            :rtype: TraceRmi.XReplyInvokeMethod
            """

        def getXreplyInvokeMethodOrBuilder(self) -> TraceRmi.XReplyInvokeMethodOrBuilder:
            """
            ``.ghidra.rmi.trace.XReplyInvokeMethod xreply_invoke_method = 49;``
            """

        def getXrequestInvokeMethod(self) -> TraceRmi.XRequestInvokeMethod:
            """
            ``.ghidra.rmi.trace.XRequestInvokeMethod xrequest_invoke_method = 48;``
            
            :return: The xrequestInvokeMethod.
            :rtype: TraceRmi.XRequestInvokeMethod
            """

        def getXrequestInvokeMethodOrBuilder(self) -> TraceRmi.XRequestInvokeMethodOrBuilder:
            """
            ``.ghidra.rmi.trace.XRequestInvokeMethod xrequest_invoke_method = 48;``
            """

        def hasError(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyError error = 1;``
            
            :return: Whether the error field is set.
            :rtype: bool
            """

        def hasReplyActivate(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
            
            :return: Whether the replyActivate field is set.
            :rtype: bool
            """

        def hasReplyCloseTrace(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
            
            :return: Whether the replyCloseTrace field is set.
            :rtype: bool
            """

        def hasReplyCreateObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
            
            :return: Whether the replyCreateObject field is set.
            :rtype: bool
            """

        def hasReplyCreateOverlay(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
            
            :return: Whether the replyCreateOverlay field is set.
            :rtype: bool
            """

        def hasReplyCreateTrace(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
            
            :return: Whether the replyCreateTrace field is set.
            :rtype: bool
            """

        def hasReplyDeleteBytes(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
            
            :return: Whether the replyDeleteBytes field is set.
            :rtype: bool
            """

        def hasReplyDeleteRegisterValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
            
            :return: Whether the replyDeleteRegisterValue field is set.
            :rtype: bool
            """

        def hasReplyDisassemble(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
            
            :return: Whether the replyDisassemble field is set.
            :rtype: bool
            """

        def hasReplyEndTx(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
            
            :return: Whether the replyEndTx field is set.
            :rtype: bool
            """

        def hasReplyGetObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
            
            :return: Whether the replyGetObject field is set.
            :rtype: bool
            """

        def hasReplyGetValues(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
            
            :return: Whether the replyGetValues field is set.
            :rtype: bool
            """

        def hasReplyInsertObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
            
            :return: Whether the replyInsertObject field is set.
            :rtype: bool
            """

        def hasReplyNegotiate(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
            
            :return: Whether the replyNegotiate field is set.
            :rtype: bool
            """

        def hasReplyPutBytes(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
            
            :return: Whether the replyPutBytes field is set.
            :rtype: bool
            """

        def hasReplyPutRegisterValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
            
            :return: Whether the replyPutRegisterValue field is set.
            :rtype: bool
            """

        def hasReplyRemoveObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
            
            :return: Whether the replyRemoveObject field is set.
            :rtype: bool
            """

        def hasReplyRetainValues(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
            
            :return: Whether the replyRetainValues field is set.
            :rtype: bool
            """

        def hasReplySaveTrace(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
            
            :return: Whether the replySaveTrace field is set.
            :rtype: bool
            """

        def hasReplySetMemoryState(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
            
            :return: Whether the replySetMemoryState field is set.
            :rtype: bool
            """

        def hasReplySetValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
            
            :return: Whether the replySetValue field is set.
            :rtype: bool
            """

        def hasReplySnapshot(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
            
            :return: Whether the replySnapshot field is set.
            :rtype: bool
            """

        def hasReplyStartTx(self) -> bool:
            """
            ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
            
            :return: Whether the replyStartTx field is set.
            :rtype: bool
            """

        def hasRequestActivate(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
            
            :return: Whether the requestActivate field is set.
            :rtype: bool
            """

        def hasRequestCloseTrace(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
            
            :return: Whether the requestCloseTrace field is set.
            :rtype: bool
            """

        def hasRequestCreateObject(self) -> bool:
            """
            
            Use same reply as CreateObject
             
            
            ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
            
            :return: Whether the requestCreateObject field is set.
            :rtype: bool
            """

        def hasRequestCreateOverlay(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
            
            :return: Whether the requestCreateOverlay field is set.
            :rtype: bool
            """

        def hasRequestCreateRootObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
            
            :return: Whether the requestCreateRootObject field is set.
            :rtype: bool
            """

        def hasRequestCreateTrace(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
            
            :return: Whether the requestCreateTrace field is set.
            :rtype: bool
            """

        def hasRequestDeleteBytes(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
            
            :return: Whether the requestDeleteBytes field is set.
            :rtype: bool
            """

        def hasRequestDeleteRegisterValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestDeleteRegisterValue request_delete_register_value = 24;``
            
            :return: Whether the requestDeleteRegisterValue field is set.
            :rtype: bool
            """

        def hasRequestDisassemble(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestDisassemble request_disassemble = 42;``
            
            :return: Whether the requestDisassemble field is set.
            :rtype: bool
            """

        def hasRequestEndTx(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestEndTx request_end_tx = 12;``
            
            :return: Whether the requestEndTx field is set.
            :rtype: bool
            """

        def hasRequestGetObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestGetObject request_get_object = 37;``
            
            :return: Whether the requestGetObject field is set.
            :rtype: bool
            """

        def hasRequestGetValues(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestGetValues request_get_values = 39;``
            
            :return: Whether the requestGetValues field is set.
            :rtype: bool
            """

        def hasRequestGetValuesIntersecting(self) -> bool:
            """
            
            Reuse reply_get_values
             
            
            ``.ghidra.rmi.trace.RequestGetValuesIntersecting request_get_values_intersecting = 41;``
            
            :return: Whether the requestGetValuesIntersecting field is set.
            :rtype: bool
            """

        def hasRequestInsertObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestInsertObject request_insert_object = 29;``
            
            :return: Whether the requestInsertObject field is set.
            :rtype: bool
            """

        def hasRequestNegotiate(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestNegotiate request_negotiate = 2;``
            
            :return: Whether the requestNegotiate field is set.
            :rtype: bool
            """

        def hasRequestPutBytes(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestPutBytes request_put_bytes = 18;``
            
            :return: Whether the requestPutBytes field is set.
            :rtype: bool
            """

        def hasRequestPutRegisterValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestPutRegisterValue request_put_register_value = 22;``
            
            :return: Whether the requestPutRegisterValue field is set.
            :rtype: bool
            """

        def hasRequestRemoveObject(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestRemoveObject request_remove_object = 31;``
            
            :return: Whether the requestRemoveObject field is set.
            :rtype: bool
            """

        def hasRequestRetainValues(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestRetainValues request_retain_values = 35;``
            
            :return: Whether the requestRetainValues field is set.
            :rtype: bool
            """

        def hasRequestSaveTrace(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestSaveTrace request_save_trace = 6;``
            
            :return: Whether the requestSaveTrace field is set.
            :rtype: bool
            """

        def hasRequestSetMemoryState(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestSetMemoryState request_set_memory_state = 16;``
            
            :return: Whether the requestSetMemoryState field is set.
            :rtype: bool
            """

        def hasRequestSetValue(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestSetValue request_set_value = 33;``
            
            :return: Whether the requestSetValue field is set.
            :rtype: bool
            """

        def hasRequestSnapshot(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestSnapshot request_snapshot = 46;``
            
            :return: Whether the requestSnapshot field is set.
            :rtype: bool
            """

        def hasRequestStartTx(self) -> bool:
            """
            ``.ghidra.rmi.trace.RequestStartTx request_start_tx = 10;``
            
            :return: Whether the requestStartTx field is set.
            :rtype: bool
            """

        def hasXreplyInvokeMethod(self) -> bool:
            """
            ``.ghidra.rmi.trace.XReplyInvokeMethod xreply_invoke_method = 49;``
            
            :return: Whether the xreplyInvokeMethod field is set.
            :rtype: bool
            """

        def hasXrequestInvokeMethod(self) -> bool:
            """
            ``.ghidra.rmi.trace.XRequestInvokeMethod xrequest_invoke_method = 48;``
            
            :return: Whether the xrequestInvokeMethod field is set.
            :rtype: bool
            """

        @property
        def xreplyInvokeMethodOrBuilder(self) -> TraceRmi.XReplyInvokeMethodOrBuilder:
            ...

        @property
        def replyCreateOverlayOrBuilder(self) -> TraceRmi.ReplyCreateOverlaySpaceOrBuilder:
            ...

        @property
        def requestDeleteBytes(self) -> TraceRmi.RequestDeleteBytes:
            ...

        @property
        def replyRetainValues(self) -> TraceRmi.ReplyRetainValues:
            ...

        @property
        def requestInsertObject(self) -> TraceRmi.RequestInsertObject:
            ...

        @property
        def replyCreateTraceOrBuilder(self) -> TraceRmi.ReplyCreateTraceOrBuilder:
            ...

        @property
        def replyActivate(self) -> TraceRmi.ReplyActivate:
            ...

        @property
        def requestCreateOverlay(self) -> TraceRmi.RequestCreateOverlaySpace:
            ...

        @property
        def replySetMemoryStateOrBuilder(self) -> TraceRmi.ReplySetMemoryStateOrBuilder:
            ...

        @property
        def requestSetMemoryStateOrBuilder(self) -> TraceRmi.RequestSetMemoryStateOrBuilder:
            ...

        @property
        def requestNegotiate(self) -> TraceRmi.RequestNegotiate:
            ...

        @property
        def replyNegotiate(self) -> TraceRmi.ReplyNegotiate:
            ...

        @property
        def requestGetValuesIntersectingOrBuilder(self) -> TraceRmi.RequestGetValuesIntersectingOrBuilder:
            ...

        @property
        def xrequestInvokeMethod(self) -> TraceRmi.XRequestInvokeMethod:
            ...

        @property
        def replyDeleteRegisterValueOrBuilder(self) -> TraceRmi.ReplyDeleteRegisterValueOrBuilder:
            ...

        @property
        def errorOrBuilder(self) -> TraceRmi.ReplyErrorOrBuilder:
            ...

        @property
        def replyEndTx(self) -> TraceRmi.ReplyEndTx:
            ...

        @property
        def requestRetainValuesOrBuilder(self) -> TraceRmi.RequestRetainValuesOrBuilder:
            ...

        @property
        def requestGetValuesOrBuilder(self) -> TraceRmi.RequestGetValuesOrBuilder:
            ...

        @property
        def replyRemoveObject(self) -> TraceRmi.ReplyRemoveObject:
            ...

        @property
        def requestSaveTraceOrBuilder(self) -> TraceRmi.RequestSaveTraceOrBuilder:
            ...

        @property
        def xrequestInvokeMethodOrBuilder(self) -> TraceRmi.XRequestInvokeMethodOrBuilder:
            ...

        @property
        def replyDisassemble(self) -> TraceRmi.ReplyDisassemble:
            ...

        @property
        def requestGetValuesIntersecting(self) -> TraceRmi.RequestGetValuesIntersecting:
            ...

        @property
        def requestDisassembleOrBuilder(self) -> TraceRmi.RequestDisassembleOrBuilder:
            ...

        @property
        def requestRetainValues(self) -> TraceRmi.RequestRetainValues:
            ...

        @property
        def replyPutRegisterValue(self) -> TraceRmi.ReplyPutRegisterValue:
            ...

        @property
        def requestPutBytesOrBuilder(self) -> TraceRmi.RequestPutBytesOrBuilder:
            ...

        @property
        def requestSnapshot(self) -> TraceRmi.RequestSnapshot:
            ...

        @property
        def requestActivate(self) -> TraceRmi.RequestActivate:
            ...

        @property
        def replyGetObjectOrBuilder(self) -> TraceRmi.ReplyGetObjectOrBuilder:
            ...

        @property
        def replyDisassembleOrBuilder(self) -> TraceRmi.ReplyDisassembleOrBuilder:
            ...

        @property
        def replyInsertObjectOrBuilder(self) -> TraceRmi.ReplyInsertObjectOrBuilder:
            ...

        @property
        def replyCreateOverlay(self) -> TraceRmi.ReplyCreateOverlaySpace:
            ...

        @property
        def replySnapshotOrBuilder(self) -> TraceRmi.ReplySnapshotOrBuilder:
            ...

        @property
        def replyCreateObject(self) -> TraceRmi.ReplyCreateObject:
            ...

        @property
        def requestEndTx(self) -> TraceRmi.RequestEndTx:
            ...

        @property
        def requestSetValueOrBuilder(self) -> TraceRmi.RequestSetValueOrBuilder:
            ...

        @property
        def replyCloseTrace(self) -> TraceRmi.ReplyCloseTrace:
            ...

        @property
        def requestDeleteRegisterValueOrBuilder(self) -> TraceRmi.RequestDeleteRegisterValueOrBuilder:
            ...

        @property
        def requestRemoveObjectOrBuilder(self) -> TraceRmi.RequestRemoveObjectOrBuilder:
            ...

        @property
        def msgCase(self) -> TraceRmi.RootMessage.MsgCase:
            ...

        @property
        def requestCreateTraceOrBuilder(self) -> TraceRmi.RequestCreateTraceOrBuilder:
            ...

        @property
        def requestCloseTraceOrBuilder(self) -> TraceRmi.RequestCloseTraceOrBuilder:
            ...

        @property
        def replySnapshot(self) -> TraceRmi.ReplySnapshot:
            ...

        @property
        def requestSnapshotOrBuilder(self) -> TraceRmi.RequestSnapshotOrBuilder:
            ...

        @property
        def requestGetObjectOrBuilder(self) -> TraceRmi.RequestGetObjectOrBuilder:
            ...

        @property
        def replyCreateTrace(self) -> TraceRmi.ReplyCreateTrace:
            ...

        @property
        def replySetValueOrBuilder(self) -> TraceRmi.ReplySetValueOrBuilder:
            ...

        @property
        def requestCreateObjectOrBuilder(self) -> TraceRmi.RequestCreateObjectOrBuilder:
            ...

        @property
        def requestCreateTrace(self) -> TraceRmi.RequestCreateTrace:
            ...

        @property
        def requestNegotiateOrBuilder(self) -> TraceRmi.RequestNegotiateOrBuilder:
            ...

        @property
        def requestStartTxOrBuilder(self) -> TraceRmi.RequestStartTxOrBuilder:
            ...

        @property
        def replyGetValuesOrBuilder(self) -> TraceRmi.ReplyGetValuesOrBuilder:
            ...

        @property
        def replyGetValues(self) -> TraceRmi.ReplyGetValues:
            ...

        @property
        def replyNegotiateOrBuilder(self) -> TraceRmi.ReplyNegotiateOrBuilder:
            ...

        @property
        def replyGetObject(self) -> TraceRmi.ReplyGetObject:
            ...

        @property
        def replyCreateObjectOrBuilder(self) -> TraceRmi.ReplyCreateObjectOrBuilder:
            ...

        @property
        def replyRetainValuesOrBuilder(self) -> TraceRmi.ReplyRetainValuesOrBuilder:
            ...

        @property
        def requestSetMemoryState(self) -> TraceRmi.RequestSetMemoryState:
            ...

        @property
        def requestEndTxOrBuilder(self) -> TraceRmi.RequestEndTxOrBuilder:
            ...

        @property
        def requestDisassemble(self) -> TraceRmi.RequestDisassemble:
            ...

        @property
        def replyEndTxOrBuilder(self) -> TraceRmi.ReplyEndTxOrBuilder:
            ...

        @property
        def replyDeleteBytesOrBuilder(self) -> TraceRmi.ReplyDeleteBytesOrBuilder:
            ...

        @property
        def requestPutBytes(self) -> TraceRmi.RequestPutBytes:
            ...

        @property
        def replyPutBytes(self) -> TraceRmi.ReplyPutBytes:
            ...

        @property
        def replyPutRegisterValueOrBuilder(self) -> TraceRmi.ReplyPutRegisterValueOrBuilder:
            ...

        @property
        def requestGetObject(self) -> TraceRmi.RequestGetObject:
            ...

        @property
        def replySaveTraceOrBuilder(self) -> TraceRmi.ReplySaveTraceOrBuilder:
            ...

        @property
        def replyStartTxOrBuilder(self) -> TraceRmi.ReplyStartTxOrBuilder:
            ...

        @property
        def replyActivateOrBuilder(self) -> TraceRmi.ReplyActivateOrBuilder:
            ...

        @property
        def requestGetValues(self) -> TraceRmi.RequestGetValues:
            ...

        @property
        def requestDeleteRegisterValue(self) -> TraceRmi.RequestDeleteRegisterValue:
            ...

        @property
        def replyDeleteRegisterValue(self) -> TraceRmi.ReplyDeleteRegisterValue:
            ...

        @property
        def replyCloseTraceOrBuilder(self) -> TraceRmi.ReplyCloseTraceOrBuilder:
            ...

        @property
        def xreplyInvokeMethod(self) -> TraceRmi.XReplyInvokeMethod:
            ...

        @property
        def requestRemoveObject(self) -> TraceRmi.RequestRemoveObject:
            ...

        @property
        def requestCreateObject(self) -> TraceRmi.RequestCreateObject:
            ...

        @property
        def replySetMemoryState(self) -> TraceRmi.ReplySetMemoryState:
            ...

        @property
        def requestDeleteBytesOrBuilder(self) -> TraceRmi.RequestDeleteBytesOrBuilder:
            ...

        @property
        def replySetValue(self) -> TraceRmi.ReplySetValue:
            ...

        @property
        def requestStartTx(self) -> TraceRmi.RequestStartTx:
            ...

        @property
        def requestCloseTrace(self) -> TraceRmi.RequestCloseTrace:
            ...

        @property
        def requestPutRegisterValue(self) -> TraceRmi.RequestPutRegisterValue:
            ...

        @property
        def requestCreateRootObjectOrBuilder(self) -> TraceRmi.RequestCreateRootObjectOrBuilder:
            ...

        @property
        def error(self) -> TraceRmi.ReplyError:
            ...

        @property
        def requestSaveTrace(self) -> TraceRmi.RequestSaveTrace:
            ...

        @property
        def requestCreateRootObject(self) -> TraceRmi.RequestCreateRootObject:
            ...

        @property
        def replySaveTrace(self) -> TraceRmi.ReplySaveTrace:
            ...

        @property
        def replyStartTx(self) -> TraceRmi.ReplyStartTx:
            ...

        @property
        def replyPutBytesOrBuilder(self) -> TraceRmi.ReplyPutBytesOrBuilder:
            ...

        @property
        def requestCreateOverlayOrBuilder(self) -> TraceRmi.RequestCreateOverlaySpaceOrBuilder:
            ...

        @property
        def requestInsertObjectOrBuilder(self) -> TraceRmi.RequestInsertObjectOrBuilder:
            ...

        @property
        def replyInsertObject(self) -> TraceRmi.ReplyInsertObject:
            ...

        @property
        def requestPutRegisterValueOrBuilder(self) -> TraceRmi.RequestPutRegisterValueOrBuilder:
            ...

        @property
        def requestSetValue(self) -> TraceRmi.RequestSetValue:
            ...

        @property
        def replyDeleteBytes(self) -> TraceRmi.ReplyDeleteBytes:
            ...

        @property
        def requestActivateOrBuilder(self) -> TraceRmi.RequestActivateOrBuilder:
            ...

        @property
        def replyRemoveObjectOrBuilder(self) -> TraceRmi.ReplyRemoveObjectOrBuilder:
            ...


    class RootMessage(com.google.protobuf.GeneratedMessage, TraceRmi.RootMessageOrBuilder):
        """
        Protobuf type ``ghidra.rmi.trace.RootMessage``
        """

        class MsgCase(java.lang.Enum[TraceRmi.RootMessage.MsgCase], com.google.protobuf.Internal.EnumLite, com.google.protobuf.AbstractMessageLite.InternalOneOfEnum):

            class_: typing.ClassVar[java.lang.Class]
            ERROR: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_NEGOTIATE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_NEGOTIATE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_CREATE_TRACE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_CREATE_TRACE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_SAVE_TRACE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_SAVE_TRACE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_CLOSE_TRACE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_CLOSE_TRACE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_START_TX: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_START_TX: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_END_TX: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_END_TX: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_CREATE_OVERLAY: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_CREATE_OVERLAY: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_SET_MEMORY_STATE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_SET_MEMORY_STATE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_PUT_BYTES: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_PUT_BYTES: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_DELETE_BYTES: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_DELETE_BYTES: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_PUT_REGISTER_VALUE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_PUT_REGISTER_VALUE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_DELETE_REGISTER_VALUE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_DELETE_REGISTER_VALUE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_CREATE_ROOT_OBJECT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_CREATE_OBJECT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_CREATE_OBJECT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_INSERT_OBJECT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_INSERT_OBJECT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_REMOVE_OBJECT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_REMOVE_OBJECT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_SET_VALUE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_SET_VALUE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_RETAIN_VALUES: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_RETAIN_VALUES: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_GET_OBJECT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_GET_OBJECT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_GET_VALUES: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_GET_VALUES: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_GET_VALUES_INTERSECTING: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_DISASSEMBLE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_DISASSEMBLE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_ACTIVATE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_ACTIVATE: typing.Final[TraceRmi.RootMessage.MsgCase]
            REQUEST_SNAPSHOT: typing.Final[TraceRmi.RootMessage.MsgCase]
            REPLY_SNAPSHOT: typing.Final[TraceRmi.RootMessage.MsgCase]
            XREQUEST_INVOKE_METHOD: typing.Final[TraceRmi.RootMessage.MsgCase]
            XREPLY_INVOKE_METHOD: typing.Final[TraceRmi.RootMessage.MsgCase]
            MSG_NOT_SET: typing.Final[TraceRmi.RootMessage.MsgCase]

            @staticmethod
            def forNumber(value: typing.Union[jpype.JInt, int]) -> TraceRmi.RootMessage.MsgCase:
                ...

            def getNumber(self) -> int:
                ...

            @staticmethod
            @typing.overload
            def valueOf(name: typing.Union[java.lang.String, str]) -> TraceRmi.RootMessage.MsgCase:
                ...

            @staticmethod
            @typing.overload
            @deprecated("Use forNumber(int) instead.")
            def valueOf(value: typing.Union[jpype.JInt, int]) -> TraceRmi.RootMessage.MsgCase:
                """
                
                
                :param jpype.JInt or int value: The number of the enum to look for.
                :return: The enum associated with the given number.
                :rtype: TraceRmi.RootMessage.MsgCase
                
                .. deprecated::
                
                Use :meth:`forNumber(int) <.forNumber>` instead.
                """

            @staticmethod
            def values() -> jpype.JArray[TraceRmi.RootMessage.MsgCase]:
                ...

            @property
            def number(self) -> jpype.JInt:
                ...


        class Builder(com.google.protobuf.GeneratedMessage.Builder[TraceRmi.RootMessage.Builder], TraceRmi.RootMessageOrBuilder):
            """
            Protobuf type ``ghidra.rmi.trace.RootMessage``
            """

            class_: typing.ClassVar[java.lang.Class]

            def clearError(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyError error = 1;``
                """

            def clearMsg(self) -> TraceRmi.RootMessage.Builder:
                ...

            def clearReplyActivate(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
                """

            def clearReplyCloseTrace(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
                """

            def clearReplyCreateObject(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
                """

            def clearReplyCreateOverlay(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
                """

            def clearReplyCreateTrace(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
                """

            def clearReplyDeleteBytes(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
                """

            def clearReplyDeleteRegisterValue(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
                """

            def clearReplyDisassemble(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
                """

            def clearReplyEndTx(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
                """

            def clearReplyGetObject(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
                """

            def clearReplyGetValues(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
                """

            def clearReplyInsertObject(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
                """

            def clearReplyNegotiate(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
                """

            def clearReplyPutBytes(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
                """

            def clearReplyPutRegisterValue(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
                """

            def clearReplyRemoveObject(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
                """

            def clearReplyRetainValues(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
                """

            def clearReplySaveTrace(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
                """

            def clearReplySetMemoryState(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
                """

            def clearReplySetValue(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
                """

            def clearReplySnapshot(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
                """

            def clearReplyStartTx(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
                """

            def clearRequestActivate(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
                """

            def clearRequestCloseTrace(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
                """

            def clearRequestCreateObject(self) -> TraceRmi.RootMessage.Builder:
                """
                
                Use same reply as CreateObject
                 
                
                ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
                """

            def clearRequestCreateOverlay(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
                """

            def clearRequestCreateRootObject(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
                """

            def clearRequestCreateTrace(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
                """

            def clearRequestDeleteBytes(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
                """

            def clearRequestDeleteRegisterValue(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestDeleteRegisterValue request_delete_register_value = 24;``
                """

            def clearRequestDisassemble(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestDisassemble request_disassemble = 42;``
                """

            def clearRequestEndTx(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestEndTx request_end_tx = 12;``
                """

            def clearRequestGetObject(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestGetObject request_get_object = 37;``
                """

            def clearRequestGetValues(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestGetValues request_get_values = 39;``
                """

            def clearRequestGetValuesIntersecting(self) -> TraceRmi.RootMessage.Builder:
                """
                
                Reuse reply_get_values
                 
                
                ``.ghidra.rmi.trace.RequestGetValuesIntersecting request_get_values_intersecting = 41;``
                """

            def clearRequestInsertObject(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestInsertObject request_insert_object = 29;``
                """

            def clearRequestNegotiate(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestNegotiate request_negotiate = 2;``
                """

            def clearRequestPutBytes(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestPutBytes request_put_bytes = 18;``
                """

            def clearRequestPutRegisterValue(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestPutRegisterValue request_put_register_value = 22;``
                """

            def clearRequestRemoveObject(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestRemoveObject request_remove_object = 31;``
                """

            def clearRequestRetainValues(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestRetainValues request_retain_values = 35;``
                """

            def clearRequestSaveTrace(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestSaveTrace request_save_trace = 6;``
                """

            def clearRequestSetMemoryState(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestSetMemoryState request_set_memory_state = 16;``
                """

            def clearRequestSetValue(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestSetValue request_set_value = 33;``
                """

            def clearRequestSnapshot(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestSnapshot request_snapshot = 46;``
                """

            def clearRequestStartTx(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestStartTx request_start_tx = 10;``
                """

            def clearXreplyInvokeMethod(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.XReplyInvokeMethod xreply_invoke_method = 49;``
                """

            def clearXrequestInvokeMethod(self) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.XRequestInvokeMethod xrequest_invoke_method = 48;``
                """

            @staticmethod
            def getDescriptor() -> com.google.protobuf.Descriptors.Descriptor:
                ...

            def getError(self) -> TraceRmi.ReplyError:
                """
                ``.ghidra.rmi.trace.ReplyError error = 1;``
                
                :return: The error.
                :rtype: TraceRmi.ReplyError
                """

            def getErrorBuilder(self) -> TraceRmi.ReplyError.Builder:
                """
                ``.ghidra.rmi.trace.ReplyError error = 1;``
                """

            def getErrorOrBuilder(self) -> TraceRmi.ReplyErrorOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyError error = 1;``
                """

            def getMsgCase(self) -> TraceRmi.RootMessage.MsgCase:
                ...

            def getReplyActivate(self) -> TraceRmi.ReplyActivate:
                """
                ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
                
                :return: The replyActivate.
                :rtype: TraceRmi.ReplyActivate
                """

            def getReplyActivateBuilder(self) -> TraceRmi.ReplyActivate.Builder:
                """
                ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
                """

            def getReplyActivateOrBuilder(self) -> TraceRmi.ReplyActivateOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
                """

            def getReplyCloseTrace(self) -> TraceRmi.ReplyCloseTrace:
                """
                ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
                
                :return: The replyCloseTrace.
                :rtype: TraceRmi.ReplyCloseTrace
                """

            def getReplyCloseTraceBuilder(self) -> TraceRmi.ReplyCloseTrace.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
                """

            def getReplyCloseTraceOrBuilder(self) -> TraceRmi.ReplyCloseTraceOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
                """

            def getReplyCreateObject(self) -> TraceRmi.ReplyCreateObject:
                """
                ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
                
                :return: The replyCreateObject.
                :rtype: TraceRmi.ReplyCreateObject
                """

            def getReplyCreateObjectBuilder(self) -> TraceRmi.ReplyCreateObject.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
                """

            def getReplyCreateObjectOrBuilder(self) -> TraceRmi.ReplyCreateObjectOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
                """

            def getReplyCreateOverlay(self) -> TraceRmi.ReplyCreateOverlaySpace:
                """
                ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
                
                :return: The replyCreateOverlay.
                :rtype: TraceRmi.ReplyCreateOverlaySpace
                """

            def getReplyCreateOverlayBuilder(self) -> TraceRmi.ReplyCreateOverlaySpace.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
                """

            def getReplyCreateOverlayOrBuilder(self) -> TraceRmi.ReplyCreateOverlaySpaceOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
                """

            def getReplyCreateTrace(self) -> TraceRmi.ReplyCreateTrace:
                """
                ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
                
                :return: The replyCreateTrace.
                :rtype: TraceRmi.ReplyCreateTrace
                """

            def getReplyCreateTraceBuilder(self) -> TraceRmi.ReplyCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
                """

            def getReplyCreateTraceOrBuilder(self) -> TraceRmi.ReplyCreateTraceOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
                """

            def getReplyDeleteBytes(self) -> TraceRmi.ReplyDeleteBytes:
                """
                ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
                
                :return: The replyDeleteBytes.
                :rtype: TraceRmi.ReplyDeleteBytes
                """

            def getReplyDeleteBytesBuilder(self) -> TraceRmi.ReplyDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
                """

            def getReplyDeleteBytesOrBuilder(self) -> TraceRmi.ReplyDeleteBytesOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
                """

            def getReplyDeleteRegisterValue(self) -> TraceRmi.ReplyDeleteRegisterValue:
                """
                ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
                
                :return: The replyDeleteRegisterValue.
                :rtype: TraceRmi.ReplyDeleteRegisterValue
                """

            def getReplyDeleteRegisterValueBuilder(self) -> TraceRmi.ReplyDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
                """

            def getReplyDeleteRegisterValueOrBuilder(self) -> TraceRmi.ReplyDeleteRegisterValueOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
                """

            def getReplyDisassemble(self) -> TraceRmi.ReplyDisassemble:
                """
                ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
                
                :return: The replyDisassemble.
                :rtype: TraceRmi.ReplyDisassemble
                """

            def getReplyDisassembleBuilder(self) -> TraceRmi.ReplyDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
                """

            def getReplyDisassembleOrBuilder(self) -> TraceRmi.ReplyDisassembleOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
                """

            def getReplyEndTx(self) -> TraceRmi.ReplyEndTx:
                """
                ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
                
                :return: The replyEndTx.
                :rtype: TraceRmi.ReplyEndTx
                """

            def getReplyEndTxBuilder(self) -> TraceRmi.ReplyEndTx.Builder:
                """
                ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
                """

            def getReplyEndTxOrBuilder(self) -> TraceRmi.ReplyEndTxOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
                """

            def getReplyGetObject(self) -> TraceRmi.ReplyGetObject:
                """
                ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
                
                :return: The replyGetObject.
                :rtype: TraceRmi.ReplyGetObject
                """

            def getReplyGetObjectBuilder(self) -> TraceRmi.ReplyGetObject.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
                """

            def getReplyGetObjectOrBuilder(self) -> TraceRmi.ReplyGetObjectOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
                """

            def getReplyGetValues(self) -> TraceRmi.ReplyGetValues:
                """
                ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
                
                :return: The replyGetValues.
                :rtype: TraceRmi.ReplyGetValues
                """

            def getReplyGetValuesBuilder(self) -> TraceRmi.ReplyGetValues.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
                """

            def getReplyGetValuesOrBuilder(self) -> TraceRmi.ReplyGetValuesOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
                """

            def getReplyInsertObject(self) -> TraceRmi.ReplyInsertObject:
                """
                ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
                
                :return: The replyInsertObject.
                :rtype: TraceRmi.ReplyInsertObject
                """

            def getReplyInsertObjectBuilder(self) -> TraceRmi.ReplyInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
                """

            def getReplyInsertObjectOrBuilder(self) -> TraceRmi.ReplyInsertObjectOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
                """

            def getReplyNegotiate(self) -> TraceRmi.ReplyNegotiate:
                """
                ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
                
                :return: The replyNegotiate.
                :rtype: TraceRmi.ReplyNegotiate
                """

            def getReplyNegotiateBuilder(self) -> TraceRmi.ReplyNegotiate.Builder:
                """
                ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
                """

            def getReplyNegotiateOrBuilder(self) -> TraceRmi.ReplyNegotiateOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
                """

            def getReplyPutBytes(self) -> TraceRmi.ReplyPutBytes:
                """
                ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
                
                :return: The replyPutBytes.
                :rtype: TraceRmi.ReplyPutBytes
                """

            def getReplyPutBytesBuilder(self) -> TraceRmi.ReplyPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
                """

            def getReplyPutBytesOrBuilder(self) -> TraceRmi.ReplyPutBytesOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
                """

            def getReplyPutRegisterValue(self) -> TraceRmi.ReplyPutRegisterValue:
                """
                ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
                
                :return: The replyPutRegisterValue.
                :rtype: TraceRmi.ReplyPutRegisterValue
                """

            def getReplyPutRegisterValueBuilder(self) -> TraceRmi.ReplyPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
                """

            def getReplyPutRegisterValueOrBuilder(self) -> TraceRmi.ReplyPutRegisterValueOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
                """

            def getReplyRemoveObject(self) -> TraceRmi.ReplyRemoveObject:
                """
                ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
                
                :return: The replyRemoveObject.
                :rtype: TraceRmi.ReplyRemoveObject
                """

            def getReplyRemoveObjectBuilder(self) -> TraceRmi.ReplyRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
                """

            def getReplyRemoveObjectOrBuilder(self) -> TraceRmi.ReplyRemoveObjectOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
                """

            def getReplyRetainValues(self) -> TraceRmi.ReplyRetainValues:
                """
                ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
                
                :return: The replyRetainValues.
                :rtype: TraceRmi.ReplyRetainValues
                """

            def getReplyRetainValuesBuilder(self) -> TraceRmi.ReplyRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
                """

            def getReplyRetainValuesOrBuilder(self) -> TraceRmi.ReplyRetainValuesOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
                """

            def getReplySaveTrace(self) -> TraceRmi.ReplySaveTrace:
                """
                ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
                
                :return: The replySaveTrace.
                :rtype: TraceRmi.ReplySaveTrace
                """

            def getReplySaveTraceBuilder(self) -> TraceRmi.ReplySaveTrace.Builder:
                """
                ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
                """

            def getReplySaveTraceOrBuilder(self) -> TraceRmi.ReplySaveTraceOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
                """

            def getReplySetMemoryState(self) -> TraceRmi.ReplySetMemoryState:
                """
                ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
                
                :return: The replySetMemoryState.
                :rtype: TraceRmi.ReplySetMemoryState
                """

            def getReplySetMemoryStateBuilder(self) -> TraceRmi.ReplySetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
                """

            def getReplySetMemoryStateOrBuilder(self) -> TraceRmi.ReplySetMemoryStateOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
                """

            def getReplySetValue(self) -> TraceRmi.ReplySetValue:
                """
                ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
                
                :return: The replySetValue.
                :rtype: TraceRmi.ReplySetValue
                """

            def getReplySetValueBuilder(self) -> TraceRmi.ReplySetValue.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
                """

            def getReplySetValueOrBuilder(self) -> TraceRmi.ReplySetValueOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
                """

            def getReplySnapshot(self) -> TraceRmi.ReplySnapshot:
                """
                ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
                
                :return: The replySnapshot.
                :rtype: TraceRmi.ReplySnapshot
                """

            def getReplySnapshotBuilder(self) -> TraceRmi.ReplySnapshot.Builder:
                """
                ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
                """

            def getReplySnapshotOrBuilder(self) -> TraceRmi.ReplySnapshotOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
                """

            def getReplyStartTx(self) -> TraceRmi.ReplyStartTx:
                """
                ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
                
                :return: The replyStartTx.
                :rtype: TraceRmi.ReplyStartTx
                """

            def getReplyStartTxBuilder(self) -> TraceRmi.ReplyStartTx.Builder:
                """
                ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
                """

            def getReplyStartTxOrBuilder(self) -> TraceRmi.ReplyStartTxOrBuilder:
                """
                ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
                """

            def getRequestActivate(self) -> TraceRmi.RequestActivate:
                """
                ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
                
                :return: The requestActivate.
                :rtype: TraceRmi.RequestActivate
                """

            def getRequestActivateBuilder(self) -> TraceRmi.RequestActivate.Builder:
                """
                ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
                """

            def getRequestActivateOrBuilder(self) -> TraceRmi.RequestActivateOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
                """

            def getRequestCloseTrace(self) -> TraceRmi.RequestCloseTrace:
                """
                ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
                
                :return: The requestCloseTrace.
                :rtype: TraceRmi.RequestCloseTrace
                """

            def getRequestCloseTraceBuilder(self) -> TraceRmi.RequestCloseTrace.Builder:
                """
                ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
                """

            def getRequestCloseTraceOrBuilder(self) -> TraceRmi.RequestCloseTraceOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
                """

            def getRequestCreateObject(self) -> TraceRmi.RequestCreateObject:
                """
                
                Use same reply as CreateObject
                 
                
                ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
                
                :return: The requestCreateObject.
                :rtype: TraceRmi.RequestCreateObject
                """

            def getRequestCreateObjectBuilder(self) -> TraceRmi.RequestCreateObject.Builder:
                """
                
                Use same reply as CreateObject
                 
                
                ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
                """

            def getRequestCreateObjectOrBuilder(self) -> TraceRmi.RequestCreateObjectOrBuilder:
                """
                
                Use same reply as CreateObject
                 
                
                ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
                """

            def getRequestCreateOverlay(self) -> TraceRmi.RequestCreateOverlaySpace:
                """
                ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
                
                :return: The requestCreateOverlay.
                :rtype: TraceRmi.RequestCreateOverlaySpace
                """

            def getRequestCreateOverlayBuilder(self) -> TraceRmi.RequestCreateOverlaySpace.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
                """

            def getRequestCreateOverlayOrBuilder(self) -> TraceRmi.RequestCreateOverlaySpaceOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
                """

            def getRequestCreateRootObject(self) -> TraceRmi.RequestCreateRootObject:
                """
                ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
                
                :return: The requestCreateRootObject.
                :rtype: TraceRmi.RequestCreateRootObject
                """

            def getRequestCreateRootObjectBuilder(self) -> TraceRmi.RequestCreateRootObject.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
                """

            def getRequestCreateRootObjectOrBuilder(self) -> TraceRmi.RequestCreateRootObjectOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
                """

            def getRequestCreateTrace(self) -> TraceRmi.RequestCreateTrace:
                """
                ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
                
                :return: The requestCreateTrace.
                :rtype: TraceRmi.RequestCreateTrace
                """

            def getRequestCreateTraceBuilder(self) -> TraceRmi.RequestCreateTrace.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
                """

            def getRequestCreateTraceOrBuilder(self) -> TraceRmi.RequestCreateTraceOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
                """

            def getRequestDeleteBytes(self) -> TraceRmi.RequestDeleteBytes:
                """
                ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
                
                :return: The requestDeleteBytes.
                :rtype: TraceRmi.RequestDeleteBytes
                """

            def getRequestDeleteBytesBuilder(self) -> TraceRmi.RequestDeleteBytes.Builder:
                """
                ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
                """

            def getRequestDeleteBytesOrBuilder(self) -> TraceRmi.RequestDeleteBytesOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
                """

            def getRequestDeleteRegisterValue(self) -> TraceRmi.RequestDeleteRegisterValue:
                """
                ``.ghidra.rmi.trace.RequestDeleteRegisterValue request_delete_register_value = 24;``
                
                :return: The requestDeleteRegisterValue.
                :rtype: TraceRmi.RequestDeleteRegisterValue
                """

            def getRequestDeleteRegisterValueBuilder(self) -> TraceRmi.RequestDeleteRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.RequestDeleteRegisterValue request_delete_register_value = 24;``
                """

            def getRequestDeleteRegisterValueOrBuilder(self) -> TraceRmi.RequestDeleteRegisterValueOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestDeleteRegisterValue request_delete_register_value = 24;``
                """

            def getRequestDisassemble(self) -> TraceRmi.RequestDisassemble:
                """
                ``.ghidra.rmi.trace.RequestDisassemble request_disassemble = 42;``
                
                :return: The requestDisassemble.
                :rtype: TraceRmi.RequestDisassemble
                """

            def getRequestDisassembleBuilder(self) -> TraceRmi.RequestDisassemble.Builder:
                """
                ``.ghidra.rmi.trace.RequestDisassemble request_disassemble = 42;``
                """

            def getRequestDisassembleOrBuilder(self) -> TraceRmi.RequestDisassembleOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestDisassemble request_disassemble = 42;``
                """

            def getRequestEndTx(self) -> TraceRmi.RequestEndTx:
                """
                ``.ghidra.rmi.trace.RequestEndTx request_end_tx = 12;``
                
                :return: The requestEndTx.
                :rtype: TraceRmi.RequestEndTx
                """

            def getRequestEndTxBuilder(self) -> TraceRmi.RequestEndTx.Builder:
                """
                ``.ghidra.rmi.trace.RequestEndTx request_end_tx = 12;``
                """

            def getRequestEndTxOrBuilder(self) -> TraceRmi.RequestEndTxOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestEndTx request_end_tx = 12;``
                """

            def getRequestGetObject(self) -> TraceRmi.RequestGetObject:
                """
                ``.ghidra.rmi.trace.RequestGetObject request_get_object = 37;``
                
                :return: The requestGetObject.
                :rtype: TraceRmi.RequestGetObject
                """

            def getRequestGetObjectBuilder(self) -> TraceRmi.RequestGetObject.Builder:
                """
                ``.ghidra.rmi.trace.RequestGetObject request_get_object = 37;``
                """

            def getRequestGetObjectOrBuilder(self) -> TraceRmi.RequestGetObjectOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestGetObject request_get_object = 37;``
                """

            def getRequestGetValues(self) -> TraceRmi.RequestGetValues:
                """
                ``.ghidra.rmi.trace.RequestGetValues request_get_values = 39;``
                
                :return: The requestGetValues.
                :rtype: TraceRmi.RequestGetValues
                """

            def getRequestGetValuesBuilder(self) -> TraceRmi.RequestGetValues.Builder:
                """
                ``.ghidra.rmi.trace.RequestGetValues request_get_values = 39;``
                """

            def getRequestGetValuesIntersecting(self) -> TraceRmi.RequestGetValuesIntersecting:
                """
                
                Reuse reply_get_values
                 
                
                ``.ghidra.rmi.trace.RequestGetValuesIntersecting request_get_values_intersecting = 41;``
                
                :return: The requestGetValuesIntersecting.
                :rtype: TraceRmi.RequestGetValuesIntersecting
                """

            def getRequestGetValuesIntersectingBuilder(self) -> TraceRmi.RequestGetValuesIntersecting.Builder:
                """
                
                Reuse reply_get_values
                 
                
                ``.ghidra.rmi.trace.RequestGetValuesIntersecting request_get_values_intersecting = 41;``
                """

            def getRequestGetValuesIntersectingOrBuilder(self) -> TraceRmi.RequestGetValuesIntersectingOrBuilder:
                """
                
                Reuse reply_get_values
                 
                
                ``.ghidra.rmi.trace.RequestGetValuesIntersecting request_get_values_intersecting = 41;``
                """

            def getRequestGetValuesOrBuilder(self) -> TraceRmi.RequestGetValuesOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestGetValues request_get_values = 39;``
                """

            def getRequestInsertObject(self) -> TraceRmi.RequestInsertObject:
                """
                ``.ghidra.rmi.trace.RequestInsertObject request_insert_object = 29;``
                
                :return: The requestInsertObject.
                :rtype: TraceRmi.RequestInsertObject
                """

            def getRequestInsertObjectBuilder(self) -> TraceRmi.RequestInsertObject.Builder:
                """
                ``.ghidra.rmi.trace.RequestInsertObject request_insert_object = 29;``
                """

            def getRequestInsertObjectOrBuilder(self) -> TraceRmi.RequestInsertObjectOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestInsertObject request_insert_object = 29;``
                """

            def getRequestNegotiate(self) -> TraceRmi.RequestNegotiate:
                """
                ``.ghidra.rmi.trace.RequestNegotiate request_negotiate = 2;``
                
                :return: The requestNegotiate.
                :rtype: TraceRmi.RequestNegotiate
                """

            def getRequestNegotiateBuilder(self) -> TraceRmi.RequestNegotiate.Builder:
                """
                ``.ghidra.rmi.trace.RequestNegotiate request_negotiate = 2;``
                """

            def getRequestNegotiateOrBuilder(self) -> TraceRmi.RequestNegotiateOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestNegotiate request_negotiate = 2;``
                """

            def getRequestPutBytes(self) -> TraceRmi.RequestPutBytes:
                """
                ``.ghidra.rmi.trace.RequestPutBytes request_put_bytes = 18;``
                
                :return: The requestPutBytes.
                :rtype: TraceRmi.RequestPutBytes
                """

            def getRequestPutBytesBuilder(self) -> TraceRmi.RequestPutBytes.Builder:
                """
                ``.ghidra.rmi.trace.RequestPutBytes request_put_bytes = 18;``
                """

            def getRequestPutBytesOrBuilder(self) -> TraceRmi.RequestPutBytesOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestPutBytes request_put_bytes = 18;``
                """

            def getRequestPutRegisterValue(self) -> TraceRmi.RequestPutRegisterValue:
                """
                ``.ghidra.rmi.trace.RequestPutRegisterValue request_put_register_value = 22;``
                
                :return: The requestPutRegisterValue.
                :rtype: TraceRmi.RequestPutRegisterValue
                """

            def getRequestPutRegisterValueBuilder(self) -> TraceRmi.RequestPutRegisterValue.Builder:
                """
                ``.ghidra.rmi.trace.RequestPutRegisterValue request_put_register_value = 22;``
                """

            def getRequestPutRegisterValueOrBuilder(self) -> TraceRmi.RequestPutRegisterValueOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestPutRegisterValue request_put_register_value = 22;``
                """

            def getRequestRemoveObject(self) -> TraceRmi.RequestRemoveObject:
                """
                ``.ghidra.rmi.trace.RequestRemoveObject request_remove_object = 31;``
                
                :return: The requestRemoveObject.
                :rtype: TraceRmi.RequestRemoveObject
                """

            def getRequestRemoveObjectBuilder(self) -> TraceRmi.RequestRemoveObject.Builder:
                """
                ``.ghidra.rmi.trace.RequestRemoveObject request_remove_object = 31;``
                """

            def getRequestRemoveObjectOrBuilder(self) -> TraceRmi.RequestRemoveObjectOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestRemoveObject request_remove_object = 31;``
                """

            def getRequestRetainValues(self) -> TraceRmi.RequestRetainValues:
                """
                ``.ghidra.rmi.trace.RequestRetainValues request_retain_values = 35;``
                
                :return: The requestRetainValues.
                :rtype: TraceRmi.RequestRetainValues
                """

            def getRequestRetainValuesBuilder(self) -> TraceRmi.RequestRetainValues.Builder:
                """
                ``.ghidra.rmi.trace.RequestRetainValues request_retain_values = 35;``
                """

            def getRequestRetainValuesOrBuilder(self) -> TraceRmi.RequestRetainValuesOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestRetainValues request_retain_values = 35;``
                """

            def getRequestSaveTrace(self) -> TraceRmi.RequestSaveTrace:
                """
                ``.ghidra.rmi.trace.RequestSaveTrace request_save_trace = 6;``
                
                :return: The requestSaveTrace.
                :rtype: TraceRmi.RequestSaveTrace
                """

            def getRequestSaveTraceBuilder(self) -> TraceRmi.RequestSaveTrace.Builder:
                """
                ``.ghidra.rmi.trace.RequestSaveTrace request_save_trace = 6;``
                """

            def getRequestSaveTraceOrBuilder(self) -> TraceRmi.RequestSaveTraceOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestSaveTrace request_save_trace = 6;``
                """

            def getRequestSetMemoryState(self) -> TraceRmi.RequestSetMemoryState:
                """
                ``.ghidra.rmi.trace.RequestSetMemoryState request_set_memory_state = 16;``
                
                :return: The requestSetMemoryState.
                :rtype: TraceRmi.RequestSetMemoryState
                """

            def getRequestSetMemoryStateBuilder(self) -> TraceRmi.RequestSetMemoryState.Builder:
                """
                ``.ghidra.rmi.trace.RequestSetMemoryState request_set_memory_state = 16;``
                """

            def getRequestSetMemoryStateOrBuilder(self) -> TraceRmi.RequestSetMemoryStateOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestSetMemoryState request_set_memory_state = 16;``
                """

            def getRequestSetValue(self) -> TraceRmi.RequestSetValue:
                """
                ``.ghidra.rmi.trace.RequestSetValue request_set_value = 33;``
                
                :return: The requestSetValue.
                :rtype: TraceRmi.RequestSetValue
                """

            def getRequestSetValueBuilder(self) -> TraceRmi.RequestSetValue.Builder:
                """
                ``.ghidra.rmi.trace.RequestSetValue request_set_value = 33;``
                """

            def getRequestSetValueOrBuilder(self) -> TraceRmi.RequestSetValueOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestSetValue request_set_value = 33;``
                """

            def getRequestSnapshot(self) -> TraceRmi.RequestSnapshot:
                """
                ``.ghidra.rmi.trace.RequestSnapshot request_snapshot = 46;``
                
                :return: The requestSnapshot.
                :rtype: TraceRmi.RequestSnapshot
                """

            def getRequestSnapshotBuilder(self) -> TraceRmi.RequestSnapshot.Builder:
                """
                ``.ghidra.rmi.trace.RequestSnapshot request_snapshot = 46;``
                """

            def getRequestSnapshotOrBuilder(self) -> TraceRmi.RequestSnapshotOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestSnapshot request_snapshot = 46;``
                """

            def getRequestStartTx(self) -> TraceRmi.RequestStartTx:
                """
                ``.ghidra.rmi.trace.RequestStartTx request_start_tx = 10;``
                
                :return: The requestStartTx.
                :rtype: TraceRmi.RequestStartTx
                """

            def getRequestStartTxBuilder(self) -> TraceRmi.RequestStartTx.Builder:
                """
                ``.ghidra.rmi.trace.RequestStartTx request_start_tx = 10;``
                """

            def getRequestStartTxOrBuilder(self) -> TraceRmi.RequestStartTxOrBuilder:
                """
                ``.ghidra.rmi.trace.RequestStartTx request_start_tx = 10;``
                """

            def getXreplyInvokeMethod(self) -> TraceRmi.XReplyInvokeMethod:
                """
                ``.ghidra.rmi.trace.XReplyInvokeMethod xreply_invoke_method = 49;``
                
                :return: The xreplyInvokeMethod.
                :rtype: TraceRmi.XReplyInvokeMethod
                """

            def getXreplyInvokeMethodBuilder(self) -> TraceRmi.XReplyInvokeMethod.Builder:
                """
                ``.ghidra.rmi.trace.XReplyInvokeMethod xreply_invoke_method = 49;``
                """

            def getXreplyInvokeMethodOrBuilder(self) -> TraceRmi.XReplyInvokeMethodOrBuilder:
                """
                ``.ghidra.rmi.trace.XReplyInvokeMethod xreply_invoke_method = 49;``
                """

            def getXrequestInvokeMethod(self) -> TraceRmi.XRequestInvokeMethod:
                """
                ``.ghidra.rmi.trace.XRequestInvokeMethod xrequest_invoke_method = 48;``
                
                :return: The xrequestInvokeMethod.
                :rtype: TraceRmi.XRequestInvokeMethod
                """

            def getXrequestInvokeMethodBuilder(self) -> TraceRmi.XRequestInvokeMethod.Builder:
                """
                ``.ghidra.rmi.trace.XRequestInvokeMethod xrequest_invoke_method = 48;``
                """

            def getXrequestInvokeMethodOrBuilder(self) -> TraceRmi.XRequestInvokeMethodOrBuilder:
                """
                ``.ghidra.rmi.trace.XRequestInvokeMethod xrequest_invoke_method = 48;``
                """

            def hasError(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyError error = 1;``
                
                :return: Whether the error field is set.
                :rtype: bool
                """

            def hasReplyActivate(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
                
                :return: Whether the replyActivate field is set.
                :rtype: bool
                """

            def hasReplyCloseTrace(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
                
                :return: Whether the replyCloseTrace field is set.
                :rtype: bool
                """

            def hasReplyCreateObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
                
                :return: Whether the replyCreateObject field is set.
                :rtype: bool
                """

            def hasReplyCreateOverlay(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
                
                :return: Whether the replyCreateOverlay field is set.
                :rtype: bool
                """

            def hasReplyCreateTrace(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
                
                :return: Whether the replyCreateTrace field is set.
                :rtype: bool
                """

            def hasReplyDeleteBytes(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
                
                :return: Whether the replyDeleteBytes field is set.
                :rtype: bool
                """

            def hasReplyDeleteRegisterValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
                
                :return: Whether the replyDeleteRegisterValue field is set.
                :rtype: bool
                """

            def hasReplyDisassemble(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
                
                :return: Whether the replyDisassemble field is set.
                :rtype: bool
                """

            def hasReplyEndTx(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
                
                :return: Whether the replyEndTx field is set.
                :rtype: bool
                """

            def hasReplyGetObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
                
                :return: Whether the replyGetObject field is set.
                :rtype: bool
                """

            def hasReplyGetValues(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
                
                :return: Whether the replyGetValues field is set.
                :rtype: bool
                """

            def hasReplyInsertObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
                
                :return: Whether the replyInsertObject field is set.
                :rtype: bool
                """

            def hasReplyNegotiate(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
                
                :return: Whether the replyNegotiate field is set.
                :rtype: bool
                """

            def hasReplyPutBytes(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
                
                :return: Whether the replyPutBytes field is set.
                :rtype: bool
                """

            def hasReplyPutRegisterValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
                
                :return: Whether the replyPutRegisterValue field is set.
                :rtype: bool
                """

            def hasReplyRemoveObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
                
                :return: Whether the replyRemoveObject field is set.
                :rtype: bool
                """

            def hasReplyRetainValues(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
                
                :return: Whether the replyRetainValues field is set.
                :rtype: bool
                """

            def hasReplySaveTrace(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
                
                :return: Whether the replySaveTrace field is set.
                :rtype: bool
                """

            def hasReplySetMemoryState(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
                
                :return: Whether the replySetMemoryState field is set.
                :rtype: bool
                """

            def hasReplySetValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
                
                :return: Whether the replySetValue field is set.
                :rtype: bool
                """

            def hasReplySnapshot(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
                
                :return: Whether the replySnapshot field is set.
                :rtype: bool
                """

            def hasReplyStartTx(self) -> bool:
                """
                ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
                
                :return: Whether the replyStartTx field is set.
                :rtype: bool
                """

            def hasRequestActivate(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
                
                :return: Whether the requestActivate field is set.
                :rtype: bool
                """

            def hasRequestCloseTrace(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
                
                :return: Whether the requestCloseTrace field is set.
                :rtype: bool
                """

            def hasRequestCreateObject(self) -> bool:
                """
                
                Use same reply as CreateObject
                 
                
                ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
                
                :return: Whether the requestCreateObject field is set.
                :rtype: bool
                """

            def hasRequestCreateOverlay(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
                
                :return: Whether the requestCreateOverlay field is set.
                :rtype: bool
                """

            def hasRequestCreateRootObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
                
                :return: Whether the requestCreateRootObject field is set.
                :rtype: bool
                """

            def hasRequestCreateTrace(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
                
                :return: Whether the requestCreateTrace field is set.
                :rtype: bool
                """

            def hasRequestDeleteBytes(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
                
                :return: Whether the requestDeleteBytes field is set.
                :rtype: bool
                """

            def hasRequestDeleteRegisterValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestDeleteRegisterValue request_delete_register_value = 24;``
                
                :return: Whether the requestDeleteRegisterValue field is set.
                :rtype: bool
                """

            def hasRequestDisassemble(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestDisassemble request_disassemble = 42;``
                
                :return: Whether the requestDisassemble field is set.
                :rtype: bool
                """

            def hasRequestEndTx(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestEndTx request_end_tx = 12;``
                
                :return: Whether the requestEndTx field is set.
                :rtype: bool
                """

            def hasRequestGetObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestGetObject request_get_object = 37;``
                
                :return: Whether the requestGetObject field is set.
                :rtype: bool
                """

            def hasRequestGetValues(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestGetValues request_get_values = 39;``
                
                :return: Whether the requestGetValues field is set.
                :rtype: bool
                """

            def hasRequestGetValuesIntersecting(self) -> bool:
                """
                
                Reuse reply_get_values
                 
                
                ``.ghidra.rmi.trace.RequestGetValuesIntersecting request_get_values_intersecting = 41;``
                
                :return: Whether the requestGetValuesIntersecting field is set.
                :rtype: bool
                """

            def hasRequestInsertObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestInsertObject request_insert_object = 29;``
                
                :return: Whether the requestInsertObject field is set.
                :rtype: bool
                """

            def hasRequestNegotiate(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestNegotiate request_negotiate = 2;``
                
                :return: Whether the requestNegotiate field is set.
                :rtype: bool
                """

            def hasRequestPutBytes(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestPutBytes request_put_bytes = 18;``
                
                :return: Whether the requestPutBytes field is set.
                :rtype: bool
                """

            def hasRequestPutRegisterValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestPutRegisterValue request_put_register_value = 22;``
                
                :return: Whether the requestPutRegisterValue field is set.
                :rtype: bool
                """

            def hasRequestRemoveObject(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestRemoveObject request_remove_object = 31;``
                
                :return: Whether the requestRemoveObject field is set.
                :rtype: bool
                """

            def hasRequestRetainValues(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestRetainValues request_retain_values = 35;``
                
                :return: Whether the requestRetainValues field is set.
                :rtype: bool
                """

            def hasRequestSaveTrace(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestSaveTrace request_save_trace = 6;``
                
                :return: Whether the requestSaveTrace field is set.
                :rtype: bool
                """

            def hasRequestSetMemoryState(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestSetMemoryState request_set_memory_state = 16;``
                
                :return: Whether the requestSetMemoryState field is set.
                :rtype: bool
                """

            def hasRequestSetValue(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestSetValue request_set_value = 33;``
                
                :return: Whether the requestSetValue field is set.
                :rtype: bool
                """

            def hasRequestSnapshot(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestSnapshot request_snapshot = 46;``
                
                :return: Whether the requestSnapshot field is set.
                :rtype: bool
                """

            def hasRequestStartTx(self) -> bool:
                """
                ``.ghidra.rmi.trace.RequestStartTx request_start_tx = 10;``
                
                :return: Whether the requestStartTx field is set.
                :rtype: bool
                """

            def hasXreplyInvokeMethod(self) -> bool:
                """
                ``.ghidra.rmi.trace.XReplyInvokeMethod xreply_invoke_method = 49;``
                
                :return: Whether the xreplyInvokeMethod field is set.
                :rtype: bool
                """

            def hasXrequestInvokeMethod(self) -> bool:
                """
                ``.ghidra.rmi.trace.XRequestInvokeMethod xrequest_invoke_method = 48;``
                
                :return: Whether the xrequestInvokeMethod field is set.
                :rtype: bool
                """

            def mergeError(self, value: TraceRmi.ReplyError) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyError error = 1;``
                """

            def mergeFrom(self, other: TraceRmi.RootMessage) -> TraceRmi.RootMessage.Builder:
                ...

            def mergeReplyActivate(self, value: TraceRmi.ReplyActivate) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
                """

            def mergeReplyCloseTrace(self, value: TraceRmi.ReplyCloseTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
                """

            def mergeReplyCreateObject(self, value: TraceRmi.ReplyCreateObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
                """

            def mergeReplyCreateOverlay(self, value: TraceRmi.ReplyCreateOverlaySpace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
                """

            def mergeReplyCreateTrace(self, value: TraceRmi.ReplyCreateTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
                """

            def mergeReplyDeleteBytes(self, value: TraceRmi.ReplyDeleteBytes) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
                """

            def mergeReplyDeleteRegisterValue(self, value: TraceRmi.ReplyDeleteRegisterValue) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
                """

            def mergeReplyDisassemble(self, value: TraceRmi.ReplyDisassemble) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
                """

            def mergeReplyEndTx(self, value: TraceRmi.ReplyEndTx) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
                """

            def mergeReplyGetObject(self, value: TraceRmi.ReplyGetObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
                """

            def mergeReplyGetValues(self, value: TraceRmi.ReplyGetValues) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
                """

            def mergeReplyInsertObject(self, value: TraceRmi.ReplyInsertObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
                """

            def mergeReplyNegotiate(self, value: TraceRmi.ReplyNegotiate) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
                """

            def mergeReplyPutBytes(self, value: TraceRmi.ReplyPutBytes) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
                """

            def mergeReplyPutRegisterValue(self, value: TraceRmi.ReplyPutRegisterValue) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
                """

            def mergeReplyRemoveObject(self, value: TraceRmi.ReplyRemoveObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
                """

            def mergeReplyRetainValues(self, value: TraceRmi.ReplyRetainValues) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
                """

            def mergeReplySaveTrace(self, value: TraceRmi.ReplySaveTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
                """

            def mergeReplySetMemoryState(self, value: TraceRmi.ReplySetMemoryState) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
                """

            def mergeReplySetValue(self, value: TraceRmi.ReplySetValue) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
                """

            def mergeReplySnapshot(self, value: TraceRmi.ReplySnapshot) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
                """

            def mergeReplyStartTx(self, value: TraceRmi.ReplyStartTx) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
                """

            def mergeRequestActivate(self, value: TraceRmi.RequestActivate) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
                """

            def mergeRequestCloseTrace(self, value: TraceRmi.RequestCloseTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
                """

            def mergeRequestCreateObject(self, value: TraceRmi.RequestCreateObject) -> TraceRmi.RootMessage.Builder:
                """
                
                Use same reply as CreateObject
                 
                
                ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
                """

            def mergeRequestCreateOverlay(self, value: TraceRmi.RequestCreateOverlaySpace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
                """

            def mergeRequestCreateRootObject(self, value: TraceRmi.RequestCreateRootObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
                """

            def mergeRequestCreateTrace(self, value: TraceRmi.RequestCreateTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
                """

            def mergeRequestDeleteBytes(self, value: TraceRmi.RequestDeleteBytes) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
                """

            def mergeRequestDeleteRegisterValue(self, value: TraceRmi.RequestDeleteRegisterValue) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestDeleteRegisterValue request_delete_register_value = 24;``
                """

            def mergeRequestDisassemble(self, value: TraceRmi.RequestDisassemble) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestDisassemble request_disassemble = 42;``
                """

            def mergeRequestEndTx(self, value: TraceRmi.RequestEndTx) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestEndTx request_end_tx = 12;``
                """

            def mergeRequestGetObject(self, value: TraceRmi.RequestGetObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestGetObject request_get_object = 37;``
                """

            def mergeRequestGetValues(self, value: TraceRmi.RequestGetValues) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestGetValues request_get_values = 39;``
                """

            def mergeRequestGetValuesIntersecting(self, value: TraceRmi.RequestGetValuesIntersecting) -> TraceRmi.RootMessage.Builder:
                """
                
                Reuse reply_get_values
                 
                
                ``.ghidra.rmi.trace.RequestGetValuesIntersecting request_get_values_intersecting = 41;``
                """

            def mergeRequestInsertObject(self, value: TraceRmi.RequestInsertObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestInsertObject request_insert_object = 29;``
                """

            def mergeRequestNegotiate(self, value: TraceRmi.RequestNegotiate) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestNegotiate request_negotiate = 2;``
                """

            def mergeRequestPutBytes(self, value: TraceRmi.RequestPutBytes) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestPutBytes request_put_bytes = 18;``
                """

            def mergeRequestPutRegisterValue(self, value: TraceRmi.RequestPutRegisterValue) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestPutRegisterValue request_put_register_value = 22;``
                """

            def mergeRequestRemoveObject(self, value: TraceRmi.RequestRemoveObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestRemoveObject request_remove_object = 31;``
                """

            def mergeRequestRetainValues(self, value: TraceRmi.RequestRetainValues) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestRetainValues request_retain_values = 35;``
                """

            def mergeRequestSaveTrace(self, value: TraceRmi.RequestSaveTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestSaveTrace request_save_trace = 6;``
                """

            def mergeRequestSetMemoryState(self, value: TraceRmi.RequestSetMemoryState) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestSetMemoryState request_set_memory_state = 16;``
                """

            def mergeRequestSetValue(self, value: TraceRmi.RequestSetValue) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestSetValue request_set_value = 33;``
                """

            def mergeRequestSnapshot(self, value: TraceRmi.RequestSnapshot) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestSnapshot request_snapshot = 46;``
                """

            def mergeRequestStartTx(self, value: TraceRmi.RequestStartTx) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestStartTx request_start_tx = 10;``
                """

            def mergeXreplyInvokeMethod(self, value: TraceRmi.XReplyInvokeMethod) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.XReplyInvokeMethod xreply_invoke_method = 49;``
                """

            def mergeXrequestInvokeMethod(self, value: TraceRmi.XRequestInvokeMethod) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.XRequestInvokeMethod xrequest_invoke_method = 48;``
                """

            @typing.overload
            def setError(self, value: TraceRmi.ReplyError) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyError error = 1;``
                """

            @typing.overload
            def setError(self, builderForValue: TraceRmi.ReplyError.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyError error = 1;``
                """

            @typing.overload
            def setReplyActivate(self, value: TraceRmi.ReplyActivate) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
                """

            @typing.overload
            def setReplyActivate(self, builderForValue: TraceRmi.ReplyActivate.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyActivate reply_activate = 45;``
                """

            @typing.overload
            def setReplyCloseTrace(self, value: TraceRmi.ReplyCloseTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
                """

            @typing.overload
            def setReplyCloseTrace(self, builderForValue: TraceRmi.ReplyCloseTrace.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCloseTrace reply_close_trace = 9;``
                """

            @typing.overload
            def setReplyCreateObject(self, value: TraceRmi.ReplyCreateObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
                """

            @typing.overload
            def setReplyCreateObject(self, builderForValue: TraceRmi.ReplyCreateObject.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateObject reply_create_object = 28;``
                """

            @typing.overload
            def setReplyCreateOverlay(self, value: TraceRmi.ReplyCreateOverlaySpace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
                """

            @typing.overload
            def setReplyCreateOverlay(self, builderForValue: TraceRmi.ReplyCreateOverlaySpace.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateOverlaySpace reply_create_overlay = 15;``
                """

            @typing.overload
            def setReplyCreateTrace(self, value: TraceRmi.ReplyCreateTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
                """

            @typing.overload
            def setReplyCreateTrace(self, builderForValue: TraceRmi.ReplyCreateTrace.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyCreateTrace reply_create_trace = 5;``
                """

            @typing.overload
            def setReplyDeleteBytes(self, value: TraceRmi.ReplyDeleteBytes) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
                """

            @typing.overload
            def setReplyDeleteBytes(self, builderForValue: TraceRmi.ReplyDeleteBytes.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteBytes reply_delete_bytes = 21;``
                """

            @typing.overload
            def setReplyDeleteRegisterValue(self, value: TraceRmi.ReplyDeleteRegisterValue) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
                """

            @typing.overload
            def setReplyDeleteRegisterValue(self, builderForValue: TraceRmi.ReplyDeleteRegisterValue.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDeleteRegisterValue reply_delete_register_value = 25;``
                """

            @typing.overload
            def setReplyDisassemble(self, value: TraceRmi.ReplyDisassemble) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
                """

            @typing.overload
            def setReplyDisassemble(self, builderForValue: TraceRmi.ReplyDisassemble.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyDisassemble reply_disassemble = 43;``
                """

            @typing.overload
            def setReplyEndTx(self, value: TraceRmi.ReplyEndTx) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
                """

            @typing.overload
            def setReplyEndTx(self, builderForValue: TraceRmi.ReplyEndTx.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyEndTx reply_end_tx = 13;``
                """

            @typing.overload
            def setReplyGetObject(self, value: TraceRmi.ReplyGetObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
                """

            @typing.overload
            def setReplyGetObject(self, builderForValue: TraceRmi.ReplyGetObject.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetObject reply_get_object = 38;``
                """

            @typing.overload
            def setReplyGetValues(self, value: TraceRmi.ReplyGetValues) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
                """

            @typing.overload
            def setReplyGetValues(self, builderForValue: TraceRmi.ReplyGetValues.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyGetValues reply_get_values = 40;``
                """

            @typing.overload
            def setReplyInsertObject(self, value: TraceRmi.ReplyInsertObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
                """

            @typing.overload
            def setReplyInsertObject(self, builderForValue: TraceRmi.ReplyInsertObject.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyInsertObject reply_insert_object = 30;``
                """

            @typing.overload
            def setReplyNegotiate(self, value: TraceRmi.ReplyNegotiate) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
                """

            @typing.overload
            def setReplyNegotiate(self, builderForValue: TraceRmi.ReplyNegotiate.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyNegotiate reply_negotiate = 3;``
                """

            @typing.overload
            def setReplyPutBytes(self, value: TraceRmi.ReplyPutBytes) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
                """

            @typing.overload
            def setReplyPutBytes(self, builderForValue: TraceRmi.ReplyPutBytes.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutBytes reply_put_bytes = 19;``
                """

            @typing.overload
            def setReplyPutRegisterValue(self, value: TraceRmi.ReplyPutRegisterValue) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
                """

            @typing.overload
            def setReplyPutRegisterValue(self, builderForValue: TraceRmi.ReplyPutRegisterValue.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyPutRegisterValue reply_put_register_value = 23;``
                """

            @typing.overload
            def setReplyRemoveObject(self, value: TraceRmi.ReplyRemoveObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
                """

            @typing.overload
            def setReplyRemoveObject(self, builderForValue: TraceRmi.ReplyRemoveObject.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRemoveObject reply_remove_object = 32;``
                """

            @typing.overload
            def setReplyRetainValues(self, value: TraceRmi.ReplyRetainValues) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
                """

            @typing.overload
            def setReplyRetainValues(self, builderForValue: TraceRmi.ReplyRetainValues.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyRetainValues reply_retain_values = 36;``
                """

            @typing.overload
            def setReplySaveTrace(self, value: TraceRmi.ReplySaveTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
                """

            @typing.overload
            def setReplySaveTrace(self, builderForValue: TraceRmi.ReplySaveTrace.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySaveTrace reply_save_trace = 7;``
                """

            @typing.overload
            def setReplySetMemoryState(self, value: TraceRmi.ReplySetMemoryState) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
                """

            @typing.overload
            def setReplySetMemoryState(self, builderForValue: TraceRmi.ReplySetMemoryState.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetMemoryState reply_set_memory_state = 17;``
                """

            @typing.overload
            def setReplySetValue(self, value: TraceRmi.ReplySetValue) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
                """

            @typing.overload
            def setReplySetValue(self, builderForValue: TraceRmi.ReplySetValue.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySetValue reply_set_value = 34;``
                """

            @typing.overload
            def setReplySnapshot(self, value: TraceRmi.ReplySnapshot) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
                """

            @typing.overload
            def setReplySnapshot(self, builderForValue: TraceRmi.ReplySnapshot.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplySnapshot reply_snapshot = 47;``
                """

            @typing.overload
            def setReplyStartTx(self, value: TraceRmi.ReplyStartTx) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
                """

            @typing.overload
            def setReplyStartTx(self, builderForValue: TraceRmi.ReplyStartTx.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.ReplyStartTx reply_start_tx = 11;``
                """

            @typing.overload
            def setRequestActivate(self, value: TraceRmi.RequestActivate) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
                """

            @typing.overload
            def setRequestActivate(self, builderForValue: TraceRmi.RequestActivate.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestActivate request_activate = 44;``
                """

            @typing.overload
            def setRequestCloseTrace(self, value: TraceRmi.RequestCloseTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
                """

            @typing.overload
            def setRequestCloseTrace(self, builderForValue: TraceRmi.RequestCloseTrace.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCloseTrace request_close_trace = 8;``
                """

            @typing.overload
            def setRequestCreateObject(self, value: TraceRmi.RequestCreateObject) -> TraceRmi.RootMessage.Builder:
                """
                
                Use same reply as CreateObject
                 
                
                ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
                """

            @typing.overload
            def setRequestCreateObject(self, builderForValue: TraceRmi.RequestCreateObject.Builder) -> TraceRmi.RootMessage.Builder:
                """
                
                Use same reply as CreateObject
                 
                
                ``.ghidra.rmi.trace.RequestCreateObject request_create_object = 27;``
                """

            @typing.overload
            def setRequestCreateOverlay(self, value: TraceRmi.RequestCreateOverlaySpace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
                """

            @typing.overload
            def setRequestCreateOverlay(self, builderForValue: TraceRmi.RequestCreateOverlaySpace.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateOverlaySpace request_create_overlay = 14;``
                """

            @typing.overload
            def setRequestCreateRootObject(self, value: TraceRmi.RequestCreateRootObject) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
                """

            @typing.overload
            def setRequestCreateRootObject(self, builderForValue: TraceRmi.RequestCreateRootObject.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateRootObject request_create_root_object = 26;``
                """

            @typing.overload
            def setRequestCreateTrace(self, value: TraceRmi.RequestCreateTrace) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
                """

            @typing.overload
            def setRequestCreateTrace(self, builderForValue: TraceRmi.RequestCreateTrace.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestCreateTrace request_create_trace = 4;``
                """

            @typing.overload
            def setRequestDeleteBytes(self, value: TraceRmi.RequestDeleteBytes) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
                """

            @typing.overload
            def setRequestDeleteBytes(self, builderForValue: TraceRmi.RequestDeleteBytes.Builder) -> TraceRmi.RootMessage.Builder:
                """
                ``.ghidra.rmi.trace.RequestDeleteBytes request_delete_bytes = 20;``
 