/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.ae2.crafting;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.CraftingLink;
import appeng.crafting.execution.ElapsedTimeTracker;
import appeng.crafting.inv.ListCraftingInventory;
import appeng.me.service.CraftingService;
import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.gtocore.api.ae2.crafting.ICraftingPlanAllocationAccessor;
import com.gtocore.api.ae2.crafting.IElapsedTimeTracker;
import com.gtocore.api.ae2.crafting.OptimizedCraftingCpuLogic;
import com.gtolib.api.ae2.pattern.IParallelPatternDetails;
import com.gtolib.utils.holder.LongHolder;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

class ExecutingCraftingJob {
    private static final String NBT_LINK = "link";
    private static final String NBT_PLAYER_ID = "playerId";
    private static final String NBT_FINAL_OUTPUT = "finalOutput";
    private static final String NBT_WAITING_FOR = "waitingFor";
    private static final String NBT_TIME_TRACKER = "timeTracker";
    private static final String NBT_REMAINING_AMOUNT = "remainingAmount";
    private static final String NBT_TASKS = "tasks";
    private static final String NBT_CRAFTING_PROGRESS = "#craftingProgress";
    final CraftingLink link;
    final ListCraftingInventory waitingFor;
    final Object2ObjectOpenHashMap<IPatternDetails, LongHolder> tasks = new O2OOpenCacheHashMap();
    final ElapsedTimeTracker timeTracker;
    final IElapsedTimeTracker tt;
    GenericStack finalOutput;
    long remainingAmount;
    Integer playerId;
    final KeyCounter expectedOutputs = new KeyCounter();
    final ReferenceOpenHashSet<AEKey> defsToPurge = new ReferenceOpenHashSet();
    final Reference2LongOpenHashMap<AEKey> totalConsumed = new Reference2LongOpenHashMap();
    final Reference2LongOpenHashMap<AEKey> currentConsumed = new Reference2LongOpenHashMap();
    final ReferenceOpenHashSet<AEKey> purgeDefsLocal = new ReferenceOpenHashSet();
    final Reference2ObjectOpenHashMap<AEKey, Object2LongOpenHashMap<IPatternDetails>> allocations = new Reference2ObjectOpenHashMap();

    ExecutingCraftingJob(ICraftingPlan plan, ListCraftingInventory.ChangeListener changeListener, CraftingLink link, @Nullable Integer playerId, KeyCounter missingIng) {
        this(plan, changeListener, link, playerId);
        for (AEKey what : missingIng.keySet()) {
            long amount = missingIng.get(what);
            this.waitingFor.insert(what, amount, Actionable.MODULATE);
            this.tt.gtolib$addMaxItems(amount, what.getType());
        }
    }

    private ExecutingCraftingJob(ICraftingPlan plan, ListCraftingInventory.ChangeListener changeListener, CraftingLink link, @Nullable Integer playerId) {
        ICraftingPlanAllocationAccessor accessor;
        Reference2ObjectOpenHashMap<AEKey, Object2LongOpenHashMap<IPatternDetails>> src;
        this.finalOutput = plan.finalOutput();
        this.remainingAmount = this.finalOutput.amount();
        this.waitingFor = new ListCraftingInventory(changeListener);
        if (plan instanceof ICraftingPlanAllocationAccessor && (src = (accessor = (ICraftingPlanAllocationAccessor)plan).getGtocore$allocations()) != null && !src.isEmpty()) {
            src.reference2ObjectEntrySet().fastForEach(e -> {
                Object2LongOpenHashMap map = new Object2LongOpenHashMap();
                Object2LongOpenHashMap inner = (Object2LongOpenHashMap)e.getValue();
                if (inner != null && !inner.isEmpty()) {
                    map.putAll((Map)inner);
                }
                this.allocations.put((Object)((AEKey)e.getKey()), (Object)map);
            });
        }
        this.timeTracker = new ElapsedTimeTracker();
        this.tt = (IElapsedTimeTracker)this.timeTracker;
        for (Reference2LongMap.Entry entry2 : plan.emittedItems()) {
            this.waitingFor.insert((AEKey)entry2.getKey(), entry2.getLongValue(), Actionable.MODULATE);
            this.tt.gtolib$addMaxItems(entry2.getLongValue(), ((AEKey)entry2.getKey()).getType());
        }
        ((Object2LongOpenHashMap)plan.patternTimes()).object2LongEntrySet().fastForEach(entry -> {
            IPatternDetails key = (IPatternDetails)entry.getKey();
            long value = entry.getLongValue();
            ((LongHolder)this.tasks.computeIfAbsent((Object)key, (Object2ObjectFunction)(Object2ObjectFunction)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$1(java.lang.Object ), (Ljava/lang/Object;)Lcom/gtolib/utils/holder/LongHolder;)())).value += value;
            for (GenericStack output : key.getOutputs()) {
                long amount = output.amount() * value * (long)output.what().getAmountPerUnit();
                this.tt.gtolib$addMaxItems(amount, output.what().getType());
            }
        });
        this.link = link;
        this.playerId = playerId;
    }

    ExecutingCraftingJob(CompoundTag data, ListCraftingInventory.ChangeListener changeListener, OptimizedCraftingCpuLogic cpu) {
        this.link = new CraftingLink(data.m_128469_(NBT_LINK), (ICraftingCPU)cpu.cluster);
        IGrid grid = cpu.cluster.getGrid();
        if (grid != null) {
            ((CraftingService)grid.getCraftingService()).addLink(this.link);
        }
        this.finalOutput = GenericStack.readTag((CompoundTag)data.m_128469_(NBT_FINAL_OUTPUT));
        this.remainingAmount = data.m_128454_(NBT_REMAINING_AMOUNT);
        this.waitingFor = new ListCraftingInventory(changeListener);
        this.waitingFor.readFromNBT(data.m_128437_(NBT_WAITING_FOR, 10));
        this.timeTracker = new ElapsedTimeTracker(data.m_128469_(NBT_TIME_TRACKER));
        this.tt = (IElapsedTimeTracker)this.timeTracker;
        this.playerId = data.m_128425_(NBT_PLAYER_ID, 3) ? Integer.valueOf(data.m_128451_(NBT_PLAYER_ID)) : null;
        ListTag tasksTag = data.m_128437_(NBT_TASKS, 10);
        for (int i = 0; i < tasksTag.size(); ++i) {
            CompoundTag item = tasksTag.m_128728_(i);
            AEItemKey pattern = AEItemKey.fromTag((CompoundTag)item);
            IPatternDetails details = PatternDetailsHelper.decodePattern((AEItemKey)pattern, (Level)cpu.cluster.getLevel());
            if (details == null) continue;
            long parallel = item.m_128454_("parallel");
            if (parallel > 0L) {
                details = IParallelPatternDetails.of((IPatternDetails)details, (Level)cpu.cluster.getLevel(), (long)parallel);
            }
            LongHolder tp = new LongHolder(item.m_128454_(NBT_CRAFTING_PROGRESS));
            this.tasks.put((Object)details, (Object)tp);
        }
        if (data.m_128425_("allocations", 9)) {
            ListTag allocs = data.m_128437_("allocations", 10);
            for (int i = 0; i < allocs.size(); ++i) {
                CompoundTag alloc = allocs.m_128728_(i);
                AEKey itemKey = AEKey.fromTagGeneric((CompoundTag)alloc.m_128469_("item"));
                if (itemKey == null) continue;
                Object2LongOpenHashMap patMap = new Object2LongOpenHashMap();
                ListTag pats = alloc.m_128437_("patterns", 10);
                for (int j = 0; j < pats.size(); ++j) {
                    CompoundTag p = pats.m_128728_(j);
                    long quota = p.m_128454_("quota");
                    AEItemKey pdKey = AEItemKey.fromTag((CompoundTag)p);
                    IPatternDetails det = PatternDetailsHelper.decodePattern((AEItemKey)pdKey, (Level)cpu.cluster.getLevel());
                    if (det == null) continue;
                    patMap.put((Object)det, quota);
                }
                if (patMap.isEmpty()) continue;
                this.allocations.put((Object)itemKey, (Object)patMap);
            }
        }
    }

    CompoundTag writeToNBT() {
        CompoundTag data = new CompoundTag();
        CompoundTag linkData = new CompoundTag();
        this.link.writeToNBT(linkData);
        data.m_128365_(NBT_LINK, (Tag)linkData);
        data.m_128365_(NBT_FINAL_OUTPUT, (Tag)GenericStack.writeTag((GenericStack)this.finalOutput));
        data.m_128365_(NBT_WAITING_FOR, (Tag)this.waitingFor.writeToNBT());
        data.m_128365_(NBT_TIME_TRACKER, (Tag)this.timeTracker.writeToNBT());
        ListTag list = new ListTag();
        this.tasks.object2ObjectEntrySet().fastForEach(e -> {
            IPatternDetails details = (IPatternDetails)e.getKey();
            CompoundTag item = details.getDefinition().toTag();
            item.m_128356_(NBT_CRAFTING_PROGRESS, ((LongHolder)e.getValue()).value);
            if (details instanceof IParallelPatternDetails) {
                IParallelPatternDetails parallelPatternDetails = (IParallelPatternDetails)details;
                item.m_128356_("parallel", parallelPatternDetails.getParallel());
            }
            list.add((Object)item);
        });
        data.m_128365_(NBT_TASKS, (Tag)list);
        ListTag allocs = new ListTag();
        this.allocations.reference2ObjectEntrySet().fastForEach(e -> {
            CompoundTag alloc = new CompoundTag();
            alloc.m_128365_("item", (Tag)((AEKey)e.getKey()).toTagGeneric());
            ListTag pats = new ListTag();
            Object2LongOpenHashMap map = (Object2LongOpenHashMap)e.getValue();
            map.object2LongEntrySet().fastForEach(pe -> {
                IPatternDetails details = (IPatternDetails)pe.getKey();
                CompoundTag ptag = details.getDefinition().toTag();
                ptag.m_128356_("quota", pe.getLongValue());
                pats.add((Object)ptag);
            });
            alloc.m_128365_("patterns", (Tag)pats);
            allocs.add((Object)alloc);
        });
        data.m_128365_("allocations", (Tag)allocs);
        data.m_128356_(NBT_REMAINING_AMOUNT, this.remainingAmount);
        if (this.playerId != null) {
            data.m_128405_(NBT_PLAYER_ID, this.playerId.intValue());
        }
        return data;
    }

    private static /* synthetic */ LongHolder lambda$new$1(Object p) {
        return new LongHolder(0L);
    }
}

