/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.ae2.stacks;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import com.gtocore.api.ae2.stacks.VariantCounter;
import com.gtolib.IUnique;
import com.gtolib.api.ae2.stacks.IKeyCounter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.Collection;
import java.util.Collections;

public final class FuzzyKeyCounter {
    private Int2ObjectOpenHashMap<VariantCounter> lists;

    public FuzzyKeyCounter(KeyCounter keyCounter) {
        Reference2LongOpenHashMap map = IKeyCounter.of((KeyCounter)keyCounter).gtolib$getMap();
        if (map == null) {
            return;
        }
        this.lists = new Int2ObjectOpenHashMap(map.size());
        map.reference2LongEntrySet().fastForEach(entry -> {
            AEKey key = (AEKey)entry.getKey();
            Object patt0$temp = key.getPrimaryKey();
            if (patt0$temp instanceof IUnique) {
                IUnique unique = (IUnique)patt0$temp;
                if (key.getFuzzySearchMaxValue() > 0) {
                    ((VariantCounter)this.lists.computeIfAbsent(unique.getUid(), k -> new VariantCounter.FuzzyVariantMap())).add(key, entry.getLongValue());
                } else {
                    ((VariantCounter)this.lists.computeIfAbsent(unique.getUid(), k -> new VariantCounter.UnorderedVariantMap())).add(key, entry.getLongValue());
                }
            }
        });
    }

    public Collection<Object2LongMap.Entry<AEKey>> findFuzzy(AEKey key, FuzzyMode fuzzy) {
        IUnique unique;
        VariantCounter subIndex;
        if (this.lists == null) {
            return Collections.emptyList();
        }
        Object object = key.getPrimaryKey();
        if (object instanceof IUnique && (subIndex = (VariantCounter)this.lists.get((unique = (IUnique)object).getUid())) != null) {
            return subIndex.findFuzzy(key, fuzzy);
        }
        return Collections.emptyList();
    }

    public void addAll(KeyCounter other) {
        Reference2LongOpenHashMap map = IKeyCounter.of((KeyCounter)other).gtolib$getMap();
        if (map == null) {
            return;
        }
        if (this.lists == null) {
            this.lists = new Int2ObjectOpenHashMap(map.size());
        }
        map.reference2LongEntrySet().fastForEach(entry -> {
            AEKey key = (AEKey)entry.getKey();
            Object patt0$temp = key.getPrimaryKey();
            if (patt0$temp instanceof IUnique) {
                IUnique unique = (IUnique)patt0$temp;
                if (key.getFuzzySearchMaxValue() > 0) {
                    ((VariantCounter)this.lists.computeIfAbsent(unique.getUid(), k -> new VariantCounter.FuzzyVariantMap())).add(key, entry.getLongValue());
                } else {
                    ((VariantCounter)this.lists.computeIfAbsent(unique.getUid(), k -> new VariantCounter.UnorderedVariantMap())).add(key, entry.getLongValue());
                }
            }
        });
    }

    public void clear() {
        if (this.lists == null) {
            return;
        }
        this.lists.values().forEach(VariantCounter::clear);
    }
}

