/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.ae2.stacks;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import com.gtocore.api.ae2.stacks.AEKey2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;

abstract class VariantCounter
implements Iterable<Object2LongMap.Entry<AEKey>> {
    VariantCounter() {
    }

    abstract int size();

    abstract boolean isEmpty();

    abstract long get(AEKey var1);

    abstract long remove(AEKey var1);

    abstract Collection<Object2LongMap.Entry<AEKey>> findFuzzy(AEKey var1, FuzzyMode var2);

    abstract AEKey2LongMap getRecords();

    abstract void reset();

    abstract void clear();

    abstract void removeZeros();

    abstract VariantCounter copy();

    void add(AEKey key, long amount) {
        this.getRecords().addTo(key, amount);
    }

    void set(AEKey key, long amount) {
        this.getRecords().put(key, amount);
    }

    void addAll(VariantCounter other) {
        int size = other.size();
        if (size == 0) {
            return;
        }
        this.ensureCapacity(size);
        for (Object2LongMap.Entry entry : other) {
            this.add((AEKey)entry.getKey(), entry.getLongValue());
        }
    }

    void removeAll(VariantCounter other) {
        int size = other.size();
        if (size == 0) {
            return;
        }
        this.ensureCapacity(size);
        for (Object2LongMap.Entry entry : other) {
            this.add((AEKey)entry.getKey(), -entry.getLongValue());
        }
    }

    void invert() {
        for (Object2LongMap.Entry entry : this) {
            entry.setValue(-entry.getLongValue());
        }
    }

    void ensureCapacity(int capacity) {
        this.getRecords().ensureCapacity(capacity);
    }

    static class FuzzyVariantMap
    extends VariantCounter {
        private static final KeyComparator COMPARATOR = new KeyComparator();
        private final AEKey2LongMap.AVLTreeMap records = new AEKey2LongMap.AVLTreeMap(COMPARATOR);
        private static final int MIN_DAMAGE_VALUE = -1;

        FuzzyVariantMap() {
        }

        @Override
        int size() {
            return this.records.size();
        }

        @Override
        boolean isEmpty() {
            return this.records.isEmpty();
        }

        @Override
        long get(AEKey key) {
            return this.records.getLong(key);
        }

        @Override
        long remove(AEKey key) {
            return this.records.removeLong(key);
        }

        @Override
        Collection<Object2LongMap.Entry<AEKey>> findFuzzy(AEKey key, FuzzyMode fuzzy) {
            return ((Object2LongSortedMap)FuzzyVariantMap.findFuzzy(this.records, key, fuzzy)).object2LongEntrySet();
        }

        @Override
        AEKey2LongMap getRecords() {
            return this.records;
        }

        @Override
        void reset() {
            this.records.reset();
        }

        @Override
        void clear() {
            this.records.clear();
        }

        @Override
        void removeZeros() {
            Iterator<Object2LongMap.Entry<AEKey>> it = this.records.iterator();
            while (it.hasNext()) {
                Object2LongMap.Entry<AEKey> entry = it.next();
                if (entry.getLongValue() != 0L) continue;
                it.remove();
            }
        }

        @Override
        VariantCounter copy() {
            FuzzyVariantMap result = new FuzzyVariantMap();
            result.records.putAll((Map)((Object)this.records));
            return result;
        }

        @Override
        @NotNull
        public Iterator<Object2LongMap.Entry<AEKey>> iterator() {
            return this.records.iterator();
        }

        private static <T extends SortedMap<K, V>, K, V> T findFuzzy(T map, AEKey key, FuzzyMode fuzzy) {
            return (T)map.subMap((Integer)FuzzyVariantMap.makeLowerBound(key, fuzzy), (Integer)FuzzyVariantMap.makeUpperBound(key, fuzzy));
        }

        private static Integer makeLowerBound(AEKey key, FuzzyMode fuzzy) {
            int damage;
            int maxValue = key.getFuzzySearchMaxValue();
            if (fuzzy == FuzzyMode.IGNORE_ALL) {
                damage = maxValue;
            } else {
                int breakpoint = fuzzy.calculateBreakPoint(maxValue);
                damage = key.getFuzzySearchValue() <= breakpoint ? breakpoint : maxValue;
            }
            return damage;
        }

        private static Integer makeUpperBound(AEKey key, FuzzyMode fuzzy) {
            int damage;
            if (fuzzy == FuzzyMode.IGNORE_ALL) {
                damage = -1;
            } else {
                int breakpoint = fuzzy.calculateBreakPoint(key.getFuzzySearchMaxValue());
                damage = key.getFuzzySearchValue() <= breakpoint ? -1 : breakpoint;
            }
            return damage;
        }

        private static class KeyComparator
        implements Comparator<Object> {
            private KeyComparator() {
            }

            @Override
            public int compare(Object a2, Object b2) {
                int fuzzyOrderA;
                int fuzzyOrderB;
                Integer boundA = null;
                AEKey stackA = null;
                if (a2 instanceof Integer) {
                    boundA = (Integer)a2;
                    fuzzyOrderB = boundA;
                } else {
                    stackA = (AEKey)a2;
                    fuzzyOrderB = stackA.getFuzzySearchValue();
                }
                Integer boundB = null;
                AEKey stackB = null;
                if (b2 instanceof Integer) {
                    boundB = (Integer)b2;
                    fuzzyOrderA = boundB;
                } else {
                    stackB = (AEKey)b2;
                    fuzzyOrderA = stackB.getFuzzySearchValue();
                }
                if (boundA != null || boundB != null) {
                    return Integer.compare(fuzzyOrderA, fuzzyOrderB);
                }
                if (stackA.equals(stackB)) {
                    return 0;
                }
                int fuzzyOrder = Integer.compare(fuzzyOrderA, fuzzyOrderB);
                if (fuzzyOrder != 0) {
                    return fuzzyOrder;
                }
                return Integer.compare(stackA.hashCode(), stackB.hashCode());
            }
        }
    }

    static class UnorderedVariantMap
    extends VariantCounter {
        private final AEKey2LongMap.OpenHashMap records = new AEKey2LongMap.OpenHashMap();

        UnorderedVariantMap() {
        }

        @Override
        int size() {
            return this.records.size();
        }

        @Override
        boolean isEmpty() {
            return this.records.isEmpty();
        }

        @Override
        long get(AEKey key) {
            return this.records.getLong(key);
        }

        @Override
        long remove(AEKey key) {
            return this.records.removeLong(key);
        }

        @Override
        Collection<Object2LongMap.Entry<AEKey>> findFuzzy(AEKey filter, FuzzyMode fuzzy) {
            return this.records.object2LongEntrySet();
        }

        @Override
        AEKey2LongMap getRecords() {
            return this.records;
        }

        @Override
        void reset() {
            this.records.reset();
        }

        @Override
        void clear() {
            this.records.clear();
        }

        @Override
        void removeZeros() {
            Iterator it = this.records.iterator();
            while (it.hasNext()) {
                Object2LongMap.Entry entry = (Object2LongMap.Entry)it.next();
                if (entry.getLongValue() != 0L) continue;
                it.remove();
            }
        }

        @Override
        VariantCounter copy() {
            UnorderedVariantMap result = new UnorderedVariantMap();
            result.records.putAll((Map)((Object)this.records));
            return result;
        }

        @Override
        @NotNull
        public Iterator<Object2LongMap.Entry<AEKey>> iterator() {
            return this.records.iterator();
        }
    }
}

