/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.gui;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gtocore.common.machine.monitor.DisplayRegistry;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayComponentGroup
extends WidgetGroup {
    private static final int PACKET_ID = 1;
    @Nullable
    private final Consumer<List<ObjectBooleanPair<ResourceLocation>>> orderedCallback;
    @NotNull
    private final List<ResourceLocation> originList;
    private final List<ObjectBooleanPair<ResourceLocation>> current = new ArrayList<ObjectBooleanPair<ResourceLocation>>();
    private final Map<ResourceLocation, DisplayComponentWidget> displayWidgets = new O2OOpenCacheHashMap();
    private DraggableScrollableWidgetGroup scrollArea;

    public DisplayComponentGroup(@NotNull List<ResourceLocation> originList, @NotNull List<ObjectBooleanPair<ResourceLocation>> currentWithState, @Nullable Consumer<List<ObjectBooleanPair<ResourceLocation>>> orderedCallback, Position position, Size size) {
        super(position, size);
        this.orderedCallback = orderedCallback;
        this.originList = originList;
        this.current.addAll(currentWithState);
        List<ResourceLocation> loadedRLs = this.current.stream().map(Pair::left).toList();
        this.current.addAll(originList.stream().filter(rl -> loadedRLs.stream().noneMatch(arg_0 -> ((ResourceLocation)rl).equals(arg_0))).map(rl -> ObjectBooleanPair.of((Object)rl, (boolean)false)).toList());
        this.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        this.addWidget(new ButtonWidget(this.getSizeWidth() - 16, this.getSizeHeight() - 12, 10, 10, click -> {
            if (!this.isRemote()) {
                this.reset();
            }
        }).setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.BUTTON_VOID.copy().scale(0.8f)}).setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.machine.monitor.adjust_component.reset")}));
        this.init();
    }

    public void init() {
        boolean firstInit;
        int lastScrollY = 0;
        if (this.scrollArea != null) {
            lastScrollY = this.scrollArea.getScrollYOffset();
        }
        boolean bl = firstInit = this.scrollArea == null;
        if (firstInit) {
            this.scrollArea = new DraggableScrollableWidgetGroup(4, 4, this.getSizeWidth() - 8, this.getSizeHeight() - 8);
            this.addWidget((Widget)this.scrollArea);
            this.scrollArea.setScrollable(true);
            this.scrollArea.setYBarStyle((IGuiTexture)GuiTextures.BACKGROUND, (IGuiTexture)GuiTextures.BOX_OVERLAY);
        } else {
            this.scrollArea.clearAllWidgets();
        }
        int y = 2;
        for (ObjectBooleanPair<ResourceLocation> rl : this.current) {
            DisplayComponentWidget displayWidget = firstInit ? new DisplayComponentWidget((ResourceLocation)rl.left(), rl.rightBoolean()) : this.displayWidgets.get(rl.left()).setEnabled(rl.rightBoolean());
            displayWidget.setSelfPosition(5, y);
            displayWidget.setSize(155, 20);
            this.scrollArea.acceptWidget((IConfigurableWidget)displayWidget);
            this.displayWidgets.putIfAbsent((ResourceLocation)rl.left(), displayWidget);
            y += 10;
        }
        if (!firstInit) {
            this.scrollArea.setScrollYOffset(lastScrollY);
        }
    }

    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            this.current.clear();
            int size = buffer.m_130242_();
            for (int i = 0; i < size; ++i) {
                ResourceLocation rl = buffer.m_130281_();
                boolean enabled = buffer.readBoolean();
                this.current.add((ObjectBooleanPair<ResourceLocation>)ObjectBooleanPair.of((Object)rl, (boolean)enabled));
            }
            this.init();
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    private void reset() {
        this.current.clear();
        this.current.addAll(this.originList.stream().map(rl -> ObjectBooleanPair.of((Object)rl, (boolean)true)).toList());
        this.init();
        this.writeUpdateInfo(1, buf -> {
            buf.m_130130_(this.current.size());
            for (ObjectBooleanPair<ResourceLocation> rl : this.current) {
                buf.m_130085_((ResourceLocation)rl.left());
                buf.writeBoolean(rl.rightBoolean());
            }
        });
    }

    private void updateOrdered() {
        List<ObjectBooleanPair> visuallyOrderedState = this.scrollArea.widgets.stream().filter(widget2 -> widget2 instanceof DisplayComponentWidget).map(widget2 -> (DisplayComponentWidget)((Object)widget2)).map(widget2 -> ObjectBooleanPair.of((Object)widget2.getRL(), (boolean)widget2.isEnabled())).toList();
        this.current.clear();
        this.current.addAll(visuallyOrderedState);
        if (this.orderedCallback != null) {
            this.orderedCallback.accept(visuallyOrderedState);
        }
        this.init();
        this.writeUpdateInfo(1, buf -> {
            buf.m_130130_(this.current.size());
            for (ObjectBooleanPair<ResourceLocation> rl : this.current) {
                buf.m_130085_((ResourceLocation)rl.left());
                buf.writeBoolean(rl.rightBoolean());
            }
        });
    }

    private void moveWidgetUp(DisplayComponentWidget widget2) {
        int index = this.scrollArea.widgets.indexOf((Object)widget2);
        if (index > 0) {
            this.scrollArea.removeWidget((Widget)widget2);
            this.scrollArea.widgets.add(index - 1, widget2);
        }
        this.updateOrdered();
    }

    private void moveWidgetDown(DisplayComponentWidget widget2) {
        int index = this.scrollArea.widgets.indexOf((Object)widget2);
        if (index < this.scrollArea.widgets.size() - 1) {
            this.scrollArea.removeWidget((Widget)widget2);
            this.scrollArea.widgets.add(index + 1, widget2);
        }
        this.updateOrdered();
    }

    private class DisplayComponentWidget
    extends WidgetGroup {
        private final ResourceLocation id;
        private final SwitchWidget switchWidget;
        private final LabelWidget labelWidget;

        DisplayComponentWidget(ResourceLocation id, boolean enabledInitially) {
            this.id = id;
            ChatFormatting color = enabledInitially ? ChatFormatting.GREEN : ChatFormatting.YELLOW;
            this.labelWidget = new LabelWidget(0, 0, (Component)Component.m_237115_((String)DisplayRegistry.langKey(id)).m_130940_(color));
            this.addWidget((Widget)this.labelWidget);
            this.labelWidget.setClientSideWidget();
            this.switchWidget = new SwitchWidget(110, 0, 10, 10, (click, result) -> {
                if (!this.isRemote()) {
                    DisplayComponentGroup.this.updateOrdered();
                } else {
                    this.labelWidget.setColor((result != false ? ChatFormatting.GREEN.m_126665_() : ChatFormatting.YELLOW.m_126665_()).intValue());
                }
            }).setPressed(enabledInitially).setBaseTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.0, 1.0, 0.5).scale(0.8f)}).setPressedTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.5, 1.0, 0.5).scale(0.8f)});
            this.addWidget((Widget)this.switchWidget);
            this.switchWidget.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.machine.monitor.adjust_component.switch")});
            ButtonWidget upButton = new ButtonWidget(125, 0, 10, 10, click -> {
                if (!this.isRemote()) {
                    DisplayComponentGroup.this.moveWidgetUp(this);
                }
            }).setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.BUTTON_RIGHT.copy().rotate(-45.0f).scale(0.8f)});
            this.addWidget((Widget)upButton);
            upButton.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.machine.monitor.adjust_component.move_up")});
            ButtonWidget downButton = new ButtonWidget(140, 0, 10, 10, click -> {
                if (!this.isRemote()) {
                    DisplayComponentGroup.this.moveWidgetDown(this);
                }
            }).setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.BUTTON_LEFT.copy().rotate(-45.0f).scale(0.8f)});
            this.addWidget((Widget)downButton);
            downButton.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.machine.monitor.adjust_component.move_down")});
        }

        ResourceLocation getRL() {
            return this.id;
        }

        boolean isEnabled() {
            return this.switchWidget.isPressed();
        }

        DisplayComponentWidget setEnabled(boolean enabled) {
            this.switchWidget.setPressed(enabled);
            if (this.isRemote()) {
                this.labelWidget.setColor((enabled ? ChatFormatting.GREEN.m_126665_() : ChatFormatting.YELLOW.m_126665_()).intValue());
            }
            return this;
        }
    }
}

