/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.gui;

import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class InteractiveImageWidget
extends Widget {
    @NumberRange(range={-100.0, 100.0})
    private int border;
    @NumberColor
    private int borderColor = -16777216;
    @Nullable
    protected Consumer<List<Component>> textSupplier;
    protected List<Component> lastText = new ArrayList<Component>();
    @OnlyIn(value=Dist.CLIENT)
    private Supplier<IGuiTexture> textureSupplier;
    @OnlyIn(value=Dist.CLIENT)
    private IGuiTexture currentImage;
    protected BiConsumer<String, ClickData> clickHandler;

    public InteractiveImageWidget() {
        this(0, 0, 50, 50, (IGuiTexture)new ResourceTexture());
    }

    public InteractiveImageWidget(int x, int y, int width, int height, IGuiTexture image) {
        super(x, y, width, height);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.currentImage = image;
            this.textureSupplier = () -> image;
            return null;
        });
    }

    public InteractiveImageWidget(int x, int y, int width, int height, Supplier<IGuiTexture> textureSupplier) {
        super(x, y, width, height);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> this.lambda$new$3((Supplier)textureSupplier));
    }

    @OnlyIn(value=Dist.CLIENT)
    public InteractiveImageWidget setImage(IGuiTexture image) {
        this.currentImage = image;
        this.textureSupplier = () -> image;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public InteractiveImageWidget setImageSupplier(Supplier<IGuiTexture> supplier) {
        this.textureSupplier = supplier;
        this.currentImage = supplier.get();
        return this;
    }

    public InteractiveImageWidget setBorder(int border, int color) {
        if (this.border != border || this.borderColor != color) {
            this.border = border;
            this.borderColor = color;
            if (!this.isRemote()) {
                this.writeUpdateInfo(1, this::writeBorderData);
            }
        }
        return this;
    }

    public InteractiveImageWidget textSupplier(@Nullable Consumer<List<Component>> textSupplier) {
        this.textSupplier = textSupplier;
        if (textSupplier != null && !this.isRemote()) {
            this.lastText.clear();
            textSupplier.accept(this.lastText);
        }
        return this;
    }

    public InteractiveImageWidget clickHandler(BiConsumer<String, ClickData> clickHandler) {
        this.clickHandler = clickHandler;
        return this;
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        this.writeBorderData(buffer);
        buffer.m_130130_(this.lastText.size());
        for (Component text : this.lastText) {
            buffer.m_130083_(text);
        }
    }

    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        this.readBorderData(buffer);
        this.lastText.clear();
        int count = buffer.m_130242_();
        for (int i = 0; i < count; ++i) {
            this.lastText.add(buffer.m_130238_());
        }
    }

    public void initWidget() {
        super.initWidget();
        if (this.textSupplier != null && !this.isRemote()) {
            this.lastText.clear();
            this.textSupplier.accept(this.lastText);
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.textSupplier != null && !this.isRemote()) {
            ArrayList<Component> newText = new ArrayList<Component>();
            this.textSupplier.accept(newText);
            if (!this.lastText.equals(newText)) {
                this.lastText = newText;
                this.writeUpdateInfo(2, buf -> {
                    buf.m_130130_(this.lastText.size());
                    for (Component text : this.lastText) {
                        buf.m_130083_(text);
                    }
                });
            }
        }
    }

    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        switch (id) {
            case 1: {
                this.readBorderData(buffer);
                break;
            }
            case 2: {
                this.lastText.clear();
                int count = buffer.m_130242_();
                for (int i = 0; i < count; ++i) {
                    this.lastText.add(buffer.m_130238_());
                }
                break;
            }
            default: {
                super.readUpdateInfo(id, buffer);
            }
        }
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (id == 3) {
            ClickData clickData = ClickData.readFromBuf((FriendlyByteBuf)buffer);
            String componentData = buffer.m_130277_();
            if (this.clickHandler != null) {
                this.clickHandler.accept(componentData, clickData);
            } else {
                super.handleClientAction(id, buffer);
            }
        }
    }

    private void writeBorderData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.border);
        buffer.writeInt(this.borderColor);
    }

    private void readBorderData(FriendlyByteBuf buffer) {
        this.border = buffer.readInt();
        this.borderColor = buffer.readInt();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.currentImage != null) {
            this.currentImage.draw(graphics, mouseX, mouseY, (float)pos.x, (float)pos.y, size.width, size.height);
        }
        if (this.border > 0) {
            DrawerHelper.drawBorder((GuiGraphics)graphics, (int)pos.x, (int)pos.y, (int)size.width, (int)size.height, (int)this.borderColor, (int)this.border);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY) && !this.lastText.isEmpty()) {
            this.updateScreen();
            this.gui.getModularUIGui().setHoverTooltip(this.lastText, ItemStack.f_41583_, null, null);
            return;
        }
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button2) {
        if (this.isMouseOver((int)mouseX, (int)mouseY)) {
            String data = "image_click";
            ClickData clickData = new ClickData();
            if (this.clickHandler != null) {
                this.clickHandler.accept(data, clickData);
            }
            this.writeClientAction(3, buf -> {
                clickData.writeToBuf(buf);
                buf.m_130070_(data);
            });
            InteractiveImageWidget.playButtonClickSound();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button2);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isMouseOver(int mouseX, int mouseY) {
        Position absolutePos = this.getPosition();
        Size size = this.getSize();
        return mouseX >= absolutePos.x && mouseX <= absolutePos.x + size.width && mouseY >= absolutePos.y && mouseY <= absolutePos.y + size.height;
    }

    @Generated
    public int getBorder() {
        return this.border;
    }

    @Generated
    public int getBorderColor() {
        return this.borderColor;
    }

    @Generated
    public List<Component> getLastText() {
        return this.lastText;
    }

    private /* synthetic */ Object lambda$new$3(Supplier textureSupplier) throws Exception {
        this.textureSupplier = textureSupplier;
        this.currentImage = (IGuiTexture)textureSupplier.get();
        return null;
    }
}

