/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.gui;

import com.gtolib.GTOCore;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

@LDLRegister(name="stack_texture", group="texture")
public class StackTexture
extends TransformTexture {
    @Configurable(name="ldlib.gui.editor.name.items")
    public ItemStack[] itemStacks = new ItemStack[0];
    @Configurable(name="ldlib.gui.editor.name.fluids")
    public FluidStack[] fluidStacks = new FluidStack[0];
    @Configurable(name="ldlib.gui.editor.name.color")
    private int color = -1;
    private static final int COUNT_OFFSET = 2;
    private int index = 0;
    private int ticks = 0;
    private long lastTick = -1L;

    public StackTexture() {
        this((Object)new ItemStack((ItemLike)Items.f_42410_));
    }

    public StackTexture(ItemStack ... itemStacks) {
        this.itemStacks = itemStacks;
        this.fluidStacks = new FluidStack[0];
        this.resetAnimation();
    }

    public StackTexture(Item ... items) {
        this.itemStacks = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.itemStacks[i] = new ItemStack((ItemLike)items[i]);
        }
        this.fluidStacks = new FluidStack[0];
        this.resetAnimation();
    }

    public StackTexture(FluidStack ... fluidStacks) {
        this.fluidStacks = fluidStacks;
        this.itemStacks = new ItemStack[0];
        this.resetAnimation();
    }

    public StackTexture(Object stackObject) {
        this.setStack(stackObject);
    }

    public StackTexture setItems(ItemStack ... itemStacks) {
        this.itemStacks = itemStacks;
        this.fluidStacks = new FluidStack[0];
        this.resetAnimation();
        return this;
    }

    public StackTexture setFluids(FluidStack ... fluidStacks) {
        this.fluidStacks = fluidStacks;
        this.itemStacks = new ItemStack[0];
        this.resetAnimation();
        return this;
    }

    public StackTexture setStack(Object stackObject) {
        Object object = stackObject;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Item.class, ItemStack.class, FluidStack.class, ItemStack[].class, FluidStack[].class}, (Object)object, n)) {
            case -1: {
                this.itemStacks = new ItemStack[0];
                this.fluidStacks = new FluidStack[0];
                this.resetAnimation();
                return this;
            }
            case 0: {
                Item item = (Item)object;
                this.setItems(new ItemStack((ItemLike)item));
                break;
            }
            case 1: {
                ItemStack itemStack = (ItemStack)object;
                this.setItems(itemStack);
                break;
            }
            case 2: {
                FluidStack fluidStack = (FluidStack)object;
                this.setFluids(fluidStack);
                break;
            }
            case 3: {
                ItemStack[] itemStacks = (ItemStack[])object;
                this.setItems(itemStacks);
                break;
            }
            case 4: {
                FluidStack[] fluidStacks = (FluidStack[])object;
                this.setFluids(fluidStacks);
                break;
            }
            default: {
                this.itemStacks = new ItemStack[0];
                this.fluidStacks = new FluidStack[0];
                this.resetAnimation();
                GTOCore.LOGGER.error("Unsupported stack type: {}\nSupported types: Item, ItemStack, FluidStack, ItemStack[], FluidStack[]", (Object)stackObject.getClass().getName());
                return this;
            }
        }
        return this;
    }

    public StackTexture setColor(int color) {
        this.color = color;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateTick() {
        int totalFrames;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            long currentTick = mc.f_91073_.m_46467_();
            if (currentTick == this.lastTick) {
                return;
            }
            this.lastTick = currentTick;
        }
        if ((totalFrames = Math.max(this.itemStacks.length, this.fluidStacks.length)) <= 1) {
            return;
        }
        if (++this.ticks % 20 == 0) {
            this.index = (this.index + 1) % totalFrames;
        }
    }

    private void resetAnimation() {
        this.index = 0;
        this.ticks = 0;
        this.lastTick = -1L;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        this.updateTick();
        Object currentStack = this.getCurrentStack();
        if (currentStack == null) {
            return;
        }
        graphics.m_280168_().m_85836_();
        float scaleX = (float)width / 16.0f;
        float scaleY = (float)height / 16.0f;
        graphics.m_280168_().m_85841_(scaleX, scaleY, 1.0f);
        graphics.m_280168_().m_252880_(x * 16.0f / (float)width, y * 16.0f / (float)height, 0.0f);
        if (currentStack instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)currentStack;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
            DrawerHelper.drawItemStack((GuiGraphics)graphics, (ItemStack)itemStack, (int)0, (int)0, (int)this.color, null);
            graphics.m_280168_().m_85849_();
        } else if (currentStack instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)currentStack;
            graphics.m_280168_().m_85836_();
            this.drawFluidStack(graphics, fluidStack, 0, 0);
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280168_().m_85849_();
        this.drawCount(graphics, currentStack, x, y, width, height);
    }

    private Object getCurrentStack() {
        if (this.itemStacks.length > 0) {
            return this.itemStacks[Math.min(this.index, this.itemStacks.length - 1)];
        }
        if (this.fluidStacks.length > 0) {
            return this.fluidStacks[Math.min(this.index, this.fluidStacks.length - 1)];
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawFluidStack(GuiGraphics graphics, FluidStack fluidStack, int drawX, int drawY) {
        TextureAtlasSprite flowingSprite;
        ResourceLocation flowingTex;
        if (fluidStack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        FluidType fluidType = fluidStack.getFluid().getFluidType();
        IClientFluidTypeExtensions renderExt = IClientFluidTypeExtensions.of((FluidType)fluidType);
        if (renderExt == null) {
            this.drawMissingTexture(graphics, drawX, drawY);
            return;
        }
        ResourceLocation stillTex = renderExt.getStillTexture(fluidStack);
        if (stillTex == null) {
            this.drawMissingTexture(graphics, drawX, drawY);
            return;
        }
        TextureAtlasSprite stillSprite = (TextureAtlasSprite)mc.m_91258_(TextureAtlas.f_118259_).apply(stillTex);
        if (stillSprite == null) {
            this.drawMissingTexture(graphics, drawX, drawY);
            return;
        }
        int fluidColor = renderExt.getTintColor(fluidStack);
        int finalColor = this.combineColors(fluidColor, this.color);
        float r = (float)(finalColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(finalColor >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(finalColor & 0xFF) / 255.0f;
        float a2 = (float)(finalColor >> 24 & 0xFF) / 255.0f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
        graphics.m_280565_(drawX, drawY, 0, 16, 16, stillSprite, r, g, b2, a2);
        graphics.m_280168_().m_85849_();
        if (fluidType.getLightLevel() > 0 && (flowingTex = renderExt.getFlowingTexture(fluidStack)) != null && (flowingSprite = (TextureAtlasSprite)mc.m_91258_(TextureAtlas.f_118259_).apply(flowingTex)) != null) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 11.0f);
            graphics.m_280565_(drawX, drawY, 0, 16, 16, flowingSprite, 1.0f, 1.0f, 1.0f, 0.4f);
            graphics.m_280168_().m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawMissingTexture(GuiGraphics graphics, int drawX, int drawY) {
        Minecraft mc = Minecraft.m_91087_();
        TextureAtlasSprite missingSprite = (TextureAtlasSprite)mc.m_91258_(TextureAtlas.f_118259_).apply(TextureManager.f_118466_);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 0.0f);
        graphics.m_280565_(drawX, drawY, 0, 16, 16, missingSprite, 1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280168_().m_85849_();
    }

    private int combineColors(int fluidColor, int overlayColor) {
        if ((fluidColor & 0xFF000000) == 0) {
            fluidColor |= 0xFF000000;
        }
        if (overlayColor == -1) {
            return fluidColor;
        }
        float a1 = (float)(fluidColor >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(fluidColor & 0xFF) / 255.0f;
        float a2 = (float)(overlayColor >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(overlayColor >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(overlayColor >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(overlayColor & 0xFF) / 255.0f;
        float a3 = a1 * a2;
        float r = r1 * r2;
        float g = g1 * g2;
        float b3 = b1 * b2;
        return (int)(a3 * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b3 * 255.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawCount(GuiGraphics graphics, Object stack, float x, float y, int width, int height) {
        String countText = this.getCountText(stack);
        if (countText.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        float textScale = (float)Math.min(width, height) / 16.0f * 0.5f;
        textScale = Math.clamp(textScale, 0.4f, 0.6f);
        graphics.m_280168_().m_85836_();
        float textWidth = (float)mc.f_91062_.m_92895_(countText) * textScale;
        Objects.requireNonNull(mc.f_91062_);
        float textHeight = 9.0f * textScale;
        float textX = x + (float)width - textWidth - 2.0f;
        float textY = y + (float)height - textHeight - 2.0f;
        graphics.m_280168_().m_252880_(textX, textY, 200.0f);
        graphics.m_280168_().m_85841_(textScale, textScale, 1.0f);
        graphics.m_280056_(mc.f_91062_, countText, 1, 1, 0, false);
        graphics.m_280056_(mc.f_91062_, countText, 0, 0, 0xFFFFFF, false);
        graphics.m_280168_().m_85849_();
    }

    private String getCountText(Object stack) {
        long currentCount;
        FluidStack fluidStack;
        if (stack instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)stack;
            return "";
        }
        if (stack instanceof FluidStack) {
            fluidStack = (FluidStack)stack;
            if (fluidStack.getAmount() <= 0) {
                return "";
            }
        } else {
            return "";
        }
        long count = fluidStack.getAmount();
        String[] units = new String[]{"", "K", "M", "B", "T", "Q", "X", "Z"};
        int unitIndex = 0;
        for (currentCount = count; currentCount >= 10000L && unitIndex < units.length - 1; currentCount /= 1000L, ++unitIndex) {
        }
        return currentCount + units[unitIndex];
    }

    @Generated
    public ItemStack[] getItemStacks() {
        return this.itemStacks;
    }

    @Generated
    public FluidStack[] getFluidStacks() {
        return this.fluidStacks;
    }

    @Generated
    public int getColor() {
        return this.color;
    }
}

