/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.gui.configurators;

import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gtocore.api.gui.configurators.CustomModeFancyConfigurator;
import com.gtocore.common.data.GTORecipeTypes;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MultiMachineModeFancyConfigurator
extends CustomModeFancyConfigurator {
    private static final List<GTRecipeType> EMPTY_LIST = Collections.singletonList(GTORecipeTypes.HATCH_COMBINED);
    private final Consumer<GTRecipeType> onChange;
    private final List<GTRecipeType> recipeTypes;
    private int currentMode;

    public MultiMachineModeFancyConfigurator(List<GTRecipeType> recipeTypes, GTRecipeType selected, Consumer<GTRecipeType> onChange) {
        super(MultiMachineModeFancyConfigurator.calculateModeSize(recipeTypes, selected));
        this.recipeTypes = MultiMachineModeFancyConfigurator.createRecipeTypeList(recipeTypes, selected);
        this.onChange = Objects.requireNonNull(onChange, "onChange consumer cannot be null");
        this.setRecipeType(selected);
    }

    public static List<GTRecipeType> extractRecipeTypes(Set<IMultiController> machines) {
        if (machines == null || machines.isEmpty()) {
            return Collections.emptyList();
        }
        return machines.stream().filter(IRecipeLogicMachine.class::isInstance).map(IRecipeLogicMachine.class::cast).map(IRecipeLogicMachine::getRecipeTypes).flatMap(Arrays::stream).filter(Objects::nonNull).collect(Collectors.toCollection(ReferenceLinkedOpenHashSet::new)).stream().toList();
    }

    private static int calculateModeSize(List<GTRecipeType> recipeTypes, GTRecipeType selected) {
        if (recipeTypes.isEmpty()) {
            return 1;
        }
        return recipeTypes.size() + (selected == GTORecipeTypes.HATCH_COMBINED || recipeTypes.contains(selected) ? 1 : 2);
    }

    private static List<GTRecipeType> createRecipeTypeList(List<GTRecipeType> original, GTRecipeType selected) {
        if (original.isEmpty()) {
            return EMPTY_LIST;
        }
        ArrayList<GTRecipeType> result = new ArrayList<GTRecipeType>(original);
        result.add(GTORecipeTypes.HATCH_COMBINED);
        if (selected != GTORecipeTypes.HATCH_COMBINED && !result.contains(selected)) {
            result.add(selected);
        }
        return result;
    }

    private GTRecipeType getCurrentRecipeType() {
        return this.recipeTypes.get(this.currentMode);
    }

    public void setRecipeType(GTRecipeType recipe) {
        if (recipe == null) {
            throw new IllegalArgumentException("Recipe type cannot be null");
        }
        int index = this.recipeTypes.indexOf(recipe);
        if (index >= 0) {
            this.setMode(index);
        }
    }

    @Override
    public void setMode(int index) {
        if (index < 0 || index >= this.recipeTypes.size()) {
            throw new IllegalArgumentException("Mode index out of bounds: " + index);
        }
        this.currentMode = index;
        this.onChange.accept(this.getCurrentRecipeType() == GTORecipeTypes.HATCH_COMBINED ? null : this.getCurrentRecipeType());
    }

    @Override
    public int getCurrentMode() {
        return this.currentMode;
    }

    @Override
    public String getLanguageKey(int index) {
        if (index < 0 || index >= this.recipeTypes.size()) {
            return this.getLanguageKey(0);
        }
        GTRecipeType recipeType = this.recipeTypes.get(index);
        if (recipeType == null) {
            return this.getLanguageKey(0);
        }
        return recipeType.registryName.m_214298_();
    }
}

