/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.gui.helper;

import com.gtocore.api.gui.helper.ProgressBarColorStyle;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jp\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u0006H\u0007J*\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00060\u00050\u0017H\u0002J*\u0010\u0018\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00152\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00060\u00050\u0017H\u0002J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J,\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006$"}, d2={"Lcom/gtocore/api/gui/helper/ProgressBarHelper;", "", "<init>", "()V", "drawProgressBarWithText", "Lkotlin/Pair;", "", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "progress", "totalWidth", "totalHeight", "text", "", "borderWidth", "progressColorStyle", "Lcom/gtocore/api/gui/helper/ProgressBarColorStyle;", "backgroundColor", "borderColor", "textColor", "getSegmentedColor", "", "segments", "", "getMultiGradientColor", "colors", "interpolateColor", "startColor", "endColor", "factor", "renderAndAddZOrder", "", "renderFunc", "Lkotlin/Function1;", "zOrder", "Ljava/util/concurrent/atomic/AtomicInteger;", "gtocore"})
public final class ProgressBarHelper {
    @NotNull
    public static final ProgressBarHelper INSTANCE = new ProgressBarHelper();

    private ProgressBarHelper() {
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public final Pair<Integer, Integer> drawProgressBarWithText(@NotNull GuiGraphics graphics, int progress, int totalWidth, int totalHeight, @NotNull String text, int borderWidth, @NotNull ProgressBarColorStyle progressColorStyle, int backgroundColor, int borderColor, int textColor) {
        int progressWidth;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)progressColorStyle, (String)"progressColorStyle");
        int safeProgress = RangesKt.coerceIn((int)progress, (int)0, (int)100);
        float progressFloat = (float)safeProgress / 100.0f;
        int innerWidth = totalWidth - borderWidth * 2;
        int innerHeight = totalHeight - borderWidth * 2;
        AtomicInteger atomicZOrder = new AtomicInteger(0);
        if (borderWidth > 0) {
            this.renderAndAddZOrder(graphics, (Function1<? super GuiGraphics, Unit>)((Function1)arg_0 -> ProgressBarHelper.drawProgressBarWithText$lambda$0(graphics, borderWidth, innerWidth, innerHeight, borderColor, arg_0)), atomicZOrder);
        }
        if (innerWidth > 0 && innerHeight > 0) {
            this.renderAndAddZOrder(graphics, (Function1<? super GuiGraphics, Unit>)((Function1)arg_0 -> ProgressBarHelper.drawProgressBarWithText$lambda$1(graphics, borderWidth, innerWidth, innerHeight, backgroundColor, arg_0)), atomicZOrder);
        }
        if ((progressWidth = MathKt.roundToInt((float)((float)innerWidth * progressFloat))) > 0 && innerHeight > 0) {
            int n;
            ProgressBarColorStyle progressBarColorStyle = progressColorStyle;
            if (progressBarColorStyle instanceof ProgressBarColorStyle.Solid) {
                n = ((ProgressBarColorStyle.Solid)progressColorStyle).getColor();
            } else if (progressBarColorStyle instanceof ProgressBarColorStyle.Segmented) {
                n = this.getSegmentedColor(progressFloat, ((ProgressBarColorStyle.Segmented)progressColorStyle).getSegments());
            } else if (progressBarColorStyle instanceof ProgressBarColorStyle.Gradient) {
                n = this.interpolateColor(((ProgressBarColorStyle.Gradient)progressColorStyle).getStartColor(), ((ProgressBarColorStyle.Gradient)progressColorStyle).getEndColor(), progressFloat);
            } else if (progressBarColorStyle instanceof ProgressBarColorStyle.MultiGradient) {
                n = this.getMultiGradientColor(progressFloat, ((ProgressBarColorStyle.MultiGradient)progressColorStyle).getColors());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int color = n;
            this.renderAndAddZOrder(graphics, (Function1<? super GuiGraphics, Unit>)((Function1)arg_0 -> ProgressBarHelper.drawProgressBarWithText$lambda$2(graphics, borderWidth, progressWidth, innerHeight, color, arg_0)), atomicZOrder);
        }
        if (((CharSequence)text).length() > 0) {
            Font font = Minecraft.m_91087_().f_91062_;
            int textWidth = font.m_92895_(text);
            int textHeight = font.f_92710_;
            float textX = (float)(totalWidth - textWidth) / 2.0f;
            float textY = (float)(totalHeight - textHeight) / 2.0f + 1.0f;
            this.renderAndAddZOrder(graphics, (Function1<? super GuiGraphics, Unit>)((Function1)arg_0 -> ProgressBarHelper.drawProgressBarWithText$lambda$3(graphics, text, textX, textY, textColor, arg_0)), atomicZOrder);
        }
        return TuplesKt.to((Object)totalWidth, (Object)totalHeight);
    }

    public static /* synthetic */ Pair drawProgressBarWithText$default(ProgressBarHelper progressBarHelper, GuiGraphics guiGraphics, int n, int n2, int n3, String string, int n4, ProgressBarColorStyle progressBarColorStyle, int n5, int n6, int n7, int n8, Object object) {
        if ((n8 & 8) != 0) {
            n3 = 7;
        }
        if ((n8 & 0x20) != 0) {
            n4 = 1;
        }
        if ((n8 & 0x40) != 0) {
            progressBarColorStyle = ProgressBarColorStyle.Companion.getDEFAULT_GREEN();
        }
        if ((n8 & 0x80) != 0) {
            n5 = -12566464;
        }
        if ((n8 & 0x100) != 0) {
            n6 = -16777216;
        }
        if ((n8 & 0x200) != 0) {
            n7 = -1;
        }
        return progressBarHelper.drawProgressBarWithText(guiGraphics, n, n2, n3, string, n4, progressBarColorStyle, n5, n6, n7);
    }

    private final int getSegmentedColor(float progress, List<Pair<Float, Integer>> segments) {
        int n = ((Collection)segments).size() + -1;
        if (0 <= n) {
            do {
                int i;
                if (!(progress >= ((Number)segments.get(i = n--).getFirst()).floatValue())) continue;
                return ((Number)segments.get(i).getSecond()).intValue();
            } while (0 <= n);
        }
        return ((Number)((Pair)CollectionsKt.first(segments)).getSecond()).intValue();
    }

    private final int getMultiGradientColor(float progress, List<Pair<Float, Integer>> colors) {
        if (progress <= ((Number)((Pair)CollectionsKt.first(colors)).getFirst()).floatValue()) {
            return ((Number)((Pair)CollectionsKt.first(colors)).getSecond()).intValue();
        }
        if (progress >= ((Number)((Pair)CollectionsKt.last(colors)).getFirst()).floatValue()) {
            return ((Number)((Pair)CollectionsKt.last(colors)).getSecond()).intValue();
        }
        int n = colors.size() - 1;
        for (int i = 0; i < n; ++i) {
            Pair<Float, Integer> current = colors.get(i);
            Pair<Float, Integer> next = colors.get(i + 1);
            if (!(progress >= ((Number)current.getFirst()).floatValue()) || !(progress <= ((Number)next.getFirst()).floatValue())) continue;
            float t = (progress - ((Number)current.getFirst()).floatValue()) / (((Number)next.getFirst()).floatValue() - ((Number)current.getFirst()).floatValue());
            return this.interpolateColor(((Number)current.getSecond()).intValue(), ((Number)next.getSecond()).intValue(), t);
        }
        return ((Number)((Pair)CollectionsKt.last(colors)).getSecond()).intValue();
    }

    private final int interpolateColor(int startColor, int endColor, float factor) {
        float safeFactor = RangesKt.coerceIn((float)factor, (float)0.0f, (float)1.0f);
        int startA = startColor >> 24 & 0xFF;
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endA = endColor >> 24 & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        int a2 = MathKt.roundToInt((float)((float)startA + (float)(endA - startA) * safeFactor));
        int r = MathKt.roundToInt((float)((float)startR + (float)(endR - startR) * safeFactor));
        int g = MathKt.roundToInt((float)((float)startG + (float)(endG - startG) * safeFactor));
        int b2 = MathKt.roundToInt((float)((float)startB + (float)(endB - startB) * safeFactor));
        return a2 << 24 | r << 16 | g << 8 | b2;
    }

    private final void renderAndAddZOrder(GuiGraphics graphics, Function1<? super GuiGraphics, Unit> renderFunc, AtomicInteger zOrder) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(0.0, 0.0, (double)zOrder.getAndIncrement());
        renderFunc.invoke((Object)graphics);
        graphics.m_280168_().m_85849_();
    }

    private static final Unit drawProgressBarWithText$lambda$0(GuiGraphics $graphics, int $borderWidth, int $innerWidth, int $innerHeight, int $borderColor, GuiGraphics it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DrawerHelper.drawBorder((GuiGraphics)$graphics, (int)$borderWidth, (int)$borderWidth, (int)$innerWidth, (int)$innerHeight, (int)$borderColor, (int)$borderWidth);
        return Unit.INSTANCE;
    }

    private static final Unit drawProgressBarWithText$lambda$1(GuiGraphics $graphics, int $borderWidth, int $innerWidth, int $innerHeight, int $backgroundColor, GuiGraphics it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DrawerHelper.drawSolidRect((GuiGraphics)$graphics, (int)$borderWidth, (int)$borderWidth, (int)$innerWidth, (int)$innerHeight, (int)$backgroundColor);
        return Unit.INSTANCE;
    }

    private static final Unit drawProgressBarWithText$lambda$2(GuiGraphics $graphics, int $borderWidth, int $progressWidth, int $innerHeight, int $color, GuiGraphics it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DrawerHelper.drawSolidRect((GuiGraphics)$graphics, (int)$borderWidth, (int)$borderWidth, (int)$progressWidth, (int)$innerHeight, (int)$color);
        return Unit.INSTANCE;
    }

    private static final Unit drawProgressBarWithText$lambda$3(GuiGraphics $graphics, String $text, float $textX, float $textY, int $textColor, GuiGraphics it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DrawerHelper.drawText((GuiGraphics)$graphics, (String)$text, (float)$textX, (float)$textY, (float)1.0f, (int)$textColor, (boolean)false);
        return Unit.INSTANCE;
    }
}

