/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.gui.helper;

import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0006H\u0007J0\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0006H\u0007J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0003J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J6\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0003J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002JH\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u001f\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\u0006\u0010#\u001a\u00020\nH\u0002J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u0019*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J \u0010%\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006'"}, d2={"Lcom/gtocore/api/gui/helper/TextBlockHelper;", "", "<init>", "()V", "drawTextBlock", "Lkotlin/Pair;", "", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "text", "", "lineGap", "scale", "", "color", "maxWidth", "calculateTextBlockSize", "prepareTextInfo", "Lcom/gtocore/api/gui/helper/TextBlockHelper$TextInfo;", "calculateTotalHeight", "lineCount", "textHeight", "renderTextLines", "", "lines", "", "wrapText", "font", "Lnet/minecraft/client/gui/Font;", "maxLineWidth", "processWord", "", "currentLine", "word", "finalizeLinesWithLastLine", "lastLine", "splitByWidth", "findCutIndex", "TextInfo", "gtocore"})
@SourceDebugExtension(value={"SMAP\nTextBlockHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextBlockHelper.kt\ncom/gtocore/api/gui/helper/TextBlockHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1#2:137\n1878#3,3:138\n1803#3,3:141\n967#3,7:144\n*S KotlinDebug\n*F\n+ 1 TextBlockHelper.kt\ncom/gtocore/api/gui/helper/TextBlockHelper\n*L\n69#1:138,3\n89#1:141,3\n132#1:144,7\n*E\n"})
public final class TextBlockHelper {
    @NotNull
    public static final TextBlockHelper INSTANCE = new TextBlockHelper();

    private TextBlockHelper() {
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public final Pair<Integer, Integer> drawTextBlock(@NotNull GuiGraphics graphics, @NotNull String text, int lineGap, float scale, int color, int maxWidth) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)text).length() == 0) {
            return TuplesKt.to((Object)0, (Object)0);
        }
        TextInfo textInfo = this.prepareTextInfo(text, maxWidth, lineGap);
        this.renderTextLines(graphics, textInfo.getLines(), lineGap, scale, color);
        return textInfo.getSize();
    }

    public static /* synthetic */ Pair drawTextBlock$default(TextBlockHelper textBlockHelper, GuiGraphics guiGraphics, String string, int n, float f, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n = 1;
        }
        if ((n4 & 8) != 0) {
            f = 1.0f;
        }
        if ((n4 & 0x10) != 0) {
            n2 = -1;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 40;
        }
        return textBlockHelper.drawTextBlock(guiGraphics, string, n, f, n2, n3);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public final Pair<Integer, Integer> calculateTextBlockSize(@NotNull String text, int lineGap, int maxWidth) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)text).length() == 0) {
            return TuplesKt.to((Object)0, (Object)0);
        }
        return this.prepareTextInfo(text, maxWidth, lineGap).getSize();
    }

    public static /* synthetic */ Pair calculateTextBlockSize$default(TextBlockHelper textBlockHelper, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 1;
        }
        if ((n3 & 4) != 0) {
            n2 = 40;
        }
        return textBlockHelper.calculateTextBlockSize(string, n, n2);
    }

    @OnlyIn(value=Dist.CLIENT)
    private final TextInfo prepareTextInfo(String text, int maxWidth, int lineGap) {
        Comparable comparable;
        Font font = Minecraft.m_91087_().f_91062_;
        Intrinsics.checkNotNull((Object)font);
        List<String> wrappedLines = this.wrapText(text, font, maxWidth);
        int textHeight = font.f_92710_;
        Iterator iterator = ((Iterable)wrappedLines).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            String it = (String)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(font.m_92895_(it));
            while (iterator.hasNext()) {
                String it2 = (String)iterator.next();
                $i$a$-maxOfOrNull-TextBlockHelper$prepareTextInfo$actualWidth$1 = false;
                Comparable comparable3 = Integer.valueOf(font.m_92895_(it2));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        int actualWidth = n != null ? n : 0;
        int totalHeight = this.calculateTotalHeight(wrappedLines.size(), textHeight, lineGap);
        return new TextInfo(wrappedLines, (Pair<Integer, Integer>)TuplesKt.to((Object)actualWidth, (Object)totalHeight));
    }

    private final int calculateTotalHeight(int lineCount, int textHeight, int lineGap) {
        int adjustedTextHeight = textHeight - 2;
        return lineCount <= 0 ? adjustedTextHeight : lineCount * adjustedTextHeight + (lineCount - 1) * lineGap;
    }

    /*
     * WARNING - void declaration
     */
    @OnlyIn(value=Dist.CLIENT)
    private final void renderTextLines(GuiGraphics graphics, List<String> lines, int lineGap, float scale, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int adjustedTextHeight = font.f_92710_ - 2;
        Iterable $this$forEachIndexed$iv = lines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            int textY = index * (adjustedTextHeight + lineGap) - 1;
            DrawerHelper.drawText((GuiGraphics)graphics, (String)line, (float)0.0f, (float)textY, (float)scale, (int)color, (boolean)false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> wrapText(String text, Font font, int maxLineWidth) {
        void $this$fold$iv;
        if (maxLineWidth <= 0) {
            return CollectionsKt.listOf((Object)text);
        }
        Object object = new String[]{" "};
        object = StringsKt.split$default((CharSequence)text, (String[])object, (boolean)false, (int)0, (int)6, null);
        Pair<List<String>, String> initial$iv = TuplesKt.to((Object)new ArrayList(), (Object)"");
        boolean $i$f$fold = false;
        Pair<List<String>, String> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void word;
            String string = (String)element$iv;
            Pair<List<String>, String> pair = accumulator$iv;
            boolean bl = false;
            List lines = (List)pair.component1();
            String currentLine = (String)pair.component2();
            accumulator$iv = INSTANCE.processWord(lines, currentLine, (String)word, font, maxLineWidth);
        }
        Pair<List<String>, String> pair = accumulator$iv;
        boolean bl = false;
        List lines = (List)pair.component1();
        String lastLine = (String)pair.component2();
        return INSTANCE.finalizeLinesWithLastLine(lines, lastLine);
    }

    private final Pair<List<String>, String> processWord(List<String> lines, String currentLine, String word, Font font, int maxLineWidth) {
        Pair pair;
        String testLine = ((CharSequence)currentLine).length() == 0 ? word : currentLine + " " + word;
        if (font.m_92895_(testLine) <= maxLineWidth) {
            pair = TuplesKt.to(lines, (Object)testLine);
        } else if (((CharSequence)currentLine).length() > 0) {
            lines.add(currentLine);
            pair = TuplesKt.to(lines, (Object)word);
        } else {
            List<String> forceSplitLines = this.splitByWidth(word, font, maxLineWidth);
            lines.addAll((Collection<String>)forceSplitLines);
            pair = TuplesKt.to(lines, (Object)"");
        }
        return pair;
    }

    private final List<String> finalizeLinesWithLastLine(List<String> lines, String lastLine) {
        List list;
        if (((CharSequence)lastLine).length() > 0) {
            List list2;
            List $this$finalizeLinesWithLastLine_u24lambda_u244 = list2 = lines;
            boolean bl = false;
            $this$finalizeLinesWithLastLine_u24lambda_u244.add(lastLine);
            list = list2;
        } else {
            list = lines.isEmpty() ? CollectionsKt.listOf((Object)"") : lines;
        }
        return list;
    }

    private final List<String> splitByWidth(String $this$splitByWidth, Font font, int maxWidth) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)$this$splitByWidth, arg_0 -> TextBlockHelper.splitByWidth$lambda$6(font, maxWidth, arg_0)), arg_0 -> TextBlockHelper.splitByWidth$lambda$7(font, maxWidth, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final int findCutIndex(String text, Font font, int maxWidth) {
        void $this$takeWhile$iv;
        Iterable iterable = (Iterable)new IntRange(1, text.length());
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            int it = ((Number)item$iv).intValue();
            boolean bl = false;
            if (!(font.m_92895_(StringsKt.take((String)text, (int)it)) <= maxWidth)) break;
            list$iv.add(item$iv);
        }
        Integer n = (Integer)CollectionsKt.lastOrNull((List)list$iv);
        return n != null ? n : 1;
    }

    private static final String splitByWidth$lambda$6(Font $font, int $maxWidth, String remaining) {
        String string;
        Intrinsics.checkNotNullParameter((Object)remaining, (String)"remaining");
        if (((CharSequence)remaining).length() == 0) {
            string = null;
        } else {
            String string2;
            int cutIndex = INSTANCE.findCutIndex(remaining, $font, $maxWidth);
            String it = string2 = StringsKt.drop((String)remaining, (int)cutIndex);
            boolean bl = false;
            string = ((CharSequence)it).length() > 0 ? string2 : null;
        }
        return string;
    }

    private static final String splitByWidth$lambda$7(Font $font, int $maxWidth, String remaining) {
        Intrinsics.checkNotNullParameter((Object)remaining, (String)"remaining");
        int cutIndex = INSTANCE.findCutIndex(remaining, $font, $maxWidth);
        return StringsKt.take((String)remaining, (int)cutIndex);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/gtocore/api/gui/helper/TextBlockHelper$TextInfo;", "", "lines", "", "", "size", "Lkotlin/Pair;", "", "<init>", "(Ljava/util/List;Lkotlin/Pair;)V", "getLines", "()Ljava/util/List;", "getSize", "()Lkotlin/Pair;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "gtocore"})
    private static final class TextInfo {
        @NotNull
        private final List<String> lines;
        @NotNull
        private final Pair<Integer, Integer> size;

        public TextInfo(@NotNull List<String> lines, @NotNull Pair<Integer, Integer> size) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(size, (String)"size");
            this.lines = lines;
            this.size = size;
        }

        @NotNull
        public final List<String> getLines() {
            return this.lines;
        }

        @NotNull
        public final Pair<Integer, Integer> getSize() {
            return this.size;
        }

        @NotNull
        public final List<String> component1() {
            return this.lines;
        }

        @NotNull
        public final Pair<Integer, Integer> component2() {
            return this.size;
        }

        @NotNull
        public final TextInfo copy(@NotNull List<String> lines, @NotNull Pair<Integer, Integer> size) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(size, (String)"size");
            return new TextInfo(lines, size);
        }

        public static /* synthetic */ TextInfo copy$default(TextInfo textInfo, List list, Pair pair, int n, Object object) {
            if ((n & 1) != 0) {
                list = textInfo.lines;
            }
            if ((n & 2) != 0) {
                pair = textInfo.size;
            }
            return textInfo.copy(list, pair);
        }

        @NotNull
        public String toString() {
            return "TextInfo(lines=" + this.lines + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result = ((Object)this.lines).hashCode();
            result = result * 31 + this.size.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextInfo)) {
                return false;
            }
            TextInfo textInfo = (TextInfo)other;
            if (!Intrinsics.areEqual(this.lines, textInfo.lines)) {
                return false;
            }
            return Intrinsics.areEqual(this.size, textInfo.size);
        }
    }
}

