/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.machine.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.gregtechceu.gtceu.utils.memoization.MemoizedSupplier;
import com.gtocore.client.forge.ForgeClientEvent;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.machines.SpaceMultiblock;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.AbstractSpaceStation;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.Core;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.ISpacePredicateMachine;
import com.gtolib.api.capability.IIWirelessInteractor;
import com.gtolib.api.machine.feature.IEnhancedRecipeLogicMachine;
import com.gtolib.api.machine.feature.multiblock.ICustomHighlightMachine;
import com.gtolib.api.recipe.Recipe;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import earth.terrarium.adastra.api.planets.PlanetApi;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ILargeSpaceStationMachine
extends ICustomHighlightMachine,
ISpacePredicateMachine {
    public static final TraceabilityPredicate checkIsModule = Predicates.custom(state -> ConnectType.check(state, ConnectType.MODULE), () -> BlockInfo.fromBlock((Block)SpaceMultiblock.SPACE_STATION_EXTENSION_MODULE.get()), null);
    public static final TraceabilityPredicate checkIsConjunction = Predicates.custom(state -> ConnectType.check(state, ConnectType.CONJUNCTION), () -> BlockInfo.fromBlock((Block)SpaceMultiblock.SPACE_STATION_DOCKING_MODULE.get()), null);
    public static final Int2ObjectOpenHashMap<Function<AbstractSpaceStation, Set<BlockPos>>> positionFunctionMap = new Int2ObjectOpenHashMap();

    public MultiblockControllerMachine self();

    default public Set<CleanroomType> getTypes() {
        if (this.getRoot() != null) {
            return this.getRoot().getTypes();
        }
        return Collections.emptySet();
    }

    default public void markDirty(boolean dirty) {
        if (this.getRoot() != null) {
            this.getRoot().markDirty(dirty);
        } else {
            IIWirelessInteractor.getMachineNet((Level)this.getLevel(), Core.class).forEach(core -> core.markDirty(dirty));
        }
    }

    @Nullable
    public Core getRoot();

    public void setRoot(@Nullable Core var1);

    default public void tickNonCoreModule() {
        int time = this.getOffsetTimer();
        if (time % 80 == 0) {
            AbstractSpaceStation self = (AbstractSpaceStation)this.self();
            if (this.firstLoad() || time % 800 == 0) {
                if (this.getRoot() != null && this.getRoot().getReadyCount() > 0) {
                    this.provideOxygen();
                } else {
                    self.clearOxygenBlocks();
                }
            }
            self.updateSpaceMachines();
        }
    }

    default public Set<BlockPos> getModulePositions() {
        AbstractSpaceStation self = (AbstractSpaceStation)this.self();
        if (self.getPositionFunction() != null) {
            return self.getPositionFunction().apply(self);
        }
        return Collections.emptySet();
    }

    public ConnectType getConnectType();

    public long getEUt();

    default public Set<ILargeSpaceStationMachine> getConnectedModules() {
        if (this.getLevel() == null) {
            return Collections.emptySet();
        }
        ReferenceOpenHashSet machines = new ReferenceOpenHashSet();
        for (BlockPos pos : this.getModulePositions()) {
            ILargeSpaceStationMachine largeSpaceStationMachine;
            MetaMachineBlockEntity metaMachineBlockEntity;
            MetaMachine machine;
            BlockEntity blockEntity = this.getLevel().m_7702_(pos);
            if (!(blockEntity instanceof MetaMachineBlockEntity) || !((machine = (metaMachineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof ILargeSpaceStationMachine) || !(largeSpaceStationMachine = (ILargeSpaceStationMachine)machine).isFormed()) continue;
            machines.add(largeSpaceStationMachine);
        }
        return machines;
    }

    default public List<ForgeClientEvent.HighlightNeed> getCustomHighlights() {
        int color = this.getConnectType().color;
        List<ForgeClientEvent.HighlightNeed> l = this.getModulePositions().stream().map(pos -> new ForgeClientEvent.HighlightNeed((BlockPos)pos, (BlockPos)pos, color)).toList();
        if (this.getRoot() != null) {
            l = new ArrayList<ForgeClientEvent.HighlightNeed>(l);
            l.add(new ForgeClientEvent.HighlightNeed(this.getRoot().self().getPos(), this.getRoot().self().getPos(), 0xFFFFFF));
        }
        return l;
    }

    default public Recipe getRecipe() {
        if (!PlanetApi.API.isSpace(this.getLevel())) {
            return null;
        }
        if (this.getRoot() == null || !this.getRoot().isWorkspaceReady()) {
            return null;
        }
        return ((IEnhancedRecipeLogicMachine)this.self()).getRecipeBuilder().duration(200).buildRawRecipe();
    }

    default public void customText(@NotNull List<Component> list) {
        list.add((Component)Component.m_237110_((String)"gui.ae2.PowerUsageRate", (Object[])new Object[]{"%s EU/t".formatted(FormattingUtil.formatNumbers((long)this.getEUt()))}).m_130940_(ChatFormatting.YELLOW));
        if (this.getRoot() != null) {
            list.add((Component)Component.m_237110_((String)"gui.ae2.AttachedTo", (Object[])new Object[]{"[" + this.getRoot().getPos().m_123344_() + "]"}));
            this.getRoot().customText(list);
        } else {
            list.add((Component)Component.m_237115_((String)"theoneprobe.ae2.p2p_unlinked"));
        }
    }

    public static Function<AbstractSpaceStation, Set<BlockPos>> twoWayPositionFunction(int distance) {
        return (Function)positionFunctionMap.computeIfAbsent(distance, i -> machine -> {
            BlockPos pos = machine.getPos();
            Direction fFacing = machine.getFrontFacing();
            Direction uFacing = machine.getUpwardsFacing();
            boolean isFlipped = machine.isFlipped();
            BlockPos hallwayCenter = pos.m_5484_(fFacing, 2).m_5484_(RelativeDirection.LEFT.getRelative(fFacing, uFacing, isFlipped), distance);
            return Set.of(hallwayCenter.m_5484_(fFacing, 2), hallwayCenter.m_5484_(fFacing.m_122424_(), 2), hallwayCenter.m_5484_(RelativeDirection.UP.getRelative(fFacing, uFacing, isFlipped), 2), hallwayCenter.m_5484_(RelativeDirection.DOWN.getRelative(fFacing, uFacing, isFlipped), 2));
        });
    }

    public static enum ConnectType {
        CONJUNCTION(0xFFFF00, () -> Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.TITANIUM_ALLOY_INTERNAL_FRAME.get()}).or(checkIsConjunction).or(checkIsModule)),
        MODULE(65535, () -> Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.TITANIUM_ALLOY_INTERNAL_FRAME.get()}).or(checkIsConjunction)),
        CORE(0xFF0000, () -> Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.TITANIUM_ALLOY_INTERNAL_FRAME.get()}).or(checkIsConjunction));

        public final int color;
        public final MemoizedSupplier<TraceabilityPredicate> traceabilityPredicate;

        private ConnectType(int color, Supplier<TraceabilityPredicate> predicateSupplier) {
            this.color = color;
            this.traceabilityPredicate = GTMemoizer.memoize(predicateSupplier);
        }

        static boolean check(MultiblockState state, ConnectType type) {
            MetaMachineBlockEntity m;
            BlockEntity blockEntity = state.getTileEntity();
            if (blockEntity instanceof MetaMachineBlockEntity && (blockEntity = (m = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof ILargeSpaceStationMachine) {
                ILargeSpaceStationMachine machine = (ILargeSpaceStationMachine)blockEntity;
                return machine.getConnectType() == type;
            }
            return false;
        }
    }
}

