/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.misc;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import com.gtocore.api.misc.NetworkStats;
import com.gtocore.integration.ae.wireless.WirelessMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u0000 02\u00020\u0001:\u000201B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\nJ\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0011H\u0002J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\nH\u0002J\u0016\u0010 \u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\nH\u0002J,\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\"\u001a\u00020\f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010$\u001a\u00020\u000fH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\fH\u0002J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\fH\u0002J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/gtocore/api/misc/WirelessNetworkTopologyManager;", "", "<init>", "()V", "clusters", "", "Lcom/gtocore/api/misc/WirelessNetworkTopologyManager$NodeCluster;", "hubConnections", "Lappeng/api/networking/IGridConnection;", "addNode", "", "node", "Lcom/gtocore/integration/ae/wireless/WirelessMachine;", "removeNode", "getTotalUsedChannels", "", "cleanupNodeConnections", "", "cluster", "createIntraClusterConnections", "createInterClusterConnections", "rebuildTopology", "nodes", "cleanupHubConnections", "isConnectionInvolving", "", "connection", "rebuildHubConnections", "getNetworkStats", "Lcom/gtocore/api/misc/NetworkStats;", "destroyAllConnections", "buildClusters", "selectOptimalHub", "findNearbyNodes", "hub", "candidates", "maxCount", "findBestClusterForNode", "rebalanceAndAddNode", "handleHubRemoval", "createConnection", "node1", "node2", "isNodeValid", "calculateDistance", "", "calculateMaxPossibleConnections", "nodeCount", "Companion", "NodeCluster", "gtocore"})
@SourceDebugExtension(value={"SMAP\nWirelessNetworkTopologyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WirelessNetworkTopologyManager.kt\ncom/gtocore/api/misc/WirelessNetworkTopologyManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,325:1\n1#2:326\n1869#3:327\n1869#3,2:328\n1870#3:330\n774#3:331\n865#3,2:332\n1869#3,2:334\n1563#3:336\n1634#3,3:337\n1869#3:340\n1869#3,2:341\n1870#3:343\n1869#3,2:344\n1869#3,2:346\n1563#3:348\n1634#3,3:349\n1563#3:352\n1634#3,3:353\n2423#3,14:356\n1563#3:370\n1634#3,3:371\n1056#3:374\n1563#3:375\n1634#3,3:376\n774#3:379\n865#3,2:380\n2423#3,14:382\n1869#3,2:396\n1869#3,2:398\n1869#3,2:400\n1869#3,2:402\n*S KotlinDebug\n*F\n+ 1 WirelessNetworkTopologyManager.kt\ncom/gtocore/api/misc/WirelessNetworkTopologyManager\n*L\n92#1:327\n93#1:328,2\n92#1:330\n130#1:331\n130#1:332,2\n169#1:334,2\n184#1:336\n184#1:337,3\n202#1:340\n203#1:341,2\n202#1:343\n206#1:344,2\n222#1:346,2\n235#1:348\n235#1:349,3\n236#1:352\n236#1:353,3\n239#1:356,14\n249#1:370\n249#1:371,3\n256#1:374\n258#1:375\n258#1:376,3\n265#1:379\n265#1:380,2\n266#1:382,14\n276#1:396,2\n283#1:398,2\n286#1:400,2\n290#1:402,2\n*E\n"})
public final class WirelessNetworkTopologyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<NodeCluster> clusters = new ArrayList();
    @NotNull
    private final List<IGridConnection> hubConnections = new ArrayList();
    private static final int MAX_NODES_PER_HUB = 15;

    @NotNull
    public final List<IGridConnection> addNode(@NotNull WirelessMachine node) {
        Object object;
        block5: {
            block3: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (!this.isNodeValid(node)) {
                        return CollectionsKt.emptyList();
                    }
                    NodeCluster targetCluster = this.findBestClusterForNode(node);
                    if (targetCluster == null || !targetCluster.addLeafNode(node)) break block3;
                    object = this.createConnection(targetCluster.getHubNode(), node);
                    if (object == null) break block4;
                    IGridConnection conn = object;
                    boolean bl = false;
                    targetCluster.getConnections().add(conn);
                    List list = CollectionsKt.listOf((Object)conn);
                    object = list;
                    if (list != null) break block5;
                }
                object = CollectionsKt.emptyList();
                break block5;
            }
            object = this.rebalanceAndAddNode(node);
        }
        return object;
    }

    @NotNull
    public final List<IGridConnection> removeNode(@NotNull WirelessMachine node) {
        List affectedConnections;
        block4: {
            NodeCluster cluster;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                affectedConnections = new ArrayList();
                Iterable iterable = this.clusters;
                for (Object t : iterable) {
                    NodeCluster it = (NodeCluster)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getHubNode(), (Object)node) || it.getLeafNodes().contains(node))) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            NodeCluster nodeCluster = cluster = (NodeCluster)v0;
            if (nodeCluster == null) break block4;
            NodeCluster it = nodeCluster;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getHubNode(), (Object)node)) {
                affectedConnections.addAll((Collection)this.handleHubRemoval(it));
                this.rebuildHubConnections();
            } else {
                it.removeLeafNode(node);
                this.cleanupNodeConnections(node, it);
                this.cleanupHubConnections(node);
            }
        }
        return affectedConnections;
    }

    public final int getTotalUsedChannels() {
        if (this.clusters.isEmpty()) {
            return 0;
        }
        IGridNode iGridNode = ((NodeCluster)CollectionsKt.first(this.clusters)).getHubNode().getGridNode();
        return iGridNode != null ? iGridNode.getUsedChannels() : 0;
    }

    private final void cleanupNodeConnections(WirelessMachine node, NodeCluster cluster) {
        cluster.getConnections().removeIf(arg_0 -> WirelessNetworkTopologyManager.cleanupNodeConnections$lambda$4(arg_0 -> WirelessNetworkTopologyManager.cleanupNodeConnections$lambda$3(this, node, arg_0), arg_0));
    }

    private final List<IGridConnection> createIntraClusterConnections() {
        List connections = new ArrayList();
        Iterable $this$forEach$iv = this.clusters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeCluster cluster = (NodeCluster)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = cluster.getLeafNodes();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IGridConnection conn;
                WirelessMachine leafNode = (WirelessMachine)element$iv2;
                boolean bl2 = false;
                if (this.createConnection(cluster.getHubNode(), leafNode) == null) continue;
                boolean bl3 = false;
                connections.add(conn);
                cluster.getConnections().add(conn);
            }
        }
        return connections;
    }

    private final List<IGridConnection> createInterClusterConnections() {
        List connections = new ArrayList();
        if (this.clusters.size() <= 1) {
            return connections;
        }
        int n = ((Collection)this.clusters).size();
        for (int i = 0; i < n; ++i) {
            IGridConnection conn;
            WirelessMachine nextHub;
            WirelessMachine currentHub = this.clusters.get(i).getHubNode();
            if (this.createConnection(currentHub, nextHub = this.clusters.get((i + 1) % this.clusters.size()).getHubNode()) == null) continue;
            boolean bl = false;
            connections.add(conn);
            this.hubConnections.add(conn);
        }
        return connections;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IGridConnection> rebuildTopology(@NotNull List<? extends WirelessMachine> nodes) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.destroyAllConnections();
        if (nodes.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (nodes.size() == 1) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = nodes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WirelessMachine it = (WirelessMachine)element$iv$iv;
            boolean bl = false;
            if (!this.isNodeValid(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validNodes = (List)destination$iv$iv;
        if (validNodes.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        this.buildClusters(validNodes);
        List allConnections = new ArrayList();
        allConnections.addAll((Collection)this.createIntraClusterConnections());
        allConnections.addAll((Collection)this.createInterClusterConnections());
        return allConnections;
    }

    private final void cleanupHubConnections(WirelessMachine node) {
        this.hubConnections.removeIf(arg_0 -> WirelessNetworkTopologyManager.cleanupHubConnections$lambda$11(arg_0 -> WirelessNetworkTopologyManager.cleanupHubConnections$lambda$10(this, node, arg_0), arg_0));
    }

    private final boolean isConnectionInvolving(IGridConnection connection, WirelessMachine node) {
        boolean bl;
        try {
            IGridNode nodeA = connection.a();
            IGridNode nodeB = connection.b();
            IGridNode targetNode = node.getMainNode().getNode();
            bl = Intrinsics.areEqual((Object)nodeA, (Object)targetNode) || Intrinsics.areEqual((Object)nodeB, (Object)targetNode);
        }
        catch (Exception e) {
            bl = true;
        }
        return bl;
    }

    private final void rebuildHubConnections() {
        Iterable $this$forEach$iv = this.hubConnections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IGridConnection it = (IGridConnection)element$iv;
            boolean bl = false;
            try {
                it.destroy();
            }
            catch (Exception exception) {
            }
        }
        this.hubConnections.clear();
        this.hubConnections.addAll((Collection<IGridConnection>)this.createInterClusterConnections());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NetworkStats getNetworkStats() {
        double d;
        int n;
        int n2;
        Iterable iterable = this.clusters;
        int n3 = 0;
        for (Object object : iterable) {
            Object it;
            NodeCluster nodeCluster = (NodeCluster)object;
            n2 = n3;
            boolean bl = false;
            n = ((NodeCluster)it).getLeafNodes().size() + 1;
            n3 = n2 + n;
        }
        int totalNodes = n3;
        Iterable iterable2 = this.clusters;
        int n4 = 0;
        for (Object it : iterable2) {
            void it2;
            NodeCluster bl = (NodeCluster)it;
            n2 = n4;
            boolean bl2 = false;
            n = it2.getConnections().size();
            n4 = n2 + n;
        }
        int totalConnections = n4 + this.hubConnections.size();
        if (!((Collection)this.clusters).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.clusters;
            boolean $i$f$map = false;
            Iterable it2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NodeCluster nodeCluster = (NodeCluster)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getLoadFactor());
            }
            d = CollectionsKt.averageOfDouble((Iterable)((List)destination$iv$iv));
        } else {
            d = 0.0;
        }
        double avgLoadFactor = d;
        return new NetworkStats(totalNodes, this.clusters.size(), totalConnections, avgLoadFactor, this.calculateMaxPossibleConnections(totalNodes));
    }

    private final void destroyAllConnections() {
        Iterable $this$forEach$iv = this.clusters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeCluster cluster = (NodeCluster)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = cluster.getConnections();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IGridConnection it = (IGridConnection)element$iv2;
                boolean bl2 = false;
                it.destroy();
            }
            cluster.getConnections().clear();
        }
        $this$forEach$iv = this.hubConnections;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IGridConnection it = (IGridConnection)element$iv;
            boolean bl = false;
            it.destroy();
        }
        this.hubConnections.clear();
        this.clusters.clear();
    }

    private final void buildClusters(List<? extends WirelessMachine> nodes) {
        List remainingNodes = CollectionsKt.toMutableList((Collection)nodes);
        while (!((Collection)remainingNodes).isEmpty()) {
            WirelessMachine hub = this.selectOptimalHub(remainingNodes);
            remainingNodes.remove(hub);
            NodeCluster cluster = new NodeCluster(hub, null, null, 6, null);
            List<WirelessMachine> nearbyNodes = this.findNearbyNodes(hub, remainingNodes, 15);
            Iterable $this$forEach$iv = nearbyNodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WirelessMachine node = (WirelessMachine)element$iv;
                boolean bl = false;
                cluster.addLeafNode(node);
                remainingNodes.remove(node);
            }
            this.clusters.add(cluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final WirelessMachine selectOptimalHub(List<? extends WirelessMachine> nodes) {
        WirelessMachine wirelessMachine;
        Object v0;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        Iterable $this$map$iv = nodes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            WirelessMachine wirelessMachine2 = (WirelessMachine)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.self().getPos().m_123341_());
        }
        double centerX = CollectionsKt.averageOfInt((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = nodes;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WirelessMachine wirelessMachine3 = (WirelessMachine)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.self().getPos().m_123343_());
        }
        double centerZ = CollectionsKt.averageOfInt((Iterable)((List)destination$iv$iv2));
        Iterable $this$minByOrNull$iv = nodes;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                WirelessMachine node = (WirelessMachine)minElem$iv;
                boolean bl = false;
                BlockPos pos = node.self().getPos();
                double minValue$iv = Math.sqrt(Math.pow((double)pos.m_123341_() - centerX, 2) + Math.pow((double)pos.m_123343_() - centerZ, 2));
                do {
                    Object e$iv = iterator$iv.next();
                    node = (WirelessMachine)e$iv;
                    bl = false;
                    pos = node.self().getPos();
                    double v$iv = Math.sqrt(Math.pow((double)pos.m_123341_() - centerX, 2) + Math.pow((double)pos.m_123343_() - centerZ, 2));
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        if ((wirelessMachine = (WirelessMachine)v0) == null) {
            wirelessMachine = nodes.get(0);
        }
        return wirelessMachine;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WirelessMachine> findNearbyNodes(WirelessMachine hub, List<? extends WirelessMachine> candidates, int maxCount) {
        Iterable $this$sortedBy$iv;
        Pair node;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        BlockPos hubPos = hub.self().getPos();
        Iterable iterable = candidates;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            WirelessMachine wirelessMachine = (WirelessMachine)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            double distance = Math.sqrt(Math.pow(node.self().getPos().m_123341_() - hubPos.m_123341_(), 2) + Math.pow(node.self().getPos().m_123343_() - hubPos.m_123343_(), 2));
            collection.add(TuplesKt.to((Object)node, (Object)distance));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Pair it = (Pair)a2;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
            }
        }), (int)maxCount);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            node = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((WirelessMachine)it.getFirst());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final NodeCluster findBestClusterForNode(WirelessMachine node) {
        Object v0;
        void $this$filterTo$iv$iv;
        if (this.clusters.isEmpty()) {
            return null;
        }
        Iterable $this$filter$iv = this.clusters;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodeCluster it = (NodeCluster)element$iv$iv;
            boolean bl = false;
            if (!(it.getLeafNodes().size() < 15)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                NodeCluster cluster = (NodeCluster)minElem$iv;
                boolean bl = false;
                double distance = this.calculateDistance(node, cluster.getHubNode());
                double loadPenalty = cluster.getLoadFactor() * (double)1000;
                double minValue$iv = distance + loadPenalty;
                do {
                    double loadPenalty2;
                    Object e$iv = iterator$iv.next();
                    NodeCluster cluster2 = (NodeCluster)e$iv;
                    $i$a$-minByOrNull-WirelessNetworkTopologyManager$findBestClusterForNode$2 = false;
                    double distance2 = this.calculateDistance(node, cluster2.getHubNode());
                    double v$iv = distance2 + (loadPenalty2 = cluster2.getLoadFactor() * (double)1000);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private final List<IGridConnection> rebalanceAndAddNode(WirelessMachine node) {
        NodeCluster newCluster = new NodeCluster(node, null, null, 6, null);
        this.clusters.add(newCluster);
        Iterable $this$forEach$iv = this.hubConnections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IGridConnection it = (IGridConnection)element$iv;
            boolean bl = false;
            it.destroy();
        }
        this.hubConnections.clear();
        return this.createInterClusterConnections();
    }

    private final List<IGridConnection> handleHubRemoval(NodeCluster cluster) {
        this.clusters.remove(cluster);
        Iterable $this$forEach$iv = cluster.getConnections();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IGridConnection it = (IGridConnection)element$iv;
            boolean bl = false;
            it.destroy();
        }
        List orphanedNodes = CollectionsKt.toList((Iterable)cluster.getLeafNodes());
        List newConnections = new ArrayList();
        Iterable $this$forEach$iv2 = orphanedNodes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            WirelessMachine node = (WirelessMachine)element$iv;
            boolean bl = false;
            newConnections.addAll((Collection)this.addNode(node));
        }
        $this$forEach$iv2 = this.hubConnections;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IGridConnection it = (IGridConnection)element$iv;
            boolean bl = false;
            it.destroy();
        }
        this.hubConnections.clear();
        newConnections.addAll((Collection)this.createInterClusterConnections());
        return newConnections;
    }

    private final IGridConnection createConnection(WirelessMachine node1, WirelessMachine node2) {
        IGridConnection iGridConnection;
        try {
            if (!this.isNodeValid(node1) || !this.isNodeValid(node2)) {
                return null;
            }
            iGridConnection = GridHelper.createConnection((IGridNode)node1.getMainNode().getNode(), (IGridNode)node2.getMainNode().getNode());
        }
        catch (Exception e) {
            iGridConnection = null;
        }
        return iGridConnection;
    }

    private final boolean isNodeValid(WirelessMachine node) {
        boolean bl;
        try {
            IGridNode iGridNode = node.getMainNode().getNode();
            bl = iGridNode != null && (iGridNode = iGridNode.getLevel()) != null ? iGridNode.m_46805_(node.self().getPos()) : false;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final double calculateDistance(WirelessMachine node1, WirelessMachine node2) {
        BlockPos pos1 = node1.self().getPos();
        BlockPos pos2 = node2.self().getPos();
        return Math.sqrt(Math.pow(pos1.m_123341_() - pos2.m_123341_(), 2) + Math.pow(pos1.m_123343_() - pos2.m_123343_(), 2));
    }

    private final int calculateMaxPossibleConnections(int nodeCount) {
        return nodeCount <= 1 ? 0 : nodeCount * (nodeCount - 1) / 2;
    }

    private static final boolean cleanupNodeConnections$lambda$3(WirelessNetworkTopologyManager this$0, WirelessMachine $node, IGridConnection conn) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        try {
            boolean bl2;
            if (this$0.isConnectionInvolving(conn, $node)) {
                conn.destroy();
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            bl = true;
        }
        return bl;
    }

    private static final boolean cleanupNodeConnections$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanupHubConnections$lambda$10(WirelessNetworkTopologyManager this$0, WirelessMachine $node, IGridConnection conn) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        try {
            boolean bl2;
            if (this$0.isConnectionInvolving(conn, $node)) {
                conn.destroy();
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            bl = true;
        }
        return bl;
    }

    private static final boolean cleanupHubConnections$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/gtocore/api/misc/WirelessNetworkTopologyManager$Companion;", "", "<init>", "()V", "MAX_NODES_PER_HUB", "", "gtocore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J3\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006 "}, d2={"Lcom/gtocore/api/misc/WirelessNetworkTopologyManager$NodeCluster;", "", "hubNode", "Lcom/gtocore/integration/ae/wireless/WirelessMachine;", "leafNodes", "", "connections", "Lappeng/api/networking/IGridConnection;", "<init>", "(Lcom/gtocore/integration/ae/wireless/WirelessMachine;Ljava/util/Set;Ljava/util/Set;)V", "getHubNode", "()Lcom/gtocore/integration/ae/wireless/WirelessMachine;", "getLeafNodes", "()Ljava/util/Set;", "getConnections", "addLeafNode", "", "node", "removeLeafNode", "", "getLoadFactor", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "gtocore"})
    public static final class NodeCluster {
        @NotNull
        private final WirelessMachine hubNode;
        @NotNull
        private final Set<WirelessMachine> leafNodes;
        @NotNull
        private final Set<IGridConnection> connections;

        public NodeCluster(@NotNull WirelessMachine hubNode, @NotNull Set<WirelessMachine> leafNodes, @NotNull Set<IGridConnection> connections) {
            Intrinsics.checkNotNullParameter((Object)hubNode, (String)"hubNode");
            Intrinsics.checkNotNullParameter(leafNodes, (String)"leafNodes");
            Intrinsics.checkNotNullParameter(connections, (String)"connections");
            this.hubNode = hubNode;
            this.leafNodes = leafNodes;
            this.connections = connections;
        }

        public /* synthetic */ NodeCluster(WirelessMachine wirelessMachine, Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                set = new LinkedHashSet();
            }
            if ((n & 4) != 0) {
                set2 = new LinkedHashSet();
            }
            this(wirelessMachine, set, set2);
        }

        @NotNull
        public final WirelessMachine getHubNode() {
            return this.hubNode;
        }

        @NotNull
        public final Set<WirelessMachine> getLeafNodes() {
            return this.leafNodes;
        }

        @NotNull
        public final Set<IGridConnection> getConnections() {
            return this.connections;
        }

        public final boolean addLeafNode(@NotNull WirelessMachine node) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.leafNodes.size() < 15) {
                this.leafNodes.add(node);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public final void removeLeafNode(@NotNull WirelessMachine node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.leafNodes.remove(node);
        }

        public final double getLoadFactor() {
            return (double)this.leafNodes.size() / (double)15;
        }

        @NotNull
        public final WirelessMachine component1() {
            return this.hubNode;
        }

        @NotNull
        public final Set<WirelessMachine> component2() {
            return this.leafNodes;
        }

        @NotNull
        public final Set<IGridConnection> component3() {
            return this.connections;
        }

        @NotNull
        public final NodeCluster copy(@NotNull WirelessMachine hubNode, @NotNull Set<WirelessMachine> leafNodes, @NotNull Set<IGridConnection> connections) {
            Intrinsics.checkNotNullParameter((Object)hubNode, (String)"hubNode");
            Intrinsics.checkNotNullParameter(leafNodes, (String)"leafNodes");
            Intrinsics.checkNotNullParameter(connections, (String)"connections");
            return new NodeCluster(hubNode, leafNodes, connections);
        }

        public static /* synthetic */ NodeCluster copy$default(NodeCluster nodeCluster, WirelessMachine wirelessMachine, Set set, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                wirelessMachine = nodeCluster.hubNode;
            }
            if ((n & 2) != 0) {
                set = nodeCluster.leafNodes;
            }
            if ((n & 4) != 0) {
                set2 = nodeCluster.connections;
            }
            return nodeCluster.copy(wirelessMachine, set, set2);
        }

        @NotNull
        public String toString() {
            return "NodeCluster(hubNode=" + this.hubNode + ", leafNodes=" + this.leafNodes + ", connections=" + this.connections + ")";
        }

        public int hashCode() {
            int result = this.hubNode.hashCode();
            result = result * 31 + ((Object)this.leafNodes).hashCode();
            result = result * 31 + ((Object)this.connections).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NodeCluster)) {
                return false;
            }
            NodeCluster nodeCluster = (NodeCluster)other;
            if (!Intrinsics.areEqual((Object)this.hubNode, (Object)nodeCluster.hubNode)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.leafNodes, nodeCluster.leafNodes)) {
                return false;
            }
            return Intrinsics.areEqual(this.connections, nodeCluster.connections);
        }
    }
}

