/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.pattern;

import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.api.pattern.error.PatternStringError;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.machine.multiblock.part.RotorHolderPartMachine;
import com.gtocore.api.machine.part.GTOPartAbility;
import com.gtocore.common.block.BlockMap;
import com.gtocore.common.block.MEStorageCoreBlock;
import com.gtocore.common.block.WirelessEnergyUnitBlock;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.machines.ManaMachine;
import com.gtolib.utils.FunctionContainer;
import com.gtolib.utils.GTOUtils;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;

public final class GTOPredicates {
    public static TraceabilityPredicate module(MachineDefinition ... definition) {
        return Predicates.blocks((Block[])new Block[]{Blocks.f_50375_}).or(Predicates.air().setPreviewCount(0)).or(Predicates.blocks((MetaMachineBlock[])((MetaMachineBlock[])Arrays.stream(definition).map(MachineDefinition::get).toArray(MetaMachineBlock[]::new))).setPreviewCount(0));
    }

    public static TraceabilityPredicate glass() {
        return GTOPredicates.tierBlock(BlockMap.GLASSMAP, "g_b");
    }

    public static TraceabilityPredicate machineCasing() {
        return GTOPredicates.tierBlock(BlockMap.MACHINECASINGMAP, "m_c");
    }

    public static TraceabilityPredicate integralFramework() {
        return GTOPredicates.tierBlock(BlockMap.INTEGRALFRAMEWORKMAP, "i_f");
    }

    public static TraceabilityPredicate absBlocks() {
        return Predicates.blocks((Block[])BlockMap.ABS_CASING);
    }

    public static TraceabilityPredicate light() {
        return Predicates.blocks((Block[])BlockMap.LIGHT);
    }

    public static TraceabilityPredicate hermeticCasing() {
        return GTOPredicates.tierBlock(BlockMap.HERMETIC_CASING, "hermetic_casing");
    }

    public static TraceabilityPredicate autoIOAbilities(GTRecipeType ... recipeType) {
        return Predicates.autoAbilities((GTRecipeType[])recipeType, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static TraceabilityPredicate autoLaserAbilities(GTRecipeType ... recipeType) {
        TraceabilityPredicate predicate = Predicates.autoAbilities((GTRecipeType[])recipeType, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        for (GTRecipeType type : recipeType) {
            if (type.getMaxInputs((RecipeCapability)EURecipeCapability.CAP) > 0) {
                predicate = predicate.or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_ENERGY}).setMaxGlobalLimited(2).setPreviewCount(0)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_LASER}).setMaxGlobalLimited(2).setPreviewCount(1));
                break;
            }
            if (type.getMaxOutputs((RecipeCapability)EURecipeCapability.CAP) <= 0) continue;
            predicate = predicate.or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_ENERGY}).setMaxGlobalLimited(2).setPreviewCount(0)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.OUTPUT_LASER}).setMaxGlobalLimited(2).setPreviewCount(1));
            break;
        }
        return predicate;
    }

    public static TraceabilityPredicate autoGCYMAbilities(GTRecipeType ... recipeType) {
        return Predicates.autoAbilities((GTRecipeType[])recipeType, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(8).setPreviewCount(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.ACCELERATE_HATCH}).setMaxGlobalLimited(1)).or(Predicates.blocks((MetaMachineBlock[])new MetaMachineBlock[]{ManaMachine.MANA_AMPLIFIER_HATCH.get(), ManaMachine.ME_MANA_AMPLIFIER_HATCH.get()}).setMaxGlobalLimited(1));
    }

    public static TraceabilityPredicate autoAccelerateAbilities(GTRecipeType ... recipeType) {
        return Predicates.autoAbilities((GTRecipeType[])recipeType).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.ACCELERATE_HATCH}).setMaxGlobalLimited(1));
    }

    public static TraceabilityPredicate autoThreadLaserAbilities(GTRecipeType ... recipeType) {
        return GTOPredicates.autoLaserAbilities(recipeType).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.THREAD_HATCH}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.OVERCLOCK_HATCH}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.ACCELERATE_HATCH}).setMaxGlobalLimited(1));
    }

    public static TraceabilityPredicate autoSpaceMachineAbilities(GTRecipeType ... recipeType) {
        return GTOPredicates.autoGCYMAbilities(recipeType).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_LASER}).setMaxGlobalLimited(2)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.THREAD_HATCH}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.OVERCLOCK_HATCH}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{GTOPartAbility.ACCELERATE_HATCH}).setMaxGlobalLimited(1));
    }

    public static TraceabilityPredicate tierBlock(Int2ObjectMap<Supplier<?>> map, String tierType) {
        Block[] blocks = new Block[map.size()];
        int index = 0;
        ArrayList<Int2ObjectMap.Entry> list = new ArrayList<Int2ObjectMap.Entry>((Collection<Int2ObjectMap.Entry>)map.int2ObjectEntrySet());
        list.sort(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey));
        for (Int2ObjectMap.Entry entry : list) {
            blocks[index] = (Block)((Supplier)entry.getValue()).get();
            ++index;
        }
        return new TraceabilityPredicate(state -> {
            BlockState blockState = state.getBlockState();
            for (Int2ObjectMap.Entry entry : map.int2ObjectEntrySet()) {
                if (!blockState.m_60713_((Block)((Supplier)entry.getValue()).get())) continue;
                int tier = entry.getIntKey();
                int type = (Integer)state.getMatchContext().getOrPut((Object)tierType, (Object)tier);
                if (type != tier) {
                    state.setError((PatternError)new PatternStringError("gtocore.machine.pattern.error.tier"));
                    return false;
                }
                return true;
            }
            return false;
        }, () -> BlockInfo.fromBlock((Block)blocks[0]), () -> blocks).addTooltips(new Component[]{Component.m_237115_((String)"gtocore.machine.pattern.error.tier")});
    }

    public static TraceabilityPredicate RotorBlock(int tier) {
        return new TraceabilityPredicate(new SimplePredicate(state -> {
            MetaMachine machine = MetaMachine.getMachine((BlockEntity)state.getTileEntity());
            if (machine instanceof IRotorHolderMachine && machine.getDefinition().getTier() >= tier) {
                Direction facing = machine.getFrontFacing();
                boolean permuteXZ = facing.m_122434_() == Direction.Axis.Z;
                for (int x = -2; x < 3; ++x) {
                    for (int y = -2; y < 3; ++y) {
                        if (x == 0 && y == 0) continue;
                        BlockPos offset = state.pos.m_7918_(permuteXZ ? x : 0, y, permuteXZ ? 0 : x);
                        if (GTOPredicates.getBlockState(state, offset).m_155947_() && MetaMachine.getMachine((BlockGetter)state.getWorld(), (BlockPos)offset) instanceof RotorHolderPartMachine) {
                            state.setError((PatternError)new PatternStringError("gtceu.multiblock.pattern.clear_amount_3"));
                            return false;
                        }
                        if (x == -2 || x == 2 || y == -2 || y == 2 || GTOPredicates.getBlockState(state, offset.m_121945_(facing)).m_60795_()) continue;
                        state.setError((PatternError)new PatternStringError("gtceu.multiblock.pattern.clear_amount_3"));
                        return false;
                    }
                }
                return true;
            }
            state.setError((PatternError)new PatternStringError("gtocore.idle_reason.block_tier_not_satisfies"));
            return false;
        }, () -> BlockInfo.fromBlockState((BlockState)GTMachines.ROTOR_HOLDER[tier].defaultBlockState()), () -> (Block[])PartAbility.ROTOR_HOLDER.getAllBlocks().stream().filter(b2 -> {
            MetaMachineBlock metaMachineBlock;
            return b2 instanceof MetaMachineBlock && (metaMachineBlock = (MetaMachineBlock)b2).getDefinition().getTier() >= tier;
        }).toArray(Block[]::new))).addTooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.pattern.clear_amount_3")});
    }

    public static TraceabilityPredicate MEStorageCore() {
        return GTOPredicates.containerBlock(() -> new FunctionContainer((Object)0.0, (data, state) -> {
            Block patt0$temp = state.getBlockState().m_60734_();
            if (patt0$temp instanceof MEStorageCoreBlock) {
                MEStorageCoreBlock block = (MEStorageCoreBlock)patt0$temp;
                data = data + (double)block.getCapacity();
            }
            return data;
        }), "MEStorageCore", BlockMap.ME_STORAGE_CORE);
    }

    public static TraceabilityPredicate craftingStorageCore() {
        return GTOPredicates.containerBlock(() -> new FunctionContainer((Object)new double[2], (data, state) -> {
            Block patt0$temp = state.getBlockState().m_60734_();
            if (patt0$temp instanceof MEStorageCoreBlock) {
                MEStorageCoreBlock block = (MEStorageCoreBlock)patt0$temp;
                data[0] = data[0] + (double)block.getCapacity();
                data[1] = data[1] + 1.0;
            }
            return data;
        }), "CraftingStorageCore", BlockMap.CRAFTING_STORAGE_CORE);
    }

    public static TraceabilityPredicate wirelessEnergyUnit() {
        return GTOPredicates.containerBlock(() -> new FunctionContainer(new ArrayList(), (data, state) -> {
            Block patt0$temp = state.getBlockState().m_60734_();
            if (patt0$temp instanceof WirelessEnergyUnitBlock) {
                WirelessEnergyUnitBlock block = (WirelessEnergyUnitBlock)patt0$temp;
                data.add(new WirelessEnergyUnitBlock.BlockData(block, state.getPos()));
            } else {
                data.add(new WirelessEnergyUnitBlock.BlockData(null, state.getPos()));
            }
            return data;
        }), "wirelessEnergyUnit", BlockMap.WIRELESS_ENERGY_UNIT).setPreviewCount(1);
    }

    public static TraceabilityPredicate fissionComponent() {
        return GTOPredicates.containerBlock(() -> new FunctionContainer((Object)new int[4], (integer, state) -> {
            Block block = state.getBlockState().m_60734_();
            if (block == GTOBlocks.FISSION_FUEL_COMPONENT.get()) {
                integer[0] = integer[0] + 1;
                integer[2] = integer[2] + GTOUtils.adjacentBlock(side -> GTOPredicates.getBlockState(state, state.pos.m_121945_(side)).m_60734_(), (Block)((Block)GTOBlocks.FISSION_FUEL_COMPONENT.get()));
            } else if (block == GTOBlocks.FISSION_COOLER_COMPONENT.get() && GTOUtils.adjacentBlock(side -> GTOPredicates.getBlockState(state, state.pos.m_121945_(side)).m_60734_(), (Block)((Block)GTOBlocks.FISSION_FUEL_COMPONENT.get())) > 0) {
                integer[1] = integer[1] + 1;
                integer[3] = integer[3] + GTOUtils.adjacentBlock(side -> GTOPredicates.getBlockState(state, state.pos.m_121945_(side)).m_60734_(), (Block)((Block)GTOBlocks.FISSION_COOLER_COMPONENT.get()));
            }
            return integer;
        }), "fissionComponent", (Block)GTOBlocks.FISSION_FUEL_COMPONENT.get(), (Block)GTOBlocks.FISSION_COOLER_COMPONENT.get()).setPreviewCount(1);
    }

    public static TraceabilityPredicate countBlock(String name, Block ... blocks) {
        return GTOPredicates.containerBlock(() -> new FunctionContainer((Object)0, (integer, state) -> {
            integer = integer + 1;
            return integer;
        }), name, blocks);
    }

    public static <T> TraceabilityPredicate containerBlock(Supplier<FunctionContainer<T, MultiblockState>> containerSupplier, String name, Block ... blocks) {
        TraceabilityPredicate predicate = Predicates.blocks((Block[])blocks);
        return new TraceabilityPredicate(new SimplePredicate(state -> {
            if (predicate.test(state)) {
                FunctionContainer container = (FunctionContainer)state.getMatchContext().getOrPut((Object)name, (Object)((FunctionContainer)containerSupplier.get()));
                container.apply(state);
                return true;
            }
            return false;
        }, () -> BlockInfo.fromBlock((Block)blocks[0]), () -> (Block[])predicate.common.stream().map(p -> p.candidates).filter(Objects::nonNull).map(Supplier::get).flatMap(Arrays::stream).toArray(Block[]::new)));
    }

    private static BlockState getBlockState(MultiblockState state, BlockPos pos) {
        return (BlockState)state.blockStateCache.computeIfAbsent(pos.m_121878_(), k -> state.world.m_8055_(pos));
    }

    public static TraceabilityPredicate recordPosition(final String name, TraceabilityPredicate original) {
        return new TraceabilityPredicate(original){

            public boolean test(MultiblockState blockWorldState) {
                if (super.test(blockWorldState)) {
                    ((ObjectOpenHashSet)blockWorldState.getMatchContext().getOrCreate((Object)name, ObjectOpenHashSet::new)).add((Object)blockWorldState.getPos());
                    return true;
                }
                return false;
            }

            public boolean testOnly() {
                return true;
            }

            public boolean isAir() {
                return false;
            }
        };
    }

    static {
        BlockPattern.addWhitelistBlockEntity(ManaPoolBlockEntity.class);
    }
}

