/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.report;

import com.gtolib.GTOCore;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public class EnchantmentStorage {
    public static Map<String, EnchantmentData> getAllEnchantmentsWithData() {
        HashMap<String, EnchantmentData> enchantmentMap = new HashMap<String, EnchantmentData>();
        for (Map.Entry entry : BuiltInRegistries.f_256876_.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            Enchantment enchantment = (Enchantment)entry.getValue();
            ResourceLocation location = key.m_135782_();
            String enchantmentId = location.toString();
            int maxLevel = enchantment.m_6586_();
            String translationKey = enchantment.m_44704_();
            enchantmentMap.put(enchantmentId, new EnchantmentData(maxLevel, translationKey));
        }
        return enchantmentMap;
    }

    public static Map<String, Integer> getAllEnchantmentsWithMaxLevel() {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        Map<String, EnchantmentData> fullData = EnchantmentStorage.getAllEnchantmentsWithData();
        for (Map.Entry<String, EnchantmentData> entry : fullData.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().maxLevel);
        }
        return resultMap;
    }

    public static void getEnchantmentsReport() {
        try {
            Map<String, EnchantmentData> enchantments = EnchantmentStorage.getAllEnchantmentsWithData();
            Path logDir = Paths.get("logs", "report");
            if (!Files.exists(logDir, new LinkOption[0])) {
                Files.createDirectories(logDir, new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            String csvFileName = "enchantments_" + timestamp + ".csv";
            String txtFileName = "enchantments_array_" + timestamp + ".txt";
            Path csvFilePath = logDir.resolve(csvFileName);
            Path txtFilePath = logDir.resolve(txtFileName);
            ArrayList<String> enchantmentIds = new ArrayList<String>();
            ArrayList<Integer> maxLevels = new ArrayList<Integer>();
            ArrayList<String> translationKeys = new ArrayList<String>();
            ArrayList<String> localizedNames = new ArrayList<String>();
            ArrayList<String> simplifiedIds = new ArrayList<String>();
            try (PrintWriter csvWriter = new PrintWriter(new FileWriter(csvFilePath.toFile()));
                 PrintWriter txtWriter = new PrintWriter(new FileWriter(txtFilePath.toFile()));){
                csvWriter.println("Enchantment ID,Max Level,Translation Key,Localized Name,Simplified ID");
                enchantments.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                    String enchantmentId = (String)entry.getKey();
                    EnchantmentData data = (EnchantmentData)entry.getValue();
                    String localizedName = I18n.m_118938_((String)data.translationKey, (Object[])new Object[0]);
                    String simplifiedId = enchantmentId.substring(enchantmentId.indexOf(58) + 1);
                    csvWriter.println(enchantmentId + "," + data.maxLevel + "," + data.translationKey + "," + localizedName + "," + simplifiedId);
                    txtWriter.println("addRecord(\"" + enchantmentId + "\"," + data.maxLevel + ",\"" + localizedName + "\",\"" + data.translationKey + "\");");
                    enchantmentIds.add(enchantmentId);
                    maxLevels.add(data.maxLevel);
                    translationKeys.add(data.translationKey);
                    localizedNames.add(localizedName);
                    simplifiedIds.add(simplifiedId);
                });
                txtWriter.println("// Enchantment IDs");
                EnchantmentStorage.writeStringArrayToFile(txtWriter, "enchantmentIds", enchantmentIds);
                txtWriter.println("\n// Max Levels");
                EnchantmentStorage.writeIntArrayToFile(txtWriter, "maxLevels", maxLevels);
                txtWriter.println("\n// Translation Keys");
                EnchantmentStorage.writeStringArrayToFile(txtWriter, "translationKey", translationKeys);
                txtWriter.println("\n// Localized Names");
                EnchantmentStorage.writeStringArrayToFile(txtWriter, "localizedNames", localizedNames);
                txtWriter.println("\n// Simplified IDs");
                EnchantmentStorage.writeStringArrayToFile(txtWriter, "simplifiedId", simplifiedIds);
                GTOCore.LOGGER.info("\u9644\u9b54\u5217\u8868\u5df2\u6210\u529f\u5bfc\u51fa\u5230: run/logs/report/{}", (Object)csvFileName);
                GTOCore.LOGGER.info("\u9644\u9b54\u6570\u7ec4\u5df2\u6210\u529f\u5bfc\u51fa\u5230: run/logs/report/{}", (Object)txtFileName);
            }
        }
        catch (IOException e) {
            GTOCore.LOGGER.error("\u9644\u9b54\u7edf\u8ba1\u62a5\u544a\u5931\u8d25", (Throwable)e);
        }
    }

    private static void writeStringArrayToFile(PrintWriter writer, String arrayName, List<String> list) {
        StringJoiner joiner = new StringJoiner(", ", "String[] " + arrayName + " = {", "};");
        for (String item : list) {
            joiner.add("\"" + item.replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
        }
        writer.println(joiner);
    }

    private static void writeIntArrayToFile(PrintWriter writer, String arrayName, List<Integer> list) {
        StringJoiner joiner = new StringJoiner(", ", "int[] " + arrayName + " = {", "};");
        for (Integer item : list) {
            joiner.add(item.toString());
        }
        writer.println(joiner);
    }

    public record EnchantmentData(int maxLevel, String translationKey) {
        @Override
        @NotNull
        public String toString() {
            return "EnchantmentData{maxLevel=" + this.maxLevel + ", translationKey='" + this.translationKey + "'}";
        }
    }
}

