/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.forge;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.GTBucketItem;
import com.gregtechceu.gtceu.api.item.TagPrefixItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gtocore.api.lang.ComponentSupplier;
import com.gtocore.api.lang.ComponentUtilsKt;
import com.gtocore.client.forge.GTOComponentHandler;
import com.gtocore.config.GTOConfig;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"getEnglishName", "Lcom/gtocore/api/lang/ComponentSupplier;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "getEnglish", "Ljava/util/Optional;", "Lnet/minecraft/network/chat/Component;", "gtocore"})
public final class GTOComponentHandlerKt {
    private static final ComponentSupplier getEnglishName(ItemStack itemStack) {
        ComponentSupplier componentSupplier;
        if (!GTOConfig.INSTANCE.showEnglishName) {
            return null;
        }
        Object object = GTOComponentHandler.INSTANCE.getEnglishLanguage();
        if (object == null || (object = object.m_6834_(itemStack.m_41778_())) == null) {
            return null;
        }
        Object englishName = object;
        if (Intrinsics.areEqual((Object)I18n.m_118938_((String)itemStack.m_41778_(), (Object[])new Object[0]), (Object)englishName)) {
            return null;
        }
        Item item = itemStack.m_41720_();
        if (itemStack.m_41619_()) {
            return null;
        }
        if (item instanceof TagPrefixItem) {
            String format;
            String string;
            TagPrefix tagPrefix = ((TagPrefixItem)item).tagPrefix;
            Material material = ((TagPrefixItem)item).material;
            Object object2 = GTOComponentHandler.INSTANCE.getEnglishLanguage();
            if (object2 != null && (object2 = object2.m_6834_(tagPrefix.getUnlocalizedName())) != null) {
                Object object3 = object2;
                Object[] objectArray = new Object[1];
                ClientLanguage clientLanguage = GTOComponentHandler.INSTANCE.getEnglishLanguage();
                objectArray[0] = clientLanguage != null ? clientLanguage.m_6834_(material.getUnlocalizedName()) : null;
                String string2 = String.format((String)object3, Arrays.copyOf(objectArray, objectArray.length));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            } else {
                string = null;
            }
            String string3 = format = string;
            boolean bl = string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"%s", (boolean)false, (int)2, null) : false;
            if (bl) {
                return null;
            }
            componentSupplier = ComponentUtilsKt.toLiteralSupplier(format);
        } else if (item instanceof GTToolItem) {
            String format;
            String string;
            GTToolType toolType = ((GTToolItem)item).getToolType();
            Material material = ((GTToolItem)item).getMaterial();
            if (toolType == null || material == null) {
                return null;
            }
            Object object4 = GTOComponentHandler.INSTANCE.getEnglishLanguage();
            if (object4 != null && (object4 = object4.m_6834_(toolType.getUnlocalizedName())) != null) {
                Object object5 = object4;
                Object[] objectArray = new Object[1];
                ClientLanguage clientLanguage = GTOComponentHandler.INSTANCE.getEnglishLanguage();
                objectArray[0] = clientLanguage != null ? clientLanguage.m_6834_(material.getUnlocalizedName()) : null;
                String string4 = String.format((String)object5, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            } else {
                string = null;
            }
            String string5 = format = string;
            boolean bl = string5 != null ? StringsKt.contains$default((CharSequence)string5, (CharSequence)"%s", (boolean)false, (int)2, null) : false;
            if (bl) {
                return null;
            }
            componentSupplier = ComponentUtilsKt.toLiteralSupplier(format);
        } else {
            if (item instanceof GTBucketItem) {
                return null;
            }
            ClientLanguage clientLanguage = GTOComponentHandler.INSTANCE.getEnglishLanguage();
            componentSupplier = ComponentUtilsKt.toLiteralSupplier(clientLanguage != null ? clientLanguage.m_6834_(itemStack.m_41778_()) : null);
        }
        ComponentSupplier componentSupplier2 = componentSupplier.gray();
        String string = componentSupplier2.get().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"%s", (boolean)false, (int)2, null)) {
            return null;
        }
        return componentSupplier2;
    }

    @NotNull
    public static final Optional<Component> getEnglish(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        ComponentSupplier componentSupplier = GTOComponentHandlerKt.getEnglishName(itemStack);
        Optional<MutableComponent> optional = Optional.ofNullable(componentSupplier != null ? componentSupplier.get() : null);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public static final /* synthetic */ ComponentSupplier access$getEnglishName(ItemStack itemStack) {
        return GTOComponentHandlerKt.getEnglishName(itemStack);
    }
}

