/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer;

import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class RenderHelper {
    public static void renderCylinder(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float radius, float height, int sides, float red, float green, float blue, float alpha) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float angleStep = (float)(Math.PI * 2 / (double)sides);
        for (int i = 0; i < sides; ++i) {
            float angle1 = (float)i * angleStep;
            float angle2 = (float)(i + 1) * angleStep;
            float cosAngle1 = Mth.m_14089_((float)angle1);
            float sinAngle1 = Mth.m_14031_((float)angle1);
            float cosAngle2 = Mth.m_14089_((float)angle2);
            float sinAngle2 = Mth.m_14031_((float)angle2);
            buffer.m_252986_(mat, x + cosAngle1 * radius, y, z + sinAngle1 * radius).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(mat, x + cosAngle2 * radius, y, z + sinAngle2 * radius).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(mat, x + cosAngle2 * radius, y + height, z + sinAngle2 * radius).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(mat, x + cosAngle1 * radius, y, z + sinAngle1 * radius).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(mat, x + cosAngle2 * radius, y + height, z + sinAngle2 * radius).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(mat, x + cosAngle1 * radius, y + height, z + sinAngle1 * radius).m_85950_(red, green, blue, alpha).m_5752_();
        }
    }

    public static void renderTexturedCylinder(PoseStack poseStack, VertexConsumer buffer, float x, float y, float z, float radius, float height, int sides, ResourceLocation sprite, float subTextureU0, float subTextureV0, float subTextureU1, float subTextureV1) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.setShader(GameRenderer::m_172820_);
        TextureAtlasSprite atlasSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(sprite);
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float angleStep = (float)(Math.PI * 2 / (double)sides);
        float u0o = atlasSprite.m_118409_();
        float u1o = atlasSprite.m_118410_();
        float v0o = atlasSprite.m_118411_();
        float v1o = atlasSprite.m_118412_();
        float u0 = Mth.m_14179_((float)subTextureU0, (float)u0o, (float)u1o);
        float u1 = Mth.m_14179_((float)subTextureU1, (float)u0o, (float)u1o);
        float v0 = Mth.m_14179_((float)subTextureV0, (float)v0o, (float)v1o);
        float v1 = Mth.m_14179_((float)subTextureV1, (float)v0o, (float)v1o);
        float uRange = u1 - u0;
        float vRange = v1 - v0;
        for (int i = 0; i < sides; ++i) {
            float angle1 = (float)i * angleStep;
            float angle2 = (float)(i + 1) * angleStep;
            float cos1 = Mth.m_14089_((float)angle1);
            float sin1 = Mth.m_14031_((float)angle1);
            float cos2 = Mth.m_14089_((float)angle2);
            float sin2 = Mth.m_14031_((float)angle2);
            float bx1 = x + cos1 * radius;
            float bz1 = z + sin1 * radius;
            float bx2 = x + cos2 * radius;
            float bz2 = z + sin2 * radius;
            float uA = u0 + (float)i / (float)sides * uRange;
            float uB = u0 + (float)(i + 1) / (float)sides * uRange;
            float vBottom = v0;
            float vTop = v0 + vRange;
            buffer.m_252986_(mat, bx1, y, bz1).m_7421_(uA, vBottom).m_5752_();
            buffer.m_252986_(mat, bx2, y, bz2).m_7421_(uB, vBottom).m_5752_();
            buffer.m_252986_(mat, bx2, y + height, bz2).m_7421_(uB, vTop).m_5752_();
            buffer.m_252986_(mat, bx1, y, bz1).m_7421_(uA, vBottom).m_5752_();
            buffer.m_252986_(mat, bx2, y + height, bz2).m_7421_(uB, vTop).m_5752_();
            buffer.m_252986_(mat, bx1, y + height, bz1).m_7421_(uA, vTop).m_5752_();
        }
    }

    public static void renderCone(PoseStack poseStack, VertexConsumer buffer, float baseRadius, float topRadius, float height, float curvature, int sides, float red, float green, float blue, float alpha) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float angleDelta = (float)(Math.PI * 2 / (double)sides);
        for (int i = 0; i < sides; ++i) {
            float angle1 = (float)i * angleDelta;
            float angle2 = angle1 + angleDelta;
            float cosAngle1 = Mth.m_14089_((float)angle1);
            float sinAngle1 = Mth.m_14031_((float)angle1);
            float cosAngle2 = Mth.m_14089_((float)angle2);
            float sinAngle2 = Mth.m_14031_((float)angle2);
            float baseX1 = cosAngle1 * baseRadius;
            float baseZ1 = sinAngle1 * baseRadius;
            float baseX2 = cosAngle2 * baseRadius;
            float baseZ2 = sinAngle2 * baseRadius;
            float topX1 = cosAngle1 * topRadius;
            float topZ1 = sinAngle1 * topRadius;
            float topX2 = cosAngle2 * topRadius;
            float topZ2 = sinAngle2 * topRadius;
            for (float j = 0.0f; j <= curvature; j += 1.0f) {
                float lerpFactor = j / curvature;
                float curX1 = baseX1 + lerpFactor * (topX1 - baseX1);
                float curZ1 = baseZ1 + lerpFactor * (topZ1 - baseZ1);
                float curX2 = baseX2 + lerpFactor * (topX2 - baseX2);
                float curZ2 = baseZ2 + lerpFactor * (topZ2 - baseZ2);
                float curY = height * (1.0f - lerpFactor);
                buffer.m_252986_(mat, curX1, curY, curZ1).m_85950_(red, green, blue, alpha).m_5752_();
                buffer.m_252986_(mat, curX2, curY, curZ2).m_85950_(red, green, blue, alpha).m_5752_();
            }
        }
    }

    public static void highlightBlock(Camera camera, PoseStack poseStack, float r, float g, float b2, BlockPos ... poses) {
        Vec3 pos = camera.m_90583_();
        float lightR = (1.0f + r * 4.0f) / 5.0f;
        float lightG = (1.0f + g * 4.0f) / 5.0f;
        float lightB = (1.0f + b2 * 4.0f) / 5.0f;
        poseStack.m_85836_();
        poseStack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderBufferUtils.renderCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)poses[0].m_123341_(), (float)poses[0].m_123342_(), (float)poses[0].m_123343_(), (float)(poses[1].m_123341_() + 1), (float)(poses[1].m_123342_() + 1), (float)(poses[1].m_123343_() + 1), (float)lightR, (float)lightG, (float)lightB, (float)0.25f, (boolean)true);
        tesselator.m_85914_();
        buffer.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        RenderSystem.setShader(GameRenderer::m_172757_);
        RenderSystem.lineWidth((float)3.0f);
        RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)poses[0].m_123341_(), (float)poses[0].m_123342_(), (float)poses[0].m_123343_(), (float)(poses[1].m_123341_() + 1), (float)(poses[1].m_123342_() + 1), (float)(poses[1].m_123343_() + 1), (float)r, (float)g, (float)b2, (float)0.5f);
        tesselator.m_85914_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
    }

    public static void highlightSphere(Camera camera, PoseStack poseStack, BlockPos blockPos, float radius) {
        Vec3 pos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderBufferUtils.shapeSphere((PoseStack)poseStack, (VertexConsumer)buffer, (float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_(), (float)radius, (int)40, (int)50, (float)0.2f, (float)0.2f, (float)1.0f, (float)0.25f);
        tesselator.m_85914_();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
    }

    public static BufferBuilder openGUIBuffer() {
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        return buffer;
    }

    public static void closeAndDrawGUIBuffer(@NotNull BufferBuilder buffer) {
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static void drawInGUI(GuiGraphics gui, BufferBuilder buffer, TextureAtlasSprite sprite, int x, int y, float width, float height, int color) {
        float x2 = (float)x + width;
        float y2 = (float)y + height;
        float z = 0.0f;
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        Matrix4f matrix4f = gui.m_280168_().m_85850_().m_252922_();
        buffer.m_252986_(matrix4f, (float)x, (float)y, z).m_7421_(u0, v0).m_193479_(color).m_5752_();
        buffer.m_252986_(matrix4f, (float)x, y2, z).m_7421_(u0, v1).m_193479_(color).m_5752_();
        buffer.m_252986_(matrix4f, x2, y2, z).m_7421_(u1, v1).m_193479_(color).m_5752_();
        buffer.m_252986_(matrix4f, x2, (float)y, z).m_7421_(u1, v0).m_193479_(color).m_5752_();
    }
}

