/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.BloomUtils;
import com.gtolib.GTOCore;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.utils.ClientUtil;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public final class AdvancedHyperRenderer
extends WorkableCasingMachineRenderer {
    private static final ResourceLocation BLUE_STAR_MODEL = GTOCore.id((String)"obj/blue_star");

    public AdvancedHyperRenderer() {
        super(GTOCore.id((String)"block/casings/enhance_hyper_mechanical_casing"), GTCEu.id((String)"block/multiblock/fusion_reactor"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ElectricMultiblockMachine machine;
        MetaMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof ElectricMultiblockMachine && (machine = (ElectricMultiblockMachine)metaMachine).isFormed() && (machine.isActive() || blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
            float tick = (float)machine.getOffsetTimer() + partialTicks;
            if (GTCEu.Mods.isShimmerLoaded() && !(blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
                PoseStack finalStack = RenderUtils.copyPoseStack((PoseStack)poseStack);
                BloomUtils.entityBloom(source -> AdvancedHyperRenderer.renderStar(machine, tick, finalStack, source));
            } else {
                AdvancedHyperRenderer.renderStar(machine, tick, poseStack, buffer);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderStar(ElectricMultiblockMachine machine, float tick, PoseStack poseStack, MultiBufferSource buffer) {
        double x = 0.5;
        double y = 8.25;
        double z = 0.5;
        switch (machine.getFrontFacing()) {
            case NORTH: {
                z = 18.5;
                break;
            }
            case SOUTH: {
                z = -17.5;
                break;
            }
            case WEST: {
                x = 18.5;
                break;
            }
            case EAST: {
                x = -17.5;
            }
        }
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        poseStack.m_85841_(0.1f, 0.1f, 0.1f);
        poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(1.0f, 1.0f, 0.0f, tick % 36.0f * 4.0f));
        ClientUtil.modelRenderer().renderModel(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110466_()), null, ClientUtil.getBakedModel((ResourceLocation)BLUE_STAR_MODEL), 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110466_());
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onAdditionalModel(Consumer<ResourceLocation> registry) {
        super.onAdditionalModel(registry);
        registry.accept(BLUE_STAR_MODEL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }
}

