/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gtocore.common.machine.multiblock.part.BallHatchPartMachine;
import com.gtolib.GTOCore;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class BallHatchRenderer
extends TieredHullMachineRenderer {
    private static final ResourceLocation BALL_HATCH_OVERLAY = GTOCore.id((String)"block/overlay/machine/ball_hatch");
    private static final ResourceLocation IDLE = GTOCore.id((String)"block/overlay/machine/ball_hatch_idle");
    private static final ResourceLocation SPINNING = GTOCore.id((String)"block/overlay/machine/ball_hatch_spinning");
    private static final AABB AABB = new AABB(-1.0, -1.0, -0.01, 2.0, 2.0, 1.01);

    public BallHatchRenderer() {
        super(5, GTCEu.id((String)"block/machine/hull_machine"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, @Nullable Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (side == frontFacing && modelFacing != null) {
            BallHatchPartMachine ballHatchMachine;
            quads.add(FaceQuad.bakeFace((Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)BALL_HATCH_OVERLAY), (ModelState)modelState));
            if (machine instanceof BallHatchPartMachine && (ballHatchMachine = (BallHatchPartMachine)machine).isFormed()) {
                if (ballHatchMachine.isWorking()) {
                    quads.add(FaceQuad.bakeFace((AABB)AABB, (Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)SPINNING), (ModelState)modelState, (int)2, (int)0, (boolean)true, (boolean)true));
                } else {
                    quads.add(FaceQuad.bakeFace((AABB)AABB, (Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)IDLE), (ModelState)modelState, (int)2, (int)0, (boolean)true, (boolean)true));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)InventoryMenu.f_39692_)) {
            register.accept(IDLE);
            register.accept(SPINNING);
            register.accept(BALL_HATCH_OVERLAY);
        }
    }
}

